/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv2Wrapper;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AMv3Wrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.GeniAMResponseCode;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.lib.AbstractApi;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.inject.Inject;

public class TestAnyGetVersion
extends BaseApiTest<LegacyApiTestConfig> {
    private AggregateManagerWrapper amWrapper;
    private CommonAMTest commonAMTest;
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "Calls GetVersion on any available Aggregate manager for the given testbed. This is mainly useful to test connectivity.";
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>();
            res.add("am_version");
            CommonAMTest.addOptionsForConnectionSshProxy(res);
            return res;
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }
    };
    private Map versionRawResult = null;

    @Inject
    public TestAnyGetVersion(Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    public void testAM2CorrectnessXmlRpcResult(Map res) {
        Object code = res.get("code");
        Object value = res.get("value");
        Object output = res.get("output");
        this.assertNotNull(code, "testAM2CorrectnessXmlRpcResult code == null in " + res);
        this.assertNotNull(value, "testAM2CorrectnessXmlRpcResult value == null in " + res);
        this.assertInstanceOf(code, Map.class, "testAM2CorrectnessXmlRpcResult code is not Map in " + res + " (it is " + code.getClass().getName() + " with value \"" + code.toString() + "\")");
        Map codeHt = (Map)code;
        Object genicode = codeHt.get("geni_code");
        this.assertNotNull(genicode, "testAM2CorrectnessXmlRpcResult code does not contain \"geni_code\" in " + res);
        this.assertEquals(genicode.getClass(), Integer.class, "testAM2CorrectnessXmlRpcResult code.geni_code is not int in " + res);
        int genicodevalue = (Integer)genicode;
        if (genicodevalue != 0) {
            this.assertNotNull(output, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output == null in " + res);
            this.assertEquals(output.getClass(), String.class, "testAM2CorrectnessXmlRpcResult: while geni_code is non success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\") in \"+res+\"");
        } else if (output == null) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is ommited. This is allowed by the API.");
        } else if (output != null && !(output instanceof String)) {
            this.note("testAM2CorrectnessXmlRpcResult: while geni_code is success (" + genicodevalue + "), output is not String (it is " + output.getClass().getName() + " with value \"" + output.toString() + "\"). This is allowed but not recommended by jFed.");
        }
    }

    @Override
    public void setUp() {
        String amVersion = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("am_version");
        if (amVersion == null || amVersion.trim().equalsIgnoreCase("auto")) {
            this.amWrapper = this.getAutomaticAggregateManagerWrapperFactory().create(this.logger, this.testedAuthority.getServerToConnect());
        } else {
            if (amVersion.trim().equalsIgnoreCase("2")) {
                this.amWrapper = new AMv2Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences(), this.testedAuthority.getServerToConnect());
            }
            if (amVersion.trim().equalsIgnoreCase("3")) {
                this.amWrapper = new AMv3Wrapper(this.logger, this.geniUserProvider, this.connectionProvider, this.getJFedPreferences(), this.testedAuthority.getServerToConnect());
            }
            if (this.amWrapper == null) {
                throw new RuntimeException("Option \"am_version\" has unknown value (\"" + amVersion + "\") should be \"auto\", \"2\" or \"3\"");
            }
        }
        this.commonAMTest = new CommonAMTest(this, this.user.getUserAuthorityServerId(), this.getTestbedInfoSource());
        this.commonAMTest.setupProxyForConnectionPool((LegacyApiTestConfig)this.getTestConfig());
        this.note("done");
    }

    @ApiTest.Test
    public void testAnyGetVersion() throws JFedException {
        assert (this.amWrapper != null);
        this.versionRawResult = this.amWrapper.getVersion();
        this.testAM2CorrectnessXmlRpcResult(this.versionRawResult);
        this.assertNotNull(this.versionRawResult);
        Map replyHt = AbstractApi.apiSpecifiesMapStringToObject((Object)this.versionRawResult);
        Map codeHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("code"));
        Integer genicodeHt = AbstractApi.apiSpecifiesInt(codeHt.get("geni_code"));
        this.assertEquals(genicodeHt, GeniAMResponseCode.GENIRESPONSE_SUCCESS.getCode(), "GeniResponse code is not SUCCESS (0)");
        Map valueHt = AbstractApi.apiSpecifiesMapStringToObject(replyHt.get("value"));
        Integer geniapiHt = AbstractApi.apiSpecifiesInt(replyHt.get("geni_api"));
        this.assertNotNull(geniapiHt);
        this.note("Test completed successfully.\nAll Done\n");
    }
}

