/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServerBuilder;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.ServiceBuilder;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.api.test.GPULabTestConfig;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.HttpConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.lib.ApiMethod;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigEditor;
import be.iminds.ilabt.jfed.testing.base.ApiTestMetaData;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.BaseApiTest;
import be.iminds.ilabt.jfed.testing.base.JsonTestConfigEditor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.inject.Inject;

public class TestGPULab
extends BaseApiTest<GPULabTestConfig> {
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final ApiTestMetaData metadata = new ApiTestMetaData<GPULabTestConfig>(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "GPULab Test: tests connectivity and basic functionality";
        }

        @Override
        @Nonnull
        public Class<GPULabTestConfig> getConfigClass() {
            return GPULabTestConfig.class;
        }

        @Override
        @Nonnull
        public GPULabTestConfig parseApiTestConfig(@Nonnull String apiTestConfigString) {
            if (apiTestConfigString == null || apiTestConfigString.trim().isEmpty()) {
                return new GPULabTestConfig();
            }
            try {
                return (GPULabTestConfig)MAPPER.readValue(apiTestConfigString, GPULabTestConfig.class);
            }
            catch (IOException e) {
                throw new RuntimeException("Invalid Test config", e);
            }
        }

        @Override
        @Nonnull
        public ApiTestConfigEditor<GPULabTestConfig> getApiTestConfigEditor() {
            return new JsonTestConfigEditor<GPULabTestConfig>(GPULabTestConfig.class);
        }
    };
    private URL url;

    @Inject
    public TestGPULab(@Nonnull Logger logger, @Nullable TargetAuthority testedAuthority, @Nonnull GeniUserProvider geniUserProvider, @Nonnull GPULabTestConfig testConfig, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedPreferences jFedPreferences) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences);
    }

    public static ApiTestMetaData getMetaData() {
        return metadata;
    }

    @Override
    public void setUp() throws MalformedURLException {
        this.url = new URL(((GPULabTestConfig)this.testConfig).getGpulabURL());
        this.note("done");
    }

    @ApiTest.Test(groups={"test"})
    public void testGPULab() throws JFedException {
        GPULabApi api = new GPULabApi(this.logger, this.getJFedPreferences());
        ServiceBuilder serviceBuilder = (ServiceBuilder)new ServiceBuilder().setApi(api.getApi().getName().getId()).setApiVersion(api.getApi().getVersion()).setUrl(((GPULabTestConfig)this.testConfig).getGpulabURL()).setId((Object)0x7FFFFFFA);
        Server server = ((ServerBuilder)new ServerBuilder().setName("GPULab").setBaseUrl(((GPULabTestConfig)this.testConfig).getGpulabURL()).addServiceBuilder(serviceBuilder).setId((Object)0x7FFFFFF9)).create();
        JFedConnection con = this.connectionProvider.getConnectionByAuthority(this.user, server, api.getApi());
        List<GPULabCluster> clusters = api.getClusters((HttpConnection)con);
        this.assertNotEmpty(clusters, "There are no active GPULab clusters");
        this.note("GPULab version: " + clusters.get(0).getVersion());
        String clusterIds = clusters.stream().map(GPULabCluster::getId).collect(Collectors.joining(", "));
        this.note("Clusters: " + clusterIds);
        int allGpuCount = clusters.stream().map(GPULabCluster::getGpuTotalCount).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        int freeGpuCount = clusters.stream().map(GPULabCluster::getGpuAvailableCount).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        this.note("Total GPUs: " + allGpuCount);
        this.note("Free  GPUs: " + freeGpuCount);
        int allCpuCount = clusters.stream().map(GPULabCluster::getCpuTotalCount).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        int freeCpuCount = clusters.stream().map(GPULabCluster::getCpuAvailableCount).filter(Objects::nonNull).mapToInt(Integer::intValue).sum();
        this.note("Total Cpus: " + allCpuCount);
        this.note("Free  Cpus: " + freeCpuCount);
        List<GPULabJob> jobs = api.getJobs((HttpConnection)con);
        this.note("Job count: " + jobs.size());
        this.note("Jobs: " + jobs.stream().map(GPULabJob::getUuid).collect(Collectors.joining(", ")));
        List<GPULabSlave> slaves = api.getSlaves((HttpConnection)con);
        this.assertNotEmpty(slaves, "There are no active GPULab slaves");
        String slaveHostnames = slaves.stream().map(GPULabSlave::getSlaveHostname).filter(Objects::nonNull).collect(Collectors.joining(", "));
        this.note("Slaves: " + slaveHostnames);
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("clusters").setLarge(false).setHttpMediaTypeToText().setValue(clusters.size()));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("slaves").setLarge(false).setHttpMediaTypeToText().setValue(slaves.size()));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("cluster_ids").setLarge(false).setHttpMediaTypeToText().setValue(clusterIds));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("slave_hostnames").setLarge(false).setHttpMediaTypeToText().setValue(slaveHostnames));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("recent_job_count").setLarge(false).setHttpMediaTypeToText().setValue(jobs.size()));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("gpu").setLarge(false).setHttpMediaTypeToText().setValue(freeGpuCount + "/" + allGpuCount));
        this.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("cpu").setLarge(false).setHttpMediaTypeToText().setValue(freeCpuCount + "/" + allCpuCount));
        this.assertTrue(allGpuCount >= ((GPULabTestConfig)this.testConfig).getMinGPUs(), "Too few GPU's in cluster -> minimum expected=" + ((GPULabTestConfig)this.testConfig).getMinGPUs() + " actual=" + allGpuCount);
        this.assertTrue(allCpuCount >= ((GPULabTestConfig)this.testConfig).getMinCPUs(), "Too few CPU's in cluster -> minimum expected=" + ((GPULabTestConfig)this.testConfig).getMinCPUs() + " actual=" + allCpuCount);
        this.assertTrue(clusters.size() >= ((GPULabTestConfig)this.testConfig).getMinClusters(), "Cluster count too small -> minimum expected=" + ((GPULabTestConfig)this.testConfig).getMinCPUs() + " actual=" + clusters.size());
        this.assertTrue(slaves.size() >= ((GPULabTestConfig)this.testConfig).getMinSlaves(), "Slave count too small -> minimum expected=" + ((GPULabTestConfig)this.testConfig).getMinSlaves() + " actual=" + slaves.size());
        this.note("Test completed successfully.");
    }

    public static class GPULabApi
    extends RestApi {
        public GPULabApi(@Nonnull Logger logger, @Nonnull JFedPreferences jFedPreferences) {
            super(logger, new ApiInfo.Api(ApiInfo.ApiName.GENERIC_HTTPS_CLIENTAUTH, 1), jFedPreferences);
        }

        @Nonnull
        public String getName() {
            return GPULabApi.getApiName();
        }

        public static String getApiName() {
            return "GPULabApi";
        }

        @ApiMethod(order=1, hint="GET gpulab/api/v2.0/clusters")
        public List<GPULabCluster> getClusters(@Nonnull HttpConnection con) throws JFedException {
            String javaName = "getClusters";
            String relUrl = "gpulab/api/v2.0/clusters";
            Map urlParams = GPULabApi.makeMethodParameters((Object[])new Object[0]);
            RestApi.RestReply r = this.internalGet(con, javaName, relUrl, urlParams, urlParams);
            try {
                return (List)MAPPER.readValue((String)r.getValue(), (TypeReference)new TypeReference<List<GPULabCluster>>(){});
            }
            catch (IOException e) {
                throw new JFedException("Exception mapping reply", (Throwable)e);
            }
        }

        @ApiMethod(order=2, hint="GET gpulab/api/v2.0/slaves")
        public List<GPULabSlave> getSlaves(@Nonnull HttpConnection con) throws JFedException {
            String javaName = "getSlaves";
            String relUrl = "gpulab/api/v2.0/slaves";
            Map urlParams = GPULabApi.makeMethodParameters((Object[])new Object[0]);
            RestApi.RestReply r = this.internalGet(con, javaName, relUrl, urlParams, urlParams);
            try {
                return (List)MAPPER.readValue((String)r.getValue(), (TypeReference)new TypeReference<List<GPULabSlave>>(){});
            }
            catch (IOException e) {
                throw new JFedException("Exception mapping reply", (Throwable)e);
            }
        }

        @ApiMethod(order=3, hint="GET gpulab/api/v2.0/jobs?max_hours=900&max_count=100")
        public List<GPULabJob> getJobs(@Nonnull HttpConnection con) throws JFedException {
            String javaName = "getJobs";
            String relUrl = "gpulab/api/v2.0/jobs?max_hours=900&max_count=100";
            Map urlParams = GPULabApi.makeMethodParameters((Object[])new Object[0]);
            RestApi.RestReply r = this.internalGet(con, javaName, relUrl, urlParams, urlParams);
            try {
                return (List)MAPPER.readValue((String)r.getValue(), (TypeReference)new TypeReference<List<GPULabJob>>(){});
            }
            catch (IOException e) {
                throw new JFedException("Exception mapping reply", (Throwable)e);
            }
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class GPULabCluster {
        @Nullable
        private final String id;
        @Nullable
        private final String comment;
        @Nullable
        private final Integer cpuAvailableCount;
        @Nullable
        private final Integer cpuTotalCount;
        @Nullable
        private final Integer gpuAvailableCount;
        @Nullable
        private final Integer gpuTotalCount;
        @Nullable
        private final List<String> gpuTypes;
        @Nullable
        private final Integer slaveCount;
        @Nullable
        private final String version;

        @JsonCreator
        public GPULabCluster(@Nullable @JsonProperty(value="cluster_id") String id, @Nullable @JsonProperty(value="comment") String comment, @Nullable @JsonProperty(value="cpu_available") Integer cpuAvailableCount, @Nullable @JsonProperty(value="cpu_count") Integer cpuTotalCount, @Nullable @JsonProperty(value="gpu_available") Integer gpuAvailableCount, @Nullable @JsonProperty(value="gpu_count") Integer gpuTotalCount, @Nullable @JsonProperty(value="gpu_models") List<String> gpuTypes, @Nullable @JsonProperty(value="slave_count") Integer slaveCount, @Nullable @JsonProperty(value="version") String version) {
            this.id = id;
            this.comment = comment;
            this.cpuAvailableCount = cpuAvailableCount;
            this.cpuTotalCount = cpuTotalCount;
            this.gpuAvailableCount = gpuAvailableCount;
            this.gpuTotalCount = gpuTotalCount;
            this.gpuTypes = gpuTypes;
            this.slaveCount = slaveCount;
            this.version = version;
        }

        @Nullable
        @JsonProperty(value="cluster_id")
        public String getId() {
            return this.id;
        }

        @Nullable
        @JsonProperty(value="comment")
        public String getComment() {
            return this.comment;
        }

        @JsonProperty(value="cpu_available")
        @Nullable
        public Integer getCpuAvailableCount() {
            return this.cpuAvailableCount;
        }

        @JsonProperty(value="cpu_count")
        @Nullable
        public Integer getCpuTotalCount() {
            return this.cpuTotalCount;
        }

        @JsonProperty(value="gpu_available")
        @Nullable
        public Integer getGpuAvailableCount() {
            return this.gpuAvailableCount;
        }

        @JsonProperty(value="gpu_count")
        @Nullable
        public Integer getGpuTotalCount() {
            return this.gpuTotalCount;
        }

        @JsonProperty(value="gpu_models")
        @Nullable
        public List<String> getGpuTypes() {
            return this.gpuTypes;
        }

        @JsonProperty(value="slave_count")
        @Nullable
        public Integer getSlaveCount() {
            return this.slaveCount;
        }

        @JsonProperty(value="version")
        @Nullable
        public String getVersion() {
            return this.version;
        }

        public String toString() {
            return "GPULabCluster{id='" + this.id + "', comment='" + this.comment + "', cpuAvailableCount='" + this.cpuAvailableCount + "', cpuTotalCount='" + this.cpuTotalCount + "', gpuAvailableCount='" + this.gpuAvailableCount + "', gpuTotalCount='" + this.gpuTotalCount + "', gpuTypes=" + this.gpuTypes + ", slaveCount=" + this.slaveCount + ", version='" + this.version + "'}";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class GPULabSlave {
        @Nullable
        private final String version;
        @Nullable
        private final String slaveHostname;
        @Nullable
        private final String clusterId;
        @Nullable
        private final List<String> gpuModels;
        @Nullable
        private final List<String> cpuModels;
        @Nullable
        private final String workerCount;
        @Nullable
        private final String systemMemoryMb;
        @Nullable
        private final Integer gpuCount;
        @Nullable
        private final Integer cpuCount;
        @Nullable
        private final Integer workerInuse;
        @Nullable
        private final Integer systemMemoryInuseMb;
        @Nullable
        private final Integer gpuInuse;
        @Nullable
        private final Integer cpuInuse;
        @Nullable
        private final String cudaVersionFull;
        @Nullable
        private final String lastUpdate;
        @Nullable
        private final String comment;

        @JsonCreator
        public GPULabSlave(@JsonProperty(value="version") @Nullable String version, @JsonProperty(value="slave_hostname") @Nullable String slaveHostname, @JsonProperty(value="cluster_id") @Nullable String clusterId, @JsonProperty(value="gpu_models") @Nullable List<String> gpuModels, @JsonProperty(value="cpu_models") @Nullable List<String> cpuModels, @JsonProperty(value="worker_count") @Nullable String workerCount, @JsonProperty(value="system_memory_mb") @Nullable String systemMemoryMb, @JsonProperty(value="gpu_count") @Nullable Integer gpuCount, @JsonProperty(value="cpu_count") @Nullable Integer cpuCount, @JsonProperty(value="worker_inuse") @Nullable Integer workerInuse, @JsonProperty(value="system_memory_inuse_mb") @Nullable Integer systemMemoryInuseMb, @JsonProperty(value="gpu_inuse") @Nullable Integer gpuInuse, @JsonProperty(value="cpu_inuse") @Nullable Integer cpuInuse, @JsonProperty(value="cuda_version_full") @Nullable String cudaVersionFull, @JsonProperty(value="last_update") @Nullable String lastUpdate, @JsonProperty(value="comment") @Nullable String comment) {
            this.version = version;
            this.slaveHostname = slaveHostname;
            this.clusterId = clusterId;
            this.gpuModels = gpuModels;
            this.cpuModels = cpuModels;
            this.workerCount = workerCount;
            this.systemMemoryMb = systemMemoryMb;
            this.gpuCount = gpuCount;
            this.cpuCount = cpuCount;
            this.workerInuse = workerInuse;
            this.systemMemoryInuseMb = systemMemoryInuseMb;
            this.gpuInuse = gpuInuse;
            this.cpuInuse = cpuInuse;
            this.cudaVersionFull = cudaVersionFull;
            this.lastUpdate = lastUpdate;
            this.comment = comment;
        }

        @JsonProperty(value="version")
        @Nullable
        public String getVersion() {
            return this.version;
        }

        @JsonProperty(value="slave_hostname")
        @Nullable
        public String getSlaveHostname() {
            return this.slaveHostname;
        }

        @JsonProperty(value="cluster_id")
        @Nullable
        public String getClusterId() {
            return this.clusterId;
        }

        @JsonProperty(value="gpu_models")
        @Nullable
        public List<String> getGpuModels() {
            return this.gpuModels;
        }

        @JsonProperty(value="cpu_models")
        @Nullable
        public List<String> getCpuModels() {
            return this.cpuModels;
        }

        @JsonProperty(value="worker_count")
        @Nullable
        public String getWorkerCount() {
            return this.workerCount;
        }

        @JsonProperty(value="system_memory_mb")
        @Nullable
        public String getSystemMemoryMb() {
            return this.systemMemoryMb;
        }

        @JsonProperty(value="gpu_count")
        @Nullable
        public Integer getGpuCount() {
            return this.gpuCount;
        }

        @JsonProperty(value="cpu_count")
        @Nullable
        public Integer getCpuCount() {
            return this.cpuCount;
        }

        @JsonProperty(value="worker_inuse")
        @Nullable
        public Integer getWorkerInuse() {
            return this.workerInuse;
        }

        @JsonProperty(value="system_memory_inuse_mb")
        @Nullable
        public Integer getSystemMemoryInuseMb() {
            return this.systemMemoryInuseMb;
        }

        @JsonProperty(value="gpu_inuse")
        @Nullable
        public Integer getGpuInuse() {
            return this.gpuInuse;
        }

        @JsonProperty(value="cpu_inuse")
        @Nullable
        public Integer getCpuInuse() {
            return this.cpuInuse;
        }

        @JsonProperty(value="cuda_version_full")
        @Nullable
        public String getCudaVersionFull() {
            return this.cudaVersionFull;
        }

        @JsonProperty(value="last_update")
        @Nullable
        public String getLastUpdate() {
            return this.lastUpdate;
        }

        @JsonProperty(value="comment")
        @Nullable
        public String getComment() {
            return this.comment;
        }

        public String toString() {
            return "GPULabSlave{version='" + this.version + "', slaveHostname='" + this.slaveHostname + "', clusterId='" + this.clusterId + "', gpuModels=" + this.gpuModels + ", cpuModels=" + this.cpuModels + ", workerCount='" + this.workerCount + "', systemMemoryMb='" + this.systemMemoryMb + "', gpuCount=" + this.gpuCount + ", cpuCount=" + this.cpuCount + ", workerInuse=" + this.workerInuse + ", systemMemoryInuseMb=" + this.systemMemoryInuseMb + ", gpuInuse=" + this.gpuInuse + ", cpuInuse=" + this.cpuInuse + ", cudaVersionFull='" + this.cudaVersionFull + "', lastUpdate='" + this.lastUpdate + "', comment='" + this.comment + "'}";
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    @JsonIgnoreProperties(ignoreUnknown=true)
    private static class GPULabJob {
        @Nullable
        private final String uuid;
        @Nullable
        private final String created;
        @Nullable
        private final String version;
        @Nullable
        private final String name;
        @Nullable
        private final String project;
        @Nullable
        private final String queueTime;
        @Nullable
        private final String state;
        @Nullable
        private final String username;

        @JsonCreator
        public GPULabJob(@JsonProperty(value="uuid") @Nullable String uuid, @JsonProperty(value="created") @Nullable String created, @JsonProperty(value="version") @Nullable String version, @JsonProperty(value="name") @Nullable String name, @JsonProperty(value="project") @Nullable String project, @JsonProperty(value="queue_time") @Nullable String queueTime, @JsonProperty(value="state") @Nullable String state, @JsonProperty(value="username") @Nullable String username) {
            this.uuid = uuid;
            this.created = created;
            this.version = version;
            this.name = name;
            this.project = project;
            this.queueTime = queueTime;
            this.state = state;
            this.username = username;
        }

        @JsonProperty
        @Nullable
        public String getUuid() {
            return this.uuid;
        }

        @JsonProperty
        @Nullable
        public String getCreated() {
            return this.created;
        }

        @JsonProperty
        @Nullable
        public String getVersion() {
            return this.version;
        }

        @JsonProperty
        @Nullable
        public String getName() {
            return this.name;
        }

        @JsonProperty
        @Nullable
        public String getProject() {
            return this.project;
        }

        @JsonProperty(value="queue_time")
        @Nullable
        public String getQueueTime() {
            return this.queueTime;
        }

        @JsonProperty
        @Nullable
        public String getState() {
            return this.state;
        }

        @JsonProperty
        @Nullable
        public String getUsername() {
            return this.username;
        }

        public String toString() {
            return "GPULabJob{uuid='" + this.uuid + "', created='" + this.created + "', version='" + this.version + "', name='" + this.name + "', project='" + this.project + "', queueTime='" + this.queueTime + "', state='" + this.state + "', username='" + this.username + "'}";
        }
    }
}

