/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.lowlevel.api.test;

import be.iminds.ilabt.jfed.lowlevel.api.test.TestNodeLogin;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticAggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.LegacyApiTestMetaData;
import be.iminds.ilabt.jfed.testing.shared.CommonAMTest;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStep;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import be.iminds.ilabt.jfed.util.common.TextUtil;
import be.iminds.ilabt.jfed.util.lib.AnsibleFileWriter;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestMultiNodeLogin
extends TestNodeLogin {
    private static final Logger LOG = LoggerFactory.getLogger(TestMultiNodeLogin.class);
    private static final LegacyApiTestMetaData metadata = new LegacyApiTestMetaData(){

        @Override
        @Nonnull
        public String getTestDescription() {
            return "This tests login to a multiple node on the same AM. AMv2 or AMv3 can be used. Links between the nodes will be tested using ping.The sliver will be deleted afterwards.";
        }

        @Override
        @Nonnull
        public List<String> getReqConfKeys() {
            return Collections.emptyList();
        }

        @Override
        @Nonnull
        public List<String> getOptConfKeys() {
            ArrayList<String> res = new ArrayList<String>(TestNodeLogin.getMetaData().getOptConfKeys());
            res.add("node_count");
            res.remove("fixed_node_urn");
            res.add("enable_ansible_test");
            res.add("enable_login_test");
            res.add("ansible_dir");
            res.add("ansible_cookbook");
            res.add("ansible_success_filter");
            res.add("ansible_warning_filter");
            res.add("ansible_failure_filter");
            res.add("ansible_success_regex");
            res.add("ansible_warning_regex");
            res.add("ansible_failure_regex");
            return res;
        }
    };
    private Boolean nodeLoginTestEnabled;
    private Boolean ansibleTestEnabled;
    private String ansibleDirName;
    private boolean ansibleDebug;
    private String ansiblePlaybookExeName;
    private String ansibleCookbookName;
    private String ansibleSuccessWord;
    private String ansibleWarningWord;
    private String ansibleFailureWord;
    private String ansibleSuccessRegex;
    private String ansibleWarningRegex;
    private String ansibleFailureRegex;
    private File ansibleDir;
    private File ansibleCookbook;

    @Inject
    public TestMultiNodeLogin(be.iminds.ilabt.jfed.log.Logger logger, TargetAuthority testedAuthority, GeniUserProvider geniUserProvider, LegacyApiTestConfig testConfig, JFedConnectionProvider connectionProvider, TestbedInfoSource testbedInfoSource, JFedPreferences jFedPreferences, AutomaticAggregateManagerWrapper.AutomaticAggregateManagerWrapperFactory automaticAggregateManagerWrapperFactory) {
        super(logger, testedAuthority, geniUserProvider, testConfig, connectionProvider, testbedInfoSource, jFedPreferences, automaticAggregateManagerWrapperFactory);
    }

    public static LegacyApiTestMetaData getMetaData() {
        return metadata;
    }

    private String makeNullIfEmpty(String s) {
        if (s == null) {
            return null;
        }
        if (s.trim().isEmpty()) {
            return null;
        }
        return s;
    }

    @Override
    public void setUp() {
        super.setUp();
        this.nodeLoginTestEnabled = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("enable_login_test"));
        this.ansibleTestEnabled = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("enable_ansible_test"));
        this.ansibleDirName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_dir");
        this.ansiblePlaybookExeName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_playbook_exe");
        this.ansibleCookbookName = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_cookbook");
        this.ansibleSuccessWord = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_success_filter"));
        this.ansibleWarningWord = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_warning_filter"));
        this.ansibleFailureWord = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_failure_filter"));
        this.ansibleSuccessRegex = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_success_regex"));
        this.ansibleWarningRegex = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_warning_regex"));
        this.ansibleFailureRegex = this.makeNullIfEmpty(((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_failure_regex"));
        this.ansibleDebug = Objects.equals(TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("ansible_debug")), Boolean.TRUE);
        if (this.ansibleTestEnabled != null && this.ansibleTestEnabled.booleanValue()) {
            if (this.ansiblePlaybookExeName == null || this.ansiblePlaybookExeName.trim().isEmpty()) {
                this.ansiblePlaybookExeName = "ansible-playbook";
            }
            this.assertNonEmptyString(this.ansibleCookbookName, "ansible_cookbook option must be specified");
            if (this.ansibleSuccessWord == null && this.ansibleSuccessRegex == null) {
                this.errorFatal("Either ansible_success_filter or ansible_success_regex option must be specified");
            }
            if (this.ansibleDirName == null) {
                try {
                    this.ansibleDir = Files.createTempDirectory("ansibleTest", new FileAttribute[0]).toFile();
                    this.ansibleDirName = this.ansibleDir.getAbsolutePath();
                }
                catch (IOException e) {
                    this.errorFatal("Could not create temporary dir for ansible files.", e);
                }
            } else {
                this.ansibleDir = new File(this.ansibleDirName);
            }
            if (this.ansibleCookbookName.startsWith("http://") || this.ansibleCookbookName.startsWith("https://")) {
                try {
                    String cookbookContent;
                    URL url = new URL(this.ansibleCookbookName);
                    try (InputStream is = url.openStream();){
                        cookbookContent = IOUtils.streamToString((InputStream)is, (String)"UTF-8");
                        if (cookbookContent.trim().isEmpty()) {
                            this.errorFatal("Empty cookbook read from URL \"" + this.ansibleCookbookName + "\"");
                        }
                        String head = TextUtil.abbreviate((String)cookbookContent, (int)200);
                        this.note("Downloaded Cookbook from \"" + this.ansibleCookbookName + "\". Cookbook size: " + cookbookContent.length() + " characters.\nHead: " + head);
                    }
                    this.ansibleCookbook = Files.createTempFile("cookbook", ".yml", new FileAttribute[0]).toFile();
                    IOUtils.stringToFile((File)this.ansibleCookbook, (String)cookbookContent);
                }
                catch (Exception e) {
                    this.errorFatal("Error reading cookbook from \"" + this.ansibleCookbookName + "\"", e);
                }
            } else {
                this.ansibleCookbook = new File(this.ansibleCookbookName);
            }
            if (!this.ansibleDir.exists() || !this.ansibleDir.isDirectory()) {
                File parentDir = this.ansibleDir.getParentFile();
                if (parentDir != null && !this.ansibleDir.exists() && parentDir.exists() && parentDir.isDirectory()) {
                    this.ansibleDir.mkdir();
                    if (!this.ansibleDir.exists() || !this.ansibleDir.isDirectory()) {
                        this.errorFatal("The ansible directory \"" + this.ansibleDirName + "\" does not exist and could be created.");
                    }
                } else {
                    this.errorFatal("The ansible directory \"" + this.ansibleDirName + "\" does not exist and will not be created because the parent dir doesn't exist either.");
                }
            }
            if (!(this.ansibleCookbook.exists() && this.ansibleCookbook.isFile() && this.ansibleCookbook.canRead())) {
                this.errorFatal("The ansible cookbook file \"" + this.ansibleCookbookName + "\" does not exist (or is not readable)");
            }
        }
    }

    @Override
    protected String getRequestRspec() throws IOException {
        String rspecArg;
        String nodeCountArg = ((LegacyApiTestConfig)this.getTestConfig()).getProperty("node_count");
        int nodeCount = 2;
        if (nodeCountArg != null) {
            nodeCount = Integer.parseInt(nodeCountArg);
        }
        if (nodeCount < 2) {
            this.warn("Node count is configured as " + nodeCountArg + " which is too small. Changing to minimum value: 2");
            nodeCount = 2;
        }
        if ((rspecArg = this.commonAMTest.getFixedRspecOption()) == null) {
            String sliverType = CommonAMTest.getSliverTypeForSite(this.testedAuthority.getServerForRspecComponentManager());
            boolean exclusive = CommonAMTest.getExclusiveForSite(this.testedAuthority.getServerForRspecComponentManager());
            String cmUrn = this.testedAuthority.getServerForRspecComponentManager().getDefaultComponentManagerUrn();
            RspecFactory rspecFactory = RspecFactoryFactory.getRspecFactoryInstance((ModelRspecType)ModelRspecType.BASIC);
            ModelRspec newRspec = rspecFactory.createModelRspec("request");
            RspecLink link = rspecFactory.createLinkWithClientId(newRspec, "link0", "lan");
            newRspec.addLink(link);
            for (int i = 0; i < nodeCount; ++i) {
                RspecNode node = rspecFactory.createNodeWithClientId(newRspec, "n" + i);
                node.setComponentManagerId(cmUrn);
                node.setSliverTypeName(sliverType);
                node.setExclusive(Boolean.valueOf(exclusive));
                newRspec.addNode(node);
                RspecInterface iface = rspecFactory.createInterface(node, link, "n" + i + ":if0");
                iface.getIpAddresses().add(new RspecInterface.IpAddress("192.168.1." + (i + 1), "255.255.255.0", "ipv4"));
            }
            assert (newRspec.getNodes().size() == nodeCount);
            assert (newRspec.getLinks().size() == 1);
            this.note("Generated RSpec with " + nodeCount + " nodes.");
            this.isGeniRspec = true;
            return newRspec.toGeni3Rspec();
        }
        this.isGeniRspec = this.commonAMTest.isGeniFixedRspec();
        return rspecArg;
    }

    private List<String> pingTargets(ModelRspec modelRspec, RspecNode node) {
        HashSet<String> res = new HashSet<String>();
        for (RspecLink link : node.getLinks()) {
            for (RspecInterface iface : link.getInterfaces()) {
                for (RspecInterface.IpAddress ip : iface.getIpAddresses()) {
                    res.add(ip.getAddress());
                }
            }
        }
        for (RspecInterface iface : node.getInterfaces()) {
            for (RspecInterface.IpAddress ip : iface.getIpAddresses()) {
                res.remove(ip.getAddress());
            }
        }
        return new ArrayList<String>(res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @ApiTest.Test(hardDepends={"createSliver"}, softDepends={"waitForSliverReady", "describeReadySliver"}, groups={"nodelogin"})
    public void testNodeLogin() throws JFedException, IOException {
        this.assertNotNull(this.notEnoughResourcesDetected);
        if (this.notEnoughResourcesDetected.booleanValue()) {
            this.warn("Test skipped because not enough free resources detected while tying to create the sliver(s)");
            return;
        }
        assert (this.nodeLoginTestStep != null);
        NodeLoginTestStep basicNodeLoginTestStep = this.nodeLoginTestStep;
        ImmutableRequestRspecSource rspecSource = new ImmutableRequestRspecSource(this.requestRspec, ModelRspecType.BASIC);
        ImmutableModelRspec modelRspec = rspecSource.getImmutableModelRspec();
        if (this.nodeLoginTestEnabled == null || this.nodeLoginTestEnabled.booleanValue()) {
            long now;
            long start = now = System.currentTimeMillis();
            long deadline = now + 1200000L;
            boolean allLoginOk = true;
            for (RspecNode node : modelRspec.getNodes()) {
                boolean isAuthenticated;
                NodeLoginTestStep nodeLoginTestStep = basicNodeLoginTestStep.copy();
                boolean foundNodeLogin = false;
                if (!foundNodeLogin && this.manifestRspec2 != null) {
                    foundNodeLogin = nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.manifestRspec2, null, node.getClientId());
                }
                if (!foundNodeLogin && this.manifestRspec != null) {
                    foundNodeLogin = nodeLoginTestStep.parseSshInfoFromGeni3ManifestRspec(this.manifestRspec, null, node.getClientId());
                }
                if (!foundNodeLogin || nodeLoginTestStep.getSshHostname() == null) {
                    this.errorNonFatal("No node / service / login in manifest RSpec for node \"" + node.getClientId() + "\", so SSH login cannot be tested.");
                    allLoginOk = false;
                    continue;
                }
                Boolean nodeloginUseExternalSsh = TextUtil.objectToBoolean((Object)((LegacyApiTestConfig)this.getTestConfig()).getProperty("nodelogin_use_external_ssh"));
                if (nodeloginUseExternalSsh == null) {
                    nodeloginUseExternalSsh = false;
                }
                if (nodeloginUseExternalSsh.booleanValue()) {
                    nodeLoginTestStep.testNodeLogin(false, this.geniUserProvider, this.slice.urn.toString());
                    continue;
                }
                String remainingMethods = "";
                SSHClient ssh = new SSHClient();
                ssh.setTimeout(8000);
                ssh.setConnectTimeout(10000);
                ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
                JFedConnection.SshProxyInfo sshProxy = nodeLoginTestStep.getNodeLoginSshProxy(this.geniUserProvider, this.slice.urn.toString());
                boolean forceSshProxyDns = false;
                if (sshProxy != null) {
                    this.note("Using SSH proxy for SSH node login test. info: " + sshProxy);
                    ssh.setSocketFactory((SocketFactory)SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)sshProxy, (String)nodeLoginTestStep.getSshHostname(), (int)nodeLoginTestStep.getSshPort()));
                    forceSshProxyDns = true;
                }
                do {
                    try {
                        if (forceSshProxyDns) {
                            ssh.connect("localhost", nodeLoginTestStep.getSshPort());
                        } else {
                            ssh.connect(nodeLoginTestStep.getSshHostname(), nodeLoginTestStep.getSshPort());
                        }
                        Object privateKeyToPrint = new String(nodeLoginTestStep.getSshKeyHelper().getPEMAnyPrivateKey());
                        if (((String)privateKeyToPrint).length() > 75) {
                            privateKeyToPrint = ((String)privateKeyToPrint).substring(0, 75) + " ...";
                        }
                        this.note("Connected to target node. Authenticating as " + nodeLoginTestStep.getSshUsername() + " with PEM private key:\n" + (String)privateKeyToPrint);
                        OpenSSHKeyFile key = new OpenSSHKeyFile();
                        key.init(new String(nodeLoginTestStep.getSshKeyHelper().getPEMRsaPrivateKey()), null);
                        ssh.authPublickey(nodeLoginTestStep.getSshUsername(), new KeyProvider[]{key});
                        isAuthenticated = true;
                    }
                    catch (IOException e) {
                        this.note("Exception while setting up SSH connection: " + e.getMessage());
                        isAuthenticated = false;
                    }
                    if (isAuthenticated) continue;
                    this.note("SSH connection not successful (should be available from the moment that status is 'ready').  Trying again in 30 seconds...");
                    try {
                        Thread.sleep(30000L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    now = System.currentTimeMillis();
                } while (!isAuthenticated && now < deadline);
                if (!isAuthenticated) {
                    this.errorNonFatal("Could not connect to node \"" + nodeLoginTestStep.getSshHostname() + "\" at port " + nodeLoginTestStep.getSshPort() + " " + remainingMethods);
                    allLoginOk = false;
                    continue;
                }
                this.note("SSH connection authenticated successfully, will open session.");
                try {
                    List<String> pingTargets = this.pingTargets((ModelRspec)modelRspec, node);
                    for (String targetIP : pingTargets) {
                        this.note("Trying to ping " + targetIP);
                        Session session = ssh.startSession();
                        String command = "ping -c 5 -n -w 30 " + targetIP;
                        Object result = "";
                        Object err = "";
                        try {
                            Session.Command comm = session.exec(command);
                            comm.join();
                            BufferedReader sout = new BufferedReader(new InputStreamReader(comm.getInputStream()));
                            BufferedReader serr = new BufferedReader(new InputStreamReader(comm.getErrorStream()));
                            String line = sout.readLine();
                            while (line != null) {
                                result = (String)result + line + "\n";
                                line = sout.readLine();
                            }
                            line = serr.readLine();
                            while (line != null) {
                                err = (String)err + line + "\n";
                                line = serr.readLine();
                            }
                        }
                        finally {
                            session.close();
                        }
                        this.note("\"" + command + "\" command on " + nodeLoginTestStep.getSshUsername() + "@" + nodeLoginTestStep.getSshHostname() + ":" + nodeLoginTestStep.getSshPort() + " result: \"" + ((String)result).trim() + "\". (stderr is: \"" + (String)err + "\")");
                        this.setErrorsNotFatal();
                        this.assertTrue(((String)result).length() > 5, "I executed \"ping\" on the remote host, and expected some reply. Instead I got: \"" + ((String)result).trim() + "\". (stderr is: \"" + (String)err + "\")");
                        this.commonAMTest.checkPingResult(session, (String)result);
                        this.setErrorsFatal();
                    }
                }
                finally {
                    ssh.close();
                }
            }
            if (!allLoginOk) {
                this.errorNonFatal("one or more login tests failed");
            }
        }
        LOG.debug("finished or skipped nodelogin test");
        if (this.ansibleTestEnabled != null && this.ansibleTestEnabled.booleanValue()) {
            LOG.debug("running ansible test");
            JFedConnection.SshProxyInfo sshProxy = this.nodeLoginTestStep.getNodeLoginSshProxy(this.geniUserProvider, this.slice.urn.toString());
            this.assertTrue(sshProxy == null, "ansible does not support an SSH proxy, but proxy configured: " + sshProxy);
            LOG.debug("  starting ansible test");
            this.ansibleTest((ModelRspec)modelRspec);
        }
    }

    private void ansibleTest(ModelRspec modelRspec) {
        try {
            this.writeAnsibleFiles(modelRspec);
            LOG.debug("   wrote ansible files to " + this.ansibleDir);
        }
        catch (IOException e) {
            this.errorFatal("Failed to write ansible files", e);
        }
        String output = this.callAnsible();
        LOG.debug("    got ansible output");
        if (output == null || output.trim().isEmpty()) {
            this.fatalError("Ansible did not return any output.");
        }
        this.note("Ansible output:\n" + output + "\n", true);
        TestMultiNodeLogin.checkAnsibleOutput(output, this, this.ansibleSuccessWord, this.ansibleWarningWord, this.ansibleFailureWord, this.ansibleSuccessRegex, this.ansibleWarningRegex, this.ansibleFailureRegex);
    }

    static void checkAnsibleOutput(String output, ApiTest test, String ansibleSuccessWord, String ansibleWarningWord, String ansibleFailureWord, String ansibleSuccessRegex, String ansibleWarningRegex, String ansibleFailureRegex) {
        if (ansibleFailureWord != null && output.contains(ansibleFailureWord)) {
            test.fatalError("Error: Ansible output contained \"" + ansibleFailureWord + "\"");
        }
        if (ansibleFailureRegex != null && Pattern.compile(ansibleFailureRegex).matcher(output).find()) {
            test.fatalError("Error: Ansible output matched regex \"" + ansibleFailureRegex + "\"");
        }
        if (ansibleWarningWord != null && output.contains(ansibleWarningWord)) {
            test.warn("Warning: Ansible output contained \"" + ansibleWarningWord + "\"");
        } else if (ansibleWarningRegex != null && Pattern.compile(ansibleWarningRegex).matcher(output).find()) {
            test.warn("Warning: Ansible output matched regex \"" + ansibleWarningRegex + "\"");
        } else if (ansibleSuccessWord != null && output.contains(ansibleSuccessWord)) {
            test.note("Success: Ansible output contained \"" + ansibleSuccessWord + "\"");
        } else if (ansibleSuccessRegex != null && Pattern.compile(ansibleSuccessRegex).matcher(output).find()) {
            test.note("Success: Ansible output matched regex \"" + ansibleSuccessRegex + "\"");
        } else if (ansibleSuccessWord != null) {
            if (ansibleSuccessRegex != null) {
                test.fatalError("Error: Ansible output did not contain \"" + ansibleSuccessWord + "\" or match regex \"" + ansibleSuccessRegex + "\"");
            } else {
                test.fatalError("Error: Ansible output did not contain \"" + ansibleSuccessWord + "\"");
            }
        } else {
            test.fatalError("Error: Ansible output did not match regex \"" + ansibleSuccessRegex + "\"");
        }
    }

    private void writeAnsibleFiles(ModelRspec modelRspec) throws IOException {
        AnsibleFileWriter ansibleFileWriter = AnsibleFileWriter.createWithCopiedPrivateKey((BasicStringRspec)new BasicStringRspec(this.requestRspec), (PrivateKey)this.nodeLoginTestStep.getSshKeyHelper().getSshPrivateKey(), (PublicKey)this.nodeLoginTestStep.getSshKeyHelper().getSshPublicKey(), (GeniUser)this.getUser(), null, (String)this.nodeLoginTestStep.getSshUsername());
        ansibleFileWriter.addAltBasicStringRspec(this.manifestRspec2);
        ansibleFileWriter.addAltBasicStringRspec(this.manifestRspec);
        ansibleFileWriter.writeFilesToDir(this.ansibleDir);
    }

    private String callAnsible() {
        ArrayList<String> command = new ArrayList<String>();
        assert (this.ansiblePlaybookExeName != null);
        command.add(this.ansiblePlaybookExeName);
        command.add(this.ansibleCookbook.getAbsolutePath());
        if (this.ansibleDebug) {
            command.add("-vvvv");
        }
        try {
            String line;
            ProcessBuilder pb = new ProcessBuilder(command);
            pb.directory(this.ansibleDir);
            pb = pb.redirectErrorStream(true);
            Process p = pb.start();
            BufferedReader input = new BufferedReader(new InputStreamReader(p.getInputStream()));
            Object output = "";
            while ((line = input.readLine()) != null) {
                output = (String)output + line + System.lineSeparator();
            }
            input.close();
            try {
                p.waitFor();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            return output;
        }
        catch (Exception e) {
            this.fatalError("Error trying to call ansible with command: " + command, e);
            return null;
        }
    }
}

