/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing;

import be.iminds.ilabt.jfed.testing.base.ApiTest;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestClassList {
    private static final Logger LOG = LoggerFactory.getLogger(TestClassList.class);
    private static final TestClassList ourInstance = new TestClassList();

    private TestClassList() {
    }

    public static TestClassList getInstance() {
        return ourInstance;
    }

    public List<String> allTestClasses() {
        return this.allTestClasses(false);
    }

    public List<String> allTestClasses(boolean ignoreNotFound) {
        ArrayList<String> res = new ArrayList<String>();
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.ConnectivityTestSliceAuthority");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAnyGetVersion");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAnyServiceGetVersion");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.ConnectivityTestAggregateManager3");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.ConnectivityTestAggregateManager2");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestSliceAuthority");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAggregateManager2");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAggregateManager3");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestNodeLogin");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestMultiNodeLogin");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAggregateManager2ListResources");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAggregateManager3ListResources");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestAggregateManager2NitosHack");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationMemberAuthority1");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationSliceAuthority1");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationRegistry1");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationMemberAuthority2");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationSliceAuthority2");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestFederationRegistry2");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestBestEffortAMv3");
        res.add("be.iminds.ilabt.jfed.lowlevel.api.test.TestGPULab");
        res.add("be.iminds.ilabt.jfed.testing.tests.highlevel.GuiLogicTest");
        res.add("be.iminds.ilabt.jfed.testing.tests.highlevel.ESpecTest");
        Iterator it = res.iterator();
        while (it.hasNext()) {
            String className = (String)it.next();
            try {
                Class<?> c = Class.forName(className);
                if (ApiTest.class.isAssignableFrom(c)) continue;
                LOG.error("Error in TestClassList.allTestClasses(): class \"" + className + "\" does not extend ApiTest");
                it.remove();
            }
            catch (ClassNotFoundException e) {
                if (!ignoreNotFound) {
                    LOG.error("Error in TestClassList.allTestClasses(): class \"" + className + "\" not found", (Throwable)e);
                }
                it.remove();
            }
        }
        return res;
    }

    public Collection<String> getGroups(Class<? extends ApiTest> clazz) {
        HashSet<String> res = new HashSet<String>();
        List<Method> methods = Arrays.asList(clazz.getMethods());
        for (Method m : methods) {
            Annotation[] annotations;
            for (Annotation annotation : annotations = m.getDeclaredAnnotations()) {
                if (!(annotation instanceof ApiTest.Test)) continue;
                ApiTest.Test testAn = (ApiTest.Test)annotation;
                Collections.addAll(res, testAn.groups());
            }
        }
        return res;
    }

    public Collection<String> getGroups(String className) {
        try {
            Class<?> c = Class.forName(className);
            if (!ApiTest.class.isAssignableFrom(c)) {
                throw new RuntimeException("Class \"" + className + "\" is not an ApiTest class");
            }
            Class<?> cc = c;
            return this.getGroups(cc);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class \"" + className + "\" not found", e);
        }
    }
}

