/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshFilesKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.ssh_terminal_tool.known_hosts.OpenSshKnownHostsFile;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.testing.shared.ProxyInfoGenerator;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import be.iminds.ilabt.jfed.util.lib.SSHKeyHelper;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import be.iminds.ilabt.jfed.util.library.LoggingSocketFactory;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpContentFile;
import be.iminds.ilabt.jfed.util.tmp_file_helpers.TmpFile;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xbill.DNS.Address;

public class NodeLoginTestStep {
    private static final Logger LOG = LoggerFactory.getLogger(NodeLoginTestStep.class);
    @Nonnull
    private ApiTest test;
    @Nonnull
    private SSHKeyHelper sshKeyHelper;
    private String sshUsername;
    private String sshHostname;
    private int sshPort;
    private JFedConnection.SshProxyInfo manifestSshProxy;
    private JFedConnection.SshProxyInfo nodeLoginSshProxy;
    private boolean parsed = false;
    @Nonnull
    private final NodeLoginTestStepConfig config;

    public NodeLoginTestStep(@Nonnull ApiTest test, @Nonnull NodeLoginTestStepConfig config) throws NoSuchAlgorithmException {
        this.test = test;
        this.config = config;
        switch (config.getSshKeySource()) {
            case PROVIDED: {
                this.sshKeyHelper = new SSHKeyHelper(config.getPublicKey(), config.getPrivateKey());
                break;
            }
            case RANDOM: {
                this.sshKeyHelper = new SSHKeyHelper();
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SSHKeySource in config: " + config.getSshKeySource());
            }
        }
    }

    private NodeLoginTestStep(NodeLoginTestStep o) {
        this.test = o.test;
        this.config = o.config;
        this.sshKeyHelper = o.sshKeyHelper;
        this.sshUsername = o.sshUsername;
        this.sshHostname = o.sshHostname;
        this.sshPort = o.sshPort;
        this.manifestSshProxy = o.manifestSshProxy;
        this.parsed = o.parsed;
    }

    @Nonnull
    public NodeLoginTestStepConfig getConfig() {
        return this.config;
    }

    public NodeLoginTestStep copy() {
        return new NodeLoginTestStep(this);
    }

    public boolean hasParsed() {
        return this.parsed;
    }

    public boolean parseSshInfoFromGeni3ManifestRspec(String rspec, Server server, String clientId) {
        BasicStringRspec basicStringRspec;
        List basicNodeInfos;
        if (rspec == null) {
            return false;
        }
        this.test.assertNotNull(rspec, "Rspec is null");
        if (rspec.contains("<RSpec")) {
            this.test.note("We received an SFA RSpec instead of a GENI RSpec v3, but we'll try to work around.");
            rspec = rspec.replace("<RSpec type=\"SFA\"", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("<RSpec ", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("</RSpec>", "</rspec>");
            rspec = rspec.replace("<network name=\"ple\">", "");
            rspec = rspec.replace("</network>", "");
        }
        if ((basicNodeInfos = (basicStringRspec = new BasicStringRspec(rspec)).getBasicNodeInfo()) == null) {
            this.test.warn("Failed to parse node login info from RSpec");
            return false;
        }
        this.parsed = true;
        ArrayList<BasicStringRspec.BasicNodeInfo> basicUsableNodeInfos = new ArrayList<BasicStringRspec.BasicNodeInfo>();
        for (BasicStringRspec.BasicNodeInfo basicNodeInfo : basicNodeInfos) {
            if (server != null && server.getDefaultComponentManagerUrn() != null && (basicNodeInfo.getComponentManagerId() == null || !Objects.equals(basicNodeInfo.getComponentManagerId(), server.getDefaultComponentManagerUrn())) || clientId != null && basicNodeInfo.getClientId() != null && !Objects.equals(basicNodeInfo.getClientId(), clientId) || basicNodeInfo.getClientId() == null && basicNodeInfo.getComponentId() == null) continue;
            basicUsableNodeInfos.add(basicNodeInfo);
        }
        int nodeCount = basicUsableNodeInfos.size();
        if (nodeCount > 0) {
            BestNodeLoginFinder.Feedback feedback = new BestNodeLoginFinder.Feedback(){

                public void info(String s) {
                    NodeLoginTestStep.this.test.note(s);
                }

                public void error(String s) {
                    NodeLoginTestStep.this.test.errorNonFatal(s);
                }

                public void debug(String s) {
                    LOG.debug(s);
                }
            };
            BestNodeLoginFinder finder = new BestNodeLoginFinder(basicStringRspec, this.config.getPreferredUser(), this.test.getUser(), feedback);
            BasicStringRspec.LoginService best = finder.findBestLogin(((BasicStringRspec.BasicNodeInfo)basicUsableNodeInfos.get(0)).getUniqueId());
            if (best != null) {
                this.sshUsername = best.getUsername();
                this.sshHostname = best.getHostname();
                this.sshPort = best.getPort();
                this.manifestSshProxy = best.getSshProxy();
                return true;
            }
            return false;
        }
        this.test.note("Found no nodes (with a client_id) in manifest RSpec" + (String)(server == null ? "" : " (for nodes of auth " + server.getDefaultComponentManagerUrn() + ")"));
        return false;
    }

    public void testNodeLogin(boolean warnIfNotYetReady, @Nonnull GeniUserProvider geniUserProvider, @Nonnull String sliceName) throws IOException {
        this.testNodeLogin(warnIfNotYetReady, !this.config.isUseExternalSsh(), geniUserProvider, sliceName);
    }

    public void testNodeLogin(boolean warnIfNotYetReady, boolean internalSsh, @Nonnull GeniUserProvider geniUserProvider, @Nonnull String sliceName) throws IOException {
        this.nodeLoginSshProxy = this.getNodeLoginSshProxy(geniUserProvider, sliceName);
        assert (this.parsed) : "No RSpec was parsed for node login info";
        if (!this.parsed) {
            this.test.skip("No manifest RSpec parsed yet, so SSH login cannot be tested.");
        }
        if (this.sshHostname == null) {
            this.test.skip("No node / service / login in manifest RSpec, so SSH login cannot be tested.");
        }
        if (this.nodeLoginSshProxy != null) {
            this.test.note("Config forces usage of proxy. Using private key for proxy matching public key: " + KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)this.nodeLoginSshProxy.getSshKeyInfo().getPublicKey()));
        } else {
            this.test.note("Config does not specify use of proxy (= will only use proxy if the testbed specifies one itself).");
        }
        Integer nodeLoginForceIpVersion = this.config.getNodeLoginForceIpVersion();
        if (nodeLoginForceIpVersion != null) {
            boolean skip = false;
            if (nodeLoginForceIpVersion != 4 && nodeLoginForceIpVersion != 6) {
                this.test.warn("nodelogin_force_ip_version property is set to invalid int: " + nodeLoginForceIpVersion + ". Supported: 4 or 6");
                skip = true;
            }
            if (this.sshHostname.matches("[0-9.]+")) {
                if (nodeLoginForceIpVersion == 4) {
                    this.test.note("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", and SSH hostname is already IPv4.");
                } else {
                    this.test.warn("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", but SSH hostname is IPv4: Will use IPv4 anyway!");
                }
                skip = true;
            }
            if (this.sshHostname.matches("[0-9A-fa-f:]+")) {
                if (nodeLoginForceIpVersion == 6) {
                    this.test.note("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", and SSH hostname is already IPv6.");
                } else {
                    this.test.warn("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", but SSH hostname is IPv6: Will use IPv6 anyway!");
                }
                skip = true;
            }
            if (!skip) {
                InetAddress[] addresses;
                boolean foundIp = false;
                String origSshHostname = this.sshHostname;
                for (InetAddress address : addresses = Address.getAllByName((String)this.sshHostname)) {
                    if (nodeLoginForceIpVersion == 4 && Address.familyOf((InetAddress)address) == 1) {
                        this.sshHostname = address.getHostAddress();
                        foundIp = true;
                        break;
                    }
                    if (nodeLoginForceIpVersion != 6 || Address.familyOf((InetAddress)address) != 2) continue;
                    this.sshHostname = address.getHostAddress();
                    foundIp = true;
                    break;
                }
                if (!foundIp) {
                    this.test.warn("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", but did not find an IPv" + nodeLoginForceIpVersion + " address for the SSH hostname (\"" + this.sshHostname + "\"). All found addresses: " + Arrays.asList(addresses));
                } else {
                    this.test.note("nodelogin_force_ip_version property is set to IPv" + nodeLoginForceIpVersion + ", and found an IPv" + nodeLoginForceIpVersion + " address (" + this.sshHostname + ") for the SSH hostname (\"" + origSshHostname + "\")");
                }
            }
        }
        if (internalSsh) {
            this.testNodeLoginInternalSsh(warnIfNotYetReady);
        } else {
            this.testNodeLoginExternalSsh(warnIfNotYetReady);
        }
    }

    private List<String> replace(List<String> orig, String match, String replacement) {
        ArrayList<String> res = new ArrayList<String>();
        for (String o : orig) {
            res.add(o.replace(match, replacement));
        }
        return res;
    }

    private void testNodeLoginExternalSsh(boolean warnIfNotYetReady) throws IOException {
        long now;
        long start = now = System.currentTimeMillis();
        long deadline = now + this.config.getNodeLoginDeadlineMs();
        this.test.note("Will test login using the local openssh executable (= using the linux command line)");
        String remoteCommand = "ls /";
        ArrayList<Object> tmpFiles = new ArrayList<Object>();
        List<String> sshCommandList = new ArrayList<String>(Arrays.asList("ssh", "-i", "$i", "$u@$h", "-oPort=$p", "-o", "PubKeyAcceptedAlgorithms=+ssh-rsa", "-o", "PubkeyAcceptedKeyTypes=+ssh-rsa", "-o", "UserKnownHostsFile=/dev/null", "-o", "StrictHostKeyChecking=no"));
        if (this.nodeLoginSshProxy != null) {
            assert (this.nodeLoginSshProxy instanceof JFedConnection.SshProxyInfo);
            JFedConnection.SshProxyInfo sshProxyInfo = this.nodeLoginSshProxy;
            if (sshProxyInfo.getHostKey() != null) {
                OpenSshKnownHostsFile openSshKnownHostsFile = new OpenSshKnownHostsFile();
                openSshKnownHostsFile.addKnownHost(sshProxyInfo.getHostname(), sshProxyInfo.getHostKey());
            }
            sshCommandList.addAll(Collections.singletonList("-oProxyCommand=\"ssh -i '$I' -oPort=$P $U@$H -W %h:%p\""));
            sshCommandList = this.replace(sshCommandList, "$P", "" + sshProxyInfo.getPort());
            sshCommandList = this.replace(sshCommandList, "$H", sshProxyInfo.getHostname());
            sshCommandList = this.replace(sshCommandList, "$U", sshProxyInfo.getUsername());
            if (sshProxyInfo.getSshKeyInfo() != null) {
                assert (sshProxyInfo.getSshKeyInfo() instanceof SshFilesKeyInfo) : "sshProxyInfo.getSshKeyInfo() -> " + sshProxyInfo.getSshKeyInfo().getClass().getName();
                SshFilesKeyInfo sshFilesKeyInfo = (SshFilesKeyInfo)sshProxyInfo.getSshKeyInfo();
                TmpFile tmpFile = sshFilesKeyInfo.getUnencryptedPrivateKeyFile();
                tmpFiles.add(tmpFile);
                sshCommandList = this.replace(sshCommandList, "$I", tmpFile.getFilename());
            }
        }
        TmpContentFile tmpPrivSshKeyFile = new TmpContentFile("testprivkey", "pem", new String(KeyUtil.privateKeyToAnyPem((PrivateKey)this.sshKeyHelper.getSshPrivateKey())), true);
        tmpFiles.add(tmpPrivSshKeyFile);
        sshCommandList = this.replace(sshCommandList, "$p", "" + this.sshPort);
        sshCommandList = this.replace(sshCommandList, "$h", this.sshHostname);
        sshCommandList = this.replace(sshCommandList, "$u", this.sshUsername);
        sshCommandList = this.replace(sshCommandList, "$i", tmpPrivSshKeyFile.getFilename());
        sshCommandList.add(remoteCommand);
        for (TmpFile tmpFile : tmpFiles) {
            tmpFile.store();
        }
        this.test.note("Using SSH commandList: " + sshCommandList);
        while (now <= deadline) {
            this.test.note("Trying to connect to " + this.sshHostname + ":" + this.sshPort + " as user \"" + this.sshUsername + "\"");
            try {
                boolean testSuccess;
                ProcessBuilder pb = new ProcessBuilder(sshCommandList);
                pb.redirectErrorStream(true);
                Process process = pb.start();
                BufferedReader input = new BufferedReader(new InputStreamReader(process.getInputStream()));
                Object allLines = "";
                String line = input.readLine();
                LOG.debug("Read line from SSH command: \"" + line + "\"");
                while (line != null) {
                    allLines = (String)allLines + line + "\n";
                    line = input.readLine();
                    LOG.debug("Read line from SSH command: \"" + line + "\"");
                }
                input.close();
                try {
                    process.waitFor();
                }
                catch (InterruptedException e) {
                    LOG.warn("ExternalTerminal Thread: processOutputMonitor thread interrupted while waiting for terminal to stop", (Throwable)e);
                }
                int exitVal = process.exitValue();
                LOG.info("SSH command exited with exit value (must be 0, certainly not 255): " + exitVal);
                this.test.note("SSH command exited with exit value (must be 0, certainly not 255): " + exitVal);
                this.test.note("SSH call result: \n" + (String)allLines, true);
                boolean bl = testSuccess = exitVal == 0 && ((String)allLines).length() > 5;
                if (testSuccess) {
                    this.test.assertTrue(process.exitValue() != 255, "I executed \"" + remoteCommand + "\" on the remote host, and expected a non 255 exit value. Instead I got " + process.exitValue());
                    this.test.assertTrue(process.exitValue() == 0, "I executed \"" + remoteCommand + "\" on the remote host, and expected a 0 exit value. Instead I got " + process.exitValue());
                    this.test.assertTrue(((String)allLines).length() > 5, "I executed \"" + remoteCommand + "\" on the remote host, and expected some reply. Instead I got: \"" + ((String)allLines).trim() + "\".");
                    for (TmpFile tmpFile : tmpFiles) {
                        tmpFile.delete();
                    }
                    return;
                }
                this.test.note("Login attempt failed");
            }
            catch (Exception e) {
                LOG.error("Unhandled Exception in ExternalTerminal Thread.", (Throwable)e);
            }
            catch (AssertionError e) {
                LOG.error("Unhandled AssertionError in ExternalTerminal Thread.", (Throwable)((Object)e));
            }
            this.test.note("Timing info: failed login attempt took " + (System.currentTimeMillis() - now) + " ms");
            if (warnIfNotYetReady) {
                this.test.warn("SSH connection not successful (should be available from the moment that status is 'ready').");
            } else {
                this.test.note("SSH connection not successful (should be available from the moment that status is 'ready').");
            }
            now = System.currentTimeMillis();
            if (now <= deadline) {
                try {
                    long sleepTimeMs = 30000L;
                    if (deadline - now < sleepTimeMs && (sleepTimeMs = deadline - now) > 1000L) {
                        sleepTimeMs -= 1000L;
                    }
                    this.test.note("Trying again in " + sleepTimeMs / 1000L + " seconds...");
                    Thread.sleep(sleepTimeMs);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        for (TmpFile tmpFile : tmpFiles) {
            tmpFile.delete();
        }
        this.test.fatalError("Could not login to host: connection setup, authentication with private key or remote command failed.");
    }

    private void testNodeLoginInternalSsh(boolean warnIfNotYetReady) throws IOException {
        long now;
        long start = now = System.currentTimeMillis();
        long deadline = now + this.config.getNodeLoginDeadlineMs();
        boolean isAuthenticated = false;
        LoggingSocketFactory.SocketLogger socketLogger = new LoggingSocketFactory.SocketLogger(){

            public void onConnectStart() {
                NodeLoginTestStep.this.test.note("SHH Connection setup start at " + new Date());
            }

            public void onConnectEnd() {
                NodeLoginTestStep.this.test.note("SHH Connection setup end at " + new Date());
            }

            public void onFirstReadStart() {
                NodeLoginTestStep.this.test.note("SHH Connection first read start at " + new Date());
            }

            public void onFirstReadEnd() {
                NodeLoginTestStep.this.test.note("SHH Connection first read end at " + new Date());
            }

            public void onFirstWriteStart() {
                NodeLoginTestStep.this.test.note("SHH Connection first write start at " + new Date());
            }

            public void onFirstWriteEnd() {
                NodeLoginTestStep.this.test.note("SHH Connection first write end at " + new Date());
            }

            public void onClose() {
                NodeLoginTestStep.this.test.note("SHH Connection close at " + new Date());
            }
        };
        Supplier<SSHClient> sshClientSupplier = () -> {
            SSHClient res = new SSHClient();
            res.setTimeout(8000);
            res.setConnectTimeout(10000);
            res.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
            LoggingSocketFactory loggingSocketFactory = new LoggingSocketFactory(SocketFactory.getDefault());
            loggingSocketFactory.addSocketLogger(socketLogger);
            res.setSocketFactory((SocketFactory)loggingSocketFactory);
            return res;
        };
        SSHClient ssh = sshClientSupplier.get();
        this.test.note("Will test login using the java library \"sshj\"");
        while (now <= deadline) {
            this.test.note("Trying to connect to " + this.sshHostname + ":" + this.sshPort + "   (will later try to authenticate as user \"" + this.sshUsername + "\")");
            boolean forceSshProxyDns = false;
            if (this.manifestSshProxy != null) {
                if (this.nodeLoginSshProxy != null) {
                    this.test.warn("A proxy was specified by the test config, AND by the AM in the manifest RSpec -> Will only use the proxy in the manifest RSpec!");
                }
                this.test.note("Will Use SSH proxy specified in manifest: " + this.manifestSshProxy.getUsername() + " @ " + this.manifestSshProxy.getHostname() + ":" + this.manifestSshProxy.getPort());
                JFedConnection.SshProxyInfo fullManifestSshProxy = new JFedConnection.SshProxyInfo(this.manifestSshProxy.getHostname(), this.manifestSshProxy.getPort(), this.manifestSshProxy.getUsername(), this.sshKeyHelper.toSshKeyInfo(), this.manifestSshProxy.getHostKey());
                LoggingSocketFactory loggingSocketFactory = new LoggingSocketFactory((SocketFactory)SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)fullManifestSshProxy, (String)this.sshHostname, (int)this.sshPort));
                loggingSocketFactory.addSocketLogger(socketLogger);
                ssh.setSocketFactory((SocketFactory)loggingSocketFactory);
                forceSshProxyDns = true;
            } else if (this.nodeLoginSshProxy != null) {
                LoggingSocketFactory loggingSocketFactory = new LoggingSocketFactory((SocketFactory)SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)this.nodeLoginSshProxy, (String)this.sshHostname, (int)this.sshPort));
                loggingSocketFactory.addSocketLogger(socketLogger);
                ssh.setSocketFactory((SocketFactory)loggingSocketFactory);
                forceSshProxyDns = true;
                this.test.note("Will Use SSH proxy for all SSH node login attempts that follow. info: " + this.nodeLoginSshProxy);
            }
            boolean isConnected = false;
            try {
                if (forceSshProxyDns) {
                    ssh.connect("localhost", this.sshPort);
                } else {
                    ssh.connect(this.sshHostname, this.sshPort);
                }
                isConnected = true;
            }
            catch (IOException e) {
                if (warnIfNotYetReady) {
                    this.test.warn("Exception while setting up SSH connection: " + e.getMessage(), e);
                } else {
                    this.test.note("Exception while setting up SSH connection: " + e.getMessage(), e);
                }
                isAuthenticated = false;
            }
            catch (IllegalThreadStateException e) {
                if (warnIfNotYetReady) {
                    this.test.note("IllegalThreadStateException while setting up SSH connection. Might be race condition in SSH library? Will fall back to handling it as a login failure...", e);
                }
                isAuthenticated = false;
                try {
                    ssh.disconnect();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    ssh.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ssh = sshClientSupplier.get();
            }
            if (isConnected) {
                try {
                    Object privateKeyToPrint = new String(this.sshKeyHelper.getPEMAnyPrivateKey());
                    if (((String)privateKeyToPrint).length() > 75) {
                        privateKeyToPrint = ((String)privateKeyToPrint).substring(0, 75) + " ...";
                    }
                    this.test.note("Connected to target node. Authenticating as " + this.sshUsername + " with PEM private key matching public key: " + this.sshKeyHelper.getSshPublicKeyString());
                    OpenSSHKeyFile key = new OpenSSHKeyFile();
                    key.init(new String(this.sshKeyHelper.getPEMRsaPrivateKey()), null);
                    ssh.authPublickey(this.sshUsername, new KeyProvider[]{key});
                    isAuthenticated = true;
                }
                catch (IOException e) {
                    if (warnIfNotYetReady) {
                        this.test.warn("Exception while authenticating over SSH connection: " + e.getMessage(), e);
                    } else {
                        this.test.note("Exception while authenticating over SSH connection: " + e.getMessage(), e);
                    }
                    isAuthenticated = false;
                }
            }
            if (isAuthenticated) break;
            this.test.note("Timing info: login attempt took " + (System.currentTimeMillis() - now) + " ms");
            if (warnIfNotYetReady) {
                this.test.warn("SSH connection not successful (should be available from the moment that status is 'ready').");
            } else {
                this.test.note("SSH connection not successful (should be available from the moment that status is 'ready').");
            }
            now = System.currentTimeMillis();
            if (now <= deadline) {
                try {
                    long sleepTimeMs = 30000L;
                    if (deadline - now < sleepTimeMs && (sleepTimeMs = deadline - now) > 1000L) {
                        sleepTimeMs -= 1000L;
                    }
                    this.test.note("Trying again in " + sleepTimeMs / 1000L + " seconds...");
                    Thread.sleep(sleepTimeMs);
                }
                catch (InterruptedException sleepTimeMs) {
                    // empty catch block
                }
            }
            now = System.currentTimeMillis();
        }
        this.test.assertTrue(isAuthenticated, "Could not login to host: connection setup or authentication with private key failed. " + this.sshUsername + "@" + this.sshHostname + ":" + this.sshPort);
        this.test.note("SSH connection authenticated successfully after " + (System.currentTimeMillis() - start) + " milliseconds, will open session.");
        Session session = ssh.startSession();
        this.test.assertTrue(session != null);
        this.test.note("SSH session opened successfully, will send command.");
        String remoteCommand = "ls / && uname -a && who && (netstat -antW | grep ':22 ')";
        Session.Command command = session.exec(remoteCommand);
        command.join();
        BufferedReader sout = new BufferedReader(new InputStreamReader(command.getInputStream()));
        BufferedReader serr = new BufferedReader(new InputStreamReader(command.getErrorStream()));
        Object result = "";
        Object err = "";
        String line = sout.readLine();
        while (line != null) {
            result = (String)result + line + "\n";
            line = sout.readLine();
        }
        line = serr.readLine();
        while (line != null) {
            err = (String)err + line + "\n";
            line = serr.readLine();
        }
        this.test.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("nodelogin", "stdout").setValue(result).setLarge(true));
        if (!((String)err).trim().isEmpty()) {
            this.test.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("nodelogin", "stderr").setValue(err).setLarge(true));
        }
        this.test.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("nodelogin", "command").setValue(remoteCommand).setLarge(false));
        this.test.addExtraResult(new ApiTestResult.ApiTestMethodResult.FedmonResultExtraBuilder().setKey("nodelogin", "node").setValue(this.sshUsername + "@" + this.sshHostname + ":" + this.sshPort).setLarge(false));
        this.test.note("\"" + remoteCommand + "\" command on " + this.sshUsername + "@" + this.sshHostname + ":" + this.sshPort + " \nresult: \"" + ((String)result).trim() + "\". \n(stderr is: \"" + (String)err + "\")", true);
        this.test.assertTrue(((String)result).length() > 5, "I executed \"" + remoteCommand + "\" on the remote host, and expected some reply. Instead I got: \"" + ((String)result).trim() + "\". (stderr is: \"" + (String)err + "\")");
        session.close();
        ssh.close();
    }

    @Nonnull
    public SSHKeyHelper getSshKeyHelper() {
        return this.sshKeyHelper;
    }

    public String getSshUsername() {
        return this.sshUsername;
    }

    public String getSshHostname() {
        return this.sshHostname;
    }

    public int getSshPort() {
        return this.sshPort;
    }

    public JFedConnection.SshProxyInfo getManifestSshProxy() {
        return this.manifestSshProxy;
    }

    public JFedConnection.SshProxyInfo getNodeLoginSshProxy(@Nonnull GeniUserProvider geniUserProvider, @Nonnull String sliceName) {
        this.nodeLoginSshProxy = ProxyInfoGenerator.generate(this.test, this.config.getProxyConfig(), geniUserProvider, sliceName, this.sshKeyHelper, this.sshUsername);
        return this.nodeLoginSshProxy;
    }

    public void checkManifestCorrectness(String rspec, TargetAuthority testedAuthority) {
        this.test.setErrorsAreWarnings(true);
        this.test.assertNotNull(rspec, "Manifest Rspec is null");
        if (rspec.contains("<RSpec")) {
            this.test.note("We received an SFA RSpec instead of a GENI RSpec v3, but we'll try to work around.");
            rspec = rspec.replace("<RSpec type=\"SFA\"", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("<RSpec ", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
            rspec = rspec.replace("</RSpec>", "</rspec>");
            rspec = rspec.replace("<network name=\"ple\">", "");
            rspec = rspec.replace("</network>", "");
        }
        ImmutableModelRspec model = new ManifestRspecSource(rspec, ModelRspecType.BASIC).getImmutableModelRspec();
        this.test.assertNotNull(model, "Problem parsing manifest RSpec: manifest is empty or not valid!");
        List nodes = model.getNodes();
        this.test.assertNotEmpty(nodes, "There are no nodes in the manifest RSpec");
        boolean gotAuthNode = false;
        for (RspecNode node : nodes) {
            this.test.assertNotNull(node.getClientId(), "The manifest RSpec contained a node without a client_id. Explanation: The AM must keep the client_id of all nodes in the request RSpec intact. Clients need the client_id to know which request node matches which node in the manifest.");
            if (node.getClientId() == null) continue;
            this.test.assertNotNull(node.getComponentManagerId(), "The manifest RSpec contained a node without a component_manager_id. client_id=\"" + node.getClientId() + "\"");
            if (node.getComponentManagerId() == null || !Objects.equals(node.getComponentManagerId(), testedAuthority.getRspecUrn())) continue;
            this.test.assertNotNull(node.getSliverId(), "The manifest RSpec contained a node without a sliver_id. client_id=\"" + node.getClientId() + "\". Explanation: The sliver_id must be set to a sliver URN by the AM for each node for which it is a component_manager. Clients need the sliver_id to know which node in the request matches which sliver in the Status/SliverStatus calls reply.");
            gotAuthNode = true;
        }
        this.test.assertTrue(gotAuthNode, "No nodes where found in the manifest for component_manager_id \"" + testedAuthority.getRspecUrn() + "\"");
        this.test.setErrorsAreWarnings(false);
    }
}

