/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.shared;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class Proxy {
    @Nonnull
    private final ProxyMode mode;
    @Nullable
    private final String hostName;
    @Nullable
    private final String hostKey;
    private final int hostPort;
    @Nonnull
    private final String username;
    @Nonnull
    private final ProxyKeySource keySource;

    public Proxy() {
        this.mode = ProxyMode.OFF;
        this.hostName = null;
        this.hostKey = null;
        this.hostPort = 22;
        this.username = "$USER";
        this.keySource = ProxyKeySource.USER;
    }

    @JsonCreator
    public Proxy(@Nullable @JsonProperty(value="mode") ProxyMode mode, @Nullable @JsonProperty(value="hostName") String hostName, @Nullable @JsonProperty(value="hostKey") String hostKey, @Nullable @JsonProperty(value="hostPort") Integer hostPort, @Nullable @JsonProperty(value="username") String username, @Nullable @JsonProperty(value="keySource") ProxyKeySource keySource) {
        this.mode = mode == null ? new Proxy().getMode() : mode;
        this.hostName = hostName;
        this.hostKey = hostKey;
        this.hostPort = hostPort == null ? new Proxy().getHostPort() : hostPort.intValue();
        this.username = username == null ? new Proxy().getUsername() : username;
        this.keySource = keySource == null ? new Proxy().getKeySource() : keySource;
    }

    @JsonIgnore
    public boolean isValid() {
        if (this.mode == ProxyMode.OFF) {
            return true;
        }
        if (this.mode == ProxyMode.USER_AUTHORITY) {
            return true;
        }
        if (this.getHostName() == null) {
            throw new IllegalArgumentException("Config Error: You must specify proxy.hostName if proxy.mode == MANUAL");
        }
        if (this.getHostKey() == null) {
            throw new IllegalArgumentException("Config Error: You must specify proxy.hostKey if proxy.mode == MANUAL");
        }
        return true;
    }

    @JsonProperty
    @Nonnull
    public ProxyMode getMode() {
        return this.mode;
    }

    @JsonProperty
    @Nullable
    public String getHostName() {
        return this.hostName;
    }

    @JsonProperty
    @Nullable
    public String getHostKey() {
        return this.hostKey;
    }

    @JsonProperty
    public int getHostPort() {
        return this.hostPort;
    }

    @JsonProperty
    @Nonnull
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    @Nonnull
    public ProxyKeySource getKeySource() {
        return this.keySource;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Proxy)) {
            return false;
        }
        Proxy proxy = (Proxy)o;
        if (this.hostPort != proxy.hostPort) {
            return false;
        }
        if (this.mode != proxy.mode) {
            return false;
        }
        if (this.hostName != null ? !this.hostName.equals(proxy.hostName) : proxy.hostName != null) {
            return false;
        }
        if (this.hostKey != null ? !this.hostKey.equals(proxy.hostKey) : proxy.hostKey != null) {
            return false;
        }
        if (!this.username.equals(proxy.username)) {
            return false;
        }
        return this.keySource == proxy.keySource;
    }

    public int hashCode() {
        int result = this.mode.hashCode();
        result = 31 * result + (this.hostName != null ? this.hostName.hashCode() : 0);
        result = 31 * result + (this.hostKey != null ? this.hostKey.hashCode() : 0);
        result = 31 * result + this.hostPort;
        result = 31 * result + this.username.hashCode();
        result = 31 * result + this.keySource.hashCode();
        return result;
    }

    public static enum ProxyMode {
        OFF,
        MANUAL,
        USER_AUTHORITY;

    }

    public static enum ProxyKeySource {
        USER,
        NODE;

    }
}

