/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.ui.test_cli;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.authority.legacy.TargetAuthority;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.testing.TestClassList;
import be.iminds.ilabt.jfed.testing.base.ApiTest;
import be.iminds.ilabt.jfed.testing.base.ApiTestFactory;
import be.iminds.ilabt.jfed.testing.base.ApiTestResult;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestModule;
import be.iminds.ilabt.jfed.testing.base.AutomatedTestRunner;
import be.iminds.ilabt.jfed.ui.commandline.BaseCli;
import be.iminds.ilabt.jfed.util.common.IOUtils;
import com.google.inject.AbstractModule;
import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Collection;
import java.util.Date;
import java.util.Objects;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutomatedTesterCli {
    private static final Logger LOG = LoggerFactory.getLogger(AutomatedTesterCli.class);
    private static Options optionsSingleton;

    protected String getIncludedTests() {
        return "basic tests";
    }

    public static void help(Options options, AutomatedTesterCli cli) {
        Object footer_extra = "";
        try {
            for (String testclass : TestClassList.getInstance().allTestClasses(true)) {
                footer_extra = (String)footer_extra + "   - " + testclass + "\n";
                Collection<String> groups = TestClassList.getInstance().getGroups(testclass);
                if (!groups.isEmpty()) {
                    footer_extra = (String)footer_extra + "      groups:\n";
                }
                for (String group : groups) {
                    footer_extra = (String)footer_extra + "       - " + group + "\n";
                }
            }
        }
        catch (Exception t) {
            LOG.error("Something went wrong trying to list all test classes and their groups: " + t.getMessage(), (Throwable)t);
        }
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "jfed-automated-testing-cli [options ... ]", "Options:", options, "\n\nExample Test Context Properties File content:\n  passwordFilename = <filename of file containing password (optional)>\n  pemKeyAndCertFilename = <filename of file containing user certificate and private key in PEM format>\n  testedAggregateManagerUrn = <URN of tested Aggregate Manager>\n\nKnown test classes: (" + cli.getIncludedTests() + ")\n" + (String)footer_extra);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException {
        int retval = AutomatedTesterCli.main_helper(args, System.out, System.err, System.in, new AutomatedTesterCli());
        System.exit(retval);
    }

    public static synchronized Options getOptions() {
        if (optionsSingleton == null) {
            optionsSingleton = new Options();
            BaseCli.addUserConfig((Options)optionsSingleton, (String)"The properties file containing context details (login, tested server, etc.) (MANDATORY)", (boolean)false);
            optionsSingleton.getOption("context-file").setRequired(true);
            BaseCli.addAuthoritiesConfig((Options)optionsSingleton);
            optionsSingleton.addOption(Option.builder((String)"C").longOpt("test-class").desc("Fully quantified test class name (MANDATORY)").hasArg().argName("CLASS NAME").required().build());
            optionsSingleton.addOption(Option.builder((String)"f").longOpt("test-config-file").desc("File containing the configuration for the test. If not specified, for low level tests, the context file is used, and for highlevel tests, an empty config is used.").hasArg().argName("TEST CONFIG FILENAME").build());
            optionsSingleton.addOption(Option.builder((String)"o").longOpt("output-dir").desc("Directory to write the generated reports (html file + PNGs).").hasArg().argName("DIR").build());
            optionsSingleton.addOption(Option.builder((String)"g").longOpt("group").desc("Test group to execute within test class (default: all methods)").hasArg().argName("NAME").build());
            optionsSingleton.addOption(Option.builder().longOpt("fake").desc("Do everything, expect for executing the actual tests (there are considered successful)").build());
            optionsSingleton.addOption("q", "quiet", false, "less output");
            optionsSingleton.addOption("S", "show-credentials", false, "do not automatically hide credentials and other security sensitive data. Obviously, this can be a security risk if the report is made available online.");
            optionsSingleton.addOption("d", "debug", false, "extra debugging output");
            optionsSingleton.addOption("h", "help", false, "show help");
        }
        return optionsSingleton;
    }

    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, AutomatedTesterCli cli) throws IOException, ClassNotFoundException {
        return AutomatedTesterCli.main_helper(args, out, err, in, new BaseCli(err), true, cli);
    }

    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, boolean temporarilyRedirectSystemStreams, AutomatedTesterCli cli) throws IOException, ClassNotFoundException {
        return AutomatedTesterCli.main_helper(args, out, err, in, new BaseCli(err), temporarilyRedirectSystemStreams, cli);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int main_helper(String[] args, PrintStream out, PrintStream err, InputStream in, BaseCli baseCli, boolean temporarilyRedirectSystemStreams, AutomatedTesterCli cli) throws IOException, ClassNotFoundException {
        PrintStream orig_out = System.out;
        PrintStream orig_err = System.err;
        InputStream orig_in = System.in;
        if (temporarilyRedirectSystemStreams) {
            System.setOut(out);
            System.setErr(err);
            System.setIn(in);
        }
        int retval = -1;
        try {
            retval = AutomatedTesterCli.main_internal(args, out, err, in, baseCli, cli);
        }
        finally {
            if (temporarilyRedirectSystemStreams) {
                System.setOut(orig_out);
                System.setErr(orig_err);
                System.setIn(orig_in);
            }
        }
        return retval;
    }

    public static int main_internal(String[] args, final PrintStream out, PrintStream err, InputStream in, BaseCli baseCli, AutomatedTesterCli cli) throws IOException, ClassNotFoundException {
        out.println("Automated tester CLI. Included tests in this version: " + cli.getIncludedTests());
        BasicParser parser = new BasicParser();
        Options options = AutomatedTesterCli.getOptions();
        if (args.length > 0 && (args[0].equals("--help") || args[0].equals("-h") || args[0].equals("-help"))) {
            AutomatedTesterCli.help(options, cli);
            return 0;
        }
        CommandLine line = null;
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException exp) {
            err.println("Command line argument Syntax error: " + exp.getMessage());
            AutomatedTesterCli.help(options, cli);
            return 3;
        }
        String outputdirArg = line.getOptionValue("output-dir");
        String group = line.getOptionValue("group");
        String testclassname = line.getOptionValue("test-class");
        boolean debug = line.hasOption("debug");
        boolean showCredentials = line.hasOption("show-credentials");
        boolean fake = line.hasOption("fake");
        boolean silent = line.hasOption("quiet");
        baseCli.initAuthoritiesModule(line);
        try {
            baseCli.initUserModule(line, out, err, in);
        }
        catch (BaseCli.CliArgumentException e) {
            LOG.debug("Got CliArgumentException", (Throwable)e);
            return 3;
        }
        try {
            baseCli.initTestTargetFromContextFileModule(line, out, err, in);
        }
        catch (BaseCli.CliArgumentException e) {
            LOG.debug("Got CliArgumentException", (Throwable)e);
            return 3;
        }
        Injector injector = baseCli.getInjector(err, new AbstractModule[]{new AutomatedTestModule()});
        assert (injector != null);
        TargetAuthority targetAuthority = (TargetAuthority)injector.getInstance(TargetAuthority.class);
        assert (targetAuthority != null);
        Server testedAuthorityToConnect = targetAuthority.getServerToConnect();
        Server testedAuthorityForRspec = targetAuthority.getServerForRspecComponentManager();
        assert (testedAuthorityToConnect != null);
        assert (testedAuthorityForRspec != null);
        GeniUser user = (GeniUser)injector.getInstance(GeniUser.class);
        assert (user != null);
        be.iminds.ilabt.jfed.log.Logger logger = (be.iminds.ilabt.jfed.log.Logger)injector.getInstance(be.iminds.ilabt.jfed.log.Logger.class);
        TestbedInfoSource testbedInfoSource = (TestbedInfoSource)injector.getInstance(TestbedInfoSource.class);
        if (Objects.equals(group, "null")) {
            group = null;
        }
        if (Objects.equals(group, "")) {
            group = null;
        }
        if (!BaseCli.checkUser((GeniUser)user, (CommandLine)line, (PrintStream)out, (PrintStream)err, (InputStream)in)) {
            return 3;
        }
        out.println("Got info on " + testbedInfoSource.getServers().size() + " servers.");
        if (!silent) {
            out.println("Read context properties from file \"" + line.getOptionValue("context-file") + "\":");
            out.println("   Tested Authority:" + testedAuthorityToConnect.getName());
            out.println("      URN (connect):" + testedAuthorityToConnect.getDefaultComponentManagerUrn());
            out.println("      URN (rspec):" + testedAuthorityForRspec.getDefaultComponentManagerUrn());
            out.println("      Hrn:" + testedAuthorityToConnect.getName());
            out.println("      Server certificates:" + testedAuthorityToConnect.getCertificateChain());
            out.println("      Allowed server certificate hostname alias:" + testedAuthorityToConnect.getAllowedCertificateAlias());
            out.println("   User:" + user.getUserUrnString());
            if (user.getUserAuthorityServer() != null) {
                out.println("      Authority URN:" + user.getUserAuthorityServer().getDefaultComponentManagerUrn());
            }
        }
        String testConfigString = line.hasOption("test-config-file") || testclassname.contains("jfed.testing.tests.highlevel") ? (line.hasOption("test-config-file") ? IOUtils.fileToString((String)line.getOptionValue("test-config-file")) : "{}") : IOUtils.fileToString((String)line.getOptionValue("context-file"));
        Class<?> testClass = Class.forName(testclassname);
        AutomatedTestRunner automatedTestRunner = (AutomatedTestRunner)injector.getInstance(AutomatedTestRunner.class);
        ApiTestFactory testFactory = (ApiTestFactory)injector.getInstance(ApiTestFactory.class);
        ApiTest test = null;
        try {
            test = testFactory.createApiTest(logger, targetAuthority, testClass, testConfigString);
        }
        catch (ApiTestFactory.InvalidApiTestException e) {
            err.println("Failed to create test: " + e.getMessage());
            LOG.error("InvalidApiTestException", (Throwable)e);
        }
        if (test == null) {
            throw new RuntimeException("Failed to create test (got null)");
        }
        assert (test != null);
        ApiTestResult result = automatedTestRunner.runTest(test, group, new AutomatedTestRunner.TestListener(){

            @Override
            public void onStart(String testname, int testNr, int testCount) {
                out.println("Running " + testname + "...");
            }

            @Override
            public void onResult(ApiTestResult.ApiTestMethodResult result, int testNr, int testCount) {
                out.println("                               " + result.getState().toString());
            }

            @Override
            public void onAllTestDone(ApiTestResult result, int testCount) {
            }
        }, fake);
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_hh-mm-ss");
        Date now = new Date();
        String outputFilenameHtml = "result.html";
        String outputFilenameXml = "result-overview.xml";
        Object outputdirname = "test-results-" + testClass.getSimpleName();
        if (group != null) {
            outputdirname = (String)outputdirname + "-" + group;
        }
        outputdirname = (String)outputdirname + "-" + dateFormat.format(now);
        if (outputdirArg != null) {
            outputdirname = outputdirArg;
        }
        File outputdir = new File((String)outputdirname).getAbsoluteFile();
        File outputFileHtml = new File(outputdir, outputFilenameHtml);
        File outputFileXml = new File(outputdir, outputFilenameXml);
        if (!outputdir.exists()) {
            if (outputdir.getParentFile() != null && !outputdir.getParentFile().exists()) {
                throw new RuntimeException("Error: parent directory \"" + outputdir.getParentFile() + "\" of output file does not exist.");
            }
            outputdir.mkdir();
        }
        out.println("Saving detailed results to \"" + outputFileHtml.getPath() + "\"...");
        result.toHtmlFile(outputFileHtml, showCredentials);
        out.println("Saving overview to \"" + outputFileXml.getPath() + "\"...");
        result.toXmlOverview(outputFileXml, showCredentials);
        return result.getReturnValue();
    }
}

