/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.adv_based_generator;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.rspec.adv_based_generator.AdvertisementBasedRspecGeneratorConfig;
import be.iminds.ilabt.jfed.rspec.model.HardwareType;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.AdvertisementRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Objects;
import java.util.Random;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class AdvertisementBasedRspecGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(AdvertisementBasedRspecGenerator.class);
    @Nonnull
    private final RspecFactory rspecFactory;
    @Nonnull
    private final AdvertisementBasedRspecGeneratorConfig config;
    @Nonnull
    private final AdvertisementRspecSource advRspecSource;
    @Nonnull
    private final TestbedInfoSource testbedInfoSource;
    private Random random = new Random();

    public AdvertisementBasedRspecGenerator(@Nonnull RspecFactory rspecFactory, @Nonnull AdvertisementBasedRspecGeneratorConfig config, @Nonnull AdvertisementRspecSource advRspecSource, @Nonnull TestbedInfoSource testbedInfoSource) {
        this.rspecFactory = rspecFactory;
        assert (rspecFactory.getModelRspecType() != ModelRspecType.IMMUTABLE);
        this.config = config;
        this.advRspecSource = advRspecSource;
        this.testbedInfoSource = testbedInfoSource;
    }

    /*
     * Could not resolve type clashes
     */
    public RequestRspecSource generate() {
        assert (this.advRspecSource != null);
        ImmutableModelRspec model = this.advRspecSource.getImmutableModelRspec();
        if (model == null) {
            throw new RspecGeneratorException("Problem with advertisement RSpec");
        }
        LinkedList<RspecNode> unusedNodes = new LinkedList<RspecNode>(model.getNodes());
        ModelRspec res = this.rspecFactory.createModelRspec("request");
        int linkId = 0;
        ArrayList nodesLinkToAll = new ArrayList();
        for (AdvertisementBasedRspecGeneratorConfig.NodeInfo nodeInfo : this.config.getNodes()) {
            int i;
            ArrayList<RspecNode> currentNodes = new ArrayList<RspecNode>();
            for (i = 0; i < nodeInfo.getCount(); ++i) {
                String compIdSelector;
                String string = nodeInfo.getComponentIdSelector() == null || nodeInfo.getComponentIdSelector().isEmpty() ? null : (compIdSelector = i < nodeInfo.getComponentIdSelector().size() ? nodeInfo.getComponentIdSelector().get(i) : nodeInfo.getComponentIdSelector().get(nodeInfo.getComponentIdSelector().size() - 1));
                if (nodeInfo.getServerId() == null) {
                    RspecNode n = this.findNode(unusedNodes, nodeInfo.getAvailableFilter(), nodeInfo.getSliverType(), nodeInfo.getHardwareTypeFilter(), compIdSelector, nodeInfo.getComponentIdFilter(), nodeInfo.getComponentNameDenyThenAllowOrDefault(), nodeInfo.getComponentNameAllowRegex(), nodeInfo.getComponentNameDenyRegex(), nodeInfo.getExclusive());
                    if (n == null) {
                        throw new RequiredResourcesUnavailableException();
                    }
                    RspecNode newNode = this.rspecFactory.createNode(res);
                    newNode.setComponentManagerId(n.getComponentManagerId());
                    newNode.setExclusive(n.getExclusive());
                    if (!Objects.equals(compIdSelector, "noassign")) {
                        newNode.setComponentId(n.getComponentId());
                    }
                    newNode.setSliverTypeName(nodeInfo.getSliverType() == null ? n.getSliverTypes().iterator().next().getName() : nodeInfo.getSliverType());
                    newNode.setClientId(this.createUniqueName(nodeInfo, res));
                    if (nodeInfo.getDiskImage() != null) {
                        newNode.setSliverTypeDiskImage(nodeInfo.getDiskImage());
                    }
                    if (nodeInfo.getAnsibleGroup() != null) {
                        newNode.getAnsibleGroups().add(nodeInfo.getAnsibleGroup());
                    }
                    currentNodes.add(newNode);
                    res.addNode(newNode);
                    continue;
                }
                assert (Objects.equals(compIdSelector, "noassign"));
                Server server = this.testbedInfoSource.getServerById(nodeInfo.getServerId());
                if (server == null) {
                    throw new RspecGeneratorException("AdvertisementBasedRspecGenerator config error: serverId=" + nodeInfo.getServerId() + " is unknown");
                }
                GeniUrn componentManagerId = server.getDefaultComponentManagerAsGeniUrn();
                RspecNode newNode = this.rspecFactory.createNode(res);
                newNode.setComponentManagerId(componentManagerId);
                newNode.setExclusive(nodeInfo.getExclusive() == null ? true : nodeInfo.getExclusive());
                newNode.setSliverTypeName(nodeInfo.getSliverType() == null ? "raw-pc" : nodeInfo.getSliverType());
                newNode.setClientId(this.createUniqueName(nodeInfo, res));
                if (nodeInfo.getDiskImage() != null) {
                    newNode.setSliverTypeDiskImage(nodeInfo.getDiskImage());
                }
                if (nodeInfo.getAnsibleGroup() != null) {
                    newNode.getAnsibleGroups().add(nodeInfo.getAnsibleGroup());
                }
                res.addNode(newNode);
                currentNodes.add(newNode);
            }
            if (nodeInfo.getLinkAllNodesOrDefault()) {
                nodesLinkToAll.addAll(currentNodes);
            }
            if (!nodeInfo.getLinkGroupNodesOrDefault()) continue;
            for (i = 0; i < currentNodes.size() - 1; ++i) {
                RspecLink l = null;
                int n = 1;
                for (int j = i + 1; j < currentNodes.size(); ++j) {
                    if (l == null) {
                        l = this.rspecFactory.createLinkWithClientId(res, "l" + linkId, "lan");
                        RspecInterface iface1 = this.rspecFactory.createInterface((RspecNode)currentNodes.get(i), l, "l" + linkId + ":if0");
                        iface1.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (linkId + 1) + ".1", "255.255.255.0", "ipv4"));
                    }
                    RspecInterface ifaceN = this.rspecFactory.createInterface((RspecNode)currentNodes.get(j), l, "l" + linkId + ":if" + n);
                    ifaceN.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (linkId + 1) + "." + (n + 1), "255.255.255.0", "ipv4"));
                    ++n;
                }
                if (l == null) continue;
                res.addLink(l);
                ++linkId;
            }
        }
        if (!nodesLinkToAll.isEmpty()) {
            for (RspecNode node : nodesLinkToAll) {
                RspecLink l = null;
                int n = 1;
                for (RspecNode otherNode : res.getNodes()) {
                    if (node.getUniqueId().equals(otherNode.getUniqueId()) || AdvertisementBasedRspecGenerator.nodesAreLinked(node, otherNode)) continue;
                    if (l == null) {
                        l = this.rspecFactory.createLinkWithClientId(res, "l" + linkId, "lan");
                        RspecInterface iface1 = this.rspecFactory.createInterface(node, l, "l" + linkId + ":if0");
                        iface1.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (linkId + 1) + ".1", "255.255.255.0", "ipv4"));
                    }
                    RspecInterface ifaceN = this.rspecFactory.createInterface(otherNode, l, "l" + linkId + ":if" + n);
                    ifaceN.getIpAddresses().add(new RspecInterface.IpAddress("192.168." + (linkId + 1) + "." + (n + 1), "255.255.255.0", "ipv4"));
                    ++n;
                }
                if (l == null) continue;
                res.addLink(l);
                ++linkId;
            }
        }
        return new ImmutableRequestRspecSource(res);
    }

    private static boolean nodesAreLinked(@Nonnull RspecNode a, @Nonnull RspecNode b) {
        return a.getLinks().stream().flatMap(l -> l.getInterfaces().stream()).map(RspecInterface::getNode).map(RspecNode::getUniqueId).anyMatch(uid -> uid.equals(b.getUniqueId()));
    }

    private String createUniqueName(@Nonnull AdvertisementBasedRspecGeneratorConfig.NodeInfo nodeInfo, @Nonnull ModelRspec res) {
        boolean nameUsedForMultipleNodes = nodeInfo.getCount() > 1;
        String clientIdBase = nodeInfo.getClientIdBase();
        if (!nameUsedForMultipleNodes) {
            for (AdvertisementBasedRspecGeneratorConfig.NodeInfo curNodeInfo : this.config.getNodes()) {
                if (curNodeInfo == nodeInfo || !curNodeInfo.getClientIdBase().equals(clientIdBase)) continue;
                nameUsedForMultipleNodes = true;
            }
        }
        if (res.getNodes().size() == 0) {
            return nameUsedForMultipleNodes ? clientIdBase + "1" : clientIdBase;
        }
        for (int i = 1; i <= res.getNodes().size() + 1; ++i) {
            Object proposedName = i == 1 && !nameUsedForMultipleNodes ? clientIdBase : clientIdBase + i;
            boolean proposedNameTaken = false;
            for (RspecNode rspecNode : res.getNodes()) {
                if (!((String)proposedName).equals(rspecNode.getClientId())) continue;
                proposedNameTaken = true;
            }
            if (proposedNameTaken) continue;
            return proposedName;
        }
        LOG.warn("Bug in createUniqueName. node names = [" + res.getNodes().stream().map(RspecNode::getClientId).collect(Collectors.joining(", ")) + "] clientIdBase=" + clientIdBase + " nameUsedForMultipleNodes=" + nameUsedForMultipleNodes);
        return clientIdBase + "-error-" + Math.random();
    }

    private RspecNode findNode(@Nonnull LinkedList<RspecNode> nodes, @Nullable Boolean available, @Nullable String sliverType, @Nullable List<String> hardwareTypeFilter, @Nullable String componentIdSelector, @Nullable List<String> componentIdFilter, boolean componentNameDenyThenAllow, @Nullable List<String> componentNameAllowRegex, @Nullable List<String> componentNameDenyRegex, Boolean exclusive) {
        LOG.debug("Looking for node in list of " + nodes.size());
        if (nodes.isEmpty()) {
            return null;
        }
        TreeSet<RspecNode> matchingNodes = new TreeSet<RspecNode>(new Comparator<RspecNode>(){

            @Override
            public int compare(RspecNode a, RspecNode b) {
                return a.getUniqueId().compareTo(b.getUniqueId());
            }
        });
        ListIterator it = nodes.listIterator();
        while (it.hasNext()) {
            RspecNode curNode;
            block35: {
                block36: {
                    boolean hasCompNameDenyFilter;
                    block33: {
                        block34: {
                            curNode = (RspecNode)it.next();
                            if (available != null && curNode.getAvailable() != null && !curNode.getAvailable().equals(available)) {
                                LOG.debug("Node skipped due to available");
                                continue;
                            }
                            if (componentIdSelector != null && componentIdSelector.startsWith("urn:") && (curNode.getComponentId() == null || !curNode.getComponentId().toString().equals(componentIdSelector))) {
                                LOG.debug("Node skipped due to componentIdSelector");
                                continue;
                            }
                            if (hardwareTypeFilter == null || hardwareTypeFilter.isEmpty()) break block33;
                            if (curNode.getHardwareTypes() == null) break block34;
                            if (!curNode.getHardwareTypes().stream().map(HardwareType::getName).filter(Objects::nonNull).noneMatch(hardwareTypeFilter::contains)) break block33;
                        }
                        LOG.debug("Node skipped due to hardwareTypeFilter");
                        continue;
                    }
                    if (componentIdFilter != null && !componentIdFilter.isEmpty() && !componentIdFilter.contains(curNode.getComponentId().toString())) {
                        LOG.debug("Node skipped due to componentIdFilter");
                        continue;
                    }
                    boolean hasCompNameAllowFilter = componentNameAllowRegex != null && !componentNameAllowRegex.isEmpty();
                    boolean bl = hasCompNameDenyFilter = componentNameDenyRegex != null && !componentNameDenyRegex.isEmpty();
                    if (hasCompNameAllowFilter || hasCompNameDenyFilter) {
                        boolean inDeny;
                        boolean inAllow;
                        String nodeName = curNode.getComponentName();
                        if (nodeName == null && curNode.getComponentManagerId() != null) {
                            nodeName = curNode.getComponentManagerId().getEncodedResourceName();
                        }
                        if (nodeName != null) {
                            inAllow = false;
                            inDeny = false;
                            if (hasCompNameAllowFilter) {
                                for (String allowFilter : componentNameAllowRegex) {
                                    if (!nodeName.matches(allowFilter)) continue;
                                    inAllow = true;
                                }
                            } else {
                                inAllow = true;
                            }
                            if (hasCompNameDenyFilter) {
                                for (String DenyFilter : componentNameDenyRegex) {
                                    if (!nodeName.matches(DenyFilter)) continue;
                                    inDeny = true;
                                }
                            } else {
                                inDeny = true;
                            }
                        } else {
                            inAllow = false;
                            inDeny = false;
                        }
                        boolean skip = false;
                        if (componentNameDenyThenAllow) {
                            if (inDeny || !inAllow) {
                                skip = true;
                            }
                        } else if (!inAllow && inDeny) {
                            skip = true;
                        }
                        if (skip) {
                            LOG.debug("Node skipped due to componentName regex");
                            continue;
                        }
                    }
                    if (sliverType == null || sliverType.isEmpty()) break block35;
                    if (curNode.getHardwareTypes() == null) break block36;
                    if (!curNode.getSliverTypes().stream().map(SliverType::getName).filter(Objects::nonNull).noneMatch(sliverType::equals)) break block35;
                }
                LOG.debug("Node skipped due to sliverType");
                continue;
            }
            if (exclusive != null && exclusive.booleanValue() && (curNode.getExclusive() == null || Objects.equals(curNode.getExclusive(), Boolean.FALSE))) {
                LOG.debug("Node skipped due to exclusive");
                continue;
            }
            it.remove();
            matchingNodes.add(curNode);
        }
        if (matchingNodes.isEmpty()) {
            LOG.debug("No matching nodes found");
            return null;
        }
        int chosenIndex = 0;
        if (componentIdSelector != null && componentIdSelector.equalsIgnoreCase("random")) {
            chosenIndex = this.random.nextInt(matchingNodes.size());
        }
        LinkedList<RspecNode> matchingNodesList = new LinkedList<RspecNode>(matchingNodes);
        RspecNode res = matchingNodesList.remove(chosenIndex);
        nodes.addAll(matchingNodesList);
        if (exclusive == null && Objects.equals(res.getExclusive(), Boolean.FALSE) || Objects.equals(exclusive, Boolean.FALSE)) {
            nodes.add(res);
            LOG.debug("Node is not exclusive -> can use again");
        } else {
            LOG.debug("Node is exclusive (" + exclusive + " " + res.getExclusive() + ") -> will not use again");
        }
        return res;
    }

    public static class RspecGeneratorException
    extends RuntimeException {
        public RspecGeneratorException() {
            super("Error generating RSpec");
        }

        public RspecGeneratorException(String s) {
            super(s);
        }

        public RspecGeneratorException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public RspecGeneratorException(Throwable throwable) {
            super(throwable);
        }

        public RspecGeneratorException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }

    public static class RequiredResourcesUnavailableException
    extends RspecGeneratorException {
        public RequiredResourcesUnavailableException() {
            super("The required resources are not available");
        }

        public RequiredResourcesUnavailableException(String s) {
            super(s);
        }

        public RequiredResourcesUnavailableException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public RequiredResourcesUnavailableException(Throwable throwable) {
            super(throwable);
        }

        public RequiredResourcesUnavailableException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }
}

