/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model;

import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecFactory;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecFactoryFactory {
    private static final Logger LOG = LoggerFactory.getLogger(RspecFactoryFactory.class);
    private static final RspecFactory fxRspecFactory;

    private RspecFactoryFactory() {
    }

    @Nonnull
    public static RspecFactory getRspecFactoryInstance(@Nonnull ModelRspecType modelRspecType) {
        switch (modelRspecType) {
            case BASIC: {
                return BasicRspecFactory.getInstance();
            }
            case FX: {
                assert (fxRspecFactory != null);
                return fxRspecFactory;
            }
            case IMMUTABLE: {
                return ImmutableRspecFactory.getInstance();
            }
        }
        throw new RuntimeException("Unexpected ModelRspecType " + modelRspecType);
    }

    static {
        RspecFactory factory = null;
        try {
            Class<?> fxRspecFactoryClazz = Class.forName("be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory");
            Method m = fxRspecFactoryClazz.getDeclaredMethod("getInstance", new Class[0]);
            factory = (RspecFactory)m.invoke(null, new Object[0]);
        }
        catch (ClassNotFoundException e) {
            LOG.debug("Could not find FXRspecFactory. rspec-fx probably isn't loaded. (ClassNotFoundException not logged)");
        }
        catch (NoSuchMethodException e) {
            LOG.error("Could not find FXRspecFactory#getInstance.", (Throwable)e);
        }
        catch (IllegalAccessException | InvocationTargetException e) {
            LOG.error("Error while creating FXRspecFactory", (Throwable)e);
        }
        catch (AssertionError e) {
            LOG.error("AssertionError while creating FXRspecFactory", (Throwable)((Object)e));
        }
        catch (Exception t) {
            LOG.error("Another fatal error while creating staticly FXRspecFactory: " + t.getMessage(), (Throwable)t);
        }
        fxRspecFactory = factory;
    }
}

