/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.model.impl;

import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.rspec.model.AddressPool;
import be.iminds.ilabt.jfed.rspec.model.AnsibleService;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.DistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.ExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.GeantTestbedType;
import be.iminds.ilabt.jfed.rspec.model.IPv4;
import be.iminds.ilabt.jfed.rspec.model.InstallService;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.LinkSetting;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.OpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.RspecFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecInterface;
import be.iminds.ilabt.jfed.rspec.model.RspecLink;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.WebVncService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicAddressPool;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicAnsibleService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicChannel;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicDistributeSshKeypair;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteAnsiblePlaybook;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicExecuteService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicGeantTestbedType;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicIPv4;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicInstallService;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicLease;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicLinkSetting;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicModelRspec;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicOpenflowDataPath;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecInterface;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecLink;
import be.iminds.ilabt.jfed.rspec.model.impl.BasicRspecNode;
import be.iminds.ilabt.jfed.rspec.parser.EventListExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.ExtraXml;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BasicRspecFactory
implements RspecFactory {
    private static final Logger LOG = LoggerFactory.getLogger(BasicRspecFactory.class);
    private static final BasicRspecFactory INSTANCE = new BasicRspecFactory();

    @Nonnull
    public static BasicRspecFactory getInstance() {
        return INSTANCE;
    }

    private BasicRspecFactory() {
    }

    @Override
    @Nonnull
    public ModelRspecType getModelRspecType() {
        return ModelRspecType.BASIC;
    }

    @Override
    @Nonnull
    public BasicRspecNode createNode(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec == null || modelRspec instanceof BasicModelRspec) : modelRspec.getClass().getName();
        return new BasicRspecNode((BasicModelRspec)modelRspec, null);
    }

    @Override
    @Nonnull
    public BasicRspecNode createNodeWithClientId(@Nonnull ModelRspec modelRspec, @Nullable String id) {
        assert (modelRspec == null || modelRspec instanceof BasicModelRspec) : modelRspec.getClass().getName();
        return new BasicRspecNode((BasicModelRspec)modelRspec, id);
    }

    @Override
    @Nonnull
    public BasicRspecNode copyNode(@Nonnull ModelRspec newModelRspec, @Nonnull RspecNode rspecNode, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        assert (newModelRspec instanceof BasicModelRspec);
        assert (rspecNode instanceof BasicRspecNode);
        return new BasicRspecNode((BasicModelRspec)newModelRspec, rspecNode, interfaceCopyMethod);
    }

    @Override
    @Nonnull
    public BasicRspecNode copyNodeIncludingInterfaces(@Nonnull ModelRspec newModelRspec, @Nonnull RspecNode rspecNode) {
        assert (newModelRspec instanceof BasicModelRspec);
        assert (rspecNode instanceof BasicRspecNode);
        return new BasicRspecNode((BasicModelRspec)newModelRspec, rspecNode, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
    }

    @Override
    @Nonnull
    public GeantTestbedType copyGeantTestbedType(@Nonnull ModelRspec modelRSpec, @Nonnull GeantTestbedType gtt) {
        return new BasicGeantTestbedType(gtt);
    }

    @Override
    @Nonnull
    public RspecNode convertToSpecialNode(@Nonnull RspecNode origNode) throws RspecParseException {
        assert (origNode != null);
        assert (origNode instanceof BasicRspecNode);
        return origNode;
    }

    @Override
    @Nonnull
    public BasicRspecLink createLink(@Nonnull ModelRspec modelRspec, @Nullable String addDefaultLinkType) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicRspecLink((BasicModelRspec)modelRspec, null, addDefaultLinkType);
    }

    @Override
    @Nonnull
    public BasicRspecLink createLinkWithClientId(@Nonnull ModelRspec modelRspec, @Nonnull String id, @Nullable String addDefaultLinkType) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicRspecLink((BasicModelRspec)modelRspec, id, addDefaultLinkType);
    }

    @Override
    @Nonnull
    public BasicRspecLink copyLink(@Nonnull ModelRspec newModelRspec, @Nonnull RspecLink rspecLink, @Nonnull RspecNode.InterfaceCopyMethod interfaceCopyMethod) {
        assert (newModelRspec instanceof BasicModelRspec);
        return new BasicRspecLink((BasicModelRspec)newModelRspec, rspecLink, interfaceCopyMethod);
    }

    @Override
    @Nonnull
    public BasicRspecInterface createInterface(@Nonnull RspecNode node, @Nullable String id) {
        assert (node instanceof BasicRspecNode);
        return new BasicRspecInterface((BasicRspecNode)node, id);
    }

    @Override
    @Nonnull
    public BasicRspecInterface createInterface(@Nonnull RspecLink link, @Nullable String id) {
        assert (link instanceof BasicRspecLink);
        return new BasicRspecInterface((BasicRspecLink)link, id);
    }

    @Override
    @Nonnull
    public BasicRspecInterface createInterface(@Nonnull RspecNode node, @Nonnull RspecLink link, @Nullable String id) {
        assert (node instanceof BasicRspecNode);
        assert (link instanceof BasicRspecLink);
        return new BasicRspecInterface((BasicRspecNode)node, (BasicRspecLink)link, id);
    }

    @Override
    @Nonnull
    public BasicRspecInterface createInterface(@Nonnull RspecNode node, @Nonnull RspecLink link) {
        assert (node instanceof BasicRspecNode);
        assert (link instanceof BasicRspecLink);
        assert (node.getRspec() == link.getRspec());
        assert (node.getRspec() instanceof BasicModelRspec);
        String newClientId = node.getRspec().nextIfaceName(node);
        return new BasicRspecInterface((BasicRspecNode)node, (BasicRspecLink)link, newClientId);
    }

    @Override
    @Nonnull
    public LinkSetting createLinkSetting(@Nonnull RspecInterface fromIface, @Nonnull RspecInterface toIface) {
        assert (fromIface instanceof BasicRspecInterface);
        assert (toIface instanceof BasicRspecInterface);
        return new BasicLinkSetting((BasicRspecInterface)fromIface, (BasicRspecInterface)toIface);
    }

    @Override
    @Nonnull
    public ExecuteService createExecuteService(@Nullable String shell, @Nullable String command) {
        return new BasicExecuteService(shell, command);
    }

    @Override
    @Nonnull
    public InstallService createInstallService(@Nullable String installPath, @Nullable String url) {
        return new BasicInstallService(installPath, url);
    }

    @Override
    @Nonnull
    public AnsibleService createAnsibleService() {
        return new BasicAnsibleService();
    }

    @Override
    @Nonnull
    public BasicModelRspec createModelRspec(@Nullable String rspecType) {
        return new BasicModelRspec(rspecType);
    }

    @Override
    @Nonnull
    public BasicModelRspec copyModelRspec(@Nonnull ModelRspec orig, @Nullable String newType) {
        BasicModelRspec res = this.createModelRspec(newType == null ? orig.getType() : newType);
        res.setParseData(orig.getSchemaLocation(), orig.getOrigDefaultNamespace(), orig.getNameSpaceInfo());
        for (RspecNode rspecNode : orig.getNodes()) {
            res.addNode(new BasicRspecNode(res, rspecNode, RspecNode.InterfaceCopyMethod.NO_COPY));
        }
        res.setHardwareTypeInfo(orig.getHardwareTypeInfo());
        for (RspecNode rspecNode : orig.getNodes()) {
            BasicRspecNode copiedNode = res.getNodeByUniqueId(rspecNode.getUniqueId());
            assert (copiedNode != null);
            rspecNode.getInterfaces().stream().filter(iface -> !iface.isLinkBound()).forEach(iface -> {
                BasicRspecInterface ifaceCopy = new BasicRspecInterface(copiedNode, iface.getClientId());
                ifaceCopy.overwritePropertiesWith((RspecInterface)iface, true);
            });
        }
        for (RspecLink rspecLink : orig.getLinks()) {
            BasicRspecLink newLink = new BasicRspecLink(res, rspecLink, RspecNode.InterfaceCopyMethod.CREATE_NEW_INTERFACE);
            res.addLink(newLink);
            for (RspecInterface rspecInterface : rspecLink.getInterfaces()) {
                BasicRspecNode newNode;
                BasicRspecInterface newIface = newLink.getInterfaceByClientId(rspecInterface.getClientId());
                BasicRspecNode basicRspecNode = newNode = rspecInterface.getNode() == null ? null : res.getNodeByUniqueId(rspecInterface.getNode().getUniqueId());
                assert (newIface != null);
                if (newIface == null) continue;
                newIface.bindNode(newNode);
                newIface.overwritePropertiesWith(rspecInterface, true);
            }
        }
        for (OpenflowDataPath openflowDataPath : orig.getOpenflowDataPaths()) {
            BasicOpenflowDataPath newOdp = new BasicOpenflowDataPath(openflowDataPath.getAsExtraXml(), openflowDataPath.getComponentManagerId(), openflowDataPath.getComponentId(), openflowDataPath.getDpid());
            res.addOpenflowDataPath(newOdp);
        }
        for (Lease lease : orig.getLeases()) {
            res.addLease(new BasicLease(lease));
        }
        for (Channel channel : orig.getChannels()) {
            res.addChannel(new BasicChannel(channel));
        }
        for (AddressPool addressPool : orig.getAddressPools()) {
            res.addAddressPool(new BasicAddressPool(addressPool));
        }
        for (GeantTestbedType geantTestbedType : orig.getGeantTestbedTypes()) {
            res.addGeantTestbedType(new BasicGeantTestbedType(geantTestbedType));
        }
        res.getDiskImageLists().addAll(orig.getDiskImageLists());
        res.getFlavorLists().addAll(orig.getFlavorLists());
        ArrayList<ExtraXml> extraXmlCopy = new ArrayList<ExtraXml>();
        extraXmlCopy.addAll(orig.getExtraXml());
        res.setExtraXml(extraXmlCopy);
        List<UserSpec> list = orig.getSshKeys().stream().map(UserSpec::new).collect(Collectors.toList());
        res.setSshKeys(list);
        res.setRoutableAddressesAvailable(orig.getRoutableAddressesAvailable());
        res.setRoutableAddressesConfigured(orig.getRoutableAddressesConfigured());
        res.setExpires(orig.getExpiresString());
        orig.getExecuteAnsiblePlaybooks().forEach(res::addExecuteAnsiblePlaybook);
        return res;
    }

    @Override
    public boolean processExtraLinkXml(@Nonnull RspecLink link, @Nonnull EventListExtraXml extraXml) throws RspecParseException {
        return false;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof BasicRspecFactory;
    }

    @Override
    public int hashCode() {
        return BasicRspecFactory.class.hashCode();
    }

    @Override
    public void mergeExtra(@Nonnull ModelRspec mergedModel, @Nonnull ModelRspec partialRspec) {
        partialRspec.getChannels().forEach(mergedModel::addChannel);
        partialRspec.getLeases().forEach(mergedModel::addLease);
    }

    @Override
    @Nonnull
    public OpenflowDataPath createOpenflowDataPath(@Nonnull ModelRspec modelRspec, @Nonnull EventListExtraXml allXml, @Nullable String componentManagerId, @Nullable String componentId, @Nullable String dpidAttValue) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicOpenflowDataPath(allXml, componentManagerId, componentId, dpidAttValue);
    }

    @Override
    @Nonnull
    public Lease createLease(@Nonnull ModelRspec rspec, @Nullable String leaseId, @Nullable String clientId, @Nullable Date validFromDate, @Nullable Date validUntilDate, @Nullable String validFromString, @Nullable String validUntilString) {
        assert (rspec instanceof BasicModelRspec);
        return new BasicLease(leaseId, clientId, validFromDate, validUntilDate, validFromString, validUntilString);
    }

    @Override
    @Nonnull
    public Lease createLease(@Nonnull ModelRspec rspec, @Nullable String leaseId, @Nullable String clientId, @Nullable Date validFromDate, @Nullable Date validUntilDate) {
        assert (rspec instanceof BasicModelRspec);
        return new BasicLease(leaseId, clientId, validFromDate, validUntilDate);
    }

    @Override
    @Nonnull
    public Channel createChannel(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicChannel();
    }

    @Override
    @Nonnull
    public GeantTestbedType createGeantTestbedType(@Nullable String name) {
        return new BasicGeantTestbedType(name);
    }

    @Override
    @Nonnull
    public AddressPool createAddressPool(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicAddressPool();
    }

    @Override
    @Nonnull
    public AddressPool copyAddressPool(@Nonnull ModelRspec modelRspec, @Nonnull AddressPool addressPool) {
        assert (modelRspec instanceof BasicAddressPool);
        return new BasicAddressPool(addressPool);
    }

    @Override
    @Nonnull
    public IPv4 createIPv4(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicIPv4();
    }

    @Override
    @Nonnull
    public IPv4 createIPv4(@Nonnull ModelRspec modelRspec, @Nullable String address, @Nullable String netmask) {
        assert (modelRspec instanceof BasicModelRspec);
        return new BasicIPv4(address, netmask);
    }

    @Override
    @Nonnull
    public ExecuteAnsiblePlaybook createExecuteAnsibleCookbook(@Nonnull ModelRspec rspec, @Nullable String source, @Nullable String outputFilename) {
        return new BasicExecuteAnsiblePlaybook(source, outputFilename);
    }

    @Override
    @Nonnull
    public DistributeSshKeypair createDistributeSshKeypair(@Nonnull ModelRspec rspec, @Nullable String location, @Nullable GeniUrn userUrn) {
        return new BasicDistributeSshKeypair(location, userUrn);
    }

    @Override
    @Nonnull
    public GeantTestbedType.VpnService createGtsVpnService(String endpoint, String username, String password) {
        return new BasicGeantTestbedType.BasicVpnService(endpoint, username, password);
    }

    @Override
    @Nonnull
    public WebVncService createWebVncService(String providerId, String vncUrl, String username, String password) {
        return new WebVncService(providerId, vncUrl, username, password);
    }
}

