/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.parser.StaxHelper;
import com.google.common.collect.Sets;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RspecCompare {
    private static final Logger LOG = LoggerFactory.getLogger(RspecCompare.class);
    private boolean equal = false;
    private final List<Difference> differences = new ArrayList<Difference>();
    private final String rspecNameA;
    private final String rspecNameB;

    public RspecCompare(@Nonnull String rspecA, @Nonnull String rspecB) throws XMLStreamException, RspecParseException {
        this(rspecA, rspecB, "RSpec A", "RSpec B");
    }

    public RspecCompare(@Nonnull String rspecA, @Nonnull String rspecB, @Nonnull String rspecNameA, @Nonnull String rspecNameB) throws XMLStreamException, RspecParseException {
        this.rspecNameA = rspecNameA;
        this.rspecNameB = rspecNameB;
        this.equal = this.equalRspec(rspecA, rspecB);
    }

    public boolean isEqual() {
        return this.equal;
    }

    public List<Difference> getDifferences() {
        return this.differences;
    }

    private boolean compareElement(List<XMLEvent> elementEventsA, List<XMLEvent> elementEventsB, boolean logDiffs) throws XMLStreamException, RspecParseException {
        if (elementEventsA.isEmpty()) {
            if (!elementEventsB.isEmpty() && logDiffs) {
                this.differences.add(new Difference(this.rspecNameA + " has empty element, where " + this.rspecNameB + " has non empty element (" + elementEventsB.get(0).asStartElement().getName() + ")", null, elementEventsB.get(0).asStartElement().getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return elementEventsB.isEmpty();
        }
        if (elementEventsB.isEmpty()) {
            if (logDiffs) {
                this.differences.add(new Difference(this.rspecNameB + " has empty element, where " + this.rspecNameA + " has non empty element (" + elementEventsA.get(0).asStartElement().getName() + ")", null, elementEventsA.get(0).asStartElement().getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        assert (elementEventsA.size() >= 2) : "sizeA=" + elementEventsA.size() + " sizeB=" + elementEventsB.size();
        assert (elementEventsB.size() >= 2) : "sizeA=" + elementEventsA.size() + " sizeB=" + elementEventsB.size();
        XMLEvent firstEventA = elementEventsA.get(0);
        XMLEvent firstEventB = elementEventsB.get(0);
        XMLEvent lastEventA = elementEventsA.get(elementEventsA.size() - 1);
        XMLEvent lastEventB = elementEventsB.get(elementEventsB.size() - 1);
        assert (firstEventA.isStartElement());
        assert (firstEventB.isStartElement());
        assert (lastEventA.isEndElement());
        assert (lastEventB.isEndElement());
        StartElement startA = firstEventA.asStartElement();
        StartElement startB = firstEventB.asStartElement();
        EndElement endA = lastEventA.asEndElement();
        EndElement endB = lastEventB.asEndElement();
        assert (Objects.equals(startA.getName(), endA.getName()));
        assert (Objects.equals(startB.getName(), endB.getName()));
        if (!Objects.equals(startA.getName(), startB.getName())) {
            if (logDiffs) {
                this.differences.add(new Difference(this.rspecNameA + " has different name than " + this.rspecNameB + ". " + this.rspecNameA + " name=" + startA.getName() + " " + this.rspecNameB + " name=" + startB.getName(), startA.getLocation(), startB.getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        assert (Objects.equals(endA.getName(), endB.getName()));
        if (!this.sameAttributes(startA, startB, logDiffs)) {
            if (logDiffs) {
                this.differences.add(new Difference(this.rspecNameA + " has different attributes than " + this.rspecNameB + " for element \"" + startA.getName() + "\". " + this.rspecNameA + " attributes: " + RspecCompare.attributesToString(startA) + " " + this.rspecNameB + " attributes: " + RspecCompare.attributesToString(startB), startA.getLocation(), startB.getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        LinkedList<List<XMLEvent>> subElementsA = new LinkedList<List<XMLEvent>>();
        LinkedList<String> charsA = new LinkedList<String>();
        Iterator<XMLEvent> it = elementEventsA.iterator();
        while (it.hasNext()) {
            XMLEvent e = it.next();
            if (e == firstEventA || e == lastEventA) continue;
            if (e.isStartElement()) {
                if (RspecCompare.isIgnoredElement(e.asStartElement().getName())) {
                    this.getAllElementEventsFromIt(e.asStartElement(), it);
                } else {
                    subElementsA.add(this.getAllElementEventsFromIt(e.asStartElement(), it));
                }
            }
            if (!e.isCharacters() || e.asCharacters().isWhiteSpace()) continue;
            charsA.add(e.asCharacters().getData());
        }
        LinkedList<List<XMLEvent>> subElementsB = new LinkedList<List<XMLEvent>>();
        LinkedList<String> charsB = new LinkedList<String>();
        Iterator<XMLEvent> it2 = elementEventsB.iterator();
        while (it2.hasNext()) {
            XMLEvent xMLEvent = it2.next();
            if (xMLEvent == firstEventB || xMLEvent == lastEventB) continue;
            if (xMLEvent.isStartElement()) {
                if (RspecCompare.isIgnoredElement(xMLEvent.asStartElement().getName())) {
                    this.getAllElementEventsFromIt(xMLEvent.asStartElement(), it2);
                } else {
                    subElementsB.add(this.getAllElementEventsFromIt(xMLEvent.asStartElement(), it2));
                }
            }
            if (!xMLEvent.isCharacters() || xMLEvent.asCharacters().isWhiteSpace()) continue;
            charsB.add(xMLEvent.asCharacters().getData());
        }
        if (charsA.size() != charsB.size()) {
            if (logDiffs) {
                this.differences.add(new Difference(this.rspecNameA + " has " + charsA.size() + " CharacterElements, while " + this.rspecNameB + " has " + charsB.size() + " " + this.rspecNameA + "text=" + (charsA.size() == 1 ? "\"" + (String)charsA.get(0) + "\"" : (charsA.isEmpty() ? "" : charsA)) + " " + this.rspecNameB + "text=" + (charsB.size() == 1 ? "\"" + (String)charsB.get(0) + "\"" : (charsB.isEmpty() ? "" : charsB)), startA.getLocation(), startB.getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        if (!charsA.isEmpty() && !Objects.equals(charsA, charsB)) {
            if (logDiffs) {
                this.differences.add(new Difference("Text in " + this.rspecNameA + " and " + this.rspecNameB + " differs: " + this.rspecNameA + "text=" + (charsA.size() == 1 ? "\"" + (String)charsA.get(0) + "\"" : charsA) + " " + this.rspecNameB + "text=" + (charsB.size() == 1 ? "\"" + (String)charsB.get(0) + "\"" : charsB), startA.getLocation(), startB.getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        for (List list : subElementsA) {
            assert (!list.isEmpty());
            StartElement startElementA = ((XMLEvent)list.get(0)).asStartElement();
            assert (list.size() >= 2) : "sizeA=" + list.size();
            boolean found = false;
            Iterator itB = subElementsB.iterator();
            while (itB.hasNext()) {
                List subElB = (List)itB.next();
                assert (list.size() >= 2) : "sizeA=" + list.size() + " sizeB=" + subElB.size();
                assert (subElB.size() >= 2) : "sizeA=" + list.size() + " sizeB=" + subElB.size();
                if (!this.compareElement(list, subElB, false)) continue;
                itB.remove();
                found = true;
                break;
            }
            if (found) continue;
            if (logDiffs) {
                this.differences.add(new Difference(this.rspecNameA + " has element \"" + startElementA.getName() + "\". " + this.rspecNameB + " does not have a matching element", startElementA.getLocation(), null, this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        if (!subElementsB.isEmpty()) {
            if (logDiffs) {
                for (List list : subElementsB) {
                    assert (!list.isEmpty());
                    assert (((XMLEvent)list.get(0)).isStartElement());
                    StartElement bStart = ((XMLEvent)list.get(0)).asStartElement();
                    this.differences.add(new Difference(this.rspecNameB + " has element \"" + bStart.getName() + "\" which " + this.rspecNameA + " does not have", null, bStart.getLocation(), this.rspecNameA, this.rspecNameB));
                }
            }
            return false;
        }
        return true;
    }

    public static String attributesToString(StartElement startElement) {
        Object res = "";
        Iterator<Attribute> it = startElement.getAttributes();
        while (it.hasNext()) {
            Attribute att = it.next();
            if (!((String)res).isEmpty()) {
                res = (String)res + " ";
            }
            res = (String)res + att.getName() + "=" + att.getValue();
        }
        return res;
    }

    private static boolean isIgnoredRspecAttribute(QName name) {
        if (Objects.equals(name, RspecXmlConstants.Q_ATT_RSPEC_GEN_BY)) {
            return true;
        }
        if (Objects.equals(name, RspecXmlConstants.Q_ATT_RSPEC_GEN_DATE)) {
            return true;
        }
        return Objects.equals(name, RspecXmlConstants.Q_XSI_SCHEMALOCATION);
    }

    private static boolean isIgnoredAttribute(QName name) {
        return false;
    }

    private static boolean isIgnoredElement(QName name) {
        return Objects.equals(name.getNamespaceURI(), "http://jfed.iminds.be/rspec/ext/jfed/1");
    }

    private boolean sameAttributes(StartElement startA, StartElement startB, boolean logDiffs) {
        boolean isRspec = Objects.equals(startA.getName(), RspecXmlConstants.Q_RSPEC);
        HashMap<QName, String> attributesB = new HashMap<QName, String>();
        HashMap<QName, String> attributesA = new HashMap<QName, String>();
        Iterator<Attribute> itB = startB.getAttributes();
        while (itB.hasNext()) {
            Attribute attB = itB.next();
            if (RspecCompare.isIgnoredAttribute(attB.getName()) || isRspec && RspecCompare.isIgnoredRspecAttribute(attB.getName())) continue;
            attributesB.put(attB.getName(), attB.getValue());
        }
        Iterator<Attribute> itA = startA.getAttributes();
        while (itA.hasNext()) {
            Attribute attA = itA.next();
            if (RspecCompare.isIgnoredAttribute(attA.getName()) || isRspec && RspecCompare.isIgnoredRspecAttribute(attA.getName())) continue;
            attributesA.put(attA.getName(), attA.getValue());
        }
        return Objects.equals(attributesA, attributesB);
    }

    public List<XMLEvent> getAllElementEventsFromIt(StartElement startEvent, Iterator<XMLEvent> it) throws XMLStreamException, RspecParseException {
        QName startElementName = startEvent.getName();
        String name = startElementName.getLocalPart();
        LinkedList<XMLEvent> res = new LinkedList<XMLEvent>();
        res.add(startEvent);
        try {
            int depth = 0;
            while (it.hasNext()) {
                XMLEvent e = it.next();
                res.add(e);
                if (e.isStartElement() && Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                    ++depth;
                }
                if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName().getLocalPart(), name)) continue;
                if (depth == 0) {
                    assert (res.size() >= 2) : "not enough elements (" + res.size() + ") for startElementName=" + startElementName + " @ " + RspecParseException.locationToString(startEvent.getLocation());
                    return res;
                }
                --depth;
            }
            throw new RspecParseException(startEvent.getLocation(), "<" + startElementName + "> tag was never closed");
        }
        catch (RspecParseException e) {
            Object curList = "";
            for (XMLEvent event : res) {
                curList = (String)curList + "      " + StaxHelper.xmlEventToStringWithAttributes(event) + "\n";
            }
            LOG.error("Parse error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
            throw e;
        }
        catch (Exception e) {
            Object curList = "";
            for (XMLEvent event : res) {
                curList = (String)curList + "      " + StaxHelper.xmlEventToStringWithAttributes(event) + "\n";
            }
            LOG.error("RspecCompare error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
            throw new RspecParseException("RspecCompare error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
        }
    }

    private boolean equalRspec(String rspecA, String rspecB) throws XMLStreamException, RspecParseException {
        RspecParts partsA = new RspecParts(rspecA);
        RspecParts partsB = new RspecParts(rspecB);
        Sets.SetView differenceA = Sets.difference(partsA.getNodeEventsMap().keySet(), partsB.getNodeEventsMap().keySet());
        if (!differenceA.isEmpty()) {
            for (String uniqueNodeId : differenceA) {
                List<XMLEvent> nodeEventsA = partsA.getNodeEventsMap().get(uniqueNodeId);
                this.differences.add(new Difference(this.rspecNameB + " does not contain a node from " + this.rspecNameA, nodeEventsA.get(0).getLocation(), null, this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        Sets.SetView differenceB = Sets.difference(partsB.getNodeEventsMap().keySet(), partsA.getNodeEventsMap().keySet());
        if (!differenceB.isEmpty()) {
            for (String uniqueNodeId : differenceB) {
                List<XMLEvent> nodeEventsB = partsB.getNodeEventsMap().get(uniqueNodeId);
                this.differences.add(new Difference(this.rspecNameA + " does not contain a node from " + this.rspecNameB, null, nodeEventsB.get(0).getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        for (String uniqueNodeId : partsA.getNodeEventsMap().keySet()) {
            List<XMLEvent> nodeEventsB;
            List<XMLEvent> nodeEventsA = partsA.getNodeEventsMap().get(uniqueNodeId);
            if (this.compareElement(nodeEventsA, nodeEventsB = partsB.getNodeEventsMap().get(uniqueNodeId), true)) continue;
            this.differences.add(new Difference(this.rspecNameA + " and " + this.rspecNameB + " have a different node", nodeEventsA.get(0).getLocation(), nodeEventsB.get(0).getLocation(), this.rspecNameA, this.rspecNameB));
            return false;
        }
        Sets.SetView differenceLinksA = Sets.difference(partsA.getLinkEventsMap().keySet(), partsB.getLinkEventsMap().keySet());
        if (!differenceLinksA.isEmpty()) {
            for (String uniqueLinkId : differenceLinksA) {
                List<XMLEvent> linkEventsA = partsA.getLinkEventsMap().get(uniqueLinkId);
                this.differences.add(new Difference(this.rspecNameB + " does not contain a link from " + this.rspecNameA, linkEventsA.get(0).getLocation(), null, this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        Sets.SetView differenceLinksB = Sets.difference(partsB.getLinkEventsMap().keySet(), partsA.getLinkEventsMap().keySet());
        if (!differenceLinksB.isEmpty()) {
            for (String uniqueLinkId : differenceLinksB) {
                List<XMLEvent> linkEventsB = partsB.getLinkEventsMap().get(uniqueLinkId);
                this.differences.add(new Difference(this.rspecNameA + " does not contain a link from " + this.rspecNameB, null, linkEventsB.get(0).getLocation(), this.rspecNameA, this.rspecNameB));
            }
            return false;
        }
        for (String uniqueLinkId : partsA.getLinkEventsMap().keySet()) {
            List<XMLEvent> linkEventsB;
            List<XMLEvent> linkEventsA = partsA.getLinkEventsMap().get(uniqueLinkId);
            if (this.compareElement(linkEventsA, linkEventsB = partsB.getLinkEventsMap().get(uniqueLinkId), true)) continue;
            this.differences.add(new Difference(this.rspecNameA + " and " + this.rspecNameB + " have a different link", linkEventsA.get(0).getLocation(), linkEventsB.get(0).getLocation(), this.rspecNameA, this.rspecNameB));
            return false;
        }
        if (!this.compareElement(partsA.getRestRspec(), partsB.getRestRspec(), true)) {
            this.differences.add(new Difference(this.rspecNameA + " and " + this.rspecNameB + " have the same node and link elements. But the rest of the RSpec differs", null, null, this.rspecNameA, this.rspecNameB));
            return false;
        }
        return true;
    }

    public static String differencesListToString(List<Difference> diffs) {
        StringBuilder sb = new StringBuilder();
        for (Difference diff : diffs) {
            sb.append(diff.getReason()).append("\n");
            if (diff.getLocationA() != null) {
                sb.append("    in ").append(diff.getRspecNameA()).append(" @ ").append(RspecParseException.locationToString(diff.getLocationA())).append("\n");
            }
            if (diff.getLocationB() != null) {
                sb.append("    in ").append(diff.getRspecNameB()).append(" @ ").append(RspecParseException.locationToString(diff.getLocationB())).append("\n");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static class Difference {
        private final String reason;
        private final Location locationA;
        private final Location locationB;
        private final String rspecNameA;
        private final String rspecNameB;

        private Difference(String reason, Location locationA, Location locationB, String rspecNameA, String rspecNameB) {
            this.reason = reason;
            this.locationA = locationA;
            this.locationB = locationB;
            this.rspecNameA = rspecNameA;
            this.rspecNameB = rspecNameB;
        }

        public String getReason() {
            return this.reason;
        }

        public Location getLocationA() {
            return this.locationA;
        }

        public Location getLocationB() {
            return this.locationB;
        }

        public String getRspecNameB() {
            return this.rspecNameB;
        }

        public String getRspecNameA() {
            return this.rspecNameA;
        }

        public String toString() {
            return this.reason + (String)(this.locationA != null ? " in " + this.rspecNameA + " @ " + RspecParseException.locationToString(this.locationA) : "") + (String)(this.locationB != null ? " in " + this.rspecNameB + " @ " + RspecParseException.locationToString(this.locationB) : "");
        }
    }

    private static class RspecParts {
        private final Map<String, List<XMLEvent>> nodeEventsMap = new HashMap<String, List<XMLEvent>>();
        private final Map<String, List<XMLEvent>> linkEventsMap = new HashMap<String, List<XMLEvent>>();
        private final List<XMLEvent> restRspec = new LinkedList<XMLEvent>();

        public RspecParts(String rspecA) throws RspecParseException {
            try {
                XMLInputFactory xif = XMLInputFactory.newFactory();
                StreamSource xml = new StreamSource(new StringReader(rspecA));
                XMLEventReader eventReader = xif.createXMLEventReader(xml);
                XMLEvent event = eventReader.nextEvent();
                assert (event.isStartDocument());
                while (eventReader.hasNext()) {
                    event = eventReader.nextEvent();
                    if (event.isStartElement()) {
                        if (Objects.equals(event.asStartElement().getName(), RspecXmlConstants.Q_RSPEC)) {
                            this.restRspec.add(event);
                            continue;
                        }
                        if (Objects.equals(event.asStartElement().getName(), RspecXmlConstants.Q_NODE)) {
                            Object nodeId = RspecParts.generateUniqueNodeId(event);
                            List<XMLEvent> nodeEvents = RspecParts.getAllElementEventsFromReader(event.asStartElement(), eventReader);
                            while (this.nodeEventsMap.containsKey(nodeId)) {
                                LOG.warn("Found a duplicate node with id '{}'. We cannot guarantee correct comparisons anymore!", nodeId);
                                nodeId = (String)nodeId + "!DUP!";
                            }
                            this.nodeEventsMap.put((String)nodeId, nodeEvents);
                        } else if (Objects.equals(event.asStartElement().getName(), RspecXmlConstants.Q_LINK)) {
                            Object linkId = RspecParts.generateUniqueLinkId(event);
                            List<XMLEvent> linkEvents = RspecParts.getAllElementEventsFromReader(event.asStartElement(), eventReader);
                            while (this.linkEventsMap.containsKey(linkId)) {
                                LOG.warn("Found a duplicate link with id '{}'. We cannot guarantee correct comparisons anymore!", linkId);
                                linkId = (String)linkId + "!DUP!";
                            }
                            this.linkEventsMap.put((String)linkId, linkEvents);
                        } else if (Objects.equals(event.asStartElement().getName(), RspecXmlConstants.Q_NITOS_E_NODE_B)) {
                            RspecParts.getAllElementEventsFromReader(event.asStartElement(), eventReader);
                        } else {
                            this.restRspec.addAll(RspecParts.getAllElementEventsFromReader(event.asStartElement(), eventReader));
                        }
                    }
                    if (!event.isEndElement()) continue;
                    if (Objects.equals(event.asEndElement().getName(), RspecXmlConstants.Q_RSPEC)) {
                        this.restRspec.add(event);
                        continue;
                    }
                    LOG.warn("Unexpected end element: {}", (Object)event);
                }
            }
            catch (XMLStreamException ex) {
                throw new RspecParseException(null, "Problem while parsing Rspec", ex);
            }
        }

        public Map<String, List<XMLEvent>> getNodeEventsMap() {
            return this.nodeEventsMap;
        }

        public Map<String, List<XMLEvent>> getLinkEventsMap() {
            return this.linkEventsMap;
        }

        public List<XMLEvent> getRestRspec() {
            return this.restRspec;
        }

        private static List<XMLEvent> getAllElementEventsFromReader(StartElement startEvent, XMLEventReader it) throws XMLStreamException, RspecParseException {
            QName startElementName = startEvent.getName();
            String name = startElementName.getLocalPart();
            LinkedList<XMLEvent> res = new LinkedList<XMLEvent>();
            res.add(startEvent);
            try {
                int depth = 0;
                while (it.hasNext()) {
                    XMLEvent e = it.nextEvent();
                    res.add(e);
                    if (e.isStartElement() && Objects.equals(e.asStartElement().getName().getLocalPart(), name)) {
                        ++depth;
                    }
                    if (!e.isEndElement() || !Objects.equals(e.asEndElement().getName().getLocalPart(), name)) continue;
                    if (depth == 0) {
                        assert (res.size() >= 2) : "not enough elements (" + res.size() + ") for startElementName=" + startElementName + " @ " + RspecParseException.locationToString(startEvent.getLocation());
                        return res;
                    }
                    --depth;
                }
                throw new RspecParseException(startEvent.getLocation(), "<" + startElementName + "> tag was never closed");
            }
            catch (RspecParseException e) {
                Object curList = "";
                for (XMLEvent event : res) {
                    curList = (String)curList + "      " + StaxHelper.xmlEventToStringWithAttributes(event) + "\n";
                }
                LOG.error("Parse error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
                throw e;
            }
            catch (Exception e) {
                Object curList = "";
                for (XMLEvent event : res) {
                    curList = (String)curList + "      " + StaxHelper.xmlEventToStringWithAttributes(event) + "\n";
                }
                LOG.error("Parse error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
                throw new RspecParseException("Parse error in getAllElementEvents. \n      startEvent=" + StaxHelper.xmlEventToString(startEvent) + "\n    Current list:\n" + (String)curList, (Throwable)e);
            }
        }

        private static String generateUniqueNodeId(XMLEvent nodeEvent) {
            assert (nodeEvent.isStartElement());
            assert (Objects.equals(nodeEvent.asStartElement().getName(), RspecXmlConstants.Q_NODE));
            StringBuilder result = new StringBuilder();
            Attribute idAtt = nodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
            if (idAtt != null) {
                result.append(idAtt.getValue());
            }
            result.append('#');
            Attribute comIdAtt = nodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_ID);
            if (comIdAtt != null) {
                result.append(comIdAtt.getValue());
            }
            result.append('#');
            Attribute comManIdAtt = nodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_MAN_ID);
            if (comManIdAtt != null) {
                result.append(comManIdAtt.getValue());
            }
            result.append('#');
            Attribute sliverIdAtt = nodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
            if (sliverIdAtt != null) {
                result.append(sliverIdAtt.getValue());
            }
            result.append('#');
            Attribute conNameAtt = nodeEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_COM_NAME);
            if (conNameAtt != null) {
                result.append(conNameAtt.getValue());
            }
            return result.toString();
        }

        private static String generateUniqueLinkId(XMLEvent linkEvent) {
            assert (linkEvent.isStartElement());
            assert (Objects.equals(linkEvent.asStartElement().getName(), RspecXmlConstants.Q_LINK));
            Object result = "";
            Attribute idAtt = linkEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_CLIENT_ID);
            if (idAtt != null) {
                result = (String)result + idAtt.getValue();
            }
            result = (String)result + "#";
            Attribute sliverIdAtt = linkEvent.asStartElement().getAttributeByName(RspecXmlConstants.Q_ATT_SLIVER_ID);
            if (sliverIdAtt != null) {
                result = (String)result + sliverIdAtt.getValue();
            }
            return result;
        }
    }
}

