/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.parser;

import javax.annotation.Nullable;
import javax.xml.stream.Location;

public class RspecParseException
extends Exception {
    private final Location staxLocation;

    public static String locationToString(Location l) {
        if (l == null) {
            return "no location info";
        }
        return "line=" + l.getLineNumber() + " col=" + l.getColumnNumber();
    }

    public RspecParseException(Location staxLocation) {
        this.staxLocation = staxLocation;
    }

    public RspecParseException(Location staxLocation, String message) {
        super(message + " @ " + RspecParseException.locationToString(staxLocation));
        this.staxLocation = staxLocation;
    }

    public RspecParseException(Location staxLocation, String message, Throwable cause) {
        super(message + " @ " + RspecParseException.locationToString(staxLocation), cause);
        this.staxLocation = staxLocation;
    }

    public RspecParseException(Location staxLocation, Throwable cause) {
        super(cause);
        this.staxLocation = staxLocation;
    }

    public RspecParseException(String msg, Throwable cause) {
        super(msg, cause);
        this.staxLocation = null;
    }

    @Nullable
    public Location getStaxLocation() {
        return this.staxLocation;
    }
}

