/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.rspec_source;

import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecFactoryFactory;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.SliverType;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableRspecFactory;
import be.iminds.ilabt.jfed.rspec.parser.RspecCompare;
import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.StaxRspecParser;
import be.iminds.ilabt.jfed.rspec.rspec_source.RspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class CachingRspecSource
implements RspecSource {
    private static final Logger LOG = LoggerFactory.getLogger(CachingRspecSource.class);
    private static final ExecutorService executorService = Executors.newCachedThreadPool(ThreadFactoryUtil.getFactory((String)"RspecSource"));
    protected final Map<ModelRspec.RequestRspecSpecialCases, StringRspec> stringRspecBySpecialCase = new EnumMap<ModelRspec.RequestRspecSpecialCases, StringRspec>(ModelRspec.RequestRspecSpecialCases.class);
    protected final Map<ModelRspecType, StaxRspecParser> modelRspecParserMap = new EnumMap<ModelRspecType, StaxRspecParser>(ModelRspecType.class);
    protected final Map<ModelRspecType, Future<ModelRspec>> modelRspecFutureMap = new EnumMap<ModelRspecType, Future<ModelRspec>>(ModelRspecType.class);
    protected final Map<ModelRspecType, ModelRspec> modelRspecMap = new EnumMap<ModelRspecType, ModelRspec>(ModelRspecType.class);
    private boolean initialized = false;
    protected final boolean isXmlBased;
    @Nonnull
    private final ModelRspecType defaultMutableModelRspecType;
    protected boolean parseFailed = false;
    private RspecParseException lastInvalidRspecException = null;
    private final Map<ModelRspecType, RspecSource.LosingDataInfo> losingDataInfoMap = new HashMap<ModelRspecType, RspecSource.LosingDataInfo>();

    protected CachingRspecSource(@Nonnull RspecSource orig) {
        if (orig.isXmlBased()) {
            this.stringRspecBySpecialCase.put(ModelRspec.RequestRspecSpecialCases.NONE, orig.getStringRspec());
            this.isXmlBased = true;
            this.defaultMutableModelRspecType = ModelRspecType.BASIC;
            this.initialized = false;
        } else {
            ModelRspec origModelRspec;
            ModelRspec modelRspec = origModelRspec = orig instanceof CachingRspecSource ? ((CachingRspecSource)orig).getAnyModelRspec() : orig.getImmutableModelRspec();
            assert (origModelRspec != null);
            this.modelRspecMap.put(origModelRspec.getModelRspecType(), origModelRspec);
            this.defaultMutableModelRspecType = ModelRspecType.BASIC;
            this.isXmlBased = false;
            this.initialized = true;
        }
    }

    protected CachingRspecSource(@Nonnull StringRspec stringRspec) {
        this(stringRspec, ModelRspecType.BASIC);
    }

    protected CachingRspecSource(@Nonnull StringRspec stringRspec, @Nonnull ModelRspecType defaultMutableModelRspecType) {
        assert (stringRspec != null);
        this.stringRspecBySpecialCase.put(ModelRspec.RequestRspecSpecialCases.NONE, stringRspec);
        this.defaultMutableModelRspecType = defaultMutableModelRspecType;
        this.isXmlBased = true;
        this.initialized = false;
    }

    protected CachingRspecSource(@Nonnull ModelRspec modelRspec) {
        assert (modelRspec != null);
        this.modelRspecMap.put(modelRspec.getModelRspecType(), modelRspec);
        this.defaultMutableModelRspecType = modelRspec.getModelRspecType();
        this.isXmlBased = false;
        this.initialized = true;
    }

    public CachingRspecSource(@Nonnull String xmlRspecString, @Nonnull ModelRspecType defaultMutableModelRspecType) {
        this(new StringRspec(xmlRspecString), defaultMutableModelRspecType);
    }

    private void initialize() {
        this.getAnyModelRspec();
    }

    @Override
    public boolean isXmlBased() {
        if (!this.initialized) {
            this.initialize();
        }
        return this.isXmlBased;
    }

    @Override
    @Nullable
    public String getRspecXmlString() {
        return this.getRspecXmlString(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public String getRspecXmlString(@Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        StringRspec stringRspec = this.getStringRspec(rspecSpecialCase);
        if (stringRspec != null) {
            return stringRspec.getXmlString();
        }
        return null;
    }

    @Nonnull
    protected String modelToString(@Nonnull ModelRspec modelRspec, @Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        assert (modelRspec != null);
        return modelRspec.toGeni3Rspec(rspecSpecialCase);
    }

    @Override
    @Nullable
    public ModelRspec getMutableModelRspec() {
        Object modelRspec = this.getModelRspec(this.defaultMutableModelRspecType, new ProgressHandler[0]);
        Iterator<Map.Entry<ModelRspecType, ModelRspec>> it = this.modelRspecMap.entrySet().iterator();
        if ((modelRspec == null || modelRspec.getModelRspecType() == ModelRspecType.IMMUTABLE) && it.hasNext()) {
            modelRspec = it.next().getValue();
        }
        return modelRspec;
    }

    @Nullable
    protected ModelRspec getAnyModelRspec() {
        Object modelRspec = this.getModelRspec(this.defaultMutableModelRspecType, new ProgressHandler[0]);
        if (modelRspec == null && !this.modelRspecMap.isEmpty()) {
            modelRspec = this.modelRspecMap.entrySet().iterator().next().getValue();
        }
        return modelRspec;
    }

    @Override
    @Nullable
    public ImmutableModelRspec getImmutableModelRspec() {
        ModelRspec modelRspec = this.modelRspecMap.get((Object)ModelRspecType.IMMUTABLE);
        if (modelRspec == null) {
            modelRspec = this.getModelRspec(ModelRspecType.IMMUTABLE, new ProgressHandler[0]);
        }
        return (ImmutableModelRspec)modelRspec;
    }

    @Override
    @Nullable
    public ModelRspec getMutableModelRspec(ProgressHandler ... progressHandlers) {
        Object modelRspec = this.getModelRspec(this.defaultMutableModelRspecType, progressHandlers);
        Iterator<Map.Entry<ModelRspecType, ModelRspec>> it = this.modelRspecMap.entrySet().iterator();
        if ((modelRspec == null || modelRspec.getModelRspecType() == ModelRspecType.IMMUTABLE) && it.hasNext()) {
            modelRspec = it.next().getValue();
        }
        return modelRspec;
    }

    @Override
    @Nullable
    public ImmutableModelRspec getImmutableModelRspec(ProgressHandler ... progressHandlers) {
        ModelRspec modelRspec = this.modelRspecMap.get((Object)ModelRspecType.IMMUTABLE);
        if (modelRspec == null) {
            modelRspec = this.getModelRspec(ModelRspecType.IMMUTABLE, progressHandlers);
        }
        return (ImmutableModelRspec)modelRspec;
    }

    @Override
    public boolean isModelRspecAvailable(@Nonnull ModelRspecType modelRspecType) {
        return this.modelRspecMap.containsKey((Object)modelRspecType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    public <M extends ModelRspec> M getModelRspec(@Nonnull ModelRspecType modelRspecType, ProgressHandler ... progressHandlers) {
        if (this.modelRspecMap.containsKey((Object)modelRspecType)) {
            return (M)this.modelRspecMap.get((Object)modelRspecType);
        }
        if (this.parseFailed) {
            return null;
        }
        Future<ModelRspec> future = this.getModelRspecAsync(modelRspecType == ModelRspecType.IMMUTABLE ? this.defaultMutableModelRspecType : modelRspecType, progressHandlers);
        ImmutableModelRspec immRes = null;
        try {
            if (future == null) {
                throw new ExecutionException(new RspecParseException(null, "Cannot create a modelRspec from an empty Rspec"));
            }
            if (modelRspecType == ModelRspecType.IMMUTABLE) {
                ModelRspec res = future.get();
                ImmutableModelRspec immutableModelRspec = immRes = ImmutableRspecFactory.getInstance().copyModelRspec(res, null);
                return (M)immutableModelRspec;
            }
            ModelRspec res = future.get();
            return (M)res;
        }
        catch (ExecutionException e) {
            if (e.getCause() instanceof RspecParseException) {
                this.lastInvalidRspecException = (RspecParseException)e.getCause();
            }
            LOG.warn("RSpec String parse failed. Will not return ModelRspec", (Throwable)e);
            this.parseFailed = true;
            M m = null;
            return m;
        }
        catch (InterruptedException e) {
            LOG.error("Rspec parsing failed unexpectedly!", (Throwable)e);
            this.parseFailed = true;
            M m = null;
            return m;
        }
        finally {
            this.initialized = true;
            if (future != null && future.isDone()) {
                try {
                    ModelRspec res = future.get();
                    this.modelRspecMap.put(res.getModelRspecType(), res);
                    if (immRes != null) {
                        this.modelRspecMap.put(immRes.getModelRspecType(), immRes);
                    }
                }
                catch (InterruptedException | ExecutionException res) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private Future<ModelRspec> getModelRspecAsync(@Nonnull ModelRspecType modelRspecType, ProgressHandler ... progressHandlers) {
        Future<ModelRspec> future;
        CachingRspecSource cachingRspecSource = this;
        synchronized (cachingRspecSource) {
            StaxRspecParser parser;
            if (!this.modelRspecParserMap.containsKey((Object)modelRspecType)) {
                StringRspec stringRspec = this.stringRspecBySpecialCase.containsKey((Object)ModelRspec.RequestRspecSpecialCases.NONE) ? this.stringRspecBySpecialCase.get((Object)ModelRspec.RequestRspecSpecialCases.NONE) : (!this.stringRspecBySpecialCase.isEmpty() ? this.stringRspecBySpecialCase.get((Object)this.stringRspecBySpecialCase.keySet().iterator().next()) : this.getStringRspec());
                if (stringRspec == null) {
                    return null;
                }
                String xmlString = stringRspec.getXmlString();
                if (xmlString.contains("<RSpec")) {
                    LOG.debug("HACK: rewriting received planetlab manifest XML to make it parsable xml");
                    xmlString = xmlString.replace("<RSpec type=\"SFA\"", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
                    xmlString = xmlString.replace("<RSpec ", "<rspec xmlns=\"http://www.geni.net/resources/rspec/3\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" type=\"manifest\"");
                    xmlString = xmlString.replace("</RSpec>", "</rspec>");
                    xmlString = xmlString.replace("<network name=\"ple\">", "");
                    xmlString = xmlString.replace("</network>", "");
                    LOG.debug("HACK: rewritten xml: " + xmlString);
                }
                parser = new StaxRspecParser(xmlString, RspecFactoryFactory.getRspecFactoryInstance(modelRspecType));
                future = executorService.submit(parser);
            } else {
                parser = this.modelRspecParserMap.get((Object)modelRspecType);
                future = this.modelRspecFutureMap.get((Object)modelRspecType);
            }
            for (ProgressHandler handler : progressHandlers) {
                parser.addProgressHandler(handler);
            }
        }
        return future;
    }

    @Override
    @Nullable
    public RspecParseException getLastInvalidRspecException() {
        return this.lastInvalidRspecException;
    }

    @Override
    @Nullable
    public StringRspec getStringRspec() {
        return this.getStringRspec(ModelRspec.RequestRspecSpecialCases.NONE);
    }

    @Override
    @Nullable
    public StringRspec getStringRspec(@Nonnull ModelRspec.RequestRspecSpecialCases rspecSpecialCase) {
        if (this.stringRspecBySpecialCase.containsKey((Object)rspecSpecialCase)) {
            return this.stringRspecBySpecialCase.get((Object)rspecSpecialCase);
        }
        ModelRspec modelRspec = this.getAnyModelRspec();
        if (modelRspec == null) {
            assert (!this.stringRspecBySpecialCase.isEmpty()) : "both modelRspec == null and stringRspecBySpecialCase.isEmpty()";
            try {
                modelRspec = this.getModelRspec(this.defaultMutableModelRspecType, new ProgressHandler[0]);
            }
            catch (AssertionError | Exception t) {
                LOG.warn("RSpec String parse failed. Cannot change type of rspec to " + rspecSpecialCase, (Throwable)t);
                this.parseFailed = true;
                return null;
            }
            if (modelRspec == null) {
                return null;
            }
        }
        assert (modelRspec != null);
        String rspecXml = this.modelToString(modelRspec, rspecSpecialCase);
        StringRspec stringRspec = new StringRspec(rspecXml);
        this.stringRspecBySpecialCase.put(rspecSpecialCase, stringRspec);
        return stringRspec;
    }

    @Override
    @Nonnull
    public List<GeniUrn> getAllComponentManagerUrns() {
        ModelRspec model = this.getAnyModelRspec();
        if (model != null) {
            List<GeniUrn> res = model.getAllComponentManagerUrns();
            StringRspec stringRspec = this.getStringRspec();
            if (stringRspec == null) {
                return Collections.emptyList();
            }
            assert (stringRspec.isWellFormed());
            for (String urnString : StringRspec.parseOpenflowComponentManagers((String)stringRspec.getXmlString())) {
                GeniUrn geniUrn = GeniUrn.parse((String)urnString);
                if (geniUrn != null) {
                    res.add(geniUrn);
                    continue;
                }
                LOG.warn("Could not parse openflowComponentManager-urn {}", (Object)urnString);
            }
            return res;
        }
        StringRspec stringRspec = this.getStringRspec();
        if (stringRspec != null && stringRspec.isWellFormed()) {
            ArrayList<GeniUrn> res = new ArrayList<GeniUrn>();
            for (String urnString : stringRspec.getAllComponentManagerUrns()) {
                GeniUrn geniUrn = GeniUrn.parse((String)urnString);
                if (geniUrn != null) {
                    res.add(geniUrn);
                    continue;
                }
                LOG.warn("Could not parse openflowComponentManager-urn {}", (Object)urnString);
            }
            return res;
        }
        return Collections.emptyList();
    }

    @Override
    public List<BasicStringRspec.BasicNodeInfo> getBasicNodeInfo() {
        ModelRspec model = this.getAnyModelRspec();
        if (model != null) {
            ArrayList<BasicStringRspec.BasicNodeInfo> res = new ArrayList<BasicStringRspec.BasicNodeInfo>();
            List<? extends RspecNode> modelNodes = model.getNodes();
            for (RspecNode rspecNode : modelNodes) {
                ArrayList<String> sliverTypeNames = new ArrayList<String>();
                for (SliverType sliverType : rspecNode.getSliverTypes()) {
                    sliverTypeNames.add(sliverType.getName());
                }
                BasicStringRspec.BasicNodeInfo ni = new BasicStringRspec.BasicNodeInfo(rspecNode.getClientId(), rspecNode.getComponentId() == null ? null : rspecNode.getComponentId().toString(), rspecNode.getComponentManagerId() == null ? null : rspecNode.getComponentManagerId().toString(), rspecNode.getAvailable(), rspecNode.getExclusive(), sliverTypeNames, rspecNode.getAnsibleGroups());
                res.add(ni);
            }
            return res;
        }
        StringRspec stringRspec = this.getStringRspec();
        LOG.debug("The RSpec could not be parsed using ModelRspec, will try StringRspec method.");
        if (stringRspec != null && stringRspec.isWellFormed()) {
            return stringRspec.getBasicNodeInfo();
        }
        LOG.warn("The RSpec could not be parsed using any method. Will return null.");
        return null;
    }

    @Nullable
    private RspecSource.LosingDataInfo getLosingDataInfo(ModelRspecType modelRspecType) {
        if (!this.isXmlBased) {
            return null;
        }
        if (!this.losingDataInfoMap.containsKey((Object)modelRspecType)) {
            RspecSource.LosingDataInfo losingDataInfo;
            Object modelRspec = this.getModelRspec(modelRspecType, new ProgressHandler[0]);
            String stringRspec = this.getRspecXmlString();
            if (modelRspec == null || stringRspec == null) {
                return null;
            }
            try {
                RspecCompare compareWithOrig = new RspecCompare(modelRspec.toGeni3Rspec(), stringRspec, "the converted RSpec", "the original RSpec");
                losingDataInfo = new RspecSource.LosingDataInfo(!compareWithOrig.isEqual(), compareWithOrig.getDifferences());
            }
            catch (XMLStreamException ex) {
                LOG.error("Exception while using RspecCompare at end of parse. location=" + RspecParseException.locationToString(ex.getLocation()), (Throwable)ex);
                losingDataInfo = new RspecSource.LosingDataInfo(true, null);
            }
            catch (AssertionError | Exception ex) {
                LOG.error("Exception while using RspecCompare at end of parse. location=unknown", (Throwable)ex);
                losingDataInfo = new RspecSource.LosingDataInfo(true, null);
            }
            this.losingDataInfoMap.put(modelRspecType, losingDataInfo);
        }
        return this.losingDataInfoMap.get((Object)modelRspecType);
    }

    @Override
    public boolean isLosingData(ModelRspecType modelRspecType) {
        RspecSource.LosingDataInfo losingDataInfo = this.getLosingDataInfo(modelRspecType);
        return losingDataInfo != null && losingDataInfo.isLosingData();
    }

    @Override
    public List<RspecCompare.Difference> getLosingDataDifferences(ModelRspecType modelRspecType) {
        RspecSource.LosingDataInfo losingDataInfo = this.getLosingDataInfo(modelRspecType);
        if (losingDataInfo != null) {
            return losingDataInfo.getLosingDataDifferences();
        }
        return null;
    }
}

