/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.statistics;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.AdvertisementCounts;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class RSpecStatistics
implements AdvertisementCounts {
    private boolean countWarnings = false;
    private boolean countErrors = false;
    private final int count;
    private final int countRaw;
    private final int countVm;
    private final int countIpv4;
    private final int countOpenflow;
    private final int countTotal;
    private final int countRawTotal;
    private final int countVmTotal;
    private final int countIpv4Total;
    private final int countOpenflowTotal;
    private final int skippedCount;
    @Nullable
    private final Date date;
    @Nonnull
    private final Set<String> explicitSkippedHwTypes;
    @Nonnull
    private final Set<String> implicitSkippedHwTypes;
    @Nonnull
    private final Set<String> countedHwTypes;
    @Nonnull
    private final Map<String, CountPair> countPerHwType;

    public RSpecStatistics(boolean countWarnings, boolean countErrors, int count, int countTotal, int countRaw, int countIpv4, int countOpenflow, int countVm, int countRawTotal, int countVmTotal, int countIpv4Total, int countOpenflowTotal, int skippedCount, @Nullable Date date, @Nonnull Set<String> explicitSkippedHwTypes, @Nonnull Set<String> implicitSkippedHwTypes, @Nonnull Set<String> countedHwTypes, @Nonnull Map<String, CountPair> countPerHwType) {
        this.countWarnings = countWarnings;
        this.countErrors = countErrors;
        this.count = count;
        this.countTotal = countTotal;
        this.countRaw = countRaw;
        this.countIpv4 = countIpv4;
        this.countOpenflow = countOpenflow;
        this.countVm = countVm;
        this.countRawTotal = countRawTotal;
        this.countVmTotal = countVmTotal;
        this.countIpv4Total = countIpv4Total;
        this.countOpenflowTotal = countOpenflowTotal;
        this.skippedCount = skippedCount;
        this.date = date;
        this.explicitSkippedHwTypes = explicitSkippedHwTypes;
        this.implicitSkippedHwTypes = implicitSkippedHwTypes;
        this.countedHwTypes = countedHwTypes;
        this.countPerHwType = countPerHwType;
    }

    @Nullable
    public Integer getCount(@Nonnull AdvertisementCounts.CountedObject countedObject, @Nonnull AdvertisementCounts.CountScope countScope) {
        assert (countScope == AdvertisementCounts.CountScope.ALL || countScope == AdvertisementCounts.CountScope.AVAILABLE);
        switch (countedObject) {
            case ANY: {
                return countScope == AdvertisementCounts.CountScope.ALL ? this.countTotal : this.count;
            }
            case IPV4: {
                return countScope == AdvertisementCounts.CountScope.ALL ? this.countIpv4Total : this.countIpv4;
            }
            case OPENFLOW: {
                return countScope == AdvertisementCounts.CountScope.ALL ? this.countOpenflowTotal : this.countOpenflow;
            }
            case RAW_PC: {
                return countScope == AdvertisementCounts.CountScope.ALL ? this.countRawTotal : this.countRaw;
            }
            case VM: {
                return countScope == AdvertisementCounts.CountScope.ALL ? this.countVmTotal : this.countVm;
            }
        }
        throw new IllegalArgumentException("Unsupported countedObject=" + countedObject);
    }

    @Nullable
    public Integer getHwCount(@Nonnull String s, @Nonnull AdvertisementCounts.CountScope countScope) {
        CountPair p = this.countPerHwType.get(s);
        if (p == null) {
            return null;
        }
        switch (countScope) {
            case ALL: {
                return p.getTotal();
            }
            case AVAILABLE: {
                return p.getAvailable();
            }
        }
        throw new IllegalArgumentException("Unsupported CountScope: " + countScope);
    }

    @Nonnull
    public Collection<AdvertisementCounts.AdvertisementCountEntry> getCountEntries() {
        return Arrays.asList(new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.ALL, this.countTotal), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.ANY, AdvertisementCounts.CountScope.AVAILABLE, this.count), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.ALL, this.countIpv4Total), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.IPV4, AdvertisementCounts.CountScope.AVAILABLE, this.countIpv4), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.OPENFLOW, AdvertisementCounts.CountScope.ALL, this.countOpenflowTotal), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.OPENFLOW, AdvertisementCounts.CountScope.AVAILABLE, this.countOpenflow), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.ALL, this.countRawTotal), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.RAW_PC, AdvertisementCounts.CountScope.AVAILABLE, this.countRaw), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.ALL, this.countVmTotal), new AdvertisementCounts.AdvertisementCountEntry(AdvertisementCounts.CountedObject.VM, AdvertisementCounts.CountScope.AVAILABLE, this.countVm));
    }

    public int getCountEntriesSize() {
        return AdvertisementCounts.CountedObject.values().length * 2;
    }

    @Nonnull
    public Collection<AdvertisementCounts.AdvertisementHwCountEntry> getHwCountEntries() {
        ArrayList<AdvertisementCounts.AdvertisementHwCountEntry> res = new ArrayList<AdvertisementCounts.AdvertisementHwCountEntry>();
        for (Map.Entry<String, CountPair> e : this.countPerHwType.entrySet()) {
            assert (e.getKey() != null);
            assert (e.getValue() != null);
            res.add(new AdvertisementCounts.AdvertisementHwCountEntry(e.getKey(), AdvertisementCounts.CountScope.ALL, e.getValue().getTotal()));
            res.add(new AdvertisementCounts.AdvertisementHwCountEntry(e.getKey(), AdvertisementCounts.CountScope.AVAILABLE, e.getValue().getAvailable()));
        }
        return res;
    }

    public int getHwCountEntriesSize() {
        return this.countPerHwType.size();
    }

    public List<String> getHwCountKeys() {
        return new ArrayList<String>(this.countPerHwType.keySet());
    }

    @Nullable
    public Date getCountDate() {
        return this.date;
    }

    public boolean isCountWarnings() {
        return this.countWarnings;
    }

    public boolean isCountErrors() {
        return this.countErrors;
    }

    public int getCount() {
        return this.count;
    }

    public int getCountRaw() {
        return this.countRaw;
    }

    public int getCountVm() {
        return this.countVm;
    }

    public int getCountIpv4() {
        return this.countIpv4;
    }

    public int getCountOpenflow() {
        return this.countOpenflow;
    }

    public int getCountTotal() {
        return this.countTotal;
    }

    public int getCountRawTotal() {
        return this.countRawTotal;
    }

    public int getCountVmTotal() {
        return this.countVmTotal;
    }

    public int getCountIpv4Total() {
        return this.countIpv4Total;
    }

    public int getCountOpenflowTotal() {
        return this.countOpenflowTotal;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    @Nullable
    public Date getDate() {
        return this.date;
    }

    @Nonnull
    public Set<String> getExplicitSkippedHwTypes() {
        return this.explicitSkippedHwTypes;
    }

    @Nonnull
    public Set<String> getImplicitSkippedHwTypes() {
        return this.implicitSkippedHwTypes;
    }

    @Nonnull
    public Set<String> getCountedHwTypes() {
        return this.countedHwTypes;
    }

    @Nonnull
    public Map<String, CountPair> getCountPerHwType() {
        return this.countPerHwType;
    }

    public static class CountPair {
        private final int total;
        private final int available;

        public CountPair(int total, int available) {
            this.total = total;
            this.available = available;
        }

        public int getTotal() {
            return this.total;
        }

        public int getAvailable() {
            return this.available;
        }

        public CountPair newWithIncTotal(int extraTotal) {
            return new CountPair(this.total + extraTotal, this.available);
        }

        public CountPair newWithIncAvailable(int extraAvailable) {
            return new CountPair(this.total, this.available + extraAvailable);
        }

        public CountPair newWithInc(Integer extraTotal, int extraAvailable) {
            return new CountPair(this.total + extraTotal, this.available + extraAvailable);
        }
    }
}

