/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec.statistics;

import be.iminds.ilabt.jfed.rspec.statistics.RSpecStatistics;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;

class RSpecStatisticsBuilder {
    private boolean countWarnings;
    private boolean countErrors;
    private int count;
    private int countTotal;
    private int countRaw;
    private int countIpv4;
    private int countOpenflow;
    private int countVm;
    private int countRawTotal;
    private int countVmTotal;
    private int countIpv4Total;
    private int countOpenflowTotal;
    private int skippedCount;
    private Date date;
    @Nonnull
    private Set<String> explicitSkippedHwTypes = new HashSet<String>();
    @Nonnull
    private Set<String> implicitSkippedHwTypes = new HashSet<String>();
    @Nonnull
    private Set<String> countedHwTypes = new HashSet<String>();
    @Nonnull
    private Map<String, RSpecStatistics.CountPair> countPerHwType = new HashMap<String, RSpecStatistics.CountPair>();

    public RSpecStatisticsBuilder setCountWarnings(boolean countWarnings) {
        this.countWarnings = countWarnings;
        return this;
    }

    public RSpecStatisticsBuilder setCountErrors(boolean countErrors) {
        this.countErrors = countErrors;
        return this;
    }

    public void addCountWarning(String msg) {
        this.countWarnings = true;
    }

    public void addCountError(String msg) {
        this.countErrors = true;
    }

    public RSpecStatisticsBuilder setCount(int count) {
        this.count = count;
        return this;
    }

    public RSpecStatisticsBuilder incCount(int extraCount) {
        this.count += extraCount;
        return this;
    }

    public RSpecStatisticsBuilder incCount() {
        ++this.count;
        return this;
    }

    public RSpecStatisticsBuilder setCountTotal(int countTotal) {
        this.countTotal = countTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountTotal() {
        ++this.countTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountTotal(int extraCountTotal) {
        this.countTotal += extraCountTotal;
        return this;
    }

    public RSpecStatisticsBuilder setCountRaw(int countRaw) {
        this.countRaw = countRaw;
        return this;
    }

    public RSpecStatisticsBuilder incCountRaw(int extraCountRaw) {
        this.countRaw += extraCountRaw;
        return this;
    }

    public RSpecStatisticsBuilder setCountIpv4(int countIpv4) {
        this.countIpv4 = countIpv4;
        return this;
    }

    public RSpecStatisticsBuilder incCountIpv4(int extraCountIpv4) {
        this.countIpv4 += extraCountIpv4;
        return this;
    }

    public RSpecStatisticsBuilder setCountOpenflow(int countOpenflow) {
        this.countOpenflow = countOpenflow;
        return this;
    }

    public RSpecStatisticsBuilder incCountOpenflow() {
        ++this.countOpenflow;
        return this;
    }

    public RSpecStatisticsBuilder incCountOpenflow(int extraCuntOpenflow) {
        this.countOpenflow += extraCuntOpenflow;
        return this;
    }

    public RSpecStatisticsBuilder setCountVm(int countVm) {
        this.countVm = countVm;
        return this;
    }

    public RSpecStatisticsBuilder incCountVm(int extraCountVm) {
        this.countVm += extraCountVm;
        return this;
    }

    public RSpecStatisticsBuilder setCountRawTotal(int countRawTotal) {
        this.countRawTotal = countRawTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountRawTotal(int extraCountRawTotal) {
        this.countRawTotal += extraCountRawTotal;
        return this;
    }

    public RSpecStatisticsBuilder setCountVmTotal(int countVmTotal) {
        this.countVmTotal = countVmTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountVmTotal(int extraCountVmTotal) {
        this.countVmTotal += extraCountVmTotal;
        return this;
    }

    public RSpecStatisticsBuilder setCountIpv4Total(int countIpv4Total) {
        this.countIpv4Total = countIpv4Total;
        return this;
    }

    public RSpecStatisticsBuilder incCountIpv4Total(int extraCountIpv4Total) {
        this.countIpv4Total += extraCountIpv4Total;
        return this;
    }

    public RSpecStatisticsBuilder setCountOpenflowTotal(int countOpenflowTotal) {
        this.countOpenflowTotal = countOpenflowTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountOpenflowTotal(int extraCountOpenflowTotal) {
        this.countOpenflowTotal += extraCountOpenflowTotal;
        return this;
    }

    public RSpecStatisticsBuilder incCountOpenflowTotal() {
        ++this.countOpenflowTotal;
        return this;
    }

    public RSpecStatisticsBuilder setSkippedCount(int skippedCount) {
        this.skippedCount = skippedCount;
        return this;
    }

    public RSpecStatisticsBuilder incSkippedCount() {
        ++this.skippedCount;
        return this;
    }

    public RSpecStatisticsBuilder incSkippedCount(int extra) {
        this.skippedCount += extra;
        return this;
    }

    public RSpecStatisticsBuilder setDate(@Nonnull Date date) {
        this.date = date;
        return this;
    }

    public RSpecStatisticsBuilder setExplicitSkippedHwTypes(@Nonnull Set<String> explicitSkippedHwTypes) {
        this.explicitSkippedHwTypes = explicitSkippedHwTypes;
        return this;
    }

    public RSpecStatisticsBuilder addExplicitSkippedHwType(@Nonnull String explicitSkippedHwType) {
        this.explicitSkippedHwTypes.add(explicitSkippedHwType);
        return this;
    }

    public RSpecStatisticsBuilder addExplicitSkippedHwTypes(@Nonnull Collection<String> explicitSkippedHwTypes) {
        this.explicitSkippedHwTypes.addAll(explicitSkippedHwTypes);
        return this;
    }

    public RSpecStatisticsBuilder setImplicitSkippedHwTypes(@Nonnull Set<String> implicitSkippedHwTypes) {
        this.implicitSkippedHwTypes = implicitSkippedHwTypes;
        return this;
    }

    public RSpecStatisticsBuilder addImplicitSkippedHwType(@Nonnull String implicitSkippedHwType) {
        this.implicitSkippedHwTypes.add(implicitSkippedHwType);
        return this;
    }

    public RSpecStatisticsBuilder addImplicitSkippedHwTypes(@Nonnull Collection<String> implicitSkippedHwTypes) {
        this.implicitSkippedHwTypes.addAll(implicitSkippedHwTypes);
        return this;
    }

    public RSpecStatisticsBuilder setCountedHwTypes(@Nonnull Set<String> countedHwTypes) {
        this.countedHwTypes = countedHwTypes;
        return this;
    }

    public RSpecStatisticsBuilder addCountedHwType(@Nonnull String countedHwType) {
        this.countedHwTypes.add(countedHwType);
        return this;
    }

    public RSpecStatisticsBuilder addCountedHwTypes(@Nonnull Collection<String> countedHwTypes) {
        this.countedHwTypes.addAll(countedHwTypes);
        return this;
    }

    public RSpecStatisticsBuilder setCountPerHwType(@Nonnull Map<String, RSpecStatistics.CountPair> countPerHwType) {
        this.countPerHwType = countPerHwType;
        return this;
    }

    public RSpecStatisticsBuilder incTotalForHwType(@Nonnull String hwType, int extra) {
        this.countPerHwType.compute(hwType, (k, pair) -> pair == null ? new RSpecStatistics.CountPair(extra, 0) : pair.newWithIncTotal(extra));
        return this;
    }

    public RSpecStatisticsBuilder incAvailableForHwType(@Nonnull String hwType, int extra) {
        this.countPerHwType.compute(hwType, (k, pair) -> pair == null ? new RSpecStatistics.CountPair(0, extra) : pair.newWithIncAvailable(extra));
        return this;
    }

    public RSpecStatisticsBuilder incForHwType(@Nonnull String hwType, int extraAvailable, int extraTotal) {
        this.countPerHwType.compute(hwType, (k, pair) -> pair == null ? new RSpecStatistics.CountPair(extraTotal, extraAvailable) : pair.newWithInc(extraTotal, extraAvailable));
        return this;
    }

    public RSpecStatistics create() {
        return new RSpecStatistics(this.countWarnings, this.countErrors, this.count, this.countTotal, this.countRaw, this.countIpv4, this.countOpenflow, this.countVm, this.countRawTotal, this.countVmTotal, this.countIpv4Total, this.countOpenflowTotal, this.skippedCount, this.date, this.explicitSkippedHwTypes, this.implicitSkippedHwTypes, this.countedHwTypes, this.countPerHwType);
    }

    public int getCount() {
        return this.count;
    }

    public int getCountTotal() {
        return this.countTotal;
    }

    public int getCountRaw() {
        return this.countRaw;
    }

    public int getCountIpv4() {
        return this.countIpv4;
    }

    public int getCountOpenflow() {
        return this.countOpenflow;
    }

    public int getCountVm() {
        return this.countVm;
    }

    public int getCountRawTotal() {
        return this.countRawTotal;
    }

    public int getCountVmTotal() {
        return this.countVmTotal;
    }

    public int getCountIpv4Total() {
        return this.countIpv4Total;
    }

    public int getCountOpenflowTotal() {
        return this.countOpenflowTotal;
    }

    public boolean isCountWarnings() {
        return this.countWarnings;
    }

    public boolean isCountErrors() {
        return this.countErrors;
    }

    public int getSkippedCount() {
        return this.skippedCount;
    }

    public Date getDate() {
        return this.date;
    }

    @Nonnull
    public Set<String> getExplicitSkippedHwTypes() {
        return Collections.unmodifiableSet(this.explicitSkippedHwTypes);
    }

    @Nonnull
    public Set<String> getImplicitSkippedHwTypes() {
        return Collections.unmodifiableSet(this.implicitSkippedHwTypes);
    }

    @Nonnull
    public Set<String> getCountedHwTypes() {
        return Collections.unmodifiableSet(this.countedHwTypes);
    }

    @Nonnull
    public Map<String, RSpecStatistics.CountPair> getCountPerHwType() {
        return Collections.unmodifiableMap(this.countPerHwType);
    }
}

