/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld;

import be.iminds.ilabt.util.jsonld.JsonLdObjectLinkDeserializer;
import be.iminds.ilabt.util.jsonld.UriTool;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithId;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithIdBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUriBuilder;
import io.github.classgraph.ClassGraph;
import io.github.classgraph.ClassInfoList;
import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsonLdObjectsMetaData {
    private static final Logger LOG = LoggerFactory.getLogger(JsonLdObjectsMetaData.class);
    public final Set<Class<? extends JsonLdObject>> allJsonLdObjectClasses;
    private static Map<Set<String>, JsonLdObjectsMetaData> metaDataByMinimalRequiredPackageReflectionPrefixes = new HashMap<Set<String>, JsonLdObjectsMetaData>();

    public static JsonLdObjectsMetaData getInstance(@Nullable Collection<String> minimalRequiredPackageReflectionPrefixes) {
        Set<Object> minimalRequiredPackageReflectionPrefixesSet = minimalRequiredPackageReflectionPrefixes != null && !minimalRequiredPackageReflectionPrefixes.isEmpty() ? Collections.unmodifiableSet(new HashSet<String>(minimalRequiredPackageReflectionPrefixes)) : Collections.emptySet();
        return metaDataByMinimalRequiredPackageReflectionPrefixes.computeIfAbsent(minimalRequiredPackageReflectionPrefixesSet, key -> new JsonLdObjectsMetaData((Collection<String>)key));
    }

    public static JsonLdObjectsMetaData getInstance(@Nullable String minimalRequiredPackageReflectionPrefix) {
        if (minimalRequiredPackageReflectionPrefix == null) {
            return JsonLdObjectsMetaData.getInstance(Collections.emptySet());
        }
        return JsonLdObjectsMetaData.getInstance(Collections.singleton(minimalRequiredPackageReflectionPrefix));
    }

    private JsonLdObjectsMetaData(Collection<String> requiredPackageReflectionPrefixes) {
        ClassGraph classGraph = new ClassGraph();
        if (requiredPackageReflectionPrefixes == null || requiredPackageReflectionPrefixes.isEmpty()) {
            LOG.debug("Will initialise Reflections without package prefixes");
        } else {
            LOG.debug("Will initialise Reflections with package prefixes \"" + requiredPackageReflectionPrefixes + "\"");
            ArrayList<String> requiredPrefixes = new ArrayList<String>(requiredPackageReflectionPrefixes);
            requiredPrefixes.add(JsonLdObjectsMetaData.class.getPackage().getName());
            assert (JsonLdObject.class.getPackage().getName().startsWith(JsonLdObjectsMetaData.class.getPackage().getName()));
            assert (JsonLdObjectWithIdBuilder.class.getPackage().getName().startsWith(JsonLdObjectsMetaData.class.getPackage().getName()));
            classGraph.whitelistPackages(requiredPrefixes.toArray(new String[0]));
        }
        ClassInfoList scannedBasicLdObjects = classGraph.enableClassInfo().scan().getClassesImplementing(JsonLdObject.class.getName());
        assert (scannedBasicLdObjects != null);
        Set nonAbstractBasicLdObjects = scannedBasicLdObjects.stream().map(classInfo -> {
            try {
                return Class.forName(classInfo.getName());
            }
            catch (ClassNotFoundException e) {
                throw new RuntimeException(e);
            }
        }).filter(c -> !c.isInterface()).filter(c -> !Modifier.isAbstract(c.getModifiers())).collect(Collectors.toSet());
        LOG.debug("scannedBasicLdObjects.size()=" + scannedBasicLdObjects.size());
        LOG.debug("nonAbstractBasicLdObjects.size()=" + nonAbstractBasicLdObjects.size());
        this.allJsonLdObjectClasses = Collections.unmodifiableSet(nonAbstractBasicLdObjects);
        this.checkAnnotations();
    }

    private boolean checkAnnotations() {
        for (Class<? extends JsonLdObject> jsonLdObjectClass : this.allJsonLdObjectClasses) {
            if (jsonLdObjectClass.isInterface() || Modifier.isAbstract(jsonLdObjectClass.getModifiers())) continue;
            boolean isObjectWithId = JsonLdObjectWithId.class.isAssignableFrom(jsonLdObjectClass);
            JsonLdObjectInfo jsonLdObjectInfoAnnotation = jsonLdObjectClass.getAnnotation(JsonLdObjectInfo.class);
            if (jsonLdObjectInfoAnnotation == null) {
                throw new RuntimeException("The JSON LD object is missing the JsonLdObjectInfo annotation for " + jsonLdObjectClass.getSimpleName());
            }
            Class<? extends JsonLdObjectBuilder> builderClass = jsonLdObjectInfoAnnotation.builderClass();
            if (isObjectWithId && !JsonLdObjectWithIdBuilder.class.isAssignableFrom(builderClass)) {
                throw new RuntimeException("The object is marked as having an ID, but the builder is not for " + jsonLdObjectClass.getSimpleName());
            }
            JsonLdObjectBuilderInfo jsonLdObjectBuilderInfoAnnotation = builderClass.getAnnotation(JsonLdObjectBuilderInfo.class);
            if (jsonLdObjectBuilderInfoAnnotation == null) {
                throw new RuntimeException("The builder is missing the JsonLdObjectBuilderInfo annotation for " + jsonLdObjectClass.getSimpleName());
            }
            if (jsonLdObjectBuilderInfoAnnotation.objectClass().equals(jsonLdObjectClass)) continue;
            throw new RuntimeException("Builder and JsonLdObject class annotations do not cross reference for " + jsonLdObjectClass.getSimpleName() + " (builder=" + builderClass.getName() + ")");
        }
        return true;
    }

    public static final boolean mustSerializeAsEmbeddedObjectForJacksonConstructor() {
        return true;
    }

    public boolean isSingleton(@NotNull JsonLdObject jsonLdObject) {
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = jsonLdObject.getClass().getAnnotation(JsonLdObjectInfo.class);
        assert (jsonLdObjectInfoAnnotation != null);
        return jsonLdObjectInfoAnnotation.uriType().equals((Object)UriType.SINGLETON);
    }

    public boolean isSingleton(@NotNull JsonLdObjectBuilder builder) {
        JsonLdObjectBuilderInfo jsonLdObjectBuilderInfoAnnotation = builder.getClass().getAnnotation(JsonLdObjectBuilderInfo.class);
        assert (jsonLdObjectBuilderInfoAnnotation != null);
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = jsonLdObjectBuilderInfoAnnotation.objectClass().getAnnotation(JsonLdObjectInfo.class);
        assert (jsonLdObjectInfoAnnotation != null);
        return jsonLdObjectInfoAnnotation.uriType().equals((Object)UriType.SINGLETON);
    }

    public static <I, T extends JsonLdObjectWithId<I>> Class<I> getIdClassFromObjectClass(@Nonnull Class<T> objectClass) {
        return (Class)((ParameterizedType)objectClass.getGenericSuperclass()).getActualTypeArguments()[0];
    }

    @Nonnull
    public <I> I getIdFromUri(@Nonnull URI uri) {
        String[] pathParts;
        assert (uri != null);
        String usedPath = uri.getPath();
        if (usedPath.startsWith("/")) {
            usedPath = usedPath.substring(1);
        }
        for (String pathPart : pathParts = uri.getPath().split("/")) {
            for (Class<? extends JsonLdObject> jsonLdObjectClass : this.allJsonLdObjectClasses) {
                JsonLdObjectInfo jsonLdObjectInfoAnnotation;
                boolean isObjectWithUri = JsonLdObjectWithUri.class.isAssignableFrom(jsonLdObjectClass);
                if (!isObjectWithUri || !(jsonLdObjectInfoAnnotation = jsonLdObjectClass.getAnnotation(JsonLdObjectInfo.class)).pathName().equals(pathPart)) continue;
                try {
                    Class<? extends JsonLdObject> matchingJsonLdObjectClass = jsonLdObjectClass;
                    Class<I> idClass = JsonLdObjectsMetaData.getIdClassFromObjectClass(matchingJsonLdObjectClass);
                    I id = JsonLdObjectLinkDeserializer.uriToId(uri.toASCIIString(), idClass, pathPart);
                    LOG.debug("Found " + pathPart + " in URL. This matches class " + matchingJsonLdObjectClass.getName() + " with ID class " + idClass.getName());
                    return id;
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException("Bad JsonLD URI format: \"" + uri.toASCIIString() + "\"", e);
                }
            }
        }
        throw new IllegalArgumentException("Unknown JSON LD Object Class for uri: \"" + uri.toASCIIString() + "\"");
    }

    public <I, T extends JsonLdObjectWithUri> Class<T> getObjectClassFromUri(@Nonnull URI uri) {
        String[] pathParts;
        assert (uri != null);
        String usedPath = uri.getPath();
        if (usedPath.startsWith("/")) {
            usedPath = usedPath.substring(1);
        }
        for (String pathPart : pathParts = uri.getPath().split("/")) {
            for (Class<? extends JsonLdObject> jsonLdObjectClass : this.allJsonLdObjectClasses) {
                JsonLdObjectInfo jsonLdObjectInfoAnnotation;
                boolean isObjectWithUri = JsonLdObjectWithUri.class.isAssignableFrom(jsonLdObjectClass);
                if (!isObjectWithUri || !(jsonLdObjectInfoAnnotation = jsonLdObjectClass.getAnnotation(JsonLdObjectInfo.class)).pathName().equals(pathPart)) continue;
                return jsonLdObjectClass;
            }
        }
        throw new IllegalArgumentException("Unknown JSON LD Object Class for uri: \"" + uri.toASCIIString() + "\"");
    }

    public <T extends JsonLdObject> Class<T> getObjectClassFromAtType(@Nonnull String atType) {
        assert (atType != null);
        for (Class<? extends JsonLdObject> jsonLdObjectClass : this.allJsonLdObjectClasses) {
            String curAtType = jsonLdObjectClass.getSimpleName();
            if (!curAtType.equals(atType)) continue;
            return jsonLdObjectClass;
        }
        return null;
    }

    public static <IdType, ObjectType extends JsonLdObjectWithId<IdType>> Class<ObjectType> getObjectClassFromBuilder(JsonLdObjectWithIdBuilder<IdType, ObjectType> builder) {
        JsonLdObjectBuilderInfo jsonLdObjectBuilderInfoAnnotation = builder.getClass().getAnnotation(JsonLdObjectBuilderInfo.class);
        if (jsonLdObjectBuilderInfoAnnotation == null) {
            throw new RuntimeException("The builder (" + builder.getClass().getSimpleName() + ") is missing the JsonLdObjectBuilderInfo annotation");
        }
        return jsonLdObjectBuilderInfoAnnotation.objectClass();
    }

    public static <IdType, ObjectType extends JsonLdObject> Class<ObjectType> getObjectClassFromBuilder(JsonLdObjectBuilder<ObjectType> builder) {
        JsonLdObjectBuilderInfo jsonLdObjectBuilderInfoAnnotation = builder.getClass().getAnnotation(JsonLdObjectBuilderInfo.class);
        if (jsonLdObjectBuilderInfoAnnotation == null) {
            throw new RuntimeException("The builder (" + builder.getClass().getSimpleName() + ") is missing the JsonLdObjectBuilderInfo annotation");
        }
        return jsonLdObjectBuilderInfoAnnotation.objectClass();
    }

    public static <IdType, ObjectType extends JsonLdObjectWithId<IdType>> Class<ObjectType> getObjectClassFromBuilder(Class<? extends JsonLdObjectWithIdBuilder<IdType, ObjectType>> builderClass) {
        JsonLdObjectBuilderInfo jsonLdObjectBuilderInfoAnnotation = builderClass.getAnnotation(JsonLdObjectBuilderInfo.class);
        if (jsonLdObjectBuilderInfoAnnotation == null) {
            throw new RuntimeException("The builder is missing the JsonLdObjectBuilderInfo annotation");
        }
        return jsonLdObjectBuilderInfoAnnotation.objectClass();
    }

    public static <IdType, ObjectType extends JsonLdObjectWithId<IdType>> Class<JsonLdObjectWithIdBuilder<IdType, ObjectType>> getJsonLdObjectWithIdBuilderClassFromObject(Class<ObjectType> objectClass) {
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = objectClass.getAnnotation(JsonLdObjectInfo.class);
        if (jsonLdObjectInfoAnnotation == null) {
            throw new RuntimeException("The JSON LD object (" + objectClass.getSimpleName() + ") is missing the JsonLdObjectInfo annotation");
        }
        return jsonLdObjectInfoAnnotation.builderClass();
    }

    public static <IdType, ObjectType extends JsonLdObjectWithUri> Class<JsonLdObjectWithUriBuilder<ObjectType>> getJsonLdObjectWithUriBuilderClassFromObject(Class<ObjectType> objectClass) {
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = objectClass.getAnnotation(JsonLdObjectInfo.class);
        if (jsonLdObjectInfoAnnotation == null) {
            throw new RuntimeException("The JSON LD object (" + objectClass.getSimpleName() + ") is missing the JsonLdObjectInfo annotation");
        }
        return jsonLdObjectInfoAnnotation.builderClass();
    }

    public static <ObjectType extends JsonLdObject> Class<JsonLdObjectBuilder<ObjectType>> getJsonLdObjectBuilderClassFromObject(Class<ObjectType> objectClass) {
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = objectClass.getAnnotation(JsonLdObjectInfo.class);
        if (jsonLdObjectInfoAnnotation == null) {
            throw new RuntimeException("The JSON LD object (" + objectClass.getSimpleName() + ") is missing the JsonLdObjectInfo annotation");
        }
        return jsonLdObjectInfoAnnotation.builderClass();
    }

    public static String getUrlObjectName(Class<? extends JsonLdObject> objectClass) {
        JsonLdObjectInfo jsonLdObjectInfoAnnotation = objectClass.getAnnotation(JsonLdObjectInfo.class);
        if (jsonLdObjectInfoAnnotation == null) {
            if (JsonLdObjectWithUri.class.isAssignableFrom(objectClass)) {
                throw new RuntimeException("The JSON LD object " + objectClass.getName() + " is missing the JsonLdObjectInfo annotation");
            }
            return null;
        }
        return jsonLdObjectInfoAnnotation.pathName();
    }

    public static <ObjectType extends JsonLdObject> JsonLdObjectBuilder<ObjectType> createJsonLdObjectBuilder(Class<ObjectType> objectClass) {
        Class<JsonLdObjectBuilder<ObjectType>> builder = JsonLdObjectsMetaData.getJsonLdObjectBuilderClassFromObject(objectClass);
        try {
            return builder.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using default constructor (" + objectClass.getSimpleName() + ")", e);
        }
    }

    public static <ObjectType extends JsonLdObjectWithUri> JsonLdObjectWithUriBuilder<ObjectType> createJsonLdObjectWithUriBuilder(Class<ObjectType> objectClass) {
        Class<JsonLdObjectWithUriBuilder<ObjectType>> builder = JsonLdObjectsMetaData.getJsonLdObjectWithUriBuilderClassFromObject(objectClass);
        try {
            return builder.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using default constructor (" + objectClass.getSimpleName() + ")", e);
        }
    }

    public static <IdType, ObjectType extends JsonLdObjectWithId<IdType>> JsonLdObjectWithIdBuilder<IdType, ObjectType> createJsonLdObjectWithIdBuilder(Class<ObjectType> objectClass) {
        Class<JsonLdObjectWithIdBuilder<IdType, ObjectType>> builder = JsonLdObjectsMetaData.getJsonLdObjectWithIdBuilderClassFromObject(objectClass);
        try {
            return builder.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using default constructor (" + objectClass.getSimpleName() + ")", e);
        }
    }

    public static <IdType, ObjectType extends JsonLdObjectWithId<IdType>> JsonLdObjectWithIdBuilder<IdType, ObjectType> createBuilderCopy(ObjectType object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't create Builder copy from null");
        }
        Class<JsonLdObjectWithIdBuilder<IdType, ?>> builder = JsonLdObjectsMetaData.getJsonLdObjectWithIdBuilderClassFromObject(object.getClass());
        try {
            Constructor<JsonLdObjectWithIdBuilder<IdType, ?>> constructor = builder.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using copy constructor", e);
        }
    }

    public static <ObjectType extends JsonLdObject> JsonLdObjectBuilder<ObjectType> createBuilderCopy(ObjectType object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't create Builder copy from null");
        }
        Class<JsonLdObjectBuilder<?>> builder = JsonLdObjectsMetaData.getJsonLdObjectBuilderClassFromObject(object.getClass());
        try {
            Constructor<JsonLdObjectBuilder<?>> constructor = builder.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using copy constructor", e);
        }
    }

    public static <ObjectType extends JsonLdObjectWithUri> JsonLdObjectWithUriBuilder<ObjectType> createBuilderWithUriCopy(ObjectType object) {
        if (object == null) {
            throw new IllegalArgumentException("Can't create Builder copy from null");
        }
        Class<JsonLdObjectWithUriBuilder<?>> builder = JsonLdObjectsMetaData.getJsonLdObjectWithUriBuilderClassFromObject(object.getClass());
        try {
            Constructor<JsonLdObjectWithUriBuilder<?>> constructor = builder.getConstructor(object.getClass());
            return constructor.newInstance(object);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Builder using copy constructor", e);
        }
    }

    public UriTool makeUriTool(String baseUrl) {
        return new UriTool(baseUrl, this, null);
    }

    public UriTool makeUriTool(String baseUrl, UriTool.DerivedUriGenerator derivedUriGenerator) {
        return new UriTool(baseUrl, this, derivedUriGenerator == null ? null : Collections.singletonList(derivedUriGenerator));
    }

    public UriTool makeUriTool(String baseUrl, UriTool.DerivedUriGenerator ... derivedUriGenerators) {
        return new UriTool(baseUrl, this, Arrays.asList(derivedUriGenerators));
    }

    public UriTool makeUriTool(String baseUrl, List<UriTool.DerivedUriGenerator> derivedUriGenerators) {
        return new UriTool(baseUrl, this, derivedUriGenerators == null ? null : derivedUriGenerators);
    }

    public static class ReferenceAccessorHelper<T extends JsonLdObjectBuilder> {
        private final Class<T> builderClass;
        private final T builder;
        private final Set<ReferenceId> referencedObjectClasses = new HashSet<ReferenceId>();
        private final Map<ReferenceId, InternalInfo> internalInfoByReferenceId = new HashMap<ReferenceId, InternalInfo>();

        public ReferenceAccessorHelper(Class<T> builderClass, T builder) {
            this.builderClass = builderClass;
            this.builder = builder;
            assert (builderClass != null);
            assert (builder != null);
            Method[] methods = builderClass.getMethods();
            for (Method method : methods) {
                ReferenceGetter referenceGetterAnnotation = method.getAnnotation(ReferenceGetter.class);
                ReferenceSetter referenceSetterAnnotation = method.getAnnotation(ReferenceSetter.class);
                ReferenceListGetter referenceListGetterAnnotation = method.getAnnotation(ReferenceListGetter.class);
                ReferenceListSetter referenceListSetterAnnotation = method.getAnnotation(ReferenceListSetter.class);
                ReferenceListCallbackBasedAccessor referenceListCallbackBasedAccessorAnnotation = method.getAnnotation(ReferenceListCallbackBasedAccessor.class);
                int anCount = 0;
                Class<? extends JsonLdObjectWithUri> referencedObjectClass = null;
                String referencedName = null;
                boolean builderReference = false;
                boolean isList = false;
                boolean isGetter = false;
                boolean isSetter = false;
                boolean isAccessorCallback = false;
                if (referenceGetterAnnotation != null) {
                    ++anCount;
                    referencedObjectClass = referenceGetterAnnotation.objectClass();
                    referencedName = referenceGetterAnnotation.name();
                    builderReference = referenceGetterAnnotation.builderReference();
                    isGetter = true;
                }
                if (referenceSetterAnnotation != null) {
                    ++anCount;
                    referencedObjectClass = referenceSetterAnnotation.objectClass();
                    referencedName = referenceSetterAnnotation.name();
                    builderReference = referenceSetterAnnotation.builderReference();
                    isSetter = true;
                }
                if (referenceListGetterAnnotation != null) {
                    ++anCount;
                    referencedObjectClass = referenceListGetterAnnotation.objectClass();
                    referencedName = referenceListGetterAnnotation.name();
                    builderReference = referenceListGetterAnnotation.builderReference();
                    isList = true;
                    isGetter = true;
                }
                if (referenceListSetterAnnotation != null) {
                    ++anCount;
                    referencedObjectClass = referenceListSetterAnnotation.objectClass();
                    referencedName = referenceListSetterAnnotation.name();
                    builderReference = referenceListSetterAnnotation.builderReference();
                    isList = true;
                    isSetter = true;
                }
                if (referenceListCallbackBasedAccessorAnnotation != null) {
                    ++anCount;
                    referencedObjectClass = referenceListCallbackBasedAccessorAnnotation.objectClass();
                    referencedName = referenceListCallbackBasedAccessorAnnotation.name();
                    builderReference = referenceListCallbackBasedAccessorAnnotation.builderReference();
                    isList = true;
                    isAccessorCallback = true;
                }
                if (anCount == 0) continue;
                if (anCount != 1) {
                    throw new AssertionError((Object)("Invalid combination of annotations for " + builderClass.getSimpleName() + " method " + method.getName()));
                }
                assert (referencedObjectClass != null);
                ReferenceId<? extends JsonLdObjectWithUri> currentReferenceId = new ReferenceId<JsonLdObjectWithUri>(referencedObjectClass, referencedName);
                InternalInfo internalInfo = this.internalInfoByReferenceId.get(currentReferenceId);
                if (internalInfo == null) {
                    internalInfo = new InternalInfo(currentReferenceId, isList);
                    this.internalInfoByReferenceId.put(currentReferenceId, internalInfo);
                } else assert (internalInfo.list == isList);
                if (builderReference) {
                    if (isGetter) {
                        internalInfo.builderGetter = method;
                    }
                    if (isSetter) {
                        internalInfo.builderSetter = method;
                    }
                    if (isAccessorCallback) {
                        internalInfo.builderAccessorCallback = method;
                    }
                } else {
                    if (isGetter) {
                        internalInfo.getter = method;
                    }
                    if (isSetter) {
                        internalInfo.setter = method;
                    }
                    if (isAccessorCallback) {
                        internalInfo.accessorCallback = method;
                    }
                }
                if (!internalInfo.complete()) continue;
                this.referencedObjectClasses.add(currentReferenceId);
            }
            for (InternalInfo internalInfo : this.internalInfoByReferenceId.values()) {
                if (internalInfo.complete()) continue;
                throw new RuntimeException(builderClass.getSimpleName() + " has incomplete annotations for " + internalInfo.referenceId.toString() + " getter=" + internalInfo.getter + " setter=" + internalInfo.setter + " all=" + this.internalInfoByReferenceId.values());
            }
        }

        public Collection<ReferenceId> getReferenceIds() {
            return this.referencedObjectClasses;
        }

        public ReferenceId getReferenceIdByReferenceId(ReferenceId otherBuildersReferenceId) {
            for (ReferenceId rid : this.referencedObjectClasses) {
                if (!rid.equals(otherBuildersReferenceId)) continue;
                return rid;
            }
            return null;
        }

        public boolean isList(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.list;
        }

        public <R extends JsonLdObjectWithUri> void set(ReferenceId<R> referenceId, R object) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (!internalInfo.list);
            try {
                internalInfo.setter.invoke(this.builder, object);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.setter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri> R get(ReferenceId<R> referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (!internalInfo.list);
            try {
                Object res = internalInfo.getter.invoke(this.builder, new Object[0]);
                return (R)((JsonLdObjectWithUri)res);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.getter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri, B extends JsonLdObjectWithUriBuilder> B getBuilder(ReferenceId<R> referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (internalInfo.builderGetter != null);
            assert (!internalInfo.list);
            try {
                Object res = internalInfo.builderGetter.invoke(this.builder, new Object[0]);
                return (B)((JsonLdObjectWithUriBuilder)res);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.builderGetter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri> void setCollection(ReferenceId<R> referenceId, List<R> objectList) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (internalInfo.list);
            try {
                internalInfo.setter.invoke(this.builder, objectList);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.setter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri> Collection<R> getCollection(ReferenceId<R> referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (this.builder != null);
            assert (internalInfo != null);
            assert (internalInfo.getter != null) : "No getter in internalInfo " + internalInfo.toString() + " for class " + this.builder.getClass().getName();
            assert (internalInfo.list);
            try {
                Object res = internalInfo.getter.invoke(this.builder, new Object[0]);
                return (Collection)res;
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.getter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri, B extends JsonLdObjectWithUriBuilder> Collection<B> getCollectionBuilder(ReferenceId<R> referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (internalInfo.builderGetter != null);
            assert (internalInfo.list);
            try {
                Object res = internalInfo.builderGetter.invoke(this.builder, new Object[0]);
                return (Collection)res;
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.builderGetter.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri> void modifyUsingAccessorCallback(ReferenceId<R> referenceId, UnaryOperator<R> modifier) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (internalInfo.accessorCallback != null);
            assert (internalInfo.list);
            try {
                internalInfo.accessorCallback.invoke(this.builder, modifier);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.accessorCallback.getName(), e);
            }
        }

        public <R extends JsonLdObjectWithUri, B extends JsonLdObjectWithUriBuilder> void modifyUsingBuilderAccessorCallback(ReferenceId<R> referenceId, UnaryOperator<B> modifier) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            assert (internalInfo.builderAccessorCallback != null);
            assert (internalInfo.list);
            try {
                internalInfo.builderAccessorCallback.invoke(this.builder, modifier);
            }
            catch (Exception e) {
                throw new RuntimeException("Error invoking " + internalInfo.builderAccessorCallback.getName(), e);
            }
        }

        public boolean hasDirectAccessors(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.getter != null && internalInfo.accessorCallback == null && internalInfo.builderAccessorCallback == null;
        }

        public boolean hasBuilderAccessors(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.builderGetter != null && internalInfo.accessorCallback == null && internalInfo.builderAccessorCallback == null;
        }

        public boolean hasAnyAccessorCallback(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.accessorCallback != null || internalInfo.builderAccessorCallback != null;
        }

        public boolean hasDirectAccessorCallback(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.accessorCallback != null;
        }

        public boolean hasBuilderAccessorCallback(ReferenceId referenceId) {
            InternalInfo internalInfo = this.internalInfoByReferenceId.get(referenceId);
            assert (internalInfo != null);
            return internalInfo.builderAccessorCallback != null;
        }

        private class InternalInfo {
            ReferenceId referenceId;
            Method setter;
            Method getter;
            Method accessorCallback;
            Method builderSetter;
            Method builderGetter;
            Method builderAccessorCallback;
            boolean list;
            String name;

            public InternalInfo(ReferenceId referenceId, boolean list) {
                this.referenceId = referenceId;
                this.list = list;
            }

            private boolean complete() {
                if (this.accessorCallback != null || this.builderAccessorCallback != null) {
                    return true;
                }
                if (this.builderSetter != null != (this.builderGetter != null)) {
                    return false;
                }
                return this.getter != null && this.setter != null;
            }

            public String toString() {
                return "InternalInfo{referenceId=" + this.referenceId + ", setter=" + this.setter + ", getter=" + this.getter + ", builderSetter=" + this.builderSetter + ", builderGetter=" + this.builderGetter + ", list=" + this.list + ", iaccessorCallback=" + this.accessorCallback + ", name='" + this.name + '\'' + '}';
            }
        }

        public static class ReferenceId<T extends JsonLdObjectWithUri> {
            private final Class<T> objectClass;
            private final String name;

            public ReferenceId(Class<T> objectClass) {
                this(objectClass, null);
            }

            public ReferenceId(Class<T> objectClass, String name) {
                assert (objectClass != null);
                this.objectClass = objectClass;
                if (name != null && !name.trim().isEmpty()) {
                    assert (name != null);
                    assert (!name.trim().isEmpty());
                    this.name = name;
                } else {
                    this.name = null;
                }
            }

            public Class<T> getObjectClass() {
                return this.objectClass;
            }

            public Class<? extends JsonLdObjectWithUriBuilder> getBuilderClass() {
                return JsonLdObjectsMetaData.getJsonLdObjectWithUriBuilderClassFromObject(this.objectClass);
            }

            public String getName() {
                return this.name;
            }

            public boolean hasName() {
                return this.name != null;
            }

            public boolean equals(Object o) {
                if (this == o) {
                    return true;
                }
                if (o == null || this.getClass() != o.getClass()) {
                    return false;
                }
                ReferenceId that = (ReferenceId)o;
                if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
                    return false;
                }
                return this.objectClass.equals(that.objectClass);
            }

            public int hashCode() {
                int result = this.objectClass.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }

            public String toString() {
                if (this.hasName()) {
                    return this.objectClass.getSimpleName() + " \"" + this.name + "\"";
                }
                return this.objectClass.getSimpleName();
            }
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Inherited
    public static @interface ReferenceListCallbackBasedAccessor {
        public String name();

        public boolean builderReference() default false;

        public Class<? extends JsonLdObjectWithUri> objectClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Inherited
    public static @interface ReferenceListGetter {
        public String name() default "";

        public boolean builderReference() default false;

        public Class<? extends JsonLdObjectWithUri> objectClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Inherited
    public static @interface ReferenceListSetter {
        public String name() default "";

        public boolean builderReference() default false;

        public Class<? extends JsonLdObjectWithUri> objectClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Inherited
    public static @interface ReferenceGetter {
        public String name() default "";

        public boolean builderReference() default false;

        public Class<? extends JsonLdObjectWithUri> objectClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.METHOD})
    @Inherited
    public static @interface ReferenceSetter {
        public String name() default "";

        public boolean builderReference() default false;

        public Class<? extends JsonLdObjectWithUri> objectClass();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface JsonLdObjectInfo {
        public String pathName();

        public Class<? extends JsonLdObjectBuilder> builderClass();

        public UriType uriType();

        public IdType idType();
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    @Inherited
    public static @interface JsonLdObjectBuilderInfo {
        public Class<? extends JsonLdObject> objectClass();
    }

    public static final class Minimization
    extends Enum<Minimization> {
        public static final /* enum */ Minimization MINIMAL_ID_ONLY = new Minimization(true, false, false, (Minimization)null, (Minimization)null);
        public static final /* enum */ Minimization ID_ONLY = new Minimization(true, true, false, (Minimization)null, (Minimization)null);
        public static final /* enum */ Minimization ID_AND_LINKS = new Minimization(true, true, false, ID_ONLY, ID_ONLY);
        public static final /* enum */ Minimization FULL_WITH_MINIMAL_LINK_IDS = new Minimization(true, true, true, MINIMAL_ID_ONLY, MINIMAL_ID_ONLY);
        public static final /* enum */ Minimization FULL_WITH_LINK_IDS = new Minimization(true, true, true, ID_ONLY, ID_ONLY);
        public static final /* enum */ Minimization FULL_FOR_EMBEDDING_IN_PARENT = new Minimization(true, true, true, (Boolean)true, MINIMAL_ID_ONLY);
        public static final /* enum */ Minimization FULL_FOR_EMBEDDING_IN_CHILD = new Minimization(true, true, true, MINIMAL_ID_ONLY, (Boolean)true);
        public static final /* enum */ Minimization FULL_EMBEDDING_PARENT_AND_CHILDREN = new Minimization(true, true, true, FULL_FOR_EMBEDDING_IN_PARENT, FULL_FOR_EMBEDDING_IN_CHILD);
        public static final /* enum */ Minimization FULL_FOR_EMBEDDING_IN_PARENT_NOBACKLINK = new Minimization(true, true, true, (Boolean)true, (Minimization)null);
        public static final /* enum */ Minimization FULL_FOR_EMBEDDING_IN_CHILD_NOBACKLINK = new Minimization(true, true, true, (Minimization)null, (Boolean)true);
        public static final /* enum */ Minimization FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK = new Minimization(true, true, true, FULL_FOR_EMBEDDING_IN_PARENT_NOBACKLINK, FULL_FOR_EMBEDDING_IN_CHILD_NOBACKLINK);
        public static final /* enum */ Minimization FULL_NO_CHILDREN_PARENT_ID_ONLY = new Minimization(true, true, true, (Minimization)null, MINIMAL_ID_ONLY);
        public static final /* enum */ Minimization FULL_EMBED_ONLY_CHILDREN = new Minimization(true, true, true, (Boolean)true, (Minimization)null);
        public static final /* enum */ Minimization FULL_EMBED_CHILDREN_LINK_PARENT = new Minimization(true, true, true, FULL_EMBED_ONLY_CHILDREN, MINIMAL_ID_ONLY);
        public static final /* enum */ Minimization FULL_LINK_CHILDREN_EMBED_PARENT = new Minimization(true, true, true, MINIMAL_ID_ONLY, FULL_EMBED_ONLY_CHILDREN);
        public static final /* enum */ Minimization FULL_WITHOUT_ID_EMBED_ONLY_CHILDREN = new Minimization(false, true, true, (Boolean)true, (Minimization)null);
        public static final /* enum */ Minimization FULL = new Minimization(true, true, true, (Boolean)true, (Boolean)true);
        public static final /* enum */ Minimization ID_ONLY_WITH_EMBEDDED_PARENT_ID = new Minimization(true, true, false, (Minimization)null, (Boolean)true);
        private final boolean mustIncludeId;
        private final boolean mustIncludeExtraIds;
        private final boolean mustIncludeOtherProperties;
        private final Minimization childrenMinimization;
        private final Minimization parentMinimization;
        private static final /* synthetic */ Minimization[] $VALUES;

        public static Minimization[] values() {
            return (Minimization[])$VALUES.clone();
        }

        public static Minimization valueOf(String name) {
            return Enum.valueOf(Minimization.class, name);
        }

        private Minimization(boolean mustIncludeId, boolean mustIncludeExtraIds, boolean includeOtherProperties, Minimization childrenMinimization, Minimization parentMinimization) {
            this.mustIncludeId = mustIncludeId;
            this.mustIncludeExtraIds = mustIncludeExtraIds;
            this.mustIncludeOtherProperties = includeOtherProperties;
            this.childrenMinimization = childrenMinimization;
            this.parentMinimization = parentMinimization;
        }

        private Minimization(boolean mustIncludeId, boolean mustIncludeExtraIds, boolean includeOtherProperties, Boolean selfChildrenMinimizationForm, Boolean selfParentMinimizationForm) {
            this.mustIncludeId = mustIncludeId;
            this.mustIncludeExtraIds = mustIncludeExtraIds;
            this.mustIncludeOtherProperties = includeOtherProperties;
            this.childrenMinimization = selfChildrenMinimizationForm == null ? null : this;
            this.parentMinimization = selfParentMinimizationForm == null ? null : this;
        }

        private Minimization(boolean mustIncludeId, boolean mustIncludeExtraIds, boolean includeOtherProperties, Boolean selfChildrenMinimizationForm, Minimization parentMinimization) {
            this.mustIncludeId = mustIncludeId;
            this.mustIncludeExtraIds = mustIncludeExtraIds;
            this.mustIncludeOtherProperties = includeOtherProperties;
            this.childrenMinimization = selfChildrenMinimizationForm == null ? null : this;
            this.parentMinimization = parentMinimization;
        }

        private Minimization(boolean mustIncludeId, boolean mustIncludeExtraIds, boolean includeOtherProperties, Minimization childrenMinimization, Boolean selfParentMinimizationForm) {
            this.mustIncludeId = mustIncludeId;
            this.mustIncludeExtraIds = mustIncludeExtraIds;
            this.mustIncludeOtherProperties = includeOtherProperties;
            this.childrenMinimization = childrenMinimization;
            this.parentMinimization = selfParentMinimizationForm == null ? null : this;
        }

        public boolean includeId() {
            return this.mustIncludeId;
        }

        public boolean includeExtraIds() {
            return this.mustIncludeExtraIds;
        }

        public boolean includeOtherProperties() {
            return this.mustIncludeOtherProperties;
        }

        public boolean includeChildren() {
            return this.childrenMinimization != null;
        }

        public Minimization getChildrenMinimization() {
            assert (this.childrenMinimization != FULL);
            return this.childrenMinimization;
        }

        public Minimization getParentMinimization() {
            assert (this.parentMinimization != FULL);
            return this.parentMinimization;
        }

        public boolean includeParent() {
            return this.parentMinimization != null;
        }

        public boolean serializeAsEmbeddedObject() {
            return this.parentMinimization != null || this.childrenMinimization != null || this.mustIncludeOtherProperties || this.mustIncludeExtraIds;
        }

        static {
            $VALUES = new Minimization[]{MINIMAL_ID_ONLY, ID_ONLY, ID_AND_LINKS, FULL_WITH_MINIMAL_LINK_IDS, FULL_WITH_LINK_IDS, FULL_FOR_EMBEDDING_IN_PARENT, FULL_FOR_EMBEDDING_IN_CHILD, FULL_EMBEDDING_PARENT_AND_CHILDREN, FULL_FOR_EMBEDDING_IN_PARENT_NOBACKLINK, FULL_FOR_EMBEDDING_IN_CHILD_NOBACKLINK, FULL_EMBEDDING_PARENT_AND_CHILDREN_NOBACKLINK, FULL_NO_CHILDREN_PARENT_ID_ONLY, FULL_EMBED_ONLY_CHILDREN, FULL_EMBED_CHILDREN_LINK_PARENT, FULL_LINK_CHILDREN_EMBED_PARENT, FULL_WITHOUT_ID_EMBED_ONLY_CHILDREN, FULL, ID_ONLY_WITH_EMBEDDED_PARENT_ID};
        }
    }

    public static enum IdType {
        NONE,
        FOREIGN,
        PRIMARY;

    }

    public static enum UriType {
        NONE,
        SINGLETON,
        ID_BASED;

    }
}

