/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.util.jsonld;

import be.iminds.ilabt.util.jsonld.JsonLdObjectsMetaData;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObject;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithIdBuilder;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUriBuilder;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObject;
import be.iminds.ilabt.util.jsonld.impl.PrimaryIdObjectBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UriTool {
    private static final Logger LOG = LoggerFactory.getLogger(UriTool.class);
    @Nonnull
    private final String baseUrl;
    @Nonnull
    private final JsonLdObjectsMetaData metaData;
    @Nonnull
    private final List<DerivedUriGenerator> derivedUriGenerators;
    private static final Map<Class, Class> jsonToResource = new HashMap<Class, Class>();
    private static final Map<Class, Class> resourceToJson = new HashMap<Class, Class>();

    protected UriTool(@NotNull String baseUrl, @NotNull JsonLdObjectsMetaData jsonLdObjectsMetaData, @Nullable List<DerivedUriGenerator> derivedUriGenerators) {
        assert (baseUrl != null);
        assert (jsonLdObjectsMetaData != null);
        if (baseUrl != null && !baseUrl.endsWith("/")) {
            baseUrl = baseUrl + "/";
        }
        this.baseUrl = baseUrl;
        this.metaData = jsonLdObjectsMetaData;
        this.derivedUriGenerators = derivedUriGenerators == null ? Collections.emptyList() : derivedUriGenerators;
        try {
            assert (new URI(baseUrl) != null);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Error constructing URI using base in config: \"" + baseUrl + "\"", e);
        }
    }

    public URI getUriUsingFedmonObject(Class<? extends JsonLdObjectWithUri> fedmonObjectClass, Object id) {
        assert (this.baseUrl != null);
        assert (this.baseUrl.endsWith("/"));
        String path = JsonLdObjectsMetaData.getUrlObjectName(fedmonObjectClass);
        assert (!path.endsWith("/"));
        assert (!path.startsWith("/"));
        try {
            if (id == null) {
                return new URI(this.baseUrl + path);
            }
            return new URI(this.baseUrl + path + "/" + id);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error constructing URI using base in config: \"" + this.baseUrl + "\"", e);
        }
    }

    @Nonnull
    public String getBaseUrlString() {
        return this.baseUrl;
    }

    @Nonnull
    public URI getBaseUri() {
        try {
            return new URI(this.baseUrl);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Error constructing URI using base in config: \"" + this.baseUrl + "\"", e);
        }
    }

    public void setBuilderUri(PrimaryIdObjectBuilder builder, boolean setSearchUris) {
        boolean isSingleton = this.metaData.isSingleton(builder);
        URI uri = isSingleton ? this.getUriUsingFedmonObject(JsonLdObjectsMetaData.getObjectClassFromBuilder(builder), null) : this.getUriUsingFedmonObject(JsonLdObjectsMetaData.getObjectClassFromBuilder(builder), builder.getId());
        builder.setUri(uri);
        if (setSearchUris && !this.derivedUriGenerators.isEmpty()) {
            for (DerivedUriGenerator derivedUriGenerator : this.derivedUriGenerators) {
                derivedUriGenerator.addDerivedUri(builder, this);
            }
        }
    }

    public void setSingletonUri(JsonLdObjectWithUriBuilder builder, boolean setSearchUris) {
        assert (this.metaData.isSingleton(builder));
        builder.setUri(this.getUriUsingFedmonObject(JsonLdObjectsMetaData.getObjectClassFromBuilder(builder), null));
        if (setSearchUris && !this.derivedUriGenerators.isEmpty()) {
            for (DerivedUriGenerator derivedUriGenerator : this.derivedUriGenerators) {
                derivedUriGenerator.addDerivedUri(builder, this);
            }
        }
    }

    public <O extends JsonLdObject> O setUriRecursive(O fedmonObject) {
        JsonLdObjectBuilder<O> builder = JsonLdObjectsMetaData.createBuilderCopy(fedmonObject);
        this.setUriRecursive(builder, Collections.emptySet(), true, true);
        return builder.create();
    }

    public <B extends JsonLdObjectBuilder> B setUriRecursive(B builder) {
        this.setUriRecursive(builder, Collections.emptySet(), true, true);
        return builder;
    }

    public <O extends JsonLdObject> O setUriRecursive(O fedmonObject, boolean setSearchRecursive) {
        JsonLdObjectBuilder<O> builder = JsonLdObjectsMetaData.createBuilderCopy(fedmonObject);
        this.setUriRecursive(builder, Collections.emptySet(), setSearchRecursive, true);
        return builder.create();
    }

    public <B extends JsonLdObjectBuilder> B setUriRecursive(B builder, boolean setSearchRecursive) {
        this.setUriRecursive(builder, Collections.emptySet(), setSearchRecursive, true);
        return builder;
    }

    private <B extends JsonLdObjectBuilder> B setUriRecursive(B builder, Set<JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId> noRecurseReferences, boolean setSearchRecursive, boolean setSearch) {
        boolean isSingleton = this.metaData.isSingleton(builder);
        if (builder instanceof JsonLdObjectWithUriBuilder && builder instanceof JsonLdObjectWithIdBuilder) {
            assert (builder instanceof PrimaryIdObjectBuilder) : "implementation assumption violated for " + builder.getClass().getName();
            PrimaryIdObjectBuilder fullBuilder = (PrimaryIdObjectBuilder)builder;
            if (!isSingleton && fullBuilder.getId() == null) {
                LOG.warn("setUriRecursive called on object without ID");
                return builder;
            }
            this.setBuilderUri(fullBuilder, setSearch);
        } else if (isSingleton) {
            assert (builder instanceof JsonLdObjectWithUriBuilder) : "implementation assumption violated for " + builder.getClass().getName();
            this.setSingletonUri((JsonLdObjectWithUriBuilder)builder, setSearch);
        }
        if (!this.derivedUriGenerators.isEmpty()) {
            for (DerivedUriGenerator derivedUriGenerator : this.derivedUriGenerators) {
                derivedUriGenerator.addForeignUri(builder, this);
            }
        }
        Class<?> builderClass = builder.getClass();
        JsonLdObjectsMetaData.ReferenceAccessorHelper builderAccessors = new JsonLdObjectsMetaData.ReferenceAccessorHelper(builderClass, builder);
        Collection<JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId> referenceIds = builderAccessors.getReferenceIds();
        for (JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId referenceId : referenceIds) {
            UnaryOperator modifier;
            boolean isSingle;
            Class<JsonLdObjectWithUriBuilder> referencedBuilderClass = referenceId.getBuilderClass();
            assert (referencedBuilderClass != null);
            HashSet<JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId> newNoRecurseReferences = new HashSet<JsonLdObjectsMetaData.ReferenceAccessorHelper.ReferenceId>(noRecurseReferences);
            if (newNoRecurseReferences.contains(referenceId)) {
                LOG.debug("Skipping setter because of noRecurseClasses set for " + referencedBuilderClass.getSimpleName());
                continue;
            }
            boolean isList = builderAccessors.isList(referenceId);
            boolean bl = isSingle = !isList;
            if (isSingle) {
                LOG.debug("Changing sub URI of single " + referenceId);
                Object o2 = builderAccessors.get(referenceId);
                if (o2 == null && builderAccessors.hasBuilderAccessors(referenceId)) {
                    LOG.debug("  o == null");
                    Object b2 = builderAccessors.getBuilder(referenceId);
                    if (b2 != null) {
                        newNoRecurseReferences.add(referenceId);
                        this.setUriRecursive(b2, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                        LOG.debug("o == null Set " + referenceId + " uri to " + b2.getUri().toASCIIString());
                        LOG.debug("o == null Successfully changed sub URI for " + referenceId);
                        continue;
                    }
                    LOG.debug("  o == null b == null");
                }
                assert (builderAccessors.hasDirectAccessors(referenceId));
                if (o2 == null) {
                    LOG.debug("Skipping: get" + referenceId + " returned null for both direct and builder");
                    continue;
                }
                JsonLdObjectWithUriBuilder copyBuilder = JsonLdObjectsMetaData.createBuilderWithUriCopy(o2);
                assert (copyBuilder != null);
                newNoRecurseReferences.add(referenceId);
                this.setUriRecursive(copyBuilder, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                assert (copyBuilder.getUri() != null) : "URI for reference " + referenceId + " was not set and is still null!";
                LOG.debug("Set " + referenceId + " uri to " + copyBuilder.getUri().toASCIIString());
                builderAccessors.set(referenceId, copyBuilder.create());
                LOG.debug("Successfully changed sub URI for " + referenceId);
            }
            if (isList && !builderAccessors.hasAnyAccessorCallback(referenceId)) {
                Collection builders;
                LOG.debug("Changing sub URIs of List of " + referenceId);
                Collection l = builderAccessors.getCollection(referenceId);
                if (l == null && builderAccessors.hasBuilderAccessors(referenceId) && (builders = builderAccessors.getCollectionBuilder(referenceId)) != null) {
                    for (PrimaryIdObjectBuilder b3 : builders) {
                        assert (b3.getId() != null) : "No ID for " + referenceId + " in sub list of " + builderClass.getSimpleName() + ". Full builder: " + builder.create().toString();
                        newNoRecurseReferences.add(referenceId);
                        this.setUriRecursive(b3, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                        assert (b3.getUri() != null);
                        LOG.debug("Changed sub URI of " + referenceId + " to " + b3.getUri().toASCIIString());
                    }
                    LOG.debug("Successfully changed sub URI of List of " + referenceId);
                    continue;
                }
                assert (builderAccessors.hasDirectAccessors(referenceId));
                if (l == null) {
                    LOG.debug("Skipping: get" + referenceId + " returned null");
                    continue;
                }
                if (l.isEmpty()) {
                    LOG.debug("Skipping: get" + referenceId + " returned empty List");
                    continue;
                }
                ArrayList<JsonLdObject> newList = new ArrayList<JsonLdObject>();
                for (PrimaryIdObject o3 : l) {
                    LOG.debug("Changing sub URI of a " + referenceId);
                    JsonLdObjectWithUriBuilder<PrimaryIdObject> copyBuilder = JsonLdObjectsMetaData.createBuilderWithUriCopy(o3);
                    assert (copyBuilder != null);
                    newNoRecurseReferences.add(referenceId);
                    this.setUriRecursive(copyBuilder, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                    assert (copyBuilder.getUri() != null);
                    LOG.debug("Changed sub URI of " + referenceId + " to " + copyBuilder.getUri().toASCIIString());
                    newList.add(copyBuilder.create());
                }
                builderAccessors.setCollection(referenceId, newList);
                LOG.debug("Successfully changed sub URI of List of " + referenceId);
            }
            if (!isList || !builderAccessors.hasAnyAccessorCallback(referenceId)) continue;
            LOG.debug("Changing sub URIs of List of " + referenceId + " using accessor callback");
            if (builderAccessors.hasBuilderAccessorCallback(referenceId)) {
                modifier = b -> {
                    assert (b.getId() != null) : "No ID for " + referenceId + " in sub list of " + builderClass.getSimpleName() + ". Full builder: " + builder.create().toString();
                    newNoRecurseReferences.add(referenceId);
                    this.setUriRecursive(b, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                    assert (b.getUri() != null);
                    LOG.debug("Changed sub URI of " + referenceId + " to " + b.getUri().toASCIIString());
                    return b;
                };
                builderAccessors.modifyUsingBuilderAccessorCallback(referenceId, modifier);
                LOG.debug("Successfully changed sub URI of List of " + referenceId + " using builder accessor callback");
                continue;
            }
            assert (builderAccessors.hasDirectAccessorCallback(referenceId));
            modifier = o -> {
                JsonLdObjectWithUriBuilder<JsonLdObjectWithUri> copyBuilder = JsonLdObjectsMetaData.createBuilderWithUriCopy(o);
                assert (copyBuilder != null);
                newNoRecurseReferences.add(referenceId);
                this.setUriRecursive(copyBuilder, Collections.unmodifiableSet(newNoRecurseReferences), setSearchRecursive, setSearchRecursive);
                assert (copyBuilder.getUri() != null);
                LOG.debug("Changed sub URI of " + referenceId + " to " + copyBuilder.getUri().toASCIIString());
                return copyBuilder.create();
            };
            builderAccessors.modifyUsingAccessorCallback(referenceId, modifier);
            LOG.debug("Successfully changed sub URI of List of " + referenceId + " using direct accessor callback");
        }
        return builder;
    }

    private static final void initResourceJsonMappingHelper(Class jsonClass, Class resourceClass) {
        jsonToResource.put(jsonClass, resourceClass);
        resourceToJson.put(resourceClass, jsonClass);
    }

    public static Class jsonClassToResourceClass(Class jsonClass) {
        Class res = jsonToResource.get(jsonClass);
        if (res == null) {
            throw new RuntimeException("No Resource class known for " + jsonClass.getName());
        }
        return res;
    }

    public static Class resourceClassToJsonClass(Class resourceClass) {
        Class res = resourceToJson.get(resourceClass);
        if (res == null) {
            throw new RuntimeException("No Json class known for Resource " + resourceClass.getName());
        }
        return res;
    }

    public static interface DerivedUriGenerator {
        public void addDerivedUri(JsonLdObjectBuilder var1, UriTool var2);

        public void addForeignUri(JsonLdObjectBuilder var1, UriTool var2);
    }
}

