/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.rrd.replay;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.rrd.base.PropertiesRrdConfig;
import be.iminds.ilabt.jfed.fedmon.rrd.base.RrdManager;
import be.iminds.ilabt.jfed.fedmon.rrd.base.TestInstanceRrd;
import be.iminds.ilabt.jfed.fedmon.rrd.replay.DbInfo;
import be.iminds.ilabt.jfed.fedmon.rrd.replay.ReplayTask;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClientPropertiesConfig;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Frequency;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestDefinition;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.MemoryApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.authority.JFedTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import java.io.FileInputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.embed.swing.JFXPanel;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RrdReplayCli {
    private static final Logger LOG = LoggerFactory.getLogger(RrdReplayCli.class);
    private final FedmonWebApiClient fedmonWebApiClient;
    private final Properties configProperties;
    private static boolean javaFXInitialized = false;

    public static void initJavaFX() {
        if (javaFXInitialized) {
            return;
        }
        try {
            long timeMillis = System.currentTimeMillis();
            new JFXPanel();
            System.out.println("JavaFX was initialised in " + (System.currentTimeMillis() - timeMillis) + "ms");
            javaFXInitialized = true;
        }
        catch (Throwable t) {
            javaFXInitialized = true;
            LOG.warn("Failed to initialize JavaFX (perhaps no X11 server present?). This could be ignored, but might cause very hard to debug problems later on. Will instead stop to prevent this", t);
            throw new RuntimeException("Failed to initialize JavaFX. Stopping to prevent hard to find bugs.");
        }
    }

    public static void main(String[] args) throws IOException {
        try {
            new RrdReplayCli(args);
        }
        catch (Throwable t) {
            t.printStackTrace();
            System.exit(0);
        }
    }

    public static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "monitorService [options ... ]", "Options:", options, "");
        System.exit(0);
    }

    public RrdReplayCli(String[] args) throws IOException {
        LOG.debug("starting ReplayMakerCli");
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"threads");
        OptionBuilder.withDescription((String)"Amount of threads to use. Default is the number of availableProcessors.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number of threads");
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"max-runs");
        OptionBuilder.withDescription((String)"Limit the maximum number of tests that can be run. (if specified, must be > 0)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"maximum number of tests");
        options.addOption(OptionBuilder.create((String)"m"));
        OptionBuilder.withLongOpt((String)"db-user");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"database username");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"u"));
        OptionBuilder.withLongOpt((String)"db-pass");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"database user password");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"p"));
        OptionBuilder.withLongOpt((String)"test-instance-id");
        OptionBuilder.withDescription((String)"Limit graph generation by instance id(s). Multiple values should be separated by ',' e.g. 17,31.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"testinstanceid");
        options.addOption(OptionBuilder.create((String)"tid"));
        OptionBuilder.withLongOpt((String)"help");
        OptionBuilder.withDescription((String)"print help message");
        options.addOption(OptionBuilder.create((String)"h"));
        OptionBuilder.withLongOpt((String)"debug");
        OptionBuilder.withDescription((String)"print some debug info");
        options.addOption(OptionBuilder.create((String)"d"));
        OptionBuilder.withLongOpt((String)"replay-for-disabled");
        OptionBuilder.withDescription((String)"Replay RRD for rrd_disabled test instances. Default: Don't run if RRD is disabled for the test instance");
        options.addOption(OptionBuilder.create((String)"rfd"));
        OptionBuilder.withLongOpt((String)"enable-afterwards");
        OptionBuilder.withDescription((String)"Set rrd_enabled to true after the RRD replay. Default: leave rrd_enabled as is");
        options.addOption(OptionBuilder.create((String)"ea"));
        OptionBuilder.withLongOpt((String)"replay-disable");
        OptionBuilder.withDescription((String)"Do not replay RRD for rrd_disabled test instances. Default: false");
        options.addOption(OptionBuilder.create((String)"rd"));
        OptionBuilder.withLongOpt((String)"disable-first");
        OptionBuilder.withDescription((String)"Start by setting rrd_disabled to false, to prevent new data corrupting the historical data. Default: false");
        options.addOption(OptionBuilder.create((String)"df"));
        OptionBuilder.withLongOpt((String)"configfile");
        OptionBuilder.withDescription((String)"location of the property file containing the configuration. Default ~/.jFed/config");
        OptionBuilder.hasArg();
        options.addOption(OptionBuilder.create((String)"conf"));
        CommandLine line = null;
        BasicParser parser = new BasicParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            RrdReplayCli.help(options);
            throw new RuntimeException("Error parsing command line parameters: " + ex.getMessage(), ex);
        }
        if (line.hasOption("help")) {
            RrdReplayCli.help(options);
            throw new RuntimeException("Help");
        }
        int threadCount = Integer.parseInt(line.getOptionValue("threads", "" + (Runtime.getRuntime().availableProcessors() * 2 + 1)));
        String maxRunHelper = line.getOptionValue("max-runs", null);
        Integer maxRunCount = maxRunHelper == null ? null : Integer.valueOf(Integer.parseInt(maxRunHelper));
        DbInfo dbInfo = new DbInfo(line.getOptionValue("db-user", null), line.getOptionValue("db-pass", null));
        String testInstanceIdFilter = line.getOptionValue("test-instance-id", "ALL");
        boolean replayForDisabled = line.hasOption("replay-for-disabled");
        boolean enableAfterwards = line.hasOption("enable-afterwards");
        boolean replayDisable = line.hasOption("replay-disable");
        boolean disableFirst = line.hasOption("disable-first");
        String originsServiceConfigFilename = line.getOptionValue("configfile", "~/.jFed/config");
        this.configProperties = new Properties();
        try {
            this.configProperties.load(new FileInputStream(originsServiceConfigFilename));
        }
        catch (Exception e) {
            System.out.println("Config file not found: \"" + originsServiceConfigFilename + "\"");
            System.exit(-2);
        }
        RrdReplayCli.initJavaFX();
        JFedCorePreferences jFedPreferences = new JFedCorePreferences();
        ConnectivityDetector connectivityDetector = new ConnectivityDetector(null);
        connectivityDetector.setNoInternet(false);
        TestbedInfoSource testbedInfoSource = new JFedTestbedInfoSource((JFedPreferences)jFedPreferences, connectivityDetector, new URL("https://flsmonitor-api.fed4fire.eu/"), null).get();
        AuthorityFinder authorityFinder = new AuthorityFinder(testbedInfoSource, (JFedPreferences)jFedPreferences);
        SerializableApiCallDetailsFactory serializableApiCallDetailsFactory = new SerializableApiCallDetailsFactory();
        MemoryApiCallDetailsCache apiCallDetailsCache = new MemoryApiCallDetailsCache(serializableApiCallDetailsFactory);
        CallReportFactory callReportFactory = new CallReportFactory((ApiCallDetailsCache)apiCallDetailsCache);
        CallReportWriter callReportWriter = new CallReportWriter((ApiCallDetailsCache)apiCallDetailsCache);
        JFedTrustStore jFedTrustStore = new JFedTrustStore();
        this.fedmonWebApiClient = new FedmonWebApiCachedClient((FedmonWebApiClientConfig)new FedmonWebApiClientPropertiesConfig(this.configProperties, jFedTrustStore, null, null, null));
        LinkedList<ReplayTask> tasks = new LinkedList<ReplayTask>();
        try {
            ArrayList<Integer> tids = new ArrayList<Integer>();
            if (testInstanceIdFilter != null && !testInstanceIdFilter.trim().isEmpty()) {
                String[] parts = testInstanceIdFilter.split(",");
                for (String p : parts) {
                    tids.add(Integer.parseInt(p));
                }
            }
            RrdManager rrdManager = new RrdManager(new PropertiesRrdConfig(this.configProperties));
            Iterator iterator = tids.iterator();
            while (iterator.hasNext()) {
                TestDefinition td;
                TestInstance ti;
                int tid = (Integer)iterator.next();
                Frequency tiFreq = (ti = (TestInstance)this.fedmonWebApiClient.getById(TestInstance.class, (Object)tid).get()).getFrequencyId() == null ? null : (Frequency)this.fedmonWebApiClient.getById(Frequency.class, (Object)ti.getFrequencyId()).get();
                List<TestInstanceRrd> rrds = rrdManager.get(ti, tiFreq, td = (TestDefinition)this.fedmonWebApiClient.getById(TestDefinition.class, (Object)ti.getTestDefinitionId()).get(), true);
                if (rrds.isEmpty()) {
                    LOG.warn("Had to skip ReplayTask because there are no RRDs. ti.id=" + ti.getId() + " td=" + (String)td.getId());
                    continue;
                }
                ReplayTask replayTask = new ReplayTask(ti, td, rrds, this.fedmonWebApiClient, dbInfo, replayForDisabled, enableAfterwards, replayDisable, disableFirst);
                tasks.add(replayTask);
            }
        }
        catch (Throwable t) {
            LOG.error("Something went wrong getting all ReplayTasks. Will abort.", t);
            System.err.println("Something went wrong getting all ReplayTasks. Will abort. " + t.getMessage());
            System.exit(-1);
            return;
        }
        LOG.debug("jFed rrd-replay run at: " + new Date().getTime() + " Tasks in queue: " + tasks.size());
        if (tasks.isEmpty()) {
            System.out.println("jFed rrd-replay service will not start: No tasks where received.");
            System.exit(0);
        }
        LOG.debug("Creating threadpool with " + threadCount + " threads.");
        ExecutorService threadPool = Executors.newFixedThreadPool(threadCount, ThreadFactoryUtil.getFactory((String)"rrd-replay-pool"));
        int sheduledCount = 0;
        while (!tasks.isEmpty()) {
            ReplayTask replayTask = (ReplayTask)tasks.poll();
            threadPool.submit(replayTask);
            System.out.println("SCHEDULING " + replayTask);
            ++sheduledCount;
        }
        try {
            threadPool.shutdown();
            threadPool.awaitTermination(10L, TimeUnit.HOURS);
        }
        catch (InterruptedException ex) {
            LOG.info("InterruptedException", (Throwable)ex);
        }
        LOG.debug("jFed rrd-replay service has finished");
        System.out.println("jFed rrd-replay service has finished.");
        System.exit(0);
    }
}

