/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.tests.highlevel.config;

import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Provision;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.Cleanup;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.SSHKeys;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.WaitForReadyInTest;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.security.PublicKey;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class ESpecTestConfig
implements ApiTestConfig {
    private static final Logger LOG = LoggerFactory.getLogger(ESpecTestConfig.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    @Nonnull
    private final Proxy amConnectionProxy;
    @Nonnull
    private final String amVersion;
    @Nonnull
    private final SSHKeys sshKeys;
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final ESpec eSpec;
    @Nonnull
    private final Provision provision;
    @Nonnull
    private final WaitForReadyInTest waitForReady;
    @Nonnull
    private final Cleanup cleanup;

    public ESpecTestConfig() {
        this.amConnectionProxy = new Proxy();
        this.amVersion = "auto";
        this.sshKeys = new SSHKeys();
        this.slice = new Slice();
        this.eSpec = new ESpec();
        this.provision = new Provision();
        this.waitForReady = new WaitForReadyInTest();
        this.cleanup = new Cleanup();
    }

    @JsonCreator
    public ESpecTestConfig(@Nullable @JsonProperty(value="amConnectionProxy") Proxy amConnectionProxy, @Nullable @JsonProperty(value="amVersion") String amVersion, @Nullable @JsonProperty(value="sshKeys") SSHKeys sshKeys, @Nullable @JsonProperty(value="slice") Slice slice, @Nullable @JsonProperty(value="eSpec") ESpec eSpec, @Nullable @JsonProperty(value="provision") Provision provision, @Nullable @JsonProperty(value="waitForReady") WaitForReadyInTest waitForReady, @Nullable @JsonProperty(value="cleanup") Cleanup cleanup) {
        this.amConnectionProxy = amConnectionProxy == null ? new ESpecTestConfig().getAmConnectionProxy() : amConnectionProxy;
        this.amVersion = amVersion == null ? new ESpecTestConfig().getAmVersion() : amVersion;
        this.sshKeys = sshKeys == null ? new ESpecTestConfig().getSshKeys() : sshKeys;
        this.slice = slice == null ? new Slice() : slice;
        this.eSpec = eSpec == null ? new ESpec() : eSpec;
        this.provision = provision == null ? new Provision() : provision;
        this.waitForReady = waitForReady == null ? new WaitForReadyInTest() : waitForReady;
        this.cleanup = cleanup == null ? new Cleanup() : cleanup;
    }

    @JsonIgnore
    public boolean isValid() {
        boolean amVersionValid;
        boolean res = this.getAmConnectionProxy().isValid();
        res = res && this.getSshKeys().isValid();
        boolean bl = amVersionValid = this.getAmVersion().equals("2") || this.getAmVersion().equals("3") || this.getAmVersion().equals("auto");
        if (!amVersionValid) {
            throw new IllegalArgumentException("Config Error: Unsupported amVersion: \"" + this.getAmVersion() + "\"");
        }
        res = res && this.getSlice().isValid();
        res = res && this.getESpec().isValid();
        res = res && this.getProvision().isValid();
        res = res && this.getWaitForReady().isValid();
        boolean bl2 = res = res && this.getCleanup().isValid();
        if (!this.getProvision().isEnabled() && !this.getWaitForReady().isEnabled()) {
            throw new IllegalArgumentException("Config Error: if the Provision step is disabled, waitForReady should be disabled too.");
        }
        return res;
    }

    @JsonProperty
    @Nonnull
    public Proxy getAmConnectionProxy() {
        return this.amConnectionProxy;
    }

    @JsonProperty
    @Nonnull
    public String getAmVersion() {
        return this.amVersion;
    }

    @JsonProperty
    @Nonnull
    public SSHKeys getSshKeys() {
        return this.sshKeys;
    }

    @JsonProperty
    @Nonnull
    public Slice getSlice() {
        return this.slice;
    }

    @JsonProperty(value="eSpec")
    @Nonnull
    public ESpec getESpec() {
        return this.eSpec;
    }

    @JsonProperty
    @Nonnull
    public Provision getProvision() {
        return this.provision;
    }

    @JsonProperty
    @Nonnull
    public WaitForReadyInTest getWaitForReady() {
        return this.waitForReady;
    }

    @JsonProperty
    @Nonnull
    public Cleanup getCleanup() {
        return this.cleanup;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ESpecTestConfig)) {
            return false;
        }
        ESpecTestConfig that = (ESpecTestConfig)o;
        if (!this.amConnectionProxy.equals((Object)that.amConnectionProxy)) {
            return false;
        }
        if (!this.amVersion.equals(that.amVersion)) {
            return false;
        }
        if (!this.sshKeys.equals(that.sshKeys)) {
            return false;
        }
        if (!this.slice.equals((Object)that.slice)) {
            return false;
        }
        if (!this.eSpec.equals((Object)that.eSpec)) {
            return false;
        }
        if (!this.provision.equals((Object)that.provision)) {
            return false;
        }
        if (!this.waitForReady.equals((Object)that.waitForReady)) {
            return false;
        }
        return this.cleanup.equals(that.cleanup);
    }

    public int hashCode() {
        int result = this.amConnectionProxy.hashCode();
        result = 31 * result + this.amVersion.hashCode();
        result = 31 * result + this.sshKeys.hashCode();
        result = 31 * result + this.slice.hashCode();
        result = 31 * result + this.eSpec.hashCode();
        result = 31 * result + this.provision.hashCode();
        result = 31 * result + this.waitForReady.hashCode();
        result = 31 * result + this.cleanup.hashCode();
        return result;
    }

    @Nonnull
    @JsonIgnore
    public String stringValue() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to covert " + this.getClass().getName() + " to String", e);
        }
    }

    public String toString() {
        return this.stringValue();
    }

    public NodeLoginTestStepConfig generateNodeLoginTestStepConfig(@Nonnull GeniUserProvider geniUserProvider) {
        PublicKey publicKey;
        NodeLoginTestStepConfig.SSHKeySource sshKeySource;
        return new NodeLoginTestStepConfig(sshKeySource, publicKey, switch (this.getSshKeys().getSource()) {
            case SSHKeys.SSHKeySource.RANDOM -> {
                sshKeySource = NodeLoginTestStepConfig.SSHKeySource.RANDOM;
                publicKey = null;
                yield null;
            }
            case SSHKeys.SSHKeySource.TEST_USER -> {
                sshKeySource = NodeLoginTestStepConfig.SSHKeySource.PROVIDED;
                if (!$assertionsDisabled && !geniUserProvider.isUserLoggedIn()) {
                    throw new AssertionError();
                }
                GeniUser user = geniUserProvider.getLoggedInGeniUser();
                if (!$assertionsDisabled && user == null) {
                    throw new AssertionError();
                }
                publicKey = user.getPublicKey();
                yield user.getPrivateKey();
            }
            default -> throw new IllegalArgumentException("Unsupported ssh keys source: " + this.getSshKeys().getSource());
        }, false, new Proxy(), 120000L, null, null);
    }
}

