/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.testing.tests.highlevel.config;

import be.iminds.ilabt.jfed.experiment.setup.ExperimentSetupConfig;
import be.iminds.ilabt.jfed.experiment.setup.config.ESpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Provision;
import be.iminds.ilabt.jfed.experiment.setup.config.RequestRSpec;
import be.iminds.ilabt.jfed.experiment.setup.config.Slice;
import be.iminds.ilabt.jfed.experiment.setup.config.WaitForReady;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfig;
import be.iminds.ilabt.jfed.testing.base.ApiTestConfigProperty;
import be.iminds.ilabt.jfed.testing.shared.NodeLoginTestStepConfig;
import be.iminds.ilabt.jfed.testing.shared.Proxy;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.Cleanup;
import be.iminds.ilabt.jfed.testing.tests.highlevel.config.SSHKeys;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.jetbrains.annotations.Contract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonIgnoreProperties(value={"@context"})
public class GuiLogicTestConfig
implements ApiTestConfig {
    private static final Logger LOG = LoggerFactory.getLogger(GuiLogicTestConfig.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    @Nonnull
    private final Proxy amConnectionProxy;
    @Nonnull
    private final String amVersion;
    @Nonnull
    private final SSHKeys sshKeys;
    @Nonnull
    private final List<Resource> resources;
    @Nonnull
    private final List<AnsibleTest> ansibleTests;
    @Nonnull
    private final NodeLoginTest nodeLoginTest;

    public GuiLogicTestConfig() {
        this.amConnectionProxy = new Proxy();
        this.amVersion = "auto";
        this.sshKeys = new SSHKeys();
        this.resources = Collections.singletonList(new Resource());
        this.ansibleTests = Collections.singletonList(new AnsibleTest());
        this.nodeLoginTest = new NodeLoginTest();
    }

    public GuiLogicTestConfig(@Nullable Proxy amConnectionProxy, @Nullable String amVersion, @Nullable SSHKeys sshKeys, @Nullable List<Resource> resources, @Nullable List<AnsibleTest> ansibleTests, @Nullable NodeLoginTest nodeLoginTest) {
        this.amConnectionProxy = amConnectionProxy == null ? new GuiLogicTestConfig().getAmConnectionProxy() : amConnectionProxy;
        this.amVersion = amVersion == null ? new GuiLogicTestConfig().getAmVersion() : amVersion;
        this.sshKeys = sshKeys == null ? new GuiLogicTestConfig().getSshKeys() : sshKeys;
        this.resources = resources == null ? new GuiLogicTestConfig().getResources() : resources;
        this.ansibleTests = ansibleTests == null ? new GuiLogicTestConfig().getAnsibleTests() : ansibleTests;
        this.nodeLoginTest = nodeLoginTest == null ? new GuiLogicTestConfig().getNodeLoginTest() : nodeLoginTest;
    }

    public GuiLogicTestConfig(@Nullable Proxy amConnectionProxy, @Nullable String amVersion, @Nullable SSHKeys sshKeys, @Nullable List<Resource> resources, @Nullable AnsibleTest ansibleTest, @Nullable NodeLoginTest nodeLoginTest) {
        this(amConnectionProxy, amVersion, sshKeys, resources, ansibleTest == null ? new GuiLogicTestConfig().getAnsibleTests() : Collections.singletonList(ansibleTest), nodeLoginTest);
    }

    @JsonCreator
    public static GuiLogicTestConfig createFromJsonObject(@Nonnull Map<String, Object> props) {
        String key;
        Object ansibleTestsObj;
        Proxy proxy = (Proxy)MAPPER.convertValue(props.get("amConnectionProxy"), Proxy.class);
        String amVersion = (String)props.get("amVersion");
        SSHKeys sshKeys = (SSHKeys)MAPPER.convertValue(props.get("sshKeys"), SSHKeys.class);
        List resources = (List)MAPPER.convertValue(props.get("resources"), (TypeReference)new TypeReference<List<Resource>>(){});
        NodeLoginTest nodeLoginTest = (NodeLoginTest)MAPPER.convertValue(props.get("nodeLoginTest"), NodeLoginTest.class);
        List ansibleTests = props.containsKey("ansibleTest") || props.containsKey("ansibleTests") ? ((ansibleTestsObj = props.get(key = props.containsKey("ansibleTests") ? "ansibleTests" : "ansibleTest")) instanceof List ? (List)MAPPER.convertValue(ansibleTestsObj, (TypeReference)new TypeReference<List<AnsibleTest>>(){}) : Collections.singletonList((AnsibleTest)MAPPER.convertValue(ansibleTestsObj, AnsibleTest.class))) : null;
        return new GuiLogicTestConfig(proxy, amVersion, sshKeys, (List<Resource>)resources, ansibleTests, nodeLoginTest);
    }

    @JsonIgnore
    public boolean isValid() {
        boolean amVersionValid;
        boolean res = this.getNodeLoginTest().isValid();
        res = res && this.getAmConnectionProxy().isValid();
        res = res && this.getSshKeys().isValid();
        for (Resource resource : this.getResources()) {
            res = res && resource.isValid();
        }
        for (AnsibleTest at : this.getAnsibleTests()) {
            res = res && at.isValid();
        }
        boolean bl = amVersionValid = this.getAmVersion().equals("2") || this.getAmVersion().equals("3") || this.getAmVersion().equals("auto");
        if (!amVersionValid) {
            throw new IllegalArgumentException("Config Error: Unsupported amVersion: \"" + this.getAmVersion() + "\"");
        }
        return res;
    }

    @JsonProperty
    @Nonnull
    public Proxy getAmConnectionProxy() {
        return this.amConnectionProxy;
    }

    @JsonProperty
    @Nonnull
    public String getAmVersion() {
        return this.amVersion;
    }

    @JsonProperty
    @Nonnull
    public SSHKeys getSshKeys() {
        return this.sshKeys;
    }

    @JsonProperty
    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<Resource> getResources() {
        return this.resources;
    }

    @JsonProperty
    @Nonnull
    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public List<AnsibleTest> getAnsibleTests() {
        return this.ansibleTests;
    }

    @JsonProperty
    @Nonnull
    public NodeLoginTest getNodeLoginTest() {
        return this.nodeLoginTest;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof GuiLogicTestConfig)) {
            return false;
        }
        GuiLogicTestConfig that = (GuiLogicTestConfig)o;
        if (!this.amConnectionProxy.equals((Object)that.amConnectionProxy)) {
            return false;
        }
        if (!this.amVersion.equals(that.amVersion)) {
            return false;
        }
        if (!this.sshKeys.equals(that.sshKeys)) {
            return false;
        }
        if (!this.resources.equals(that.resources)) {
            return false;
        }
        if (!this.ansibleTests.equals(that.ansibleTests)) {
            return false;
        }
        return this.nodeLoginTest.equals(that.nodeLoginTest);
    }

    public int hashCode() {
        int result = this.amConnectionProxy.hashCode();
        result = 31 * result + this.amVersion.hashCode();
        result = 31 * result + this.sshKeys.hashCode();
        result = 31 * result + this.resources.hashCode();
        result = 31 * result + this.ansibleTests.hashCode();
        result = 31 * result + this.nodeLoginTest.hashCode();
        return result;
    }

    @Nonnull
    @JsonIgnore
    public String stringValue() {
        try {
            return MAPPER.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException("Failed to covert " + this.getClass().getName() + " to String", e);
        }
    }

    public String toString() {
        return this.stringValue();
    }

    public NodeLoginTestStepConfig generateNodeLoginTestStepConfig(@Nonnull GeniUserProvider geniUserProvider) {
        PublicKey publicKey;
        NodeLoginTestStepConfig.SSHKeySource sshKeySource;
        return new NodeLoginTestStepConfig(sshKeySource, publicKey, switch (this.getSshKeys().getSource()) {
            case SSHKeys.SSHKeySource.RANDOM -> {
                sshKeySource = NodeLoginTestStepConfig.SSHKeySource.RANDOM;
                publicKey = null;
                yield null;
            }
            case SSHKeys.SSHKeySource.TEST_USER -> {
                sshKeySource = NodeLoginTestStepConfig.SSHKeySource.PROVIDED;
                if (!$assertionsDisabled && !geniUserProvider.isUserLoggedIn()) {
                    throw new AssertionError();
                }
                GeniUser user = geniUserProvider.getLoggedInGeniUser();
                if (!$assertionsDisabled && user == null) {
                    throw new AssertionError();
                }
                publicKey = user.getPublicKey();
                yield user.getPrivateKey();
            }
            default -> throw new IllegalArgumentException("Unsupported ssh keys source: " + this.getSshKeys().getSource());
        }, this.getNodeLoginTest().getUseExternalSsh(), this.getNodeLoginTest().getProxy(), this.getNodeLoginTest().getDeadlineSeconds() * 1000L, this.getNodeLoginTest().getPreferredUser(), this.getNodeLoginTest().getForceIpVersion());
    }

    @Nullable
    @Contract(value="null -> null")
    private static String trimAndToNullIfEmpty(@Nullable String orig) {
        if (orig == null) {
            return null;
        }
        if (orig.trim().isEmpty()) {
            return null;
        }
        return orig.trim();
    }

    @Nullable
    @Contract(value="null -> null")
    private static String toNullIfEmpty(@Nullable String orig) {
        if (orig == null) {
            return null;
        }
        if (orig.trim().isEmpty()) {
            return null;
        }
        return orig.trim();
    }

    @Nullable
    @Contract(value="null,null -> null; _,!null->!null")
    private static String trimAndToDefaultIfEmpty(@Nullable String orig, @Nullable NonNullSupplier<String> defaultString) {
        if (orig == null) {
            return defaultString == null ? null : defaultString.get();
        }
        if (orig.trim().isEmpty()) {
            return defaultString == null ? null : defaultString.get();
        }
        return orig.trim();
    }

    @Nullable
    @Contract(value="null,null -> null; _,!null->!null")
    private static String toDefaultIfEmpty(@Nullable String orig, @Nullable NonNullSupplier<String> defaultString) {
        if (orig == null) {
            return defaultString == null ? null : defaultString.get();
        }
        if (orig.trim().isEmpty()) {
            return defaultString == null ? null : defaultString.get();
        }
        return orig;
    }

    @Nullable
    @Contract(value="null,null -> null")
    private static String toNullableDefaultIfEmpty(@Nullable String orig, @Nullable Supplier<String> defaultString) {
        if (orig == null) {
            return defaultString == null ? null : defaultString.get();
        }
        if (orig.trim().isEmpty()) {
            return defaultString == null ? null : defaultString.get();
        }
        return orig;
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonIgnoreProperties(value={"@context"})
    public static class Resource
    extends ExperimentSetupConfig {
        @Nonnull
        private final Cleanup cleanup;
        private final boolean skipFinalManifestCheck;
        private final boolean requireNodesInManifest;

        public Resource() {
            this.cleanup = new Cleanup();
            this.skipFinalManifestCheck = false;
            this.requireNodesInManifest = true;
        }

        @JsonCreator
        public Resource(@Nullable @JsonProperty(value="slice") Slice slice, @Nullable @JsonProperty(value="requestRSpec") RequestRSpec requestRSpec, @Nullable @JsonProperty(value="eSpec") ESpec eSpec, @Nullable @JsonProperty(value="provision") Provision provision, @Nullable @JsonProperty(value="waitForReady") WaitForReady waitForReady, @Nullable @JsonProperty(value="cleanup") Cleanup cleanup, @Nullable @JsonProperty(value="overrideESpecRSpec") Boolean overrideESpecRSpec, @Nullable @JsonProperty(value="runLinkTest") Boolean runLinkTest, @Nullable @JsonProperty(value="skipFinalManifestCheck") Boolean skipFinalManifestCheck, @Nullable @JsonProperty(value="requireNodesInManifest") Boolean requireNodesInManifest) {
            super(slice, requestRSpec, eSpec, provision, waitForReady, overrideESpecRSpec, runLinkTest);
            this.cleanup = cleanup == null ? new Resource().getCleanup() : cleanup;
            this.skipFinalManifestCheck = skipFinalManifestCheck == null ? new Resource().getSkipFinalManifestCheck() : skipFinalManifestCheck.booleanValue();
            this.requireNodesInManifest = requireNodesInManifest == null ? new Resource().getRequireNodesInManifest() : requireNodesInManifest.booleanValue();
        }

        @JsonIgnore
        public boolean isValid() {
            boolean res = super.isValid();
            res = res && this.getCleanup().isValid();
            return res;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="Skip the detailed manifest test in the \"checkManifest\" step? If skipped, very basic testing of the manifest is still done.")
        public boolean getSkipFinalManifestCheck() {
            return this.skipFinalManifestCheck;
        }

        @JsonProperty
        public boolean getRequireNodesInManifest() {
            return this.requireNodesInManifest;
        }

        @JsonProperty
        @Nullable
        @ApiTestConfigProperty(noEdit=true)
        public RequestRSpec getRequestRSpec() {
            return this.requestRSpec;
        }

        @JsonProperty
        @Nonnull
        public Cleanup getCleanup() {
            return this.cleanup;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Resource)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Resource resource = (Resource)((Object)o);
            return this.skipFinalManifestCheck == resource.skipFinalManifestCheck && this.requireNodesInManifest == resource.requireNodesInManifest && Objects.equals(this.cleanup, resource.cleanup);
        }

        public int hashCode() {
            return Objects.hash(super.hashCode(), this.cleanup, this.skipFinalManifestCheck, this.requireNodesInManifest);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonIgnoreProperties(value={"@context", "playbookExe"})
    public static class AnsibleTest {
        @Nonnull
        private final Boolean enabled;
        @Nonnull
        private final Boolean debug;
        @Nullable
        private final String playbookUrl;
        @Nullable
        private final String playbookFileNameInArchive;
        @Nullable
        private final String playbookContent;
        @Nullable
        private final String failureRegex;
        @Nullable
        private final String warningRegex;
        @Nullable
        private final String successRegex;
        @Nonnull
        private final Proxy proxy;
        @Nonnull
        private final List<ExtractSpec> extract;
        private final int timeoutInSec;

        public AnsibleTest() {
            this.enabled = false;
            this.proxy = new Proxy();
            this.debug = false;
            this.playbookUrl = null;
            this.playbookFileNameInArchive = null;
            this.playbookContent = null;
            this.failureRegex = "(failed=[^0]|unreachable=[^0])";
            this.warningRegex = null;
            this.successRegex = "ok=[^0]";
            this.extract = Collections.emptyList();
            this.timeoutInSec = 1200;
        }

        @JsonCreator
        public AnsibleTest(@Nullable @JsonProperty(value="enabled") Boolean enabled, @Nullable @JsonProperty(value="proxy") Proxy proxy, @Nullable @JsonProperty(value="debug") Boolean debug, @Nullable @JsonProperty(value="playbookUrl") String playbookUrl, @Nullable @JsonProperty(value="playbookFileNameInArchive") String playbookFileNameInArchive, @Nullable @JsonProperty(value="playbookContent") String playbookContent, @Nullable @JsonProperty(value="failureRegex") String failureRegex, @Nullable @JsonProperty(value="warningRegex") String warningRegex, @Nullable @JsonProperty(value="successRegex") String successRegex, @Nullable @JsonProperty(value="extract") List<ExtractSpec> extract, @Nullable @JsonProperty(value="timeoutInSec") Integer timeoutInSec) {
            this.enabled = enabled == null ? new AnsibleTest().isEnabled() : enabled.booleanValue();
            this.proxy = proxy == null ? new AnsibleTest().getProxy() : proxy;
            this.debug = debug == null ? new AnsibleTest().getDebug() : debug.booleanValue();
            this.playbookUrl = GuiLogicTestConfig.trimAndToNullIfEmpty(playbookUrl);
            this.playbookFileNameInArchive = GuiLogicTestConfig.trimAndToNullIfEmpty(playbookFileNameInArchive);
            this.playbookContent = GuiLogicTestConfig.toNullIfEmpty(playbookContent);
            this.failureRegex = GuiLogicTestConfig.toNullableDefaultIfEmpty(failureRegex, () -> new AnsibleTest().getFailureRegex());
            this.warningRegex = GuiLogicTestConfig.toNullableDefaultIfEmpty(warningRegex, () -> new AnsibleTest().getWarningRegex());
            this.successRegex = GuiLogicTestConfig.toNullableDefaultIfEmpty(successRegex, () -> new AnsibleTest().getSuccessRegex());
            this.extract = extract != null ? Collections.unmodifiableList(new ArrayList<ExtractSpec>(extract)) : new AnsibleTest().getExtract();
            this.timeoutInSec = timeoutInSec == null ? 1200 : timeoutInSec;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @JsonIgnore
        public boolean isValid() {
            if (!this.isEnabled()) {
                return true;
            }
            if (this.getPlaybookContent() == null && this.getPlaybookUrl() == null) {
                throw new IllegalArgumentException("Config Error: You need to specify either ansible.playbookContent or ansible.playbookUrl");
            }
            if (this.getPlaybookContent() != null && this.getPlaybookUrl() != null) {
                throw new IllegalArgumentException("Config Error: You need to specify either ansible.playbookContent or ansible.playbookUrl, but not both");
            }
            if (this.getPlaybookContent() != null && this.getPlaybookContent().trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.playbookContent may not be empty when specified");
            }
            if (this.getPlaybookUrl() != null) {
                if (this.getPlaybookUrl().trim().isEmpty()) {
                    throw new IllegalArgumentException("Config Error: ansible.playbookUrl may not be empty when specified");
                }
                if (!this.getPlaybookUrl().trim().startsWith("http://") && !this.getPlaybookUrl().trim().startsWith("https://")) {
                    if (!this.getPlaybookUrl().trim().startsWith("git ") && !this.getPlaybookUrl().trim().startsWith("github ")) throw new IllegalArgumentException("Config Error: ansible.playbookUrl does not appear to be a URL: \"" + this.getPlaybookUrl() + "\"");
                    if (this.playbookFileNameInArchive == null) {
                        throw new IllegalArgumentException("Config Error: ansible.playbookUrl refers to git (\"" + this.getPlaybookUrl() + "\"), but playbookFileNameInArchive is not set");
                    }
                } else if (AnsibleTest.isProbablyArchiveUrl(this.getPlaybookUrl().trim()) && this.playbookFileNameInArchive == null) {
                    throw new IllegalArgumentException("Config Error: ansible.playbookUrl appear to be an archive(\"" + this.getPlaybookUrl() + "\"), but playbookFileNameInArchive is not set");
                }
            }
            if (this.getPlaybookUrl() == null && this.playbookFileNameInArchive != null) {
                throw new IllegalArgumentException("Config Error: ansible.playbookFileNameInArchive only makes sense if ansible.playbookUrl is used (and points to an archive)");
            }
            if (this.getFailureRegex() != null && this.getFailureRegex().trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.failureRegex may not be empty");
            }
            if (this.getWarningRegex() != null && this.getWarningRegex().trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.warningRegex may not be empty");
            }
            if (this.getSuccessRegex() != null && this.getSuccessRegex().trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.successRegex may not be empty");
            }
            for (ExtractSpec extractSpec : this.getExtract()) {
                boolean extractValid = extractSpec.isValid();
                if (extractValid) continue;
                return false;
            }
            return this.proxy.isValid();
        }

        private static boolean isProbablyArchiveUrl(String url) {
            if (url.endsWith(".zip")) {
                return true;
            }
            if (url.endsWith(".tar")) {
                return true;
            }
            if (url.endsWith(".tar.gz")) {
                return true;
            }
            if (url.endsWith(".tar.bz2")) {
                return true;
            }
            return url.endsWith(".rar");
        }

        @JsonProperty
        @ApiTestConfigProperty(description="Timeout of the test in seconds. <= 0 means to timeout. Default is 20 minutes.")
        public int getTimeoutInSec() {
            return this.timeoutInSec;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="enables the runAnsible() step of the test")
        public boolean isEnabled() {
            return this.enabled;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="(SSH) proxy to use for the ansible tests")
        @Nonnull
        public Proxy getProxy() {
            return this.proxy;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="sets the debug flag when calling ansible")
        public boolean getDebug() {
            return this.debug;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="URL of the PlayBook to execute (either playbookUrl or playbookUrl must be provided, and not both)")
        @Nullable
        public String getPlaybookUrl() {
            return this.playbookUrl;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="Name of the PlayBook inside the archive pointed to by playbookUrl")
        @Nullable
        public String getPlaybookFileNameInArchive() {
            return this.playbookFileNameInArchive;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="Content of the PlayBook to execute (either playbookUrl or playbookUrl must be provided, and not both)")
        @Nullable
        public String getPlaybookContent() {
            return this.playbookContent;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="When this regex matches a line in the ansible output, the test state is considered failed.")
        @Nullable
        public String getFailureRegex() {
            return this.failureRegex;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="When this regex matches a line in the ansible output, the test state is considered warning. (Unless it is failed.)")
        @Nullable
        public String getWarningRegex() {
            return this.warningRegex;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="When this regex matches a line in the ansible output, the test state is considered succes. (Unless it is failed or warning.)")
        @Nullable
        public String getSuccessRegex() {
            return this.successRegex;
        }

        @JsonProperty
        @ApiTestConfigProperty(description="Data to extract from ansible result")
        @Nonnull
        public List<ExtractSpec> getExtract() {
            return this.extract;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof AnsibleTest)) {
                return false;
            }
            AnsibleTest that = (AnsibleTest)o;
            if (!this.enabled.equals(that.enabled)) {
                return false;
            }
            if (!this.debug.equals(that.debug)) {
                return false;
            }
            if (this.playbookUrl != null ? !this.playbookUrl.equals(that.playbookUrl) : that.playbookUrl != null) {
                return false;
            }
            if (this.playbookFileNameInArchive != null ? !this.playbookFileNameInArchive.equals(that.playbookFileNameInArchive) : that.playbookFileNameInArchive != null) {
                return false;
            }
            if (this.playbookContent != null ? !this.playbookContent.equals(that.playbookContent) : that.playbookContent != null) {
                return false;
            }
            if (this.failureRegex != null ? !this.failureRegex.equals(that.failureRegex) : that.failureRegex != null) {
                return false;
            }
            if (this.warningRegex != null ? !this.warningRegex.equals(that.warningRegex) : that.warningRegex != null) {
                return false;
            }
            if (this.successRegex != null ? !this.successRegex.equals(that.successRegex) : that.successRegex != null) {
                return false;
            }
            if (!this.proxy.equals((Object)that.proxy)) {
                return false;
            }
            return this.extract.equals(that.extract);
        }

        public int hashCode() {
            int result = this.enabled.hashCode();
            result = 31 * result + this.debug.hashCode();
            result = 31 * result + (this.playbookUrl != null ? this.playbookUrl.hashCode() : 0);
            result = 31 * result + (this.playbookFileNameInArchive != null ? this.playbookFileNameInArchive.hashCode() : 0);
            result = 31 * result + (this.playbookContent != null ? this.playbookContent.hashCode() : 0);
            result = 31 * result + (this.failureRegex != null ? this.failureRegex.hashCode() : 0);
            result = 31 * result + (this.warningRegex != null ? this.warningRegex.hashCode() : 0);
            result = 31 * result + (this.successRegex != null ? this.successRegex.hashCode() : 0);
            result = 31 * result + this.proxy.hashCode();
            result = 31 * result + this.extract.hashCode();
            return result;
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    @JsonIgnoreProperties(value={"@context"})
    public static class NodeLoginTest {
        private final boolean enabled;
        private final long deadlineSeconds;
        @Nullable
        private final String preferredUser;
        @Nullable
        private final Integer forceIpVersion;
        private final boolean useExternalSsh;
        @Nonnull
        private final Proxy proxy;

        public NodeLoginTest() {
            this.enabled = true;
            this.deadlineSeconds = 1200L;
            this.preferredUser = null;
            this.forceIpVersion = null;
            this.useExternalSsh = false;
            this.proxy = new Proxy();
        }

        @JsonCreator
        public NodeLoginTest(@Nullable @JsonProperty(value="enabled") Boolean enabled, @Nullable @JsonProperty(value="deadlineSeconds") Long deadlineSeconds, @Nullable @JsonProperty(value="preferredUser") String preferredUser, @Nullable @JsonProperty(value="forceIpVersion") Integer forceIpVersion, @Nullable @JsonProperty(value="useExternalSsh") Boolean useExternalSsh, @Nullable @JsonProperty(value="proxy") Proxy proxy) {
            this.enabled = enabled == null ? new NodeLoginTest().isEnabled() : enabled.booleanValue();
            this.deadlineSeconds = deadlineSeconds == null ? new NodeLoginTest().getDeadlineSeconds() : deadlineSeconds.longValue();
            this.preferredUser = preferredUser;
            this.forceIpVersion = forceIpVersion;
            this.useExternalSsh = useExternalSsh == null ? new NodeLoginTest().getUseExternalSsh() : useExternalSsh.booleanValue();
            this.proxy = proxy == null ? new NodeLoginTest().getProxy() : proxy;
        }

        @JsonIgnore
        public boolean isValid() {
            boolean ipVersionValid;
            if (!this.isEnabled()) {
                return true;
            }
            if (this.deadlineSeconds <= 0L) {
                throw new IllegalArgumentException("Config Error: nodelogin.deadlineSeconds <= 0 makes no sense: " + this.deadlineSeconds);
            }
            boolean bl = ipVersionValid = this.getForceIpVersion() == null || this.getForceIpVersion().equals(4) || this.getForceIpVersion().equals(6);
            if (!ipVersionValid) {
                throw new IllegalArgumentException("Config Error: Unsupported forceIpVersion: \"" + this.getForceIpVersion() + "\"");
            }
            return this.proxy.isValid();
        }

        @JsonProperty
        public boolean isEnabled() {
            return this.enabled;
        }

        @JsonProperty
        public long getDeadlineSeconds() {
            return this.deadlineSeconds;
        }

        @JsonProperty
        @Nullable
        public String getPreferredUser() {
            return this.preferredUser;
        }

        @JsonProperty
        @Nullable
        public Integer getForceIpVersion() {
            return this.forceIpVersion;
        }

        @JsonProperty
        public boolean getUseExternalSsh() {
            return this.useExternalSsh;
        }

        @JsonProperty
        @Nonnull
        public Proxy getProxy() {
            return this.proxy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NodeLoginTest)) {
                return false;
            }
            NodeLoginTest that = (NodeLoginTest)o;
            if (this.enabled != that.enabled) {
                return false;
            }
            if (this.deadlineSeconds != that.deadlineSeconds) {
                return false;
            }
            if (this.useExternalSsh != that.useExternalSsh) {
                return false;
            }
            if (this.preferredUser != null ? !this.preferredUser.equals(that.preferredUser) : that.preferredUser != null) {
                return false;
            }
            if (this.forceIpVersion != null ? !this.forceIpVersion.equals(that.forceIpVersion) : that.forceIpVersion != null) {
                return false;
            }
            return this.proxy.equals((Object)that.proxy);
        }

        public int hashCode() {
            int result = this.enabled ? 1 : 0;
            result = 31 * result + (int)(this.deadlineSeconds ^ this.deadlineSeconds >>> 32);
            result = 31 * result + (this.preferredUser != null ? this.preferredUser.hashCode() : 0);
            result = 31 * result + (this.forceIpVersion != null ? this.forceIpVersion.hashCode() : 0);
            result = 31 * result + (this.useExternalSsh ? 1 : 0);
            result = 31 * result + this.proxy.hashCode();
            return result;
        }
    }

    @FunctionalInterface
    public static interface NonNullSupplier<T> {
        @Nonnull
        public T get();
    }

    public static class ExtractSpec {
        @Nonnull
        private final String delim;
        @Nullable
        private final String startDelim;
        @Nullable
        private final String endDelim;
        @Nullable
        private final String regex;
        @Nonnull
        private final ExtractDataType type;
        @Nonnull
        private final String name;
        @Nonnull
        private final ExtractScope scope;

        public ExtractSpec() {
            this.delim = "$$$";
            this.startDelim = null;
            this.endDelim = null;
            this.regex = null;
            this.type = ExtractDataType.TEXT;
            this.name = "data";
            this.scope = ExtractScope.TESTINSTANCE;
        }

        @JsonCreator
        public ExtractSpec(@Nullable @JsonProperty(value="delim") String delim, @Nullable @JsonProperty(value="startDelim") String startDelim, @Nullable @JsonProperty(value="endDelim") String endDelim, @Nullable @JsonProperty(value="regex") String regex, @Nullable @JsonProperty(value="type") ExtractDataType type, @Nullable @JsonProperty(value="name") String name, @Nullable @JsonProperty(value="scope") ExtractScope scope) {
            this.delim = delim != null ? delim : new ExtractSpec().getDelim();
            this.startDelim = startDelim == null || startDelim.trim().isEmpty() ? null : startDelim;
            this.endDelim = endDelim == null || endDelim.trim().isEmpty() ? null : endDelim;
            this.regex = regex == null || regex.trim().isEmpty() ? null : regex;
            this.type = type != null ? type : new ExtractSpec().getType();
            this.name = name != null ? name : new ExtractSpec().getName();
            this.scope = scope != null ? scope : new ExtractSpec().getScope();
        }

        @JsonProperty
        @Nonnull
        public String getDelim() {
            return this.delim;
        }

        @JsonProperty
        @Nullable
        public String getStartDelim() {
            return this.startDelim;
        }

        @JsonProperty
        @Nullable
        public String getEndDelim() {
            return this.endDelim;
        }

        @JsonProperty
        @Nullable
        public String getRegex() {
            return this.regex;
        }

        @JsonIgnore
        @Nonnull
        public String getStartDelimOrFallback() {
            return this.startDelim == null ? this.delim : this.startDelim;
        }

        @JsonIgnore
        @Nonnull
        public String getEndDelimOrFallback() {
            return this.endDelim == null ? this.delim : this.endDelim;
        }

        @JsonProperty
        @Nonnull
        public ExtractDataType getType() {
            return this.type;
        }

        @JsonProperty
        @Nonnull
        public String getName() {
            return this.name;
        }

        @JsonProperty
        @Nonnull
        public ExtractScope getScope() {
            return this.scope;
        }

        @JsonIgnore
        public boolean isValid() {
            if (this.delim.trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.extract.delim may not be empty");
            }
            if (this.name.trim().isEmpty()) {
                throw new IllegalArgumentException("Config Error: ansible.extract.name may not be empty");
            }
            return true;
        }
    }

    public static enum ExtractScope {
        TESTINSTANCE,
        SERVER,
        NODE;

    }

    public static enum ExtractDataType {
        TEXT,
        CSV,
        JSON;

    }
}

