/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.fedmon.origins_stresstest_service;

import be.iminds.ilabt.jfed.call_log_output.SerializableApiCallDetailsFactory;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsService;
import be.iminds.ilabt.jfed.fedmon.origins_service.BasicOriginsServiceConfig;
import be.iminds.ilabt.jfed.fedmon.origins_service.ResultUploader;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunner;
import be.iminds.ilabt.jfed.fedmon.origins_service.testrunners.TestRunnerFactory;
import be.iminds.ilabt.jfed.fedmon.origins_service.util.EmailSender;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiCachedClient;
import be.iminds.ilabt.jfed.fedmon.webapi.client.FedmonWebApiClient;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstance;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.TestInstanceBuilder;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportFactory;
import be.iminds.ilabt.jfed.highlevel.call_log_output.CallReportWriter;
import be.iminds.ilabt.jfed.log_cache.ApiCallDetailsCache;
import be.iminds.ilabt.jfed.log_cache.MemoryApiCallDetailsCache;
import be.iminds.ilabt.jfed.lowlevel.authority.JFedTestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocations;
import be.iminds.ilabt.jfed.testing.shared.AutomatedTestExternalExecutableLocationsImpl;
import be.iminds.ilabt.jfed.util.common.RFC3339Util;
import be.iminds.ilabt.jfed.util.common.ThreadFactoryUtil;
import be.iminds.ilabt.jfed.util.lib.ConnectivityDetector;
import be.iminds.ilabt.util.jsonld.iface.JsonLdObjectWithUri;
import java.lang.management.ManagementFactory;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;
import java.util.LinkedList;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import javafx.embed.swing.JFXPanel;
import javax.annotation.Nonnull;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StressTest
implements BasicOriginsService {
    private static final Logger LOG = LoggerFactory.getLogger(StressTest.class);
    private Properties configProperties;
    private FedmonWebApiClient webAccess;
    private ExecutorService threadPool;
    private FedmonWebApiClient fedmonWebApiClient;
    private ResultUploader resultUploader;
    private BasicOriginsServiceConfig basicOriginsServiceConfig;
    private AutomatedTestExternalExecutableLocations automatedTestExternalExecutableLocations;
    private static boolean javaFXInitialized = false;

    public static void main(String[] args) {
        new StressTest(args);
    }

    public StressTest(String[] args) {
        this.stressTest(args);
    }

    public static void help(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(200, "stressTest [options ... ]", "Options:", options, "");
        System.exit(0);
    }

    public void stressTest(String[] args) {
        LinkedList<TestRunner> testRunners;
        TestInstance createdTestInstance;
        TestInstance originalTestInstance;
        TestbedInfoSource testbedInfoSource;
        Options options = new Options();
        OptionBuilder.withLongOpt((String)"number-of-tests");
        OptionBuilder.withDescription((String)"Amount of tests to run, each test runs on it's own thread");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"number of tests");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"n"));
        OptionBuilder.withLongOpt((String)"wait-time");
        OptionBuilder.withDescription((String)"time in between tests calls in seconds (sub seconds precision allowed)");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"time in between");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"t"));
        OptionBuilder.withLongOpt((String)"testinstance-id");
        OptionBuilder.withDescription((String)"test to run multiple times");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"test for multiple runs");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"tid"));
        OptionBuilder.withLongOpt((String)"configfile");
        OptionBuilder.withDescription((String)"location of the proprerty file containing the configuration.");
        OptionBuilder.hasArg();
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"conf"));
        OptionBuilder.withLongOpt((String)"pem");
        OptionBuilder.withDescription((String)"If specified, the provided user will be used for setting up user authenticated SSL connections.");
        OptionBuilder.hasArg();
        OptionBuilder.withArgName((String)"PEM file containing user certificate and (unencrypted) private key");
        OptionBuilder.isRequired();
        options.addOption(OptionBuilder.create((String)"p"));
        CommandLine line = null;
        BasicParser parser = new BasicParser();
        try {
            line = parser.parse(options, args);
        }
        catch (ParseException ex) {
            StressTest.help(options);
            return;
        }
        StressTest.initJavaFX();
        final Thread mainThread = Thread.currentThread();
        Thread shutdownHook = new Thread(){

            @Override
            public void run() {
                mainThread.interrupt();
                System.err.println("Shutdown hook ran. Probably due to SIGINT. In any case, we will exit ASAP!");
                System.err.flush();
            }
        };
        Runtime.getRuntime().addShutdownHook(shutdownHook);
        this.basicOriginsServiceConfig = new BasicOriginsServiceConfig(line);
        assert (this.basicOriginsServiceConfig.getWebApiClientConfig().getUserPrivateKey() != null);
        int testCount = Integer.parseInt(line.getOptionValue("number-of-tests"));
        double waitTime = Double.parseDouble(line.getOptionValue("wait-time"));
        Integer originalTestInstanceId = Integer.parseInt(line.getOptionValue("testinstance-id"));
        JFedCorePreferences jFedPreferences = new JFedCorePreferences();
        ConnectivityDetector connectivityDetector = new ConnectivityDetector(null);
        connectivityDetector.forceNoInternet(false);
        try {
            testbedInfoSource = new JFedTestbedInfoSource((JFedPreferences)jFedPreferences, connectivityDetector, new URL("https://flsmonitor-api.fed4fire.eu/"), null).get();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException("Hardcoded URL is malformed -> this is a bug", e);
        }
        AuthorityFinder authorityFinder = new AuthorityFinder(testbedInfoSource, (JFedPreferences)jFedPreferences);
        SerializableApiCallDetailsFactory serializableApiCallDetailsFactory = new SerializableApiCallDetailsFactory();
        MemoryApiCallDetailsCache apiCallDetailsCache = new MemoryApiCallDetailsCache(serializableApiCallDetailsFactory);
        CallReportFactory callReportFactory = new CallReportFactory((ApiCallDetailsCache)apiCallDetailsCache);
        CallReportWriter callReportWriter = new CallReportWriter((ApiCallDetailsCache)apiCallDetailsCache);
        this.fedmonWebApiClient = new FedmonWebApiCachedClient(this.basicOriginsServiceConfig.getWebApiClientConfig());
        this.resultUploader = new ResultUploader(this);
        this.automatedTestExternalExecutableLocations = new AutomatedTestExternalExecutableLocationsImpl((AutomatedTestExternalExecutableLocationsImpl.PropConfig)this.basicOriginsServiceConfig);
        try {
            this.automatedTestExternalExecutableLocations.requireExe("ansible-playbook");
            this.automatedTestExternalExecutableLocations.requireExe("fping");
        }
        catch (AutomatedTestExternalExecutableLocations.ExecutableNotFoundException e) {
            throw new RuntimeException("Exe not found", e);
        }
        try {
            Optional originalTestInstanceOpt = this.fedmonWebApiClient.getById(TestInstance.class, (Object)originalTestInstanceId);
            originalTestInstance = (TestInstance)originalTestInstanceOpt.orElseThrow(() -> new RuntimeException("TestInstance with ID " + originalTestInstanceId + " was not found"));
            assert (originalTestInstance != null);
        }
        catch (Exception e) {
            LOG.error("Something went wrong getting original TestInstance with ID " + originalTestInstanceId + ". Will abort.", (Throwable)e);
            System.err.println("Something went wrong getting original TestInstance with ID " + originalTestInstanceId + ". Will abort." + e.getMessage());
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(-1);
            return;
        }
        TestInstanceBuilder newNodeTestInstance = new TestInstanceBuilder(originalTestInstance);
        String dateString = RFC3339Util.dateToRFC3339String((Date)new Date());
        newNodeTestInstance.setName("stress-" + testCount + "-" + dateString + "-" + originalTestInstance.getName());
        newNodeTestInstance.setEnabled(Boolean.valueOf(true));
        newNodeTestInstance.setId(null);
        newNodeTestInstance.setTestVersion("stresstest");
        try {
            createdTestInstance = (TestInstance)this.fedmonWebApiClient.create((JsonLdObjectWithUri)newNodeTestInstance.create());
            assert (createdTestInstance != null);
            assert (createdTestInstance.getId() != null);
            if (createdTestInstance.getId() == null) {
                throw new RuntimeException("Create TestInstance has no ID! " + createdTestInstance);
            }
            if (createdTestInstance.getId() == originalTestInstanceId) {
                throw new RuntimeException("Create TestInstance has identical ID! " + createdTestInstance);
            }
            System.out.println("========> Created TestInstance for this stresstest run: " + createdTestInstance.getId());
            System.out.println("========= see https://flsmonitor.fed4fire.eu/testresults.html?testinstanceid=" + createdTestInstance.getId());
        }
        catch (Exception e) {
            LOG.error("Failed to create new TestInstance. Will abort.", (Throwable)e);
            System.err.println("Failed to create new TestInstance. Will abort." + e.getMessage());
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(-1);
            return;
        }
        String runInfo = "stress-" + ManagementFactory.getRuntimeMXBean().getName();
        TestRunnerFactory testRunnerFactory = new TestRunnerFactory(testbedInfoSource, authorityFinder, callReportFactory, callReportWriter, this, this.automatedTestExternalExecutableLocations);
        try {
            testRunners = new LinkedList<TestRunner>(testRunnerFactory.createStressTestTestRunners(testCount, (Integer)createdTestInstance.getId(), runInfo));
        }
        catch (Throwable t) {
            LOG.error("Something went wrong getting initial Tasks. Will abort.", t);
            System.err.println("Something went wrong getting initial Tasks. Will abort. " + t.getMessage());
            Runtime.getRuntime().removeShutdownHook(shutdownHook);
            System.exit(-1);
            return;
        }
        assert (testRunners.size() == testCount);
        if (!testRunners.isEmpty()) {
            this.threadPool = Executors.newFixedThreadPool(testRunners.size(), ThreadFactoryUtil.getFactory((String)"stresstest-pool"));
            for (TestRunner testRunner : testRunners) {
                this.threadPool.submit(testRunner);
                try {
                    Thread.sleep((int)(waitTime * 1000.0));
                }
                catch (InterruptedException ex) {
                    LOG.info("InterruptedException", (Throwable)ex);
                }
            }
            try {
                this.threadPool.shutdown();
                this.threadPool.awaitTermination(1L, TimeUnit.DAYS);
            }
            catch (InterruptedException ex) {
                LOG.info("InterruptedException", (Throwable)ex);
            }
            this.resultUploader.waitUntilFinished(300000L);
            System.out.println("Execution complete");
            System.out.println("========> Created TestInstance for this stresstest run: " + createdTestInstance.getId());
            System.out.println("========= see https://flsmonitor.fed4fire.eu/testresults.html?testinstanceid=" + createdTestInstance.getId());
            System.exit(0);
        } else {
            System.out.println("No Tasks received!\n Check your connection and check for typo's and try again");
            StressTest.help(options);
            System.exit(-1);
        }
    }

    @Override
    @Nonnull
    public FedmonWebApiClient getFedmonWebApiClient() {
        return this.fedmonWebApiClient;
    }

    @Override
    @Nonnull
    public BasicOriginsServiceConfig getConfig() {
        return this.basicOriginsServiceConfig;
    }

    @Override
    @Nonnull
    public ResultUploader getResultUploader() {
        return this.resultUploader;
    }

    @Override
    @Nonnull
    public EmailSender getEmailSender() {
        return EmailSender.getNoEmailSender();
    }

    @Override
    @Nonnull
    public AutomatedTestExternalExecutableLocations getAutomatedTestExternalExecutableLocations() {
        return this.automatedTestExternalExecutableLocations;
    }

    public static void initJavaFX() {
        if (javaFXInitialized) {
            return;
        }
        try {
            long timeMillis = System.currentTimeMillis();
            new JFXPanel();
            System.out.println("JavaFX was initialised in " + (System.currentTimeMillis() - timeMillis) + "ms");
            javaFXInitialized = true;
        }
        catch (Throwable t) {
            javaFXInitialized = true;
            LOG.warn("Failed to initialize JavaFX (perhaps no X11 server present?). This could be ignored, but might cause very hard to debug problems later on. Will instead stop to prevent this", t);
            throw new RuntimeException("Failed to initialize JavaFX. Stopping to prevent hard to find bugs.");
        }
    }
}

