/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.impl.AutomaticUserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import be.iminds.ilabt.jfed.lowlevel.credential.SfaCredential;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.util.Date;
import java.util.List;
import java.util.Objects;

public class GetSACredentialTest
implements ConnectivityTest {
    private static final int TIMEOUT = 5000;
    private final String description = "GetCredential @ user authority";
    private final String category = "GetCredential";
    private final GeniUserProvider geniUserProvider;
    private final JFedConnectionProvider jFedConnectionProvider;
    private final JFedPreferences jFedPreferences;
    private final JavaFXLogger logger;
    private final AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory;

    public GetSACredentialTest(GeniUserProvider geniUserProvider, JFedConnectionProvider jFedConnectionProvider, JavaFXLogger logger, JFedPreferences jFedPreferences, AutomaticUserAndSliceApiWrapper.AutomaticUserAndSliceApiWrapperFactory automaticUserAndSliceApiWrapperFactory) {
        this.geniUserProvider = geniUserProvider;
        this.jFedConnectionProvider = jFedConnectionProvider;
        this.logger = logger;
        this.jFedPreferences = jFedPreferences;
        this.automaticUserAndSliceApiWrapperFactory = automaticUserAndSliceApiWrapperFactory;
    }

    @Override
    public String getName() {
        return String.format("[%s] %s", "GetCredential", "GetCredential @ user authority");
    }

    @Override
    public boolean isLoginRequired() {
        return true;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        try {
            GeniUser geniUser = null;
            if (!this.geniUserProvider.isUserLoggedIn()) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "No user logged in. Cannot test.");
            }
            geniUser = this.geniUserProvider.getLoggedInGeniUser();
            if (geniUser == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "No user logged in (logged in user is null). Cannot test");
            }
            if (geniUser.getUserUrn() == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "No user logged in (logged in user URN is null). Cannot test");
            }
            AutomaticUserAndSliceApiWrapper sa = this.automaticUserAndSliceApiWrapperFactory.create();
            List creds = sa.getUserCredentials((Logger)this.logger, geniUser.getUserUrn());
            if (creds == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Did not successfully fetch credential (null reply) for " + geniUser.getUserUrnString());
            }
            if (creds.isEmpty()) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Did not successfully fetch credential (empty list reply) for " + geniUser.getUserUrnString());
            }
            for (AnyCredential cred : creds) {
                SfaCredential sfaCred;
                if (cred.getCredentialXml() == null) {
                    return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "did not successfully fetch credential (xml null) for " + geniUser.getUserUrnString());
                }
                if (cred instanceof SfaCredential && !Objects.equals((sfaCred = (SfaCredential)cred).getOwnerUrn(), geniUser.getUserUrnString())) {
                    return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "credential was recieved, but was for user " + sfaCred.getOwnerUrn() + " instead of for expected user " + geniUser.getUserUrnString());
                }
                Date now = new Date();
                if (cred.getExpiresDate() == null || !cred.getExpiresDate().before(now)) continue;
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "received credential has already expired (" + cred.getExpiresDate() + ") for user" + geniUser.getUserUrnString());
            }
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "GetCredential success for user " + geniUser.getUserUrnString());
        }
        catch (Exception e) {
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Failed to get User Credential. msg:" + e.getMessage(), e);
        }
    }
}

