/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.ApiCallDetails;
import be.iminds.ilabt.jfed.lowlevel.api.AbstractGeniAggregateManager;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager2;
import be.iminds.ilabt.jfed.lowlevel.api.AggregateManager3;
import be.iminds.ilabt.jfed.lowlevel.authority.finder.AuthorityFinder;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SfaConnection;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.SfaConnectionPool;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GetVersionTest
implements ConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(GetVersionTest.class);
    private static final int TIMEOUT = 5000;
    private final URL url;
    private final Server auth;
    private final JFedConnection.ProxyInfo proxyInfo;
    private final String description;
    private final String category = "GetVersion";
    private final int version;
    private final GeniUserProvider geniUserProvider;
    private final JavaFXLogger logger;
    private final JFedConnectionProvider jFedConnectionProvider;
    private final JFedPreferences jFedPreferences;

    public GetVersionTest(Server auth, GeniUserProvider geniUserProvider, JavaFXLogger logger, JFedConnectionProvider jFedConnectionProvider, JFedPreferences jFedPreferences) throws MalformedURLException {
        this(auth, null, 2, geniUserProvider, logger, jFedConnectionProvider, jFedPreferences);
    }

    public GetVersionTest(String authUrn, TestbedInfoSource testbedInfoSource, AuthorityFinder authorityFinder, GeniUserProvider geniUserProvider, JavaFXLogger logger, JFedConnectionProvider jFedConnectionProvider, JFedPreferences jFedPreferences) {
        this(authorityFinder.findByUrn(authUrn, AuthorityFinder.Purpose.CREATE_SLIVER), null, 2, geniUserProvider, logger, jFedConnectionProvider, jFedPreferences);
    }

    public GetVersionTest(Server auth, JFedConnection.ProxyInfo proxyInfo, int version, GeniUserProvider geniUserProvider, JavaFXLogger logger, JFedConnectionProvider jFedConnectionProvider, JFedPreferences jFedPreferences) {
        this.auth = auth;
        StringBuilder description = new StringBuilder("GetVersion ");
        if (proxyInfo != null) {
            description.append("with proxy ");
        }
        description.append("@ ").append(auth.getName());
        this.description = description.toString();
        this.jFedPreferences = jFedPreferences;
        this.proxyInfo = proxyInfo;
        this.version = version;
        this.geniUserProvider = geniUserProvider;
        this.logger = logger;
        this.jFedConnectionProvider = jFedConnectionProvider;
        this.url = ApiInfo.findUrl((Server)auth, (ApiInfo.Api)new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, version));
        if (this.url == null) {
            throw new RuntimeException("No URL for AMv" + version + " at " + auth);
        }
    }

    @Override
    public String getName() {
        if (this.proxyInfo == null) {
            return String.format("[%s] %s (no proxy)", "GetVersion", this.description);
        }
        return String.format("[%s] %s (with proxy)", "GetVersion", this.description);
    }

    @Override
    public boolean isLoginRequired() {
        return true;
    }

    @Override
    public ConnectivityTest.ConnectivityTestResult call() {
        ArrayList callResults = new ArrayList();
        try {
            GeniUser geniUser = null;
            if (!this.geniUserProvider.isUserLoggedIn()) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "no user logged in. Cannot test @ " + this.url);
            }
            geniUser = this.geniUserProvider.getLoggedInGeniUser();
            if (geniUser == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "no user logged in (logged in user is null). Cannot test @ " + this.url);
            }
            if (geniUser.getUserUrn() == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "no user logged in (logged in user URN is null). Cannot test @ " + this.url);
            }
            this.logger.addResultListener(callResults::add);
            Object am = this.version == 2 ? new AggregateManager2((be.iminds.ilabt.jfed.log.Logger)this.logger, this.jFedPreferences) : new AggregateManager3((be.iminds.ilabt.jfed.log.Logger)this.logger, this.jFedPreferences);
            if (!(this.jFedConnectionProvider instanceof SfaConnectionPool)) {
                throw new RuntimeException("guiModel.getConnectionProvider() is not SfaConnectionPool but " + this.jFedConnectionProvider.getClass().getName());
            }
            SfaConnectionPool conPool = (SfaConnectionPool)this.jFedConnectionProvider;
            SfaConnection con = (SfaConnection)conPool.getConnectionByAuthority(geniUser, this.auth, new ApiInfo.Api(ApiInfo.ApiName.GENI_AM, this.version), false, this.proxyInfo);
            LOG.debug("GetVersionTest is creating connection to " + this.url + " for user " + geniUser.getUserUrnString() + " with proxy " + this.proxyInfo + " for AM version " + this.version);
            AbstractGeniAggregateManager.AggregateManagerReply reply = am.getVersion(con);
            if (reply == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "no reply to GetVersion @ " + this.url + " user=" + geniUser.getUserUrn());
            }
            if (reply.getGeniResponseCode() == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "no geni response code replied to GetVersion @ " + this.url + " user=" + geniUser.getUserUrn());
            }
            if (!reply.getGeniResponseCode().isSuccess()) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "reply to GetVersion was not success (" + reply.getGeniResponseCode() + ") @ " + this.url + " user=" + geniUser.getUserUrn());
            }
            if (reply.getValue() == null) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "reply to GetVersion was success, but not version info was received @ " + this.url + " user=" + geniUser.getUserUrn());
            }
            AbstractGeniAggregateManager.AbstractVersionInfo versionInfo = (AbstractGeniAggregateManager.AbstractVersionInfo)reply.getValue();
            if (versionInfo.getApi() != this.version) {
                return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "reply to GetVersion was success, but AM version was not " + this.version + " (was " + versionInfo.getApi() + ") @ " + this.url + " user=" + geniUser.getUserUrn());
            }
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "GetVersion success @ " + this.url + " user=" + geniUser.getUserUrn() + " VersionInfo Received: " + versionInfo);
        }
        catch (Exception e) {
            StringBuilder callDetails = new StringBuilder();
            if (callResults.isEmpty()) {
                callDetails.append("no call details");
            }
            for (ApiCallDetails callResult : callResults) {
                callDetails.append("Call Detail:\n").append(callResult.toString()).append("\n");
            }
            return new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Failed to call GetVersion @ " + this.url + "  msg:" + e.getMessage() + " callDetails: " + callDetails.toString(), e);
        }
    }
}

