/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PingUtils {
    private static final Logger LOG = LoggerFactory.getLogger(PingUtils.class);
    private static String cachedPing6Command = null;

    private static String getUnixPing6Command() throws IOException {
        if (cachedPing6Command != null) {
            return cachedPing6Command;
        }
        try {
            String line;
            Process cmdProc = Runtime.getRuntime().exec("which ping6");
            Object out = "";
            BufferedReader stdoutReader = new BufferedReader(new InputStreamReader(cmdProc.getInputStream()));
            while ((line = stdoutReader.readLine()) != null) {
                out = (String)out + line;
            }
            stdoutReader.close();
            BufferedReader stderrReader = new BufferedReader(new InputStreamReader(cmdProc.getErrorStream()));
            while ((line = stderrReader.readLine()) != null) {
                out = (String)out + line;
            }
            stderrReader.close();
            try {
                cmdProc.waitFor();
            }
            catch (InterruptedException e) {
                LOG.warn("InterruptedException in getLinuxPing6Command", (Throwable)e);
            }
            int retValue = cmdProc.exitValue();
            cachedPing6Command = retValue != 0 ? "ping -6" : "ping6";
        }
        catch (Exception e) {
            LOG.error("Failed to get ping6 command. Will ignore by defaulting to \"ping6\".", (Throwable)e);
            cachedPing6Command = "ping6";
        }
        LOG.debug("getUnixPing6Command() found ping6 command and is returning \"" + cachedPing6Command + "\"");
        return cachedPing6Command;
    }

    public static boolean isReachableByPing(String host) {
        try {
            Object cmd = "";
            cmd = System.getProperty("os.name").startsWith("Windows") ? "ping -n 1 " + host : "ping -c 1 " + host;
            Process myProcess = Runtime.getRuntime().exec((String)cmd);
            myProcess.waitFor();
            return myProcess.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isReachableByPing6(String host) {
        try {
            Object cmd = "";
            cmd = System.getProperty("os.name").startsWith("Windows") ? "ping -6 -n 1 " + host : PingUtils.getUnixPing6Command() + " -c 1 " + host;
            Process myProcess = Runtime.getRuntime().exec((String)cmd);
            myProcess.waitFor();
            return myProcess.exitValue() == 0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

