/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTestFactory;
import be.iminds.ilabt.jfed.connectivity_tester.GetVersionTest;
import be.iminds.ilabt.jfed.connectivity_tester.HostAndPortTest;
import be.iminds.ilabt.jfed.connectivity_tester.SSHLoginTest;
import be.iminds.ilabt.jfed.connectivity_tester.TestsGenerator;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Proxy;
import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.stitching.VlanRange;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProxyTestGenerator
implements TestsGenerator {
    private static final Logger LOG = LoggerFactory.getLogger(ProxyTestGenerator.class);
    private static final String WALL2_URN = "urn:publicid:IDN+wall2.ilabt.iminds.be+authority+cm";
    private final GeniUserProvider geniUserProvider;
    private final TestbedInfoSource testbedInfoSource;
    private final ConnectivityTestFactory connectivityTestFactory;
    private final JFedPreferences jFedPreferences;
    private final ProxyPreferencesManager proxyPreferencesManager;

    @Inject
    public ProxyTestGenerator(GeniUserProvider geniUserProvider, TestbedInfoSource testbedInfoSource, ConnectivityTestFactory connectivityTestFactory, JFedPreferences jFedPreferences, ProxyPreferencesManager proxyPreferencesManager) {
        this.geniUserProvider = geniUserProvider;
        this.testbedInfoSource = testbedInfoSource;
        this.connectivityTestFactory = connectivityTestFactory;
        this.jFedPreferences = jFedPreferences;
        this.proxyPreferencesManager = proxyPreferencesManager;
    }

    public Collection<ConnectivityTest> generateTests() {
        ArrayList<ConnectivityTest> tests = new ArrayList<ConnectivityTest>();
        List authorities = this.testbedInfoSource.getServers();
        for (Server auth : authorities) {
            if (auth.getTestbed() == null || auth.getTestbed().getProxies() == null) continue;
            block1: for (Proxy proxyInfo : auth.getTestbed().getProxies()) {
                VlanRange portRange = new VlanRange(proxyInfo.getPortRange());
                Integer port = portRange.getFirst();
                if (port != null && this.geniUserProvider != null && this.geniUserProvider.isUserLoggedIn() && Objects.equals(this.geniUserProvider.getLoggedInGeniUser().getUserAuthorityServer(), auth)) {
                    JFedConnection.SshProxyInfo conProxyInfo;
                    GeniUser user = this.geniUserProvider.getLoggedInGeniUser();
                    assert (user != null);
                    GeniUserSshKeyInfo userSshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)user);
                    JFedConnection.SshProxyInfo sshProxyInfo = conProxyInfo = user.getUserAuthorityServer() == null ? null : this.proxyPreferencesManager.chooseUserProxy(user.getUserAuthorityServer().getTestbed().getProxies(), user, (SshKeyInfo)userSshKeyInfo);
                    if (conProxyInfo == null) {
                        LOG.warn("Skipping Proxy tests: no proxy found!");
                        return Collections.emptyList();
                    }
                    SSHLoginTest proxyLoginTest = new SSHLoginTest(proxyInfo.getHostname(), port, conProxyInfo.getUsername(), (SshKeyInfo)userSshKeyInfo, null, this.geniUserProvider, this.jFedPreferences, "Proxy");
                    tests.add(proxyLoginTest);
                    URL amUrl = ApiInfo.findUrl((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)3);
                    int version = 3;
                    if (amUrl == null && ApiInfo.findUrl((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)2) != null) {
                        amUrl = ApiInfo.findUrl((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)2);
                        version = 2;
                    }
                    if (amUrl == null && (auth = this.testbedInfoSource.getByUrnExact(WALL2_URN)) != null) {
                        amUrl = ApiInfo.findUrl((Server)auth, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM, (int)3);
                        version = 3;
                    }
                    if (amUrl != null) {
                        GetVersionTest getVersionTest = this.connectivityTestFactory.createGetVersionTest(auth, (JFedConnection.ProxyInfo)conProxyInfo, version);
                        tests.add(getVersionTest);
                    }
                }
                int maxTests = 10;
                for (Integer curPort : portRange) {
                    if (maxTests-- <= 0) continue block1;
                    HostAndPortTest proxyTest = new HostAndPortTest(proxyInfo.getHostname(), curPort, "Proxy " + proxyInfo.getHostname() + ":" + curPort, "Proxy");
                    if (tests.contains(proxyTest)) continue;
                    tests.add(proxyTest);
                }
            }
        }
        return tests;
    }
}

