/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.connectivity_tester;

import be.iminds.ilabt.jfed.connectivity_tester.ConnectivityTest;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ServerTrustInfo;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.util.library.JFedTrustStore;
import be.iminds.ilabt.jfed.util.library.SSLCertificateDownloader;
import be.iminds.ilabt.jfed.util.library.SshProxySocketImplFactory;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketException;
import java.net.URL;
import java.security.cert.X509Certificate;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslHostAndPortTest
implements ConnectivityTest {
    private static final Logger LOG = LoggerFactory.getLogger(SslHostAndPortTest.class);
    private final JFedConnection.ProxyInfo proxyInfo;
    private final String hostname;
    private final int port;
    private final String description;
    private final String category;
    private final TestbedInfoSource testbedInfoSource;
    public static JFedTrustStore allTrustStore = null;

    public SslHostAndPortTest(String hostname, int port, String description, String category, JFedConnection.ProxyInfo proxyInfo, TestbedInfoSource testbedInfoSource) {
        this.hostname = hostname;
        this.port = port;
        this.proxyInfo = proxyInfo;
        this.description = description;
        this.category = category;
        this.testbedInfoSource = testbedInfoSource;
    }

    public SslHostAndPortTest(String hostname, int port, String description, String category, TestbedInfoSource testbedInfoSource) {
        this(hostname, port, description, category, null, testbedInfoSource);
    }

    public SslHostAndPortTest(URL url, String description, String category, JFedConnection.ProxyInfo proxyInfo, TestbedInfoSource testbedInfoSource) {
        this(url.getHost(), url.getPort() != -1 ? url.getPort() : url.getDefaultPort(), description, category, proxyInfo, testbedInfoSource);
    }

    public SslHostAndPortTest(URL url, String description, String category, TestbedInfoSource testbedInfoSource) {
        this(url, description, category, null, testbedInfoSource);
    }

    @Override
    public String getName() {
        return String.format("[%s] %s", this.category, this.description);
    }

    @Override
    public boolean isLoginRequired() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ConnectivityTest.ConnectivityTestResult call() throws Exception {
        if (allTrustStore == null) {
            allTrustStore = new JFedTrustStore(ServerTrustInfo.convert((TestbedInfoSource)this.testbedInfoSource));
        }
        Socket socket = null;
        try {
            SSLContext context = SSLContext.getInstance("TLS");
            TrustManagerFactory tmf = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            tmf.init(allTrustStore.getTrustStore());
            X509TrustManager defaultTrustManager = (X509TrustManager)tmf.getTrustManagers()[0];
            SSLCertificateDownloader.SavingTrustManager tm = new SSLCertificateDownloader.SavingTrustManager(defaultTrustManager);
            context.init(null, new TrustManager[]{tm}, null);
            SSLSocketFactory factory = context.getSocketFactory();
            if (this.proxyInfo != null) {
                Socket underlying = null;
                if (this.proxyInfo instanceof JFedConnection.SshProxyInfo) {
                    SshProxySocketImplFactory sshHSocketImplFactory = SshProxySocketImplFactory.getFactory((JFedConnection.SshProxyInfo)((JFedConnection.SshProxyInfo)this.proxyInfo));
                    underlying = new SSHSocket(sshHSocketImplFactory);
                } else {
                    Proxy proxy = new Proxy(Proxy.Type.SOCKS, new InetSocketAddress(this.proxyInfo.getHostname(), this.proxyInfo.getPort()));
                    underlying = new Socket(proxy);
                }
                underlying.connect(new InetSocketAddress(this.hostname, this.port), 10000);
                socket = (SSLSocket)factory.createSocket(underlying, this.proxyInfo.getHostname(), this.proxyInfo.getPort(), true);
            } else {
                socket = (SSLSocket)factory.createSocket(this.hostname, this.port);
            }
            socket.setSoTimeout(10000);
            SSLException ex = null;
            try {
                ((SSLSocket)socket).startHandshake();
            }
            catch (SSLException e) {
                if (e.getCause() != null && e.getCause() instanceof UnsupportedOperationException) {
                    LOG.trace("SslHostAndPortTest socket.startHandshake() got UnsupportedOperationException as was expected. (=all is fine)", (Throwable)e);
                    ex = null;
                } else {
                    ex = e;
                    LOG.debug("SslHostAndPortTest socket.startHandshake() got unexpected exception: " + e.getMessage(), (Throwable)e);
                }
            }
            finally {
                try {
                    socket.close();
                }
                catch (IOException e) {}
                socket = null;
            }
            X509Certificate[] chain = tm.chain;
            if (chain == null) {
                ConnectivityTest.ConnectivityTestResult connectivityTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Connection succeeded, but failed to fetch SSL certificate chain @ " + this.hostname + ":" + this.port, ex);
                return connectivityTestResult;
            }
            ConnectivityTest.ConnectivityTestResult connectivityTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.SUCCEEDED, "Successfully did SSL handshake with '" + this.hostname + "'", ex);
            return connectivityTestResult;
        }
        catch (Exception e) {
            ConnectivityTest.ConnectivityTestResult connectivityTestResult = new ConnectivityTest.ConnectivityTestResult(ConnectivityTest.Status.FAILED, "Failed to fetch SSL certificate @ " + this.hostname + ":" + this.port + "  msg:" + e.getMessage(), e);
            return connectivityTestResult;
        }
        finally {
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private static class SSHSocket
    extends Socket {
        public SSHSocket(SshProxySocketImplFactory sshProxySocketImplFactory) throws SocketException {
            super(sshProxySocketImplFactory.createSocketImpl());
        }
    }
}

