/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.experiment;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.util.ExecuteOnNotNull;
import be.iminds.ilabt.jfed.highlevel.util.ProxyServiceUtil;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.preferences.ProxyPreferencesManager;
import be.iminds.ilabt.jfed.rspec.model.LoginService;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import com.jcraft.jsch.agentproxy.AgentProxy;
import com.jcraft.jsch.agentproxy.AgentProxyException;
import com.jcraft.jsch.agentproxy.Connector;
import com.jcraft.jsch.agentproxy.ConnectorFactory;
import com.jcraft.jsch.agentproxy.Identity;
import com.jcraft.jsch.agentproxy.sshj.AuthAgent;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javafx.application.Platform;
import javafx.beans.InvalidationListener;
import javafx.beans.Observable;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ReadOnlyListProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableObjectValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import net.schmizz.sshj.userauth.method.AuthMethod;
import net.schmizz.sshj.userauth.method.AuthPublickey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SshConnectionPool {
    private static final Logger LOG = LoggerFactory.getLogger(SshConnectionPool.class);
    private final AgentProxy agentProxy;
    private final ProxySocketFactoryProvider proxySocketFactoryProvider;
    private final ProxyServiceUtil proxyServiceUtil;
    private final ProxyPreferencesManager proxyPreferencesManager;
    private final Map<String, NodeInfo> nodeInfoByUniqueId = new HashMap<String, NodeInfo>();
    private final Experiment experiment;
    private final ObjectProperty<FXModelRspec> modelRspecValue = new SimpleObjectProperty();
    private final ReadOnlyListWrapper<String> nodeIds = new ReadOnlyListWrapper(FXCollections.observableArrayList());
    private final BooleanProperty allConnectable = new SimpleBooleanProperty(false);
    private final BooleanProperty allConnected = new SimpleBooleanProperty(false);
    private final BooleanProperty anyConnectable = new SimpleBooleanProperty(false);
    private final BooleanProperty anyConnected = new SimpleBooleanProperty(false);
    private final GeniUser sshUser;
    private final InvalidationListener updateAllConnectionStateListener = observable -> this.updateAllConnectionState();

    public SshConnectionPool(final Experiment experiment, GeniUser sshUser, ProxySocketFactoryProvider proxySocketFactoryProvider, ProxyPreferencesManager proxyPreferencesManager, ProxyServiceUtil proxyServiceUtil) {
        this.experiment = experiment;
        this.sshUser = sshUser;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
        this.proxyPreferencesManager = proxyPreferencesManager;
        this.proxyServiceUtil = proxyServiceUtil;
        this.modelRspecValue.addListener(observable -> this.updateModel());
        new ExecuteOnNotNull<Slice>(experiment.sliceProperty()){

            @Override
            public void run() {
                SshConnectionPool.this.modelRspecValue.bind((ObservableValue)new ObjectBinding<FXModelRspec>(){
                    {
                        assert (experiment.getSliceOrNull() != null);
                        this.bind(new Observable[]{experiment.getSliceOrNull().manifestRspecProperty()});
                    }

                    protected FXModelRspec computeValue() {
                        assert (experiment.getSliceOrNull() != null);
                        if (experiment.getSliceOrNull().getManifestRspec() != null) {
                            return (FXModelRspec)experiment.getSliceOrNull().getManifestRspec().getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
                        }
                        return null;
                    }
                });
                SshConnectionPool.this.updateModel();
            }
        };
        AgentProxy agentProxy = null;
        try {
            Connector agentConnector = ConnectorFactory.getDefault().createConnector();
            agentProxy = new AgentProxy(agentConnector);
        }
        catch (AgentProxyException e) {
            LOG.error("Could not initialize agent connector");
        }
        this.agentProxy = agentProxy;
    }

    private void updateAllConnectionState() {
        boolean newAllConnectable = true;
        boolean newAllConnected = true;
        boolean newAnyConnectable = false;
        boolean newAnyConnected = false;
        for (NodeInfo nodeInfo : this.nodeInfoByUniqueId.values()) {
            switch ((NodeState)((Object)nodeInfo.state.get())) {
                case NO_INFO: {
                    newAllConnectable = false;
                    newAllConnected = false;
                    break;
                }
                case CONNECTABLE: {
                    newAnyConnectable = true;
                    newAllConnected = false;
                    break;
                }
                case CONNECTING: {
                    newAnyConnectable = true;
                    newAllConnected = false;
                    break;
                }
                case CONNECTED: {
                    newAnyConnectable = true;
                    newAnyConnected = true;
                    break;
                }
                case FAILCONNECT: {
                    newAllConnected = false;
                }
            }
        }
        this.allConnectable.setValue(Boolean.valueOf(newAllConnectable));
        this.allConnected.setValue(Boolean.valueOf(newAllConnected));
        this.anyConnectable.setValue(Boolean.valueOf(newAnyConnectable));
        this.anyConnected.setValue(Boolean.valueOf(newAnyConnected));
    }

    private void updateModel() {
        if (this.modelRspecValue.get() == null) {
            return;
        }
        for (FXRspecNode n : ((FXModelRspec)this.modelRspecValue.get()).getNodes()) {
            String nodeId = n.getUniqueId();
            this.getNodeInfo(nodeId).update(n);
        }
    }

    private void closeAll() {
        this.nodeInfoByUniqueId.values().forEach(NodeInfo::close);
    }

    public ReadOnlyListProperty<String> getNodeIds() {
        return this.nodeIds.getReadOnlyProperty();
    }

    private NodeInfo getNodeInfo(String nodeId) {
        NodeInfo ni = this.nodeInfoByUniqueId.get(nodeId);
        if (ni == null) {
            ni = new NodeInfo(nodeId);
            ni.state.addListener(this.updateAllConnectionStateListener);
            this.nodeInfoByUniqueId.put(nodeId, ni);
            this.nodeIds.get().add((Object)nodeId);
        }
        assert (Objects.equals(ni.nodeId, nodeId));
        return ni;
    }

    public ObservableObjectValue<NodeState> getNodeState(String nodeId) {
        return this.getNodeInfo((String)nodeId).state;
    }

    public ObservableBooleanValue isNodeConnectable(String nodeId) {
        return this.getNodeInfo((String)nodeId).state.isEqualTo((Object)NodeState.NO_INFO).not();
    }

    public ObservableBooleanValue isNodeConnected(String nodeId) {
        return this.getNodeInfo((String)nodeId).state.isEqualTo((Object)NodeState.CONNECTED);
    }

    public ObservableBooleanValue allConnectableProperty() {
        return this.allConnectable;
    }

    public ObservableBooleanValue allConnectedProperty() {
        return this.allConnected;
    }

    public BooleanProperty anyConnectableProperty() {
        return this.anyConnectable;
    }

    public BooleanProperty anyConnectedProperty() {
        return this.anyConnected;
    }

    @Nullable
    public SSHClient getConnection(@Nonnull String nodeId, @Nonnull BlockingMode blockingMode) {
        NodeInfo ni = this.getNodeInfo(nodeId);
        if (ni.connection != null && !ni.connection.isConnected()) {
            ni.close();
        }
        switch (blockingMode) {
            case NON_BLOCKING: {
                switch ((NodeState)((Object)ni.state.get())) {
                    case NO_INFO: 
                    case FAILCONNECT: {
                        return null;
                    }
                    case CONNECTABLE: {
                        ni.startConnect();
                        return null;
                    }
                    case CONNECTING: {
                        return null;
                    }
                    case CONNECTED: {
                        return ni.connection;
                    }
                }
                throw new RuntimeException("unsupported case " + ni.state.get());
            }
            case WAIT_FOR_SINGLE: {
                switch ((NodeState)((Object)ni.state.get())) {
                    case NO_INFO: 
                    case FAILCONNECT: {
                        return null;
                    }
                    case CONNECTABLE: {
                        ni.startConnect();
                        ni.waitForConnect();
                        return ni.connection;
                    }
                    case CONNECTING: {
                        ni.waitForConnect();
                        return ni.connection;
                    }
                    case CONNECTED: {
                        return ni.connection;
                    }
                }
                throw new RuntimeException("unsupported case " + ni.state.get());
            }
            case WAIT_FOR_ALL: {
                throw new RuntimeException("WAIT_FOR_ALL not yet implemented");
            }
        }
        throw new RuntimeException("unsupported blockingMode " + blockingMode);
    }

    public void initAllConnection() {
        for (FXRspecNode node : ((FXModelRspec)this.modelRspecValue.get()).getNodes()) {
            String nodeID = node.getUniqueId();
            NodeInfo nodeInfo = this.getNodeInfo(nodeID);
            NodeState state = (NodeState)((Object)nodeInfo.state.get());
            if (Objects.equals((Object)state, (Object)NodeState.NO_INFO) || Objects.equals((Object)state, (Object)NodeState.CONNECTED)) continue;
            nodeInfo.startConnect();
        }
    }

    @Nullable
    private LoginService chooseLoginService(@Nullable List<LoginService> loginServices) {
        if (loginServices == null || loginServices.isEmpty()) {
            return null;
        }
        LoginService chosenLoginService = loginServices.get(0);
        for (int i = 1; i < loginServices.size(); ++i) {
            LoginService otherLoginService = loginServices.get(i);
            if (!Objects.equals(otherLoginService.getUsername(), this.sshUser.getUserUrn().getEncodedResourceName())) continue;
            chosenLoginService = otherLoginService;
        }
        if (chosenLoginService == null || chosenLoginService.getHostname() == null || chosenLoginService.getIntPort() <= 0) {
            LOG.error(" invalid chosenLoginService skipped: " + chosenLoginService);
            return null;
        }
        return chosenLoginService;
    }

    private static List<AuthMethod> getAuthMethods(AgentProxy agent) throws Exception {
        Identity[] identities = agent.getIdentities();
        ArrayList<AuthMethod> result = new ArrayList<AuthMethod>();
        for (Identity identity : identities) {
            result.add((AuthMethod)new AuthAgent(agent, identity));
        }
        return result;
    }

    private class NodeInfo {
        final String nodeId;
        SSHClient connection;
        Thread connectionCreatorThread;
        final ObjectProperty<NodeState> state = new SimpleObjectProperty((Object)NodeState.NO_INFO);
        private LoginService loginService;
        private JFedConnection.SshProxyInfo proxyService;

        private NodeInfo(String nodeId) {
            this.nodeId = nodeId;
        }

        public void update(FXRspecNode rspecNode) {
            ObservableList loginServices = rspecNode.getLoginServices();
            if (!loginServices.isEmpty()) {
                this.loginService = SshConnectionPool.this.chooseLoginService((List<LoginService>)rspecNode.getLoginServices());
                if (this.loginService != null) {
                    this.proxyService = SshConnectionPool.this.proxyServiceUtil.findTestbedProxy((RspecNode)rspecNode, this.loginService);
                }
            } else {
                this.loginService = null;
                this.proxyService = null;
            }
            if (this.loginService == null) {
                this.close();
                this.state.setValue((Object)NodeState.NO_INFO);
            } else if (Objects.equals(this.state.get(), (Object)NodeState.NO_INFO)) {
                this.state.set((Object)NodeState.CONNECTABLE);
            }
        }

        public void close() {
            if (this.connection != null) {
                try {
                    this.connection.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.connection = null;
            }
            if (this.loginService != null) {
                this.state.set((Object)NodeState.CONNECTABLE);
            } else {
                this.state.setValue((Object)NodeState.NO_INFO);
            }
        }

        public void startConnect() {
            if (this.state.get() == NodeState.NO_INFO) {
                return;
            }
            this.connectionCreatorThread = new Thread(this::blockingConnect, "ConnectionThread#" + this.nodeId);
            this.connectionCreatorThread.start();
        }

        public void waitForConnect() {
            if (this.connectionCreatorThread != null) {
                try {
                    this.connectionCreatorThread.join();
                    this.connectionCreatorThread = null;
                }
                catch (InterruptedException e) {
                    LOG.debug("connectionCreatorThread.join() interrupted", (Throwable)e);
                }
            }
        }

        public SSHClient blockingConnect() {
            int attemptCount = 1;
            boolean success = false;
            this.safeSetState(NodeState.CONNECTING);
            while (attemptCount < 3 && !success) {
                this.connection = new SSHClient();
                this.connection.setTimeout(8000);
                this.connection.setConnectTimeout(10000);
                this.connection.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
                try {
                    GeniUserSshKeyInfo sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)SshConnectionPool.this.sshUser);
                    assert (SshConnectionPool.this.sshUser.getUserAuthorityServerId() != null);
                    LOG.debug("Creating SSH connection to " + this.loginService.getHostname() + ":" + this.loginService.getIntPort());
                    SocketFactory socketFactory = SshConnectionPool.this.proxySocketFactoryProvider.createProxySocketFactoryForSsh(this.proxyService != null ? null : this.loginService.getHostname(), this.proxyService != null ? null : Integer.valueOf(this.loginService.getIntPort()));
                    if (socketFactory != null) {
                        LOG.debug("Using user-authority proxy for  SSH connection");
                    }
                    if (this.proxyService != null) {
                        LOG.info("Wrapping SSH connection into proxy defined by testbed: {}", (Object)this.proxyService);
                        socketFactory = SshConnectionPool.this.proxyPreferencesManager.isDnsOverProxyRequiredForSsh() ? SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)this.proxyService, (SocketFactory)socketFactory, (String)this.loginService.getHostname(), (int)this.loginService.getIntPort()) : SshProxySocketFactory.create((JFedConnection.SshProxyInfo)this.proxyService, (SocketFactory)socketFactory);
                    }
                    if (socketFactory != null) {
                        this.connection.setSocketFactory(socketFactory);
                    }
                    try {
                        this.connection.connect(this.loginService.getHostname(), this.loginService.getIntPort());
                        LOG.debug("Connected to server.");
                    }
                    catch (IOException ex) {
                        LOG.debug("Connection to server seems to have failed (ConnectionInfo is null), will try to continue anyway.");
                    }
                    ArrayList<Object> authMethods = new ArrayList<Object>();
                    if (SshConnectionPool.this.agentProxy != null) {
                        authMethods.addAll(SshConnectionPool.getAuthMethods(SshConnectionPool.this.agentProxy));
                    }
                    KeyPairWrapper keypair = new KeyPairWrapper(sshKeyInfo.getPublicKey(), sshKeyInfo.getPrivateKey());
                    authMethods.add(new AuthPublickey((KeyProvider)keypair));
                    try {
                        this.connection.auth(this.loginService.getUsername(), authMethods);
                    }
                    catch (UserAuthException ex) {
                        LOG.warn("Could not authenticate connection for FXRspecNode: {}, for username {}", new Object[]{this.nodeId, this.loginService.getUsername(), ex});
                        throw ex;
                    }
                    this.connection.getConnection().getKeepAlive().setKeepAliveInterval(30);
                    success = true;
                    this.safeSetState(NodeState.CONNECTED);
                }
                catch (AssertionError ex) {
                    LOG.error("Could not setup a connection to node {} due to AssertionError", (Object)this.nodeId, (Object)ex);
                    this.safeSetState(NodeState.FAILCONNECT);
                }
                catch (Exception ex) {
                    if (++attemptCount < 3 && ex instanceof SocketTimeoutException) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.debug("InterruptedException while waiting for next connect attempt. Will cancel connecting.", (Throwable)e);
                            this.safeSetState(NodeState.FAILCONNECT);
                            return null;
                        }
                        LOG.info("Connection for FXRspecNode " + this.nodeId + " gave a SocketTimeoutException. Retrying once more..");
                        continue;
                    }
                    LOG.error("Could not setup a connection to node {}", (Object)this.nodeId, (Object)ex);
                    this.safeSetState(NodeState.FAILCONNECT);
                }
            }
            return this.connection;
        }

        public void safeSetState(NodeState newState) {
            Platform.runLater(() -> this.state.setValue((Object)newState));
        }
    }

    public static enum NodeState {
        NO_INFO,
        CONNECTABLE,
        CONNECTING,
        CONNECTED,
        FAILCONNECT;

    }

    public static enum BlockingMode {
        NON_BLOCKING,
        WAIT_FOR_SINGLE,
        WAIT_FOR_ALL;

    }
}

