/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.gui_preferences;

import be.iminds.ilabt.jfed.gui_preferences.HLPreferenceKey;
import be.iminds.ilabt.jfed.preferences.JFedCorePreferences;
import be.iminds.ilabt.jfed.ssh_terminal_tool.unix.TerminalFinder;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import be.iminds.ilabt.jfed.util.common.OSDetector;
import be.iminds.ilabt.jfed.util.common.SshVersionFinder;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.jackson.Jackson;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JFedHLPreferences
extends JFedCorePreferences {
    private static final Logger LOG = LoggerFactory.getLogger(JFedHLPreferences.class);
    private static final ObjectMapper MAPPER = Jackson.newObjectMapper();
    private static final String DEFAULT_PUTTY_DIR = "PuTTY";
    private static final String[] DEFAULT_PUTTY_LOCATIONS = new String[]{System.getenv("ProgramFiles") + File.separator + "PuTTY", System.getenv("ProgramFiles(x86)") + File.separator + "PuTTY", "C:\\PuTTY"};
    public static final String DEFAULT_UNIX_SSH_COMMAND = "ssh -A -X -oServerAliveInterval=120 -i '$i' $u@$h -oPort=$p";
    public static final String DEFAULT_UNIX_RDP_COMMAND = "rdesktop -p $P -u $u $h:$p";
    public static final String DEFAULT_WINDOWS_RDP_COMMAND = "mstsc /v:$h:$p";
    public static final String DEFAULT_UNIX_PROXY_SSH_COMMAND_FOR_OLD_OPENSSH = "ssh -A -X -oServerAliveInterval=120 -i '$i' $u@$h -oPort=$p -oProxyCommand=\"ssh -e none -i '$I' -oPort=$P $U@$H nc -w 5 %h %p\"";
    public static final String DEFAULT_UNIX_PROXY_SSH_COMMAND_FOR_NEW_OPENSSH = "ssh -A -X -oServerAliveInterval=120 -i '$i' $u@$h -oPort=$p -oProxyCommand=\"ssh -i '$I' -oPort=$P $U@$H -W %h:%p\"";
    private String autoFindUnixTerminalCommand;

    public JFedHLPreferences() {
        this(true);
    }

    protected JFedHLPreferences(boolean autoSave) {
        this.config.setAutoSave(autoSave);
    }

    protected JFedHLPreferences(PropertiesConfiguration propFile, boolean autoSave) {
        super(null, propFile);
        this.config.setAutoSave(autoSave);
    }

    public JFedHLPreferences makeNoSaveCopy() {
        PropertiesConfiguration config = new PropertiesConfiguration();
        config.copy((Configuration)this.config);
        return new JFedHLPreferences(config, false);
    }

    protected void fillinBlanks(PropertiesConfiguration config) {
        super.fillinBlanks(config);
        if (OSDetector.getUnixLikeOsFilter().includedOs(OSDetector.os)) {
            boolean autoSshCommand;
            if (!config.containsKey(HLPreferenceKey.PREF_COMMAND_RDP.key)) {
                config.setProperty(HLPreferenceKey.PREF_COMMAND_RDP.key, (Object)DEFAULT_UNIX_RDP_COMMAND);
            }
            if (!config.containsKey(HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL.key)) {
                config.setProperty(HLPreferenceKey.PREF_COMMAND_UNIX_TERMINAL.key, (Object)this.findUnixTerminalCommand());
            }
            if ((autoSshCommand = this.getBoolean(HLPreferenceKey.PREF_COMMAND_SSH_AUTO, true)) || !config.containsKey(HLPreferenceKey.PREF_COMMAND_SSH.key)) {
                config.setProperty(HLPreferenceKey.PREF_COMMAND_SSH.key, (Object)DEFAULT_UNIX_SSH_COMMAND);
            }
            if (autoSshCommand || !config.containsKey(HLPreferenceKey.PREF_COMMAND_SSH_PROXY.key) || Objects.equals(config.getProperty(HLPreferenceKey.PREF_COMMAND_SSH_PROXY.key), DEFAULT_UNIX_PROXY_SSH_COMMAND_FOR_OLD_OPENSSH)) {
                boolean newOpenSsh = false;
                Boolean supportsNc = SshVersionFinder.checkIfVersionSupportsNc();
                if (supportsNc == null) {
                    LOG.debug("OpenSSH version could not be determined: unknown if -nc option is supported");
                    newOpenSsh = false;
                } else {
                    newOpenSsh = supportsNc;
                }
                LOG.debug("newOpenSsh=" + newOpenSsh);
                if (newOpenSsh) {
                    config.setProperty(HLPreferenceKey.PREF_COMMAND_SSH_PROXY.key, (Object)DEFAULT_UNIX_PROXY_SSH_COMMAND_FOR_NEW_OPENSSH);
                } else {
                    config.setProperty(HLPreferenceKey.PREF_COMMAND_SSH_PROXY.key, (Object)DEFAULT_UNIX_PROXY_SSH_COMMAND_FOR_OLD_OPENSSH);
                }
            }
        }
        if (OSDetector.findOS() == OSDetector.OS.WIN) {
            if (!config.containsKey(HLPreferenceKey.PREF_COMMAND_RDP.key)) {
                config.setProperty(HLPreferenceKey.PREF_COMMAND_RDP.key, (Object)DEFAULT_WINDOWS_RDP_COMMAND);
            }
            if (!config.containsKey(HLPreferenceKey.PREF_PUTTY_DIRECTORY.key)) {
                String puttyDir = JFedHLPreferences.findPuTTYDirectory();
                boolean enablePageant = true;
                if (puttyDir != null) {
                    config.setProperty(HLPreferenceKey.PREF_PUTTY_DIRECTORY.key, (Object)puttyDir);
                    enablePageant = JFedHLPreferences.pageantExists(new File(puttyDir));
                } else {
                    enablePageant = false;
                }
                if (!config.containsKey(HLPreferenceKey.PREF_SSHAGENT_USE.key)) {
                    config.setProperty(HLPreferenceKey.PREF_SSHAGENT_USE.key, (Object)enablePageant);
                }
            }
        }
        if (!config.containsKey(HLPreferenceKey.PREF_FIRSTRUN_VERSION.key)) {
            config.setProperty(HLPreferenceKey.PREF_FIRSTRUN_VERSION.key, (Object)0);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_SSHAGENT_USE.key)) {
            config.setProperty(HLPreferenceKey.PREF_SSHAGENT_USE.key, (Object)true);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES.key)) {
            config.setProperty(HLPreferenceKey.PREF_TERMINAL_KEEP_TMP_FILES.key, (Object)true);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_TERMINAL_DEBUG.key)) {
            config.setProperty(HLPreferenceKey.PREF_TERMINAL_DEBUG.key, (Object)true);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_EXPIRATION_WARNING_ENABLED.key)) {
            config.setProperty(HLPreferenceKey.PREF_EXPIRATION_WARNING_ENABLED.key, (Object)true);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_EXPIRATION_WARNING_TIME.key)) {
            config.setProperty(HLPreferenceKey.PREF_EXPIRATION_WARNING_TIME.key, (Object)60);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_ENABLED.key)) {
            config.setProperty(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_ENABLED.key, (Object)true);
        }
        if (!config.containsKey(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_TIME.key)) {
            config.setProperty(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_TIME.key, (Object)110);
        }
    }

    public boolean isSshAgentAvailable() {
        if (OSDetector.os == OSDetector.OS.WIN) {
            String puttyDir = this.getString(HLPreferenceKey.PREF_PUTTY_DIRECTORY);
            if (puttyDir == null) {
                return false;
            }
            return new File(puttyDir, "pageant.exe").exists();
        }
        return OSDetector.os != OSDetector.OS.MAC;
    }

    public static boolean isValidPuttyDir(File puttyDir) {
        if (puttyDir == null) {
            return false;
        }
        if (!puttyDir.exists()) {
            return false;
        }
        if (!puttyDir.isDirectory()) {
            return false;
        }
        if (!new File(puttyDir, "putty.exe").exists()) {
            return false;
        }
        return new File(puttyDir, "plink.exe").exists();
    }

    public static String findPuTTYDirectory() {
        for (String location : DEFAULT_PUTTY_LOCATIONS) {
            File file = new File(location);
            if (!JFedHLPreferences.isValidPuttyDir(file)) continue;
            return location;
        }
        return null;
    }

    private static boolean pageantExists(File puttyDir) {
        return new File(puttyDir, "pageant.exe").exists();
    }

    private String findUnixTerminalCommand() {
        if (this.autoFindUnixTerminalCommand == null) {
            if (OSDetector.os == OSDetector.OS.UNIX) {
                this.autoFindUnixTerminalCommand = TerminalFinder.findLinuxTerminalCommand();
            } else if (OSDetector.os == OSDetector.OS.MAC) {
                this.autoFindUnixTerminalCommand = "tell application \"Terminal\" to do script \"%\"";
            }
        }
        if (this.autoFindUnixTerminalCommand != null) {
            LOG.info("Falling back to auto-detected terminal command: " + this.autoFindUnixTerminalCommand);
        }
        return this.autoFindUnixTerminalCommand;
    }

    public boolean isExpirationWarningEnabled() {
        return this.getBoolean(HLPreferenceKey.PREF_EXPIRATION_WARNING_ENABLED, true);
    }

    public void setExpirationWarningEnabled(boolean enabled) {
        this.setBoolean(HLPreferenceKey.PREF_EXPIRATION_WARNING_ENABLED, enabled);
    }

    public int getExpirationWarningTime() {
        return this.getInt(HLPreferenceKey.PREF_EXPIRATION_WARNING_TIME, 60);
    }

    public void setExpirationWarningTime(int value) {
        this.setInt(HLPreferenceKey.PREF_EXPIRATION_WARNING_TIME, value);
    }

    public boolean isRecoverExpirationWarningEnabled() {
        return this.getBoolean(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_ENABLED, true);
    }

    public void setRecoverExpirationWarningEnabled(boolean enabled) {
        this.setBoolean(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_ENABLED, enabled);
    }

    public int getRecoverExpirationWarningTime() {
        return this.getInt(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_TIME, 10);
    }

    public void setRecoverExpirationWarningTime(int value) {
        this.setInt(HLPreferenceKey.PREF_RECOVER_EXPIRATION_WARNING_TIME, value);
    }

    @Nonnull
    private Map<String, Boolean> getExperimentAutoshareMap(@Nonnull GeniUrn projectUrn) {
        String raw = this.getString(HLPreferenceKey.PREF_EXPERIMENT_AUTOSHARE_JSON, "{}");
        try {
            return new HashMap<String, Boolean>((Map)MAPPER.readValue(raw, Map.class));
        }
        catch (IOException e) {
            LOG.warn("Error while reading PREF_EXPERIMENT_AUTOSHARE_JSON for \"" + projectUrn + "\" (str=\"" + raw + "\"", (Throwable)e);
            return new HashMap<String, Boolean>();
        }
    }

    @Nullable
    public Boolean getExperimentAutoshare(@Nonnull GeniUrn projectUrn) {
        Map<String, Boolean> mapping = this.getExperimentAutoshareMap(projectUrn);
        return mapping.get(projectUrn.toString());
    }

    public void setExperimentAutoshare(@Nonnull GeniUrn projectUrn, @Nullable Boolean autoShare) {
        Map<String, Boolean> mapping = this.getExperimentAutoshareMap(projectUrn);
        if (autoShare == null) {
            mapping.remove(projectUrn.toString());
        } else {
            mapping.put(projectUrn.toString(), autoShare);
        }
        try {
            String s = MAPPER.writeValueAsString(mapping);
            LOG.debug("writing PREF_EXPERIMENT_AUTOSHARE_JSON -> \"" + s + "\"");
            this.setString(HLPreferenceKey.PREF_EXPERIMENT_AUTOSHARE_JSON, s);
        }
        catch (JsonProcessingException e) {
            LOG.error("Error while writing PREF_EXPERIMENT_AUTOSHARE_JSON after modifying \"" + projectUrn + "\": " + mapping, (Throwable)e);
        }
    }
}

