/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.controller;

import be.iminds.ilabt.jfed.highlevel.controller.JavaFXTaskThread;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskFinishedCallback;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class Task {
    private static final AtomicLong nextId = new AtomicLong();
    public final List<TaskThread.FutureTask> futureTasks = new ArrayList<TaskThread.FutureTask>();
    @Nonnull
    protected final String name;
    private final List<TaskExecution> currentActiveTaskExecutions = Collections.synchronizedList(new ArrayList());
    private final List<TaskFinishedCallback> callbacks = new ArrayList<TaskFinishedCallback>();
    protected List<Task> depCache = null;
    protected List<Task> alwaysDepCache = null;
    JavaFXTaskThread.Task javafx;
    private final long id = nextId.getAndIncrement();
    private TaskExecution lastCompletedTaskExecution = null;

    public Task(@Nonnull String name) {
        this.name = name;
    }

    protected abstract void doTask(@Nonnull TaskExecution var1) throws JFedException, InterruptedException;

    protected void onCancelledDueToDependencyFailed() {
    }

    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.emptyList();
    }

    @Nonnull
    public List<Task> initAlwaysDependsOn() {
        return Collections.emptyList();
    }

    public boolean newExecutionNeeded() {
        return this.lastCompletedTaskExecution == null || this.lastCompletedTaskExecution.getState() != TaskExecution.TaskState.SUCCESS;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        String res = "Task(\"" + this.getName();
        List<TaskExecution> list = this.currentActiveTaskExecutions;
        synchronized (list) {
            if (this.currentActiveTaskExecutions.size() > 0) {
                res = res + " active={";
            }
            boolean first = true;
            for (TaskExecution st : this.currentActiveTaskExecutions) {
                if (!first) {
                    res = res + ", ";
                }
                res = res + st.getState();
                first = false;
            }
            if (this.currentActiveTaskExecutions.size() > 0) {
                res = res + "}";
            }
        }
        if (this.lastCompletedTaskExecution != null) {
            res = res + " last=" + this.lastCompletedTaskExecution.state;
        }
        res = res + ")";
        return res;
    }

    @Nonnull
    protected List<Task> getDependsOn() {
        if (this.depCache == null) {
            this.depCache = new ArrayList<Task>(this.initDependsOn());
            for (Task t : this.depCache) {
                assert (t != null) : "DependsOn-list of task " + this.getName() + " contains a null value";
            }
        }
        return this.depCache;
    }

    @Nonnull
    protected List<Task> getAlwaysDependsOn() {
        if (this.alwaysDepCache == null) {
            this.alwaysDepCache = new ArrayList<Task>(this.initAlwaysDependsOn());
            for (Task t : this.alwaysDepCache) {
                assert (t != null) : "AlwaysDependsOn-list of task " + this.getName() + " contains a null value";
            }
        }
        return this.alwaysDepCache;
    }

    public synchronized boolean isActive() {
        return !this.currentActiveTaskExecutions.isEmpty();
    }

    public synchronized int getActiveTaskCount() {
        return this.currentActiveTaskExecutions.size();
    }

    synchronized void addActiveTaskExecution(TaskExecution taskExecution) {
        this.currentActiveTaskExecutions.add(taskExecution);
    }

    synchronized boolean removeActiveTaskExecution(TaskExecution taskExecution) {
        return this.currentActiveTaskExecutions.remove(taskExecution);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nonnull
    public synchronized List<TaskExecution> getCurrentActiveTaskExecutionsCopy() {
        List<TaskExecution> list = this.currentActiveTaskExecutions;
        synchronized (list) {
            return new ArrayList<TaskExecution>(this.currentActiveTaskExecutions);
        }
    }

    synchronized void addFuture(TaskThread.FutureTask futureTask) {
        this.futureTasks.add(futureTask);
    }

    synchronized boolean removeFuture(TaskThread.FutureTask futureTask) {
        return this.futureTasks.remove(futureTask);
    }

    @Nonnull
    synchronized List<TaskThread.FutureTask> getFuturesCopy() {
        return new ArrayList<TaskThread.FutureTask>(this.futureTasks);
    }

    public void addCallback(TaskFinishedCallback callback) {
        this.callbacks.add(callback);
    }

    public void removeCallback(TaskFinishedCallback callback) {
        this.callbacks.remove(callback);
    }

    @Nonnull
    public List<TaskFinishedCallback> getCallbacks() {
        return Collections.unmodifiableList(this.callbacks);
    }

    @Nonnull
    public CountDownLatch getCompletionCountDownLatch() {
        CountDownLatch latch = new CountDownLatch(1);
        this.addCallback((task, taskExecution, state) -> latch.countDown());
        return latch;
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public TaskExecution getLastCompletedTaskExecution() {
        return this.lastCompletedTaskExecution;
    }

    void setLastCompletedTaskExecution(@Nonnull TaskExecution lastCompletedTaskExecution) {
        this.lastCompletedTaskExecution = lastCompletedTaskExecution;
    }
}

