/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateImageTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import javax.annotation.Nonnull;

public class CreateDiskImageJob
extends AbstractJob<String> {
    private final FXRspecNode nodeToImage;
    private final String imageName;
    private final boolean global;
    private final boolean updatePrepare;
    private final JobStateFactory jobStateFactory;

    public CreateDiskImageJob(Experiment experiment, FXRspecNode nodeToImage, String imageName, boolean global, boolean updatePrepare, HighLevelTaskFactory hltf, TaskThread tt, JobStateFactory jobStateFactory) {
        super("Create disk image from node " + nodeToImage.getClientId(), experiment, hltf, tt);
        this.nodeToImage = nodeToImage;
        this.imageName = imageName;
        this.global = global;
        this.updatePrepare = updatePrepare;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public String execute() throws Exception {
        CreateImageState cis = new CreateImageState();
        this.setAndRunState(cis);
        if (cis.getStatus() == ExperimentTaskStatus.SUCCESS) {
            ExperimentPart experimentPart = this.experiment.getPart(this.nodeToImage.getSliverId());
            if (experimentPart == null) {
                throw new JFedHighLevelException("Could not find ExperimentPart associated with " + this.nodeToImage.getSliverId());
            }
            if (!(experimentPart instanceof SfaExperimentPart)) {
                throw new JFedHighLevelException("Expected an SfaExperimentPart, but got an " + experimentPart.getClass().getSimpleName());
            }
            this.setAndRunState(this.jobStateFactory.createGetStatusUntilReadyOrFailTaskState(this, LOG, this.experiment.getCheckReadyInterval(), this.experiment.getMaxWaitUntilReady(), (SfaExperimentPart)experimentPart, DesiredStatus.GENI_READY));
        }
        return null;
    }

    public class CreateImageState
    extends SingleCallState<CreateImageTask> {
        protected CreateImageState() {
            super("Create disk image from node " + CreateDiskImageJob.this.nodeToImage.getClientId(), CreateDiskImageJob.this.hltf.createImage(CreateDiskImageJob.this.experiment.getSlice(), CreateDiskImageJob.this.nodeToImage.getSliverId(), CreateDiskImageJob.this.imageName, CreateDiskImageJob.this.global, CreateDiskImageJob.this.updatePrepare));
        }

        @Override
        @Nonnull
        public ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException {
            ExperimentTaskStatus result = super.executeState(job);
            this.updateMessage(((CreateImageTask)this.task).getResultDiskImageUrn().toString());
            return result;
        }
    }
}

