/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.ProxySocketFactoryProvider;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedConnection;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection.SshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.GeniUserSshKeyInfo;
import be.iminds.ilabt.jfed.lowlevel.ssh_key_info.SshKeyInfoFactory;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.rspec.basic_model.BasicStringRspec;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.util.lib.BestNodeLoginFinder;
import be.iminds.ilabt.jfed.util.library.PublicKeyConvertor;
import be.iminds.ilabt.jfed.util.library.SshProxySocketFactory;
import java.io.IOException;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.net.SocketFactory;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.transport.TransportException;
import net.schmizz.sshj.transport.verification.HostKeyVerifier;
import net.schmizz.sshj.transport.verification.PromiscuousVerifier;
import net.schmizz.sshj.userauth.UserAuthException;
import net.schmizz.sshj.userauth.keyprovider.KeyPairWrapper;
import net.schmizz.sshj.userauth.keyprovider.KeyProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class JobWithSshConnectionManager<T>
extends AbstractJob<T> {
    private static final Logger LOG = LoggerFactory.getLogger(JobWithSshConnectionManager.class);
    @Nonnull
    protected final JobStateFactory jobStateFactory;
    @Nonnull
    protected final ProxySocketFactoryProvider proxySocketFactoryProvider;
    @Nonnull
    protected final GeniUserProvider geniUserProvider;
    private KeyPair loginKeyPair;
    private String loginUsername;
    private BestNodeLoginFinder bestNodeLoginFinder;
    private Map<String, SSHClient> sshClientByUniqueNodeId = new ConcurrentHashMap<String, SSHClient>();
    private static final int SETUP_SSH_CONNECTION_RETRIES = 3;

    public JobWithSshConnectionManager(@Nonnull String name, @Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull JobStateFactory jobStateFactory, @Nonnull ProxySocketFactoryProvider proxySocketFactoryProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super(name, experiment, hltf, tt);
        this.jobStateFactory = jobStateFactory;
        this.proxySocketFactoryProvider = proxySocketFactoryProvider;
        this.geniUserProvider = geniUserProvider;
    }

    protected boolean setAndRunSshUsingState(@Nonnull State newState) throws JFedException, InterruptedException {
        boolean sawException = true;
        boolean success = true;
        try {
            super.setAndRunState(newState);
            sawException = false;
        }
        catch (Throwable t) {
            sawException = true;
            success = false;
            throw t;
        }
        finally {
            if (sawException || newState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                success = false;
                LOG.warn("Something went wrong in " + newState.getName() + " (" + newState.getStatus() + ") (ex=" + sawException + ") -> closing all SSH connections");
                this.closeAllSshConnections();
                if (!sawException) {
                    throw new RuntimeException("JobWithSshConnectionManager encountered a failure in: " + newState.getName());
                }
            }
        }
        return success;
    }

    @Nonnull
    public KeyPair getKeyPair() {
        if (this.loginKeyPair == null) {
            assert (this.experiment.getKeypairs() != null);
            this.loginUsername = null;
            KeyPair loginKeyPair = null;
            if (loginKeyPair == null) {
                loginKeyPair = new KeyPair(this.geniUserProvider.getLoggedInGeniUser().getPublicKey(), this.geniUserProvider.getLoggedInGeniUser().getPrivateKey());
                this.loginUsername = this.geniUserProvider.getLoggedInGeniUser().getUserUrn().getEncodedResourceName();
            }
            this.loginKeyPair = loginKeyPair;
        }
        return this.loginKeyPair;
    }

    @Nonnull
    public String getLoginUsername() {
        if (this.loginUsername == null || this.loginKeyPair == null) {
            this.getKeyPair();
            if (this.loginUsername == null) {
                throw new IllegalStateException("Did not find login username");
            }
        }
        return this.loginUsername;
    }

    @Nullable
    public BestNodeLoginFinder getBestNodeLoginFinder() {
        if (this.bestNodeLoginFinder == null) {
            String distributedSshKeysUsername = this.getLoginUsername();
            ManifestRspecSource manifestRspecSource = this.experiment.getSlice().getManifestRspec();
            this.bestNodeLoginFinder = manifestRspecSource == null || manifestRspecSource.getStringRspec() == null ? null : new BestNodeLoginFinder((BasicStringRspec)manifestRspecSource.getStringRspec(), distributedSshKeysUsername, this.geniUserProvider.getLoggedInGeniUser(), new BestNodeLoginFinder.Feedback(){

                public void info(String s) {
                    LOG.info("JobWithSshConnectionManager.BestNodeLoginFinder: " + s);
                }

                public void error(String s) {
                    LOG.error("JobWithSshConnectionManager.BestNodeLoginFinder: " + s);
                }

                public void debug(String s) {
                    LOG.debug("JobWithSshConnectionManager.BestNodeLoginFinder: " + s);
                }
            });
        }
        return this.bestNodeLoginFinder;
    }

    @Nonnull
    public synchronized SSHClient getSSHClient(@Nonnull RspecNode node, @Nullable StateSlice stateSlice) throws JFedException, InterruptedException, SshException {
        SSHClient res = this.sshClientByUniqueNodeId.get(node.getUniqueId());
        if (res != null) {
            if (!res.isConnected()) {
                throw new SshException("Existing SSH connection is not connected (for node " + node.getUniqueId() + ")");
            }
            return res;
        }
        SetupSshConnectionState setupSshConnectionState = new SetupSshConnectionState(node);
        if (stateSlice == null) {
            setupSshConnectionState.executeState(this);
        } else {
            stateSlice.setAndRunState(setupSshConnectionState);
            if (setupSshConnectionState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                throw new SshException("Failed to setup SSH connection (" + setupSshConnectionState.getStatus() + ") to node " + node.getClientId());
            }
        }
        res = setupSshConnectionState.getSsh();
        if (res == null) {
            throw new SshException("Failed to setup SSH connection (sshClient=null) to node " + node.getUniqueId());
        }
        this.sshClientByUniqueNodeId.put(node.getUniqueId(), res);
        if (!res.isConnected()) {
            throw new SshException("SSH connection is not connected with node " + node.getUniqueId());
        }
        return res;
    }

    public synchronized void closeSSH(@Nonnull RspecNode node) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void closeAllSshConnections() {
        LOG.debug("closeAllSshConnections() called");
        Map<String, SSHClient> map = this.sshClientByUniqueNodeId;
        synchronized (map) {
            for (SSHClient ssh : this.sshClientByUniqueNodeId.values()) {
                try {
                    if (ssh == null) continue;
                    ssh.close();
                }
                catch (IOException ignored) {
                    LOG.debug("Will ignore error while closing SSH connection: " + ignored.getMessage());
                }
            }
            this.sshClientByUniqueNodeId.clear();
        }
    }

    @Nonnull
    public SSHClient setupNewSSHClient(@Nonnull RspecNode node) throws SshSetupException {
        BasicStringRspec.LoginService loginService;
        BestNodeLoginFinder loginFinder = this.getBestNodeLoginFinder();
        if (loginFinder == null) {
            LOG.warn("loginFinder is null! Will not be able to setup SSH connection.");
        }
        BasicStringRspec.LoginService loginService2 = loginService = loginFinder == null ? null : loginFinder.findBestLogin(node.getUniqueId());
        if (loginService == null) {
            LOG.warn("Cannot setup connection to {} as no login-service is available", (Object)node.getClientId());
            throw new SshSetupException("Cannot setup connection to " + node.getClientId() + " as no login-service is available");
        }
        SSHClient ssh = new SSHClient();
        ssh.setTimeout(8000);
        ssh.setConnectTimeout(10000);
        ssh.addHostKeyVerifier((HostKeyVerifier)new PromiscuousVerifier());
        try {
            SocketFactory socketFactory;
            if (loginService.getSshProxy() != null) {
                JFedConnection.SshProxyInfo testbedSshProxy = loginService.getSshProxy();
                GeniUserSshKeyInfo sshKeyInfo = SshKeyInfoFactory.createGeniUserSshKeyInfo((GeniUser)this.geniUserProvider.getLoggedInGeniUser());
                testbedSshProxy = new JFedConnection.SshProxyInfo(testbedSshProxy, (SshKeyInfo)sshKeyInfo);
                socketFactory = SshProxySocketFactory.createWithForcedTarget((JFedConnection.SshProxyInfo)testbedSshProxy, (String)loginService.getHostname(), (int)loginService.getPort());
                LOG.debug("Using testbed proxy for SSH access: " + loginService.getSshProxy().toString());
            } else {
                socketFactory = this.proxySocketFactoryProvider.createProxySocketFactoryForSsh(loginService.getHostname(), loginService.getPort());
                if (socketFactory != null) {
                    LOG.debug("Using jFed proxy for SSH access");
                } else {
                    LOG.debug("No proxy needed for SSH access: no testbed proxy found and no jFed proxy requested in config");
                }
            }
            if (socketFactory != null) {
                ssh.setSocketFactory(socketFactory);
            }
        }
        catch (IOException ex) {
            LOG.error("Error while creating ProxySocketFactory. (loginService.getSshProxy()=" + loginService.getSshProxy() + ").Trying without now.", (Throwable)ex);
        }
        int connectTries = 0;
        boolean connected = false;
        IOException lastConnectEx = null;
        while (!connected && connectTries < 3) {
            ++connectTries;
            try {
                ssh.connect(loginService.getHostname(), loginService.getPort());
                connected = true;
            }
            catch (IOException e) {
                lastConnectEx = e;
                String message = "Error while connecting to " + loginService.getHostname() + ": " + e.getMessage();
                if (connectTries < 3) {
                    message = message + ". Retrying ...";
                }
                this.updateMessage(message);
                LOG.error("Error while connecting to {}: {}", new Object[]{loginService.getHostname(), e.getMessage(), e});
            }
        }
        if (!connected) {
            throw new SshSetupException("SSHClient could not connect after " + connectTries + " tries.", lastConnectEx);
        }
        try {
            ssh.authPublickey(loginService.getUsername(), new KeyProvider[]{new KeyPairWrapper(this.loginKeyPair)});
        }
        catch (UserAuthException e) {
            this.updateMessage("Could not authenticate: " + e.getMessage());
            LOG.error("Authentication failed on {}: {}", new Object[]{node.getClientId(), e.getMessage(), e});
            try {
                LOG.error("Authentication failed trying key with pubkey " + PublicKeyConvertor.fromPublicKey((PublicKey)this.loginKeyPair.getPublic()).getOpensshFormString());
            }
            catch (Throwable t) {
                LOG.error("Logging error. Will ignore and continue.", t);
            }
            throw new SshSetupException("Authentication failed on " + node.getClientId(), e);
        }
        catch (TransportException e) {
            this.updateMessage("Error while authenticating: " + e.getMessage());
            LOG.error("Error while authenticating on {}: {}", new Object[]{node.getClientId(), e.getMessage(), e});
            throw new SshSetupException("Error while authenticating on " + node.getClientId(), e);
        }
        ssh.getConnection().getKeepAlive().setKeepAliveInterval(30);
        return ssh;
    }

    public static class SshException
    extends Exception {
        public SshException() {
        }

        public SshException(String s) {
            super(s);
        }

        public SshException(String s, Throwable throwable) {
            super(s, throwable);
        }

        public SshException(Throwable throwable) {
            super(throwable);
        }

        public SshException(String s, Throwable throwable, boolean b, boolean b1) {
            super(s, throwable, b, b1);
        }
    }

    public class SetupSshConnectionState
    extends State {
        @Nonnull
        private final RspecNode node;
        private SSHClient ssh;

        protected SetupSshConnectionState(RspecNode node) {
            super("Setting up SSH Connection to '" + node.getClientId() + "'");
            this.node = node;
        }

        @Override
        @Nonnull
        protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
            try {
                this.ssh = JobWithSshConnectionManager.this.setupNewSSHClient(this.node);
            }
            catch (SshSetupException e) {
                return ExperimentTaskStatus.FAILED;
            }
            return ExperimentTaskStatus.SUCCESS;
        }

        public SSHClient getSsh() {
            return this.ssh;
        }
    }

    public static class SshSetupException
    extends Exception {
        public SshSetupException() {
        }

        public SshSetupException(String message) {
            super(message);
        }

        public SshSetupException(String message, Throwable cause) {
            super(message, cause);
        }

        public SshSetupException(Throwable cause) {
            super(cause);
        }

        public SshSetupException(String message, Throwable cause, boolean enableSuppression, boolean writableStackTrace) {
            super(message, cause, enableSuppression, writableStackTrace);
        }
    }
}

