/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.ExperimentPartsContainer;
import be.iminds.ilabt.jfed.experiment.ExperimentState;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartsSlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.StatusDetails;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StopExperimentJob
extends AbstractJob<Void> {
    private static final Logger LOG = LoggerFactory.getLogger(StopExperimentJob.class);
    private final Collection<ExperimentPart> experimentParts;
    private final ExperimentPartControllerManager epcManager;

    public StopExperimentJob(Experiment experiment, HighLevelTaskFactory hltf, TaskThread tt, ExperimentPartControllerManager epcManager) {
        super("Delete all active resources from experiment '" + experiment.getName() + "'", experiment, hltf, tt);
        this.epcManager = epcManager;
        this.experimentParts = null;
    }

    public StopExperimentJob(Experiment experiment, Collection<ExperimentPart> experimentParts, HighLevelTaskFactory hltf, TaskThread tt, ExperimentPartControllerManager epcManager) {
        super("Delete active resources from '" + experimentParts.stream().map(ExperimentPart::getName).collect(Collectors.joining(", ")) + "'", experiment, hltf, tt);
        this.experimentParts = experimentParts;
        this.epcManager = epcManager;
    }

    @Override
    public Void execute() throws Exception {
        assert (this.experiment.getSliceOrNull() != null);
        if (this.experimentParts == null || this.experimentParts.size() == this.experiment.getPartsSize()) {
            this.experiment.setExperimentState(ExperimentState.DELETING);
        }
        StopExperimentAtExperimentPartsSlicedState stopExperimentAtExperimentPartsState = new StopExperimentAtExperimentPartsSlicedState();
        this.setAndRunState(stopExperimentAtExperimentPartsState);
        HashMap<ExperimentPartsContainer, Boolean> containersInUse = new HashMap<ExperimentPartsContainer, Boolean>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (experimentPart instanceof SfaExperimentPart || experimentPart.getContainer() == null) continue;
            if (experimentPart.getState() != InternalState.DELETED) {
                containersInUse.put(experimentPart.getContainer(), true);
                continue;
            }
            if (containersInUse.containsKey(experimentPart.getContainer())) continue;
            containersInUse.put(experimentPart.getContainer(), false);
        }
        Collection containersToBeRemoved = containersInUse.entrySet().stream().filter(entry -> (Boolean)entry.getValue() == false).map(Map.Entry::getKey).filter(ExperimentPartsContainer::shouldBeDestroyedOnTermination).collect(Collectors.toList());
        if (!containersToBeRemoved.isEmpty()) {
            this.setAndRunState(new StopExperimentPartsContainersState(containersToBeRemoved));
        }
        if (this.experimentParts == null || this.experimentParts.size() == this.experiment.getPartsSize()) {
            if (stopExperimentAtExperimentPartsState.getStatus() == ExperimentTaskStatus.SUCCESS) {
                this.experiment.setExperimentState(ExperimentState.EMPTY);
            } else {
                LOG.warn("Error while stopping experiment: state did not return SUCCESS");
            }
        }
        boolean hasActiveResources = false;
        StatusDetails sliceStatus = this.experiment.getSlice().getStatus();
        if (sliceStatus != null) {
            for (StatusDetails.SliverStatus sliverStatus : sliceStatus.getStatusBySliverUrn().values()) {
                if (sliverStatus != StatusDetails.SliverStatus.READY && sliverStatus != StatusDetails.SliverStatus.NOTREADY && sliverStatus != StatusDetails.SliverStatus.CHANGING) continue;
                hasActiveResources = true;
            }
            for (StatusDetails.SliverStatus sliverStatus : sliceStatus.getStatusByComponentUrn().values()) {
                if (sliverStatus != StatusDetails.SliverStatus.READY && sliverStatus != StatusDetails.SliverStatus.NOTREADY && sliverStatus != StatusDetails.SliverStatus.CHANGING) continue;
                hasActiveResources = true;
            }
        } else {
            LOG.warn("Slice has no known status -> assuming it is not active");
        }
        if (!hasActiveResources) {
            this.experiment.getSlice().setHasActiveSlivers(false);
        }
        return null;
    }

    public class StopExperimentAtExperimentPartsSlicedState
    extends ExperimentPartsSlicedState {
        protected StopExperimentAtExperimentPartsSlicedState() {
            super("Delete all active resources from experiment '" + StopExperimentJob.this.experiment.getName() + "'", StopExperimentJob.this.experiment, StopExperimentJob.this.experimentParts, StopExperimentJob.this.epcManager);
        }

        public ExperimentPartStateSlice createJobSlice(ExperimentPartController controller, ExperimentPart experimentPart) {
            return controller.stop(StopExperimentJob.this, experimentPart);
        }
    }

    public class StopExperimentPartsContainersState
    extends SlicedState<StateSlice> {
        private final Collection<StateSlice> states;

        public StopExperimentPartsContainersState(Collection<ExperimentPartsContainer> containers) {
            super("Destroying " + containers.size() + " experiment container(s)");
            this.states = containers.stream().map(container -> StopExperimentJob.this.epcManager.getContainerController(container).destroyContainer(StopExperimentJob.this, (ExperimentPartsContainer)container)).collect(Collectors.toList());
        }

        @Override
        public Collection<StateSlice> getSlices() {
            return this.states;
        }
    }
}

