/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs;

import be.iminds.ilabt.jfed.espec.model.RspecSpec;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.ExperimentPart;
import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.ExperimentPartControllerManager;
import be.iminds.ilabt.jfed.highlevel.jobs.parts.NonSfaExperimentPartController;
import be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts.UpdateSfaExperimentPartUntilTargetOpStatusSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.model.InternalState;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForOpStatusExperimentJob
extends AbstractJob<Boolean> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(WaitForOpStatusExperimentJob.class);
    private final Logger LOG;
    @Nonnull
    private final JobStateFactory jobStateFactory;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final ExperimentPartControllerManager epcManager;
    private Boolean success = null;
    private Boolean timeout = null;
    @Nonnull
    private final DesiredStatus desiredStatus;

    public WaitForOpStatusExperimentJob(@Nonnull Experiment experiment, @Nonnull HighLevelTaskFactory hltf, @Nonnull TaskThread tt, @Nonnull JobStateFactory jobStateFactory, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull ExperimentPartControllerManager epcManager, @Nonnull DesiredStatus desiredStatus) {
        super("Wait for " + desiredStatus + " for Experiment " + experiment.getName(), experiment, hltf, tt);
        this.jobStateFactory = jobStateFactory;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.epcManager = epcManager;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, this.getJobReport());
        this.desiredStatus = desiredStatus;
    }

    @Override
    public Boolean execute() throws Exception {
        if (!this.hasSfaParts()) {
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "assert failed: experiment.getExperimentSpecification() == null", null);
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, Collections.emptyList());
            }
            return true;
        }
        boolean permanentFailure = false;
        this.LOG.debug("WaitForOpStatusExperimentJob started");
        UpdateSfaPartsUntilTargetOpStatus updateUntilReadyState = new UpdateSfaPartsUntilTargetOpStatus(this.jobStateFactory, this, this.LOG, this.desiredStatus);
        this.setAndRunState(updateUntilReadyState);
        this.timeout = updateUntilReadyState.isTimeout();
        if (this.timeout.booleanValue()) {
            this.LOG.info("WaitForPartsReadyState reported timeout");
        }
        if (updateUntilReadyState.isPermanentFailure()) {
            permanentFailure = true;
            this.LOG.info("WaitForPartsReadyState reported permanent failure");
        }
        if (permanentFailure) {
            if (this.experiment.getExperimentSpecification() != null) {
                this.experiment.getExperimentSpecificationLogger().firePostRSpecFail((RspecSpec)this.experiment.getExperimentSpecification().getRspecs().get(0), "WaitForPartsReadyState reported permanent failure", null);
                this.experiment.getExperimentSpecificationLogger().firePostRspecAll(false, this.getExperimentClientIds());
            }
            this.LOG.debug("WaitForOpStatusExperimentJob stopped in failure");
            this.success = false;
            return false;
        }
        this.LOG.debug("WaitForOpStatusExperimentJob stopped successfully");
        this.success = true;
        return true;
    }

    public Boolean isTimeout() {
        return this.timeout;
    }

    @Nonnull
    private List<String> getExperimentClientIds() {
        FXModelRspec model;
        if (this.experiment.getSliceOrNull() == null || this.experiment.getSliceOrNull().getRequestRspec() == null) {
            return Collections.emptyList();
        }
        RequestRspecSource requestRspecSource = this.experiment.getSliceOrNull().getRequestRspec();
        FXModelRspec fXModelRspec = model = requestRspecSource == null ? null : (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        return model.getNodes().stream().map(RspecNode::getClientId).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public Boolean isSuccess() {
        return this.success;
    }

    private Collection<SfaExperimentPart> getSfaParts() {
        return this.experiment.getPartsStream().filter(part -> part instanceof SfaExperimentPart).map(SfaExperimentPart.class::cast).collect(Collectors.toList());
    }

    private Collection<NonSfaExperimentPartController> getNonSfaExperimentPartControllers() {
        HashSet<NonSfaExperimentPartController> controllers = new HashSet<NonSfaExperimentPartController>();
        for (ExperimentPart experimentPart : this.experiment.getPartsListCopy()) {
            if (experimentPart instanceof SfaExperimentPart) continue;
            ExperimentPartController epc = this.epcManager.getController(experimentPart);
            if (!(epc instanceof NonSfaExperimentPartController)) {
                throw new RuntimeException("Expected a non-sfa ExperimentPartController");
            }
            controllers.add((NonSfaExperimentPartController)epc);
        }
        return controllers;
    }

    private boolean hasNonSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> !(part instanceof SfaExperimentPart));
    }

    private boolean hasSfaParts() {
        return this.experiment.getPartsStream().anyMatch(part -> part instanceof SfaExperimentPart);
    }

    public static class UpdateSfaPartsUntilTargetOpStatus
    extends SlicedState<UpdateSfaExperimentPartUntilTargetOpStatusSlice> {
        private final List<UpdateSfaExperimentPartUntilTargetOpStatusSlice> slices;
        private final Experiment experiment;
        private final JobStateFactory jobStateFactory;
        private final Job job;
        private final DesiredStatus desiredStatus;

        UpdateSfaPartsUntilTargetOpStatus(@Nonnull JobStateFactory jobStateFactory, @Nonnull Job job, @Nonnull Logger LOG, @Nonnull DesiredStatus desiredStatus) {
            super("Waiting for resources to become ready");
            this.jobStateFactory = jobStateFactory;
            this.job = job;
            this.desiredStatus = desiredStatus;
            this.experiment = job.getExperiment();
            this.slices = this.experiment.getPartsStream().filter(part -> part.getState() != InternalState.FAILED).filter(part -> part instanceof SfaExperimentPart).map(part -> new UpdateSfaExperimentPartUntilTargetOpStatusSlice(job, (SfaExperimentPart)part, this.experiment.getCheckReadyInterval(), this.experiment.getMaxWaitUntilReady(), jobStateFactory, desiredStatus)).collect(Collectors.toList());
        }

        public boolean isPermanentFailure() {
            return this.getSlices().stream().anyMatch(updateSlice -> updateSlice.getResult() != ExperimentTaskStatus.SUCCESS);
        }

        public boolean isTimeout() {
            return this.getSlices().stream().anyMatch(UpdateSfaExperimentPartUntilTargetOpStatusSlice::isTimeout);
        }

        @Override
        public Collection<UpdateSfaExperimentPartUntilTargetOpStatusSlice> getSlices() {
            return this.slices;
        }
    }
}

