/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.report;

import be.iminds.ilabt.jfed.call_log_output.LogOutput;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.AbstractJob;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.report.JobStateReport;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryListener;
import java.time.Instant;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;

public class JobReport
implements LogEntryListener {
    private final AbstractJob<?> job;
    private final ObjectProperty<Instant> startTime = new SimpleObjectProperty();
    private final ObjectProperty<Instant> endTime = new SimpleObjectProperty();
    private final ObservableList<JobStateReport> jobStateReports = FXCollections.observableArrayList();
    private JobStateReport currentStateReport = null;
    private final ObservableList<LogOutput.LogEntry> statelessLogLines = FXCollections.synchronizedObservableList((ObservableList)FXCollections.observableArrayList());

    public JobReport(@Nonnull AbstractJob<?> job) {
        this.job = job;
        assert (job.getState() == null) : "Cannot attach report to active job";
        job.stateProperty().addListener((observable, oldValue, newValue) -> {
            if (newValue != null) {
                JobStateReport jobStateReport = new JobStateReport((State)newValue);
                newValue.registerStateFinishedListener(state -> jobStateReport.registerEnd(state.getStatus()));
                this.jobStateReports.add((Object)jobStateReport);
                this.currentStateReport = jobStateReport;
            } else {
                this.currentStateReport = null;
            }
        });
        job.addTaskExecutionFinishedListener(this::onTaskExecutionFinished);
    }

    public void registerStart() {
        this.startTime.set((Object)Instant.now());
    }

    public void registerEnd() {
        this.endTime.set((Object)Instant.now());
    }

    private void onTaskExecutionFinished(TaskExecution<?> taskExecution) {
        assert (this.currentStateReport != null);
        this.currentStateReport.addTaskExecution(taskExecution);
    }

    public ObservableList<JobStateReport> getJobStateReports() {
        return this.jobStateReports;
    }

    @Override
    public void log(@Nonnull LogOutput.LogEntry logEntry) {
        if (this.currentStateReport != null) {
            this.currentStateReport.addLogLine(logEntry);
        } else {
            this.statelessLogLines.add((Object)logEntry);
        }
    }

    public ObservableList<LogOutput.LogEntry> getStatelessLogLines() {
        return this.statelessLogLines;
    }

    public String getName() {
        return this.job.getName();
    }

    public Instant getStartTime() {
        return (Instant)this.startTime.get();
    }

    public Instant getEndTime() {
        return (Instant)this.endTime.get();
    }
}

