/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.sfa_parts;

import be.iminds.ilabt.jfed.experiment.SfaExperimentPart;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.DesiredStatus;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.jobs.ExperimentPartStateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.SingleCallState;
import be.iminds.ilabt.jfed.highlevel.jobs.states.JobStateFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.EditSSHKeysTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditSshKeysOnSfaExperimentPartJobSlice
extends ExperimentPartStateSlice<SfaExperimentPart> {
    private static final Logger LOG = LoggerFactory.getLogger(EditSshKeysOnSfaExperimentPartJobSlice.class);
    private final Collection<UserSpec> userSpecs;
    private final HighLevelTaskFactory hltf;
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final JobStateFactory jobStateFactory;

    public EditSshKeysOnSfaExperimentPartJobSlice(Job<?> job, SfaExperimentPart experimentPart, Collection<UserSpec> userSpecs, HighLevelTaskFactory hltf, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, JobStateFactory jobStateFactory) {
        super(job, experimentPart);
        this.userSpecs = userSpecs;
        this.hltf = hltf;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.jobStateFactory = jobStateFactory;
    }

    @Override
    public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
        if (this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority()).isEditSshKeysSupported()) {
            EditSshKeysOnExperimentPartState editSshKeysInExperimentPartState = new EditSshKeysOnExperimentPartState((SfaExperimentPart)this.experimentPart, this.userSpecs);
            this.setAndRunState(editSshKeysInExperimentPartState);
            if (editSshKeysInExperimentPartState.getTaskExecution().getState() != TaskExecution.TaskState.SUCCESS) {
                LOG.warn("Updating SSH-keys failed in {}", (Object)((SfaExperimentPart)this.experimentPart).getName());
                return ExperimentTaskStatus.FAILED;
            }
        } else {
            LOG.info("Skipping updating SSH keys info on {}, as it is not supported", (Object)((SfaExperimentPart)this.experimentPart).getConnectSfaAuthority().getName());
            return ExperimentTaskStatus.WARNING;
        }
        this.setAndRunState(this.jobStateFactory.createGetStatusUntilReadyOrFailTaskState(this.job, LOG, this.experiment.getCheckReadyInterval(), this.experiment.getMaxWaitUntilReady(), (SfaExperimentPart)this.experimentPart, DesiredStatus.GENI_READY));
        return ExperimentTaskStatus.SUCCESS;
    }

    public class EditSshKeysOnExperimentPartState
    extends SingleCallState<EditSSHKeysTask> {
        protected EditSshKeysOnExperimentPartState(SfaExperimentPart experimentPart, Collection<UserSpec> userSpecs) {
            super(String.format("Updating %d SSH keys on %s", userSpecs.size(), experimentPart.getName()), EditSshKeysOnSfaExperimentPartJobSlice.this.hltf.getEditSshKeysTask(EditSshKeysOnSfaExperimentPartJobSlice.this.experiment.getSliceOrNull(), experimentPart.getConnectSfaAuthority(), userSpecs));
        }
    }
}

