/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.espec.ESpecLogic;
import be.iminds.ilabt.jfed.espec.bundle.ESpecBundle;
import be.iminds.ilabt.jfed.espec.filefetcher.ExperimentSpecificationFileManager;
import be.iminds.ilabt.jfed.espec.model.AnsiblePlaybookSpec;
import be.iminds.ilabt.jfed.espec.model.DirSpec;
import be.iminds.ilabt.jfed.espec.model.ExecuteSpec;
import be.iminds.ilabt.jfed.espec.model.ExperimentSpecification;
import be.iminds.ilabt.jfed.espec.model.FileSource;
import be.iminds.ilabt.jfed.espec.model.UploadLikeSpec;
import be.iminds.ilabt.jfed.espec.model.UploadSpec;
import be.iminds.ilabt.jfed.espec.parser.ESpecConstants;
import be.iminds.ilabt.jfed.espec.util.ChModPermissionsUtil;
import be.iminds.ilabt.jfed.espec.util.ESpecLogger;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTracker;
import be.iminds.ilabt.jfed.espec.util.UploadProgressTrackerImpl;
import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.jobs.states.RemotePathResolver;
import be.iminds.ilabt.jfed.highlevel.util.ByteArraySshjFile;
import be.iminds.ilabt.jfed.highlevel.util.ESpecMetaFileCreator;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUser;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecNode;
import be.iminds.ilabt.jfed.util.library.KeyUtil;
import com.google.common.base.Charsets;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.KeyPair;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import javafx.collections.ObservableList;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.sftp.FileAttributes;
import net.schmizz.sshj.sftp.FileMode;
import net.schmizz.sshj.sftp.PathComponents;
import net.schmizz.sshj.sftp.SFTPClient;
import net.schmizz.sshj.sftp.SFTPEngine;
import net.schmizz.sshj.xfer.LocalSourceFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExperimentSpecificationServicesDirsAndUploadsState
extends SlicedState<ExperimentSpecificationServiceDirsAndUploadsStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(ExperimentSpecificationServicesDirsAndUploadsState.class);
    private final Logger LOG;
    @Nonnull
    private final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final GeniUser geniUser;
    @Nonnull
    private final ExperimentSpecification experimentSpecification;
    @Nonnull
    private final ESpecBundle experimentSpecificationBundle;
    @Nonnull
    private final ESpecLogger eSpecLogger;
    @Nonnull
    private final RemotePathResolver remotePathResolver;
    private final AtomicBoolean anyDirFailed = new AtomicBoolean(false);
    private final AtomicBoolean anyUploadFailed = new AtomicBoolean(false);
    @Nonnull
    private final List<ExperimentSpecificationServiceDirsAndUploadsStateSlice> slices;

    protected ExperimentSpecificationServicesDirsAndUploadsState(@Nonnull SetupSoftwareExperimentJob job, @Nonnull RemotePathResolver remotePathResolver, @Nonnull GeniUser geniUser) {
        super("Execute ExperimentSpecification Dir And Upload Steps");
        FXModelRspec model;
        this.setupSoftwareExperimentJob = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.remotePathResolver = remotePathResolver;
        this.geniUser = geniUser;
        this.experiment = job.getExperiment();
        this.eSpecLogger = this.experiment.getExperimentSpecificationLogger();
        this.experiment.requireSlice();
        if (this.experiment.getExperimentSpecification() == null) {
            throw new IllegalStateException("Internal error, ExperimentSpecificationServicesDirsAndUploadsState created for experiment without ExperimentSpecification");
        }
        if (this.experiment.getExperimentSpecificationBundle() == null) {
            throw new IllegalStateException("Internal error, ExperimentSpecificationServicesDirsAndUploadsState created for experiment without ExperimentSpecification (bundle)");
        }
        this.experimentSpecification = this.experiment.getExperimentSpecification();
        this.experimentSpecificationBundle = this.experiment.getExperimentSpecificationBundle();
        assert (this.experiment.getKeypairs() != null);
        this.slices = new ArrayList<ExperimentSpecificationServiceDirsAndUploadsStateSlice>();
        RequestRspecSource requestRspecSource = this.experiment.getSlice().getRequestRspec();
        FXModelRspec fXModelRspec = model = requestRspecSource == null ? null : (FXModelRspec)requestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        assert (model != null);
        if (model == null) {
            this.LOG.warn("ExperimentSpecificationServicesDirsAndUploadsState will do nothing because there is no usable request RSpec");
            return;
        }
        for (FXRspecNode node : model.getNodes()) {
            String nodeId = node.getClientId();
            if (nodeId == null) continue;
            ObservableList ansibleGroups = node.getAnsibleGroups();
            boolean neededOnNode = false;
            neededOnNode |= this.experimentSpecification.getExecutes().stream().anyMatch(arg_0 -> this.lambda$new$0(nodeId, (Collection)ansibleGroups, arg_0));
            neededOnNode |= this.experimentSpecification.getUploads().stream().anyMatch(arg_0 -> this.lambda$new$1(nodeId, (Collection)ansibleGroups, arg_0));
            if (ESpecLogic.isAnsibleNode((String)nodeId, (ExperimentSpecification)this.experimentSpecification)) {
                neededOnNode = true;
            }
            if (Objects.equals(node.getSliverTypeName(), "fake")) {
                neededOnNode = false;
            }
            if (!neededOnNode) continue;
            this.LOG.debug("dir & upload step needed on node " + nodeId);
            this.slices.add(new ExperimentSpecificationServiceDirsAndUploadsStateSlice(job, node));
        }
    }

    @Override
    @Nonnull
    protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
        ExperimentTaskStatus res;
        this.eSpecLogger.firePreDir();
        this.eSpecLogger.firePreUpload();
        try {
            res = super.executeState(job);
            this.eSpecLogger.firePostDirAll(!this.anyDirFailed.get());
        }
        catch (Throwable t) {
            try {
                this.LOG.error("Failing due to exception in super.executeState", t);
                ExperimentTaskStatus res2 = ExperimentTaskStatus.FAILED;
                throw t;
            }
            catch (Throwable throwable) {
                this.eSpecLogger.firePostDirAll(!this.anyDirFailed.get());
                this.eSpecLogger.firePostUploadAll(!this.anyUploadFailed.get());
                throw throwable;
            }
        }
        this.eSpecLogger.firePostUploadAll(!this.anyUploadFailed.get());
        this.eSpecLogger.firePreExecute();
        return res;
    }

    @Override
    public Collection<ExperimentSpecificationServiceDirsAndUploadsStateSlice> getSlices() {
        return this.slices;
    }

    private /* synthetic */ boolean lambda$new$1(String nodeId, Collection ansibleGroups, UploadSpec s) {
        return ESpecLogic.mustRunOn((String)nodeId, (Collection)ansibleGroups, (ExperimentSpecification)this.experimentSpecification, (UploadLikeSpec)s);
    }

    private /* synthetic */ boolean lambda$new$0(String nodeId, Collection ansibleGroups, ExecuteSpec s) {
        return ESpecLogic.mustRunOn((String)nodeId, (Collection)ansibleGroups, (ExperimentSpecification)this.experimentSpecification, (UploadLikeSpec)s);
    }

    public class ExperimentSpecificationServiceDirsAndUploadsStateSlice
    extends StateSlice {
        @Nonnull
        protected final FXRspecNode node;
        @Nonnull
        protected final String clientId;
        @Nullable
        private SSHClient ssh;
        @Nullable
        private ExternalFileUtil externalFileUtil;

        public ExperimentSpecificationServiceDirsAndUploadsStateSlice(@Nonnull Job<?> job, FXRspecNode node) {
            super(job);
            this.node = node;
            if (node.getClientId() == null) {
                throw new IllegalStateException("Only nodes with a client_id can be used in an ExperimentSpecification");
            }
            this.clientId = node.getClientId();
        }

        @Override
        public String getName() {
            return "ExperimentSpecification steps for node " + this.clientId;
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            if (Objects.equals(this.node.getSliverTypeName(), "fake")) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.warn("Dir and Upload should NOT run on node with sliver type 'fake' clientId=" + this.clientId + "  (this is a bug in the code, and it will be handled by not running the Dir and Upload statefulRun)");
                return ExperimentTaskStatus.SUCCESS;
            }
            try {
                this.ssh = ExperimentSpecificationServicesDirsAndUploadsState.this.setupSoftwareExperimentJob.getSSHClient((RspecNode)this.node, this);
            }
            catch (JobWithSshConnectionManager.SshException e) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.warn("Aborting ExperimentSpecificationServiceDirsAndUploadsStateSlice.statefulRun due to SSH connection problem to node " + this.node.getClientId(), (Throwable)e);
                return ExperimentTaskStatus.FAILED;
            }
            assert (this.ssh != null);
            this.externalFileUtil = new ExternalFileUtil(this.ssh);
            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePreDir(this.clientId);
            SetupDirsState setupDirState = new SetupDirsState();
            try {
                this.setAndRunState(setupDirState);
            }
            catch (Throwable throwable) {
                if (setupDirState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.anyDirFailed.set(true);
                }
                ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostDirNode(this.clientId, setupDirState.getStatus() == ExperimentTaskStatus.SUCCESS);
                throw throwable;
            }
            if (setupDirState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.anyDirFailed.set(true);
            }
            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostDirNode(this.clientId, setupDirState.getStatus() == ExperimentTaskStatus.SUCCESS);
            if (setupDirState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Failing because setupDirState.getStatus()=" + setupDirState.getStatus());
                return ExperimentTaskStatus.FAILED;
            }
            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePreUpload(this.clientId);
            UploadState uploadState = new UploadState();
            try {
                this.setAndRunState(uploadState);
            }
            catch (Throwable throwable) {
                if (uploadState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.anyUploadFailed.set(true);
                }
                ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostUploadNode(this.clientId, uploadState.getStatus() == ExperimentTaskStatus.SUCCESS);
                throw throwable;
            }
            if (uploadState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.anyUploadFailed.set(true);
            }
            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostUploadNode(this.clientId, uploadState.getStatus() == ExperimentTaskStatus.SUCCESS);
            if (uploadState.getStatus() != ExperimentTaskStatus.SUCCESS) {
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Failing because uploadState.getStatus()=" + uploadState.getStatus());
                return ExperimentTaskStatus.FAILED;
            }
            return ExperimentTaskStatus.SUCCESS;
        }

        public class SetupDirsState
        extends State {
            protected SetupDirsState() {
                super("Checking (and possible creating) dirs on " + ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId());
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.ssh == null) {
                    throw new IllegalStateException("ssh == null");
                }
                if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.externalFileUtil == null) {
                    throw new IllegalStateException("externalFileUtil == null");
                }
                ArrayList dirs = new ArrayList(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getDirs());
                for (DirSpec dirSpec : dirs) {
                    if (!ESpecLogic.mustRunOn((String)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, (Collection)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getAnsibleGroups(), (ExperimentSpecification)ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification, (DirSpec)dirSpec)) continue;
                    String remotePath = ExperimentSpecificationServicesDirsAndUploadsState.this.remotePathResolver.getRemotePath(dirSpec, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId);
                    ExperimentSpecificationServicesDirsAndUploadsState experimentSpecificationServicesDirsAndUploadsState = ExperimentSpecificationServicesDirsAndUploadsState.this;
                    long logId = experimentSpecificationServicesDirsAndUploadsState.eSpecLogger.getNextLogId();
                    int targetDirMask = ChModPermissionsUtil.toMask((String)dirSpec.getPermissions());
                    FileAttributes targetDirAtts = new FileAttributes.Builder().withPermissions(targetDirMask).withType(FileMode.Type.DIRECTORY).build();
                    if (dirSpec.getDirContent() != null) assert (remotePath != null);
                    ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePreDir(logId, dirSpec, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId);
                    try {
                        SFTPClient sftpClient = ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.ssh.newSFTPClient();
                        try {
                            FileAttributes att = sftpClient.statExistence(remotePath);
                            ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.dir checked dir {} on {}. exists={}", new Object[]{remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), att != null});
                            if (att != null) {
                                if (att.getType() != FileMode.Type.DIRECTORY) {
                                    throw new IllegalStateException("Error while checking dir " + remotePath + ", it already exists but is not a directory");
                                }
                                sftpClient.chmod(remotePath, targetDirMask);
                            } else {
                                SFTPEngine engine = sftpClient.getSFTPEngine();
                                LinkedList<String> dirsToMake = new LinkedList<String>();
                                PathComponents current = engine.getPathHelper().getComponents(remotePath);
                                while (true) {
                                    FileAttributes attrs;
                                    if ((attrs = sftpClient.statExistence(current.getPath())) != null) {
                                        if (attrs.getType() == FileMode.Type.DIRECTORY) break;
                                        throw new IllegalStateException("Error while creating dir " + remotePath + " -> " + current.getPath() + " exists but is not a directory");
                                    }
                                    dirsToMake.push(current.getPath());
                                    current = engine.getPathHelper().getComponents(current.getParent());
                                }
                                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.dir must create dirs {}", dirsToMake);
                                while (!dirsToMake.isEmpty()) {
                                    String dirToMake = (String)dirsToMake.pop();
                                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.dir creating {} on {}", (Object)dirToMake, (Object)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId());
                                    engine.makeDir(dirToMake, targetDirAtts);
                                    sftpClient.chmod(dirToMake, targetDirMask);
                                }
                            }
                            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostDirSuccess(logId, dirSpec, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId);
                        }
                        finally {
                            if (sftpClient == null) continue;
                            sftpClient.close();
                        }
                    }
                    catch (IOException ex) {
                        ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Error while creating dir {} on {}", new Object[]{remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), ex});
                        this.updateMessage(String.format("Error while creating dir %s on %s: %s", remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), ex.getMessage()));
                        ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostDirFail(logId, dirSpec, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, "Error while creating dir " + remotePath + " on " + ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), (Throwable)ex);
                        return ExperimentTaskStatus.FAILED;
                    }
                }
                return ExperimentTaskStatus.SUCCESS;
            }
        }

        public class UploadState
        extends State {
            protected UploadState() {
                super("Uploading files on " + ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId());
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.ssh == null) {
                    throw new IllegalStateException("ssh == null");
                }
                if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.externalFileUtil == null) {
                    throw new IllegalStateException("externalFileUtil == null");
                }
                try {
                    job.getExperiment().getExperimentSpecificationFileManager().waitUntilReady();
                    if (job.getExperiment().getExperimentSpecificationFileManager().getErrorOccured()) {
                        throw new RuntimeException("Error fetching ESpec resources for upload");
                    }
                }
                catch (Exception e) {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Error fetching ESpec resources for upload", (Throwable)e);
                    this.updateMessage("Error fetching ESpec resources for upload: " + e.getMessage());
                    return ExperimentTaskStatus.FAILED;
                }
                ArrayList posUploads = new ArrayList(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getUploads());
                posUploads.addAll(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getExecutes());
                ArrayList<AnsiblePlaybookSpec.ExtraVarsJsonFileSpec> ansibleUploads = new ArrayList<AnsiblePlaybookSpec.ExtraVarsJsonFileSpec>();
                if (ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible() != null) {
                    ansibleUploads.addAll(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible().getAnsibleHostSpec().getUploadLists());
                    ansibleUploads.addAll(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible().getAnsibleHostSpec().getExecuteLists());
                    ansibleUploads.addAll(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible().getAnsibleGalaxySpecs());
                    ansibleUploads.addAll(ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible().getAnsiblePlaybookSpecs());
                    for (AnsiblePlaybookSpec ansiblePlaybookSpec : ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification.getAnsible().getAnsiblePlaybookSpecs()) {
                        if (!ansiblePlaybookSpec.hasExtraVarsJsonFileSpec() || ansiblePlaybookSpec.getExtraVarsJsonFileSpec() == null) continue;
                        ansibleUploads.add(ansiblePlaybookSpec.getExtraVarsJsonFileSpec());
                    }
                    posUploads.addAll(ansibleUploads);
                }
                List localFiles = posUploads.stream().filter(f -> f.getSource() == null).collect(Collectors.toList());
                List uploads = posUploads.stream().filter(f -> f.getSource() != null).collect(Collectors.toList());
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload There are " + uploads.size() + " uploads needed.");
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload There are " + localFiles.size() + " files already present on the nodes.");
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload Of these there are " + ansibleUploads.size() + " ansible file uploads or already present files.");
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload Files to be uploaded: " + uploads.stream().map(UploadLikeSpec::getDesc).collect(Collectors.joining(", ")));
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload Files already present: " + localFiles.stream().map(UploadLikeSpec::getDesc).collect(Collectors.joining(", ")));
                try (SFTPClient sftpClient = ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.ssh.newSFTPClient();){
                    Iterator iterator = uploads.iterator();
                    while (iterator.hasNext()) {
                        UploadLikeSpec uploadSpec = (UploadLikeSpec)iterator.next();
                        ExperimentSpecificationServicesDirsAndUploadsState experimentSpecificationServicesDirsAndUploadsState = ExperimentSpecificationServicesDirsAndUploadsState.this;
                        long logId = experimentSpecificationServicesDirsAndUploadsState.eSpecLogger.getNextLogId();
                        if (uploadSpec.getSource() == null) {
                            throw new RuntimeException("Internal assumption failed");
                        }
                        if (!ESpecLogic.mustRunOn((String)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, (Collection)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getAnsibleGroups(), (ExperimentSpecification)ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification, (UploadLikeSpec)uploadSpec)) {
                            ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload skips {} on {}  (ansNode={} ansSub={})", new Object[]{uploadSpec.getDesc(), ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, ESpecLogic.isAnsibleNode((String)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, (ExperimentSpecification)ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification), ESpecLogic.isAnsibleSubPart((UploadLikeSpec)uploadSpec, (ExperimentSpecification)ExperimentSpecificationServicesDirsAndUploadsState.this.experimentSpecification)});
                            continue;
                        }
                        assert (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.externalFileUtil != null);
                        Object remotePath = ExperimentSpecificationServicesDirsAndUploadsState.this.remotePathResolver.getRemotePath(uploadSpec, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId);
                        assert (remotePath != null);
                        UploadProgressTrackerImpl uploadProgressTracker = new UploadProgressTrackerImpl();
                        ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePreUpload(logId, uploadSpec, (String)remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, (UploadProgressTracker)uploadProgressTracker);
                        ExternalFileUtil cfr_ignored_0 = ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.externalFileUtil;
                        String name = ExternalFileUtil.getBasename((String)remotePath);
                        try {
                            boolean isDir = job.getExperiment().getExperimentSpecificationFileManager().isDir(uploadSpec.getSource());
                            if (!isDir) {
                                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload starts single file upload from {} to {} on {}", new Object[]{uploadSpec.getSource().getValue(), remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId()});
                                byte[] content = uploadSpec.getSource().getType() == FileSource.SourceType.META ? this.getMetaContent(uploadSpec.getSource().getValue(), (RspecNode)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node) : (uploadSpec.getSource().isGeneratedKeyPair() ? this.getGeneratedContent(uploadSpec.getSource().getValue()) : job.getExperiment().getExperimentSpecificationFileManager().getBytes(uploadSpec.getSource()));
                                uploadProgressTracker.setTotalBytes(content.length);
                                this.uploadFile(sftpClient, (String)remotePath, name, uploadSpec.getPermissions(), content);
                                uploadProgressTracker.setCurrentBytes(content.length);
                            } else {
                                ExperimentSpecificationFileManager.DirFileBytes dirFileBytes;
                                if (!((String)remotePath).endsWith("/")) {
                                    remotePath = (String)remotePath + "/";
                                }
                                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload starts recursive dir upload from {} to {} on {}", new Object[]{uploadSpec.getSource().getValue(), remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId()});
                                int totalByteCount = 0;
                                Iterator filesToUpload = job.getExperiment().getExperimentSpecificationFileManager().getDirBytes(uploadSpec.getSource());
                                while (filesToUpload.hasNext()) {
                                    dirFileBytes = (ExperimentSpecificationFileManager.DirFileBytes)filesToUpload.next();
                                    if (dirFileBytes.isDir()) continue;
                                    totalByteCount += dirFileBytes.getContent().length;
                                }
                                uploadProgressTracker.setTotalBytes(totalByteCount);
                                int currentUploadedByteCount = 0;
                                filesToUpload = job.getExperiment().getExperimentSpecificationFileManager().getDirBytes(uploadSpec.getSource());
                                while (filesToUpload.hasNext()) {
                                    dirFileBytes = (ExperimentSpecificationFileManager.DirFileBytes)filesToUpload.next();
                                    String curRemotePath = (String)remotePath + dirFileBytes.getFullRelativePath();
                                    if (dirFileBytes.isDir()) {
                                        this.makeDir(sftpClient, curRemotePath, "u=rwx");
                                    } else {
                                        this.uploadFile(sftpClient, curRemotePath, dirFileBytes.getBaseFilename().isEmpty() ? name : dirFileBytes.getBaseFilename(), uploadSpec.getPermissions(), dirFileBytes.getContent());
                                        uploadProgressTracker.setCurrentBytes(currentUploadedByteCount += dirFileBytes.getContent().length);
                                    }
                                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload finished recursive dir upload");
                                }
                            }
                            ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload successfully uploaded {} to {} on {}", new Object[]{name, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId()});
                            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostUploadSuccess(logId, uploadSpec, (String)remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId);
                        }
                        catch (IOException ex) {
                            ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Error while uploading {} to {} on {}", new Object[]{name, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), ex});
                            this.updateMessage(String.format("Error while uploading %s to %s on %s: %s", name, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), ex.getMessage()));
                            ExperimentSpecificationServicesDirsAndUploadsState.this.eSpecLogger.firePostUploadFail(logId, uploadSpec, (String)remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.clientId, "Error while uploading " + name + " to " + (String)remotePath + " on " + ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), (Throwable)ex);
                            ExperimentTaskStatus experimentTaskStatus = ExperimentTaskStatus.FAILED;
                            if (sftpClient == null) return experimentTaskStatus;
                            sftpClient.close();
                            return experimentTaskStatus;
                        }
                    }
                    return ExperimentTaskStatus.SUCCESS;
                }
                catch (IOException e) {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.error("Failed to create SSH SFTP client", (Throwable)e);
                    throw new JFedException("Failed to create SSH SFTP client", (Throwable)e);
                }
            }

            private void makeDir(SFTPClient sftpClient, String remotePath, String dirPerm) throws IOException {
                boolean hasDir;
                SFTPEngine engine = sftpClient.getSFTPEngine();
                int targetDirMask = ChModPermissionsUtil.toMask((String)dirPerm);
                FileAttributes targetDirAtts = new FileAttributes.Builder().withPermissions(targetDirMask).withType(FileMode.Type.DIRECTORY).build();
                try {
                    FileAttributes stats = engine.stat(remotePath);
                    hasDir = stats != null;
                }
                catch (Exception e) {
                    hasDir = false;
                }
                if (!hasDir) {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload creating dir {} on {}", (Object)remotePath, (Object)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId());
                    engine.makeDir(remotePath, targetDirAtts);
                    sftpClient.chmod(remotePath, targetDirMask);
                } else {
                    ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload saw that dir {} on {} already exists", (Object)remotePath, (Object)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId());
                }
            }

            private void uploadFile(SFTPClient sftpClient, String remotePath, String name, String perm, byte[] content) throws IOException {
                int targetFileMask = ChModPermissionsUtil.toMask((String)perm);
                ExperimentSpecificationServicesDirsAndUploadsState.this.LOG.debug("ExperimentSpecification.upload is uploading {} ({} bytes) to {} on {} with perm={}", new Object[]{name, content.length, remotePath, ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.node.getClientId(), perm});
                sftpClient.getFileTransfer().upload((LocalSourceFile)new ByteArraySshjFile(name, content, perm), remotePath);
                sftpClient.chmod(remotePath, targetFileMask);
            }

            private byte[] getGeneratedContent(String generatedContentId) {
                if (ESpecConstants.isPrivateKey((String)generatedContentId)) {
                    if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs() == null || ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs().isEmpty()) {
                        throw new IllegalStateException("\"generated\" source \"" + generatedContentId + "\" used, but experiment has no keypairs");
                    }
                    KeyPair keyPair = (KeyPair)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs().values().iterator().next();
                    assert (keyPair != null);
                    assert (keyPair.getPrivate() != null);
                    char[] privateKeyChars = KeyUtil.privateKeyToPem((PrivateKey)keyPair.getPrivate());
                    return new String(privateKeyChars).getBytes(StandardCharsets.UTF_8);
                }
                if (ESpecConstants.isPublicKey((String)generatedContentId)) {
                    if (ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs() == null || ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs().isEmpty()) {
                        throw new IllegalStateException("\"generated\" source \"" + generatedContentId + "\" used, but experiment has no keypairs");
                    }
                    KeyPair keyPair = (KeyPair)ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment.getKeypairs().values().iterator().next();
                    assert (keyPair != null);
                    assert (keyPair.getPublic() != null);
                    String publicKeyString = KeyUtil.publicKeyToOpenSshAuthorizedKeysFormat((PublicKey)keyPair.getPublic());
                    return publicKeyString.getBytes(StandardCharsets.UTF_8);
                }
                throw new UnsupportedOperationException("Unsupported \"generated\" source \"" + generatedContentId + "\"");
            }

            private byte[] getMetaContent(@Nonnull String metaContentId, @Nonnull RspecNode node) {
                ESpecMetaFileCreator metaFileCreator = new ESpecMetaFileCreator(ExperimentSpecificationServiceDirsAndUploadsStateSlice.this.experiment, ExperimentSpecificationServicesDirsAndUploadsState.this.geniUser);
                if (metaContentId.equals("manifest.xml")) {
                    return metaFileCreator.getManifestXml();
                }
                if (metaContentId.equals("experiment-info.json")) {
                    return metaFileCreator.getExperimentInfoJson();
                }
                if (metaContentId.equals("client_id.txt")) {
                    if (node == null) {
                        return "INTERNAL ERROR: Unknown node".getBytes(Charsets.UTF_8);
                    }
                    if (node.getClientId() == null) {
                        return "INTERNAL ERROR: Unknown client_id for node".getBytes(Charsets.UTF_8);
                    }
                    return node.getClientId().getBytes(Charsets.UTF_8);
                }
                throw new UnsupportedOperationException("Unsupported \"meta\" value \"" + metaContentId + "\"");
            }
        }
    }
}

