/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.jobs.states;

import be.iminds.ilabt.jfed.experiment.Experiment;
import be.iminds.ilabt.jfed.experiment.tasks.ExperimentTaskStatus;
import be.iminds.ilabt.jfed.highlevel.jobs.Job;
import be.iminds.ilabt.jfed.highlevel.jobs.JobWithSshConnectionManager;
import be.iminds.ilabt.jfed.highlevel.jobs.SetupSoftwareExperimentJob;
import be.iminds.ilabt.jfed.highlevel.jobs.SlicedState;
import be.iminds.ilabt.jfed.highlevel.jobs.State;
import be.iminds.ilabt.jfed.highlevel.jobs.StateSlice;
import be.iminds.ilabt.jfed.highlevel.util.ExternalFileUtil;
import be.iminds.ilabt.jfed.highlevel.util.LogEntryGeneratorWrappingLogger;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.ExecuteService;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.imutable_impl.ImmutableModelRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.RequestRspecSource;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javafx.util.Pair;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.schmizz.sshj.SSHClient;
import net.schmizz.sshj.connection.channel.direct.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WaitForExecuteFinishedState
extends SlicedState<WaitForExecuteServiceStateSlice> {
    private static final Logger ACTUAL_LOG = LoggerFactory.getLogger(WaitForExecuteFinishedState.class);
    private final Logger LOG;
    public static final int MAX_EXECUTE_FINISHED_FILE_DETECTION_TRIES = 60;
    public static final int TIME_BETWEEN_FINISHED_FILE_DETECTION_TRIES_MS = 10000;
    @Nonnull
    private final SetupSoftwareExperimentJob setupSoftwareExperimentJob;
    @Nonnull
    private final Experiment experiment;
    @Nonnull
    private final List<WaitForExecuteServiceStateSlice> slices;

    protected WaitForExecuteFinishedState(@Nonnull SetupSoftwareExperimentJob job) {
        super("Wait For Execute Finished");
        this.setupSoftwareExperimentJob = job;
        this.LOG = new LogEntryGeneratorWrappingLogger(ACTUAL_LOG, job.getJobReport());
        this.experiment = job.getExperiment();
        this.experiment.requireSlice();
        List<Pair<RspecNode, ExecuteService>> executeServices = WaitForExecuteFinishedState.getExecuteServicesToWaitFor(this.experiment);
        this.slices = executeServices.stream().map(p -> new WaitForExecuteServiceStateSlice(job, (RspecNode)p.getKey(), (ExecuteService)p.getValue())).collect(Collectors.toList());
    }

    @Nonnull
    private static List<Pair<RspecNode, ExecuteService>> getExecuteServicesToWaitFor(@Nonnull Experiment experiment) {
        ImmutableModelRspec model;
        RequestRspecSource requestRspecSource = experiment.getSlice().getRequestRspec();
        ImmutableModelRspec immutableModelRspec = model = requestRspecSource == null ? null : requestRspecSource.getImmutableModelRspec();
        assert (model != null);
        if (model == null) {
            return Collections.emptyList();
        }
        ArrayList<Pair<RspecNode, ExecuteService>> res = new ArrayList<Pair<RspecNode, ExecuteService>>();
        for (RspecNode node : model.getNodes()) {
            if (node.getExecuteServices() == null) continue;
            res.addAll(node.getExecuteServices().stream().filter(Objects::nonNull).filter(es -> es.getFinishedFile() != null).map(es -> new Pair((Object)node, es)).collect(Collectors.toList()));
        }
        return res;
    }

    public static boolean hasWaitForExecute(Experiment experiment) {
        return !WaitForExecuteFinishedState.getExecuteServicesToWaitFor(experiment).isEmpty();
    }

    @Override
    public Collection<WaitForExecuteServiceStateSlice> getSlices() {
        return this.slices;
    }

    public class WaitForExecuteServiceStateSlice
    extends StateSlice {
        @Nonnull
        protected final RspecNode node;
        @Nonnull
        protected final ExecuteService executeService;
        @Nullable
        private SSHClient ssh;
        @Nullable
        private ExternalFileUtil externalFileUtil;

        public WaitForExecuteServiceStateSlice(@Nonnull Job<?> job, @Nonnull RspecNode node, ExecuteService executeService) {
            super(job);
            this.ssh = null;
            this.node = node;
            this.executeService = executeService;
        }

        @Override
        public String getName() {
            return "Waiting for ExecuteServices to finish on " + this.node.getClientId();
        }

        @Override
        public ExperimentTaskStatus statefulRun() throws JFedException, InterruptedException {
            try {
                this.ssh = WaitForExecuteFinishedState.this.setupSoftwareExperimentJob.getSSHClient(this.node, this);
            }
            catch (JobWithSshConnectionManager.SshException e) {
                WaitForExecuteFinishedState.this.LOG.warn("Aborting WaitForExecuteServiceStateSlice.statefulRun due to SSH comnection problem", (Throwable)e);
                return ExperimentTaskStatus.FAILED;
            }
            assert (this.ssh != null);
            this.externalFileUtil = new ExternalFileUtil(this.ssh);
            WaitForExecuteServicesState waitState = new WaitForExecuteServicesState();
            this.setAndRunState(waitState);
            WaitForExecuteFinishedState.this.setupSoftwareExperimentJob.closeSSH(this.node);
            return waitState.getStatus();
        }

        public class WaitForExecuteServicesState
        extends State {
            protected WaitForExecuteServicesState() {
                super("Waiting for execute-services to finish on " + WaitForExecuteServiceStateSlice.this.node.getClientId());
            }

            @Override
            @Nonnull
            protected ExperimentTaskStatus executeState(Job<?> job) throws InterruptedException, JFedException {
                try {
                    if (WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() == null) {
                        WaitForExecuteFinishedState.this.LOG.warn("BUG: executeService.getFinishedFile() == null so nothing to do.");
                        return ExperimentTaskStatus.SUCCESS;
                    }
                    boolean fileFound = false;
                    WaitForExecuteFinishedState.this.LOG.debug("WaitForExecuteServicesState starts waiting for file \"" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "\" to appear.");
                    for (int tries = 0; !fileFound && tries < 60; ++tries) {
                        Session.Command command = WaitForExecuteServiceStateSlice.this.ssh.startSession().exec("test -f " + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile());
                        command.join();
                        fileFound = command.getExitStatus() == 0;
                        if (fileFound) continue;
                        this.updateMessage("Looked for '" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "' " + tries + " times.");
                        Thread.sleep(10000L);
                    }
                    if (!fileFound) {
                        WaitForExecuteFinishedState.this.LOG.debug("WaitForExecuteServicesState stopped waiting: Timed out while waiting for file \"" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "\" to appear.");
                        this.updateMessage("Timed out while waiting for finished-file '" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "' to appear");
                        return ExperimentTaskStatus.FAILED;
                    }
                    WaitForExecuteFinishedState.this.LOG.debug("WaitForExecuteServicesState stopped waiting: Found finished-file \"" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "\"");
                    this.updateMessage("Found finished-file '" + WaitForExecuteServiceStateSlice.this.executeService.getFinishedFile() + "'");
                    return ExperimentTaskStatus.SUCCESS;
                }
                catch (IOException ex) {
                    WaitForExecuteFinishedState.this.LOG.error("Error while waiting for finished-files on {}", (Object)WaitForExecuteServiceStateSlice.this.node.getClientId(), (Object)ex);
                    this.updateMessage("Error while waiting for finished-files on {}" + ex.getMessage());
                    return ExperimentTaskStatus.FAILED;
                }
            }
        }
    }
}

