/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class AggregatesForSliceTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(AggregatesForSliceTask.class);
    private final Slice slice;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final HighLevelTaskFactory highLevelTaskFactory;
    private List<GeniUrn> aggregates = null;

    public AggregatesForSliceTask(@Nonnull Slice slice, UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, HighLevelTaskFactory highLevelTaskFactory) {
        super("Resolve Slice");
        this.slice = slice;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.aggregates = this.userAndSliceApiWrapper.getAggregatesForSlice((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.slice.getCredentials(), this.slice.getUrn());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getUserCredential());
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }

    public List<GeniUrn> getAggregates() {
        return this.aggregates;
    }
}

