/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.SfaModel;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateSliceTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSliceTask.class);
    private final String sliceName;
    private final String subAuthority;
    @Nonnull
    private final List<GeniUrn> shareWith;
    private final Instant expirationDate;
    private Slice slice;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final SfaModel sfaModel;
    private final HighLevelTaskFactory hltf;

    public CreateSliceTask(@Nonnull String sliceName, @Nullable String subAuthority, @Nonnull List<GeniUrn> shareWith, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory hltf) {
        this(sliceName, subAuthority, shareWith, null, userAndSliceApiWrapper, logger, sfaModel, hltf);
    }

    public CreateSliceTask(@Nonnull String sliceName, @Nullable String subAuthority, @Nonnull List<GeniUrn> shareWith, @Nullable Instant expirationDate, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull SfaModel sfaModel, @Nonnull HighLevelTaskFactory hltf) {
        super("Create Slice");
        this.sliceName = sliceName;
        this.subAuthority = subAuthority;
        this.shareWith = shareWith;
        this.expirationDate = expirationDate;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.sfaModel = sfaModel;
        this.hltf = hltf;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        LOG.debug("Requesting slice with expiration time {}", (Object)this.expirationDate);
        assert (this.userAndSliceApiWrapper.hasUserCredentials()) : "There was no valid user credential available.";
        if (!this.userAndSliceApiWrapper.hasUserCredentials()) {
            LOG.warn("Register call saw that UserAndSliceApiWrapper does not have a valid credential. The call will most likely fail.");
        }
        UserAndSliceApiWrapper.SliceInfo sliceInfo = this.userAndSliceApiWrapper.createSlice((be.iminds.ilabt.jfed.log.Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.sliceName, this.expirationDate != null ? Date.from(this.expirationDate) : null, this.subAuthority);
        GeniUrn sliceUrn = sliceInfo.getUrn();
        this.slice = this.sfaModel.getSlice(sliceUrn);
        if (this.slice == null) {
            LOG.error("failed: slice was not added to SfaModel sliceUrn={}", (Object)sliceUrn);
            throw new JFedHighLevelException("Creation of slice was successful, but Task FAILED because slice was not added to SfaModel. sliceUrn=" + sliceUrn);
        }
        LOG.debug("success: '{}'", (Object)sliceUrn.toString());
        if (!this.shareWith.isEmpty()) {
            LOG.debug("Also sharing slice with " + this.shareWith);
            this.userAndSliceApiWrapper.shareSlice((be.iminds.ilabt.jfed.log.Logger)JavaFXLogger.wrap(this.logger, taskExecution), sliceUrn, sliceInfo.getCredentials(), this.shareWith, "MEMBER");
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.hltf.getUserCredential());
    }

    public String getSliceName() {
        return this.sliceName;
    }

    public Slice getSlice() {
        return this.slice;
    }
}

