/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.model.Sliver;
import be.iminds.ilabt.jfed.highlevel.tasks.CreateTask;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.rspec.model.Channel;
import be.iminds.ilabt.jfed.rspec.model.Lease;
import be.iminds.ilabt.jfed.rspec.model.ModelRspec;
import be.iminds.ilabt.jfed.rspec.model.ModelRspecType;
import be.iminds.ilabt.jfed.rspec.model.RspecNode;
import be.iminds.ilabt.jfed.rspec.model.StringRspec;
import be.iminds.ilabt.jfed.rspec.rspec_source.ImmutableRequestRspecSource;
import be.iminds.ilabt.jfed.rspec.rspec_source.ManifestRspecSource;
import be.iminds.ilabt.jfed.rspec.util.ProgressHandler;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXModelRspec;
import be.iminds.ilabt.jfed.rspec_fx.model.javafx_impl.FXRspecFactory;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CreateSliverReservationTask
extends CreateTask {
    private static final Logger LOG = LoggerFactory.getLogger(CreateSliverReservationTask.class);
    private final Slice slice;
    private final Instant reservationStartTime;
    private final Instant reservationEndTime;
    private final List<UserSpec> userSpecs;
    private final Server auth;
    private String manifestRspec;
    private String status;
    private Boolean success = null;
    private Set<Sliver> createdSlivers = null;
    private final List<GeniUrn> failedResources = new ArrayList<GeniUrn>();
    private final FXRspecFactory rspecFactory = FXRspecFactory.getInstance();
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public CreateSliverReservationTask(@Nonnull Slice slice, Server auth, @Nonnull Instant reservationStartTime, @Nonnull Instant reservationEndTime, List<UserSpec> userSpecs, AggregateManagerWrapperFactory aggregateManagerWrapperFactory, HighLevelTaskFactory highLevelTaskFactory) {
        super("Create Sliver @ " + auth.getDefaultComponentManagerUrn());
        this.slice = slice;
        this.auth = auth;
        this.reservationStartTime = reservationStartTime;
        this.reservationEndTime = reservationEndTime;
        this.userSpecs = userSpecs;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        block8: {
            AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
            try {
                if (this.auth.hasFlag(Server.Flag.featureReservationsGeni)) {
                    AggregateManagerWrapper.AllocateReply allocateReply = amWrapper.allocate(this.slice.getUrn(), this.slice.getCredentials(), this.slice.getRequestRspec().getRspecXmlString(), Date.from(this.reservationStartTime), Date.from(this.reservationEndTime));
                    if (allocateReply != null) {
                        this.manifestRspec = allocateReply.getManifest();
                    }
                    break block8;
                }
                if (this.auth.hasFlag(Server.Flag.featureReservationsNitos)) {
                    ModelRspec requestWithLease = this.createRequestWithNitosLease(this.slice.getRequestRspec().getRspecXmlString(), this.auth, this.reservationStartTime, this.reservationEndTime);
                    this.updateExpires(this.auth, requestWithLease, this.reservationEndTime);
                    String requestWithLeaseRspecString = requestWithLease.toGeni3Rspec();
                    this.manifestRspec = amWrapper.createSliver(this.slice.getUrn(), this.slice.getCredentials(), requestWithLeaseRspecString, this.userSpecs, Date.from(this.reservationEndTime));
                    ArrayList<GeniUrn> failedResources = new ArrayList<GeniUrn>();
                    if (this.manifestRspec != null) {
                        failedResources.addAll(this.checkForFailedNitosReservations(this.manifestRspec, this.auth, requestWithLease));
                        if (!failedResources.isEmpty()) {
                            this.status = "Could not make a reservation for resource(s) " + failedResources.stream().map(GeniUrn::toString).collect(Collectors.joining(", "));
                            this.manifestRspec = null;
                            throw new JFedHighLevelException("Could not make a reservation for node(s) " + failedResources.stream().map(GeniUrn::toString).collect(Collectors.joining(", ")));
                        }
                        this.success = true;
                    } else {
                        this.status = "Reservation call was unsuccessful";
                        this.success = false;
                    }
                    break block8;
                }
                throw new JFedHighLevelException("Making a reservation is not supported on this authority!");
            }
            catch (JFedException ex) {
                this.success = false;
                throw ex;
            }
        }
    }

    private ModelRspec createRequestWithNitosLease(@Nonnull String requestRspec, @Nonnull Server auth, @Nonnull Instant reservationStartTime, @Nonnull Instant reservationEndTime) throws JFedHighLevelException {
        ImmutableRequestRspecSource requestCopy = new ImmutableRequestRspecSource(new StringRspec(requestRspec));
        if (requestCopy.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]) == null) {
            throw new JFedHighLevelException("Could not parse request rspec into model: got null!");
        }
        if (requestCopy.isLosingData(ModelRspecType.FX)) {
            throw new JFedHighLevelException("Lost data while parsing request rspec: " + requestCopy.getLosingDataDifferences(ModelRspecType.FX));
        }
        ModelRspec requestWithLease = requestCopy.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        String clientLeaseId = UUID.randomUUID().toString();
        Lease newLease = this.rspecFactory.createLease(requestWithLease, null, clientLeaseId, Date.from(reservationStartTime), Date.from(reservationEndTime));
        requestWithLease.addLease(newLease);
        requestWithLease.getNodes().stream().filter(node -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), node.getComponentManagerId())).forEach(node -> {
            node.getLeaseIdRefs().clear();
            node.addLeaseIdRef(clientLeaseId);
        });
        requestWithLease.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).forEach(channel -> {
            channel.getLeaseIdRefs().clear();
            channel.addLeaseIdRef(clientLeaseId);
        });
        return requestWithLease;
    }

    protected List<GeniUrn> checkForFailedNitosReservations(@Nonnull String manifestRspec, @Nonnull Server auth, @Nonnull ModelRspec requestWithLease) {
        ArrayList<GeniUrn> failedResources = new ArrayList<GeniUrn>();
        ManifestRspecSource manifestRspecSource = new ManifestRspecSource(new StringRspec(manifestRspec));
        FXModelRspec modelRspec = (FXModelRspec)manifestRspecSource.getModelRspec(ModelRspecType.FX, new ProgressHandler[0]);
        failedResources.addAll(modelRspec.getNodes().stream().filter(rspecNode -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), rspecNode.getComponentManagerId())).filter(rspecNode -> rspecNode.getLeaseIdRefs().isEmpty()).map(RspecNode::getComponentId).collect(Collectors.toList()));
        failedResources.addAll(modelRspec.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).filter(channel -> channel.getLeaseIdRefs().isEmpty()).map(Channel::getComponentId).collect(Collectors.toList()));
        failedResources.addAll(requestWithLease.getNodes().stream().filter(node -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), node.getComponentManagerId())).filter(node -> modelRspec.getNodeByClientId(node.getClientId()) == null).map(RspecNode::getComponentId).collect(Collectors.toList()));
        failedResources.addAll(requestWithLease.getChannels().stream().filter(channel -> Objects.equals(auth.getDefaultComponentManagerAsGeniUrn(), channel.getComponentManagerId())).filter(channel -> modelRspec.getChannelByComponentId(channel.getComponentId()) == null).map(Channel::getComponentId).collect(Collectors.toList()));
        return failedResources;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        ArrayList<Task> res = new ArrayList<Task>();
        res.add(this.highLevelTaskFactory.getSliceCredential(this.slice));
        return res;
    }

    public String getManifestRspec() {
        return this.manifestRspec;
    }

    @Override
    public Server getServer() {
        return this.auth;
    }

    @Override
    public Collection<Sliver> getCreatedSlivers() {
        throw new UnsupportedOperationException();
    }

    public String getStatus() {
        return this.status;
    }

    public List<GeniUrn> getFailedResources() {
        return this.failedResources;
    }

    public Boolean isSuccess() {
        return this.success;
    }
}

