/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.AggregateManagerWrapperFactory;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.AggregateManagerWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class ListSliceResourcesTask
extends Task {
    @Nonnull
    private final Server auth;
    @Nonnull
    private final Slice slice;
    private String rspec;
    @Nonnull
    private final AggregateManagerWrapperFactory aggregateManagerWrapperFactory;
    @Nonnull
    private final HighLevelTaskFactory highLevelTaskFactory;
    private boolean hardFailure;

    public ListSliceResourcesTask(@Nonnull Server auth, @Nonnull Slice slice, @Nonnull AggregateManagerWrapperFactory aggregateManagerWrapperFactory, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super("ListResources of Slice @ " + auth.getDefaultComponentManagerUrn());
        this.auth = auth;
        this.slice = slice;
        this.aggregateManagerWrapperFactory = aggregateManagerWrapperFactory;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.hardFailure = false;
    }

    @Override
    protected void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        AggregateManagerWrapper amWrapper = this.aggregateManagerWrapperFactory.getAggregateManagerWrapper(taskExecution, this.auth);
        this.hardFailure = true;
        try {
            this.rspec = amWrapper.describe(this.slice.getUrn(), this.slice.getCredentials());
            this.hardFailure = false;
        }
        catch (JFedException e) {
            this.hardFailure = true;
        }
    }

    @Nullable
    public String getRspec() {
        return this.rspec;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Nonnull
    public Server getAuthority() {
        return this.auth;
    }

    public boolean isHardFailure() {
        return this.hardFailure;
    }
}

