/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;

public class ListSlicesTask
extends Task {
    private List<GeniUrn> slices;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final GeniUserProvider geniUserProvider;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public ListSlicesTask(UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, GeniUserProvider geniUserProvider, HighLevelTaskFactory highLevelTaskFactory) {
        super("List Slices");
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.geniUserProvider = geniUserProvider;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        this.slices = this.userAndSliceApiWrapper.getSlicesForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.geniUserProvider.getLoggedInGeniUser().getUserUrn());
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getUserCredential());
    }

    public List<GeniUrn> getSlices() {
        return this.slices;
    }
}

