/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.JFedHighLevelException;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.RegisterOrUpdateSliversTask;
import be.iminds.ilabt.jfed.highlevel.tasks.SlaTask;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.lowlevel.api.RestApi;
import be.iminds.ilabt.jfed.lowlevel.api.SlaCollector;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.connection_pool.JFedConnectionProvider;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.TestbedInfoSource;
import be.iminds.ilabt.jfed.lowlevel.user.GeniUserProvider;
import be.iminds.ilabt.jfed.preferences.JFedPreferences;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegisterStopToSLACollectorTask
extends SlaTask {
    private static final Logger LOG = LoggerFactory.getLogger(RegisterOrUpdateSliversTask.class);
    @Nonnull
    private final Slice slice;
    @Nonnull
    private final Server auth;

    public RegisterStopToSLACollectorTask(@Nonnull Slice slice, @Nonnull Server auth, @Nonnull JavaFXLogger logger, @Nonnull JFedPreferences jFedPreferences, @Nonnull TestbedInfoSource testbedInfoSource, @Nonnull JFedConnectionProvider connectionProvider, @Nonnull GeniUserProvider geniUserProvider) {
        super("Registering stop of resources @ " + auth.getDefaultComponentManagerUrn() + " to SLA Collector", logger, jFedPreferences, testbedInfoSource, connectionProvider, geniUserProvider);
        this.slice = slice;
        this.auth = auth;
    }

    @Override
    protected void doSlaTask(@Nonnull TaskExecution taskExecution, @Nonnull SlaCollector slaCollector) throws JFedException {
        if (this.slice.getUuid() == null) {
            throw new JFedHighLevelException("No UUID available to present to the SLA Collector");
        }
        RestApi.RestReply result = slaCollector.registerStop(this.createConnection(), this.slice.getUuid(), this.auth.getDefaultComponentManagerAsGeniUrn());
        if (result.getHttpCallDetails().getResultHttpStatusCode() != 200) {
            throw new JFedHighLevelException("Error while registering stop of slivers at " + this.auth.getName() + " to SLA collector");
        }
    }

    @Nonnull
    public Server getAuthority() {
        return this.auth;
    }
}

