/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.time.Instant;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

abstract class RenewTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(RenewTask.class);
    @Nonnull
    protected final Slice slice;
    @Nonnull
    protected final Instant newExpirationDate;
    protected final UserAndSliceApiWrapper userAndSliceApiWrapper;
    protected final JavaFXLogger logger;
    protected final HighLevelTaskFactory highLevelTaskFactory;

    protected RenewTask(String name, @Nonnull Slice slice, @Nonnull Instant newExpirationDate, @Nonnull UserAndSliceApiWrapper userAndSliceApiWrapper, @Nonnull JavaFXLogger logger, @Nonnull HighLevelTaskFactory highLevelTaskFactory) {
        super(name);
        this.slice = slice;
        this.newExpirationDate = newExpirationDate;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    protected void updateSlivers(Server amServer, Collection<GeniUrn> sliverUrns, TaskExecution taskExecution) throws JFedException {
        if (!this.userAndSliceApiWrapper.isRegisterAggregatesForSliceSupported()) {
            LOG.debug("UpdateSliversTask: This SA does not support updating sliver info. Doing nothing.");
            return;
        }
        LOG.debug("UpdateSliversTask has {} sliver Urns to update.", (Object)sliverUrns.size());
        if (!sliverUrns.isEmpty()) {
            this.userAndSliceApiWrapper.updateSliverExpirationDateInfoForSlice((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.slice.getCredentials(), this.slice.getUrn(), amServer.getDefaultComponentManagerAsGeniUrn(), sliverUrns, Date.from(this.newExpirationDate));
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }
}

