/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.fedmon.webapi.service.json.Server;
import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.controller.TaskThread;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.tasks.SliceManifestForAuthorityTask;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.testbed_info.ApiInfo;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SliceManifestTask
extends Task {
    private static final Logger LOG = LoggerFactory.getLogger(SliceManifestTask.class);
    private final Slice slice;
    private final TaskThread tt;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public SliceManifestTask(@Nonnull Slice slice, TaskThread tt, HighLevelTaskFactory highLevelTaskFactory) {
        super("Get Slice Manifest");
        this.slice = slice;
        this.tt = tt;
        this.highLevelTaskFactory = highLevelTaskFactory;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        LOG.debug("getManifest cm count: " + this.slice.getManifestComponentManagers().size());
        for (Server server : this.slice.getManifestComponentManagers()) {
            if (ApiInfo.hasService((Server)server, (ApiInfo.ApiName)ApiInfo.ApiName.GENI_AM)) {
                SliceManifestForAuthorityTask subCall = this.highLevelTaskFactory.getSliceManifest(this.slice, server);
                this.tt.addTask(subCall);
                continue;
            }
            LOG.error("Tried to get manifest for slice \"" + this.slice.getUrn() + "\", at server \"" + server.getDefaultComponentManagerUrn() + "\", but that server has no AM URL: will ignore slice on this authority.");
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    @Override
    @Nonnull
    public List<Task> initAlwaysDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getAggregatesForSlice(this.slice));
    }
}

