/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.model.Slice;
import be.iminds.ilabt.jfed.highlevel.tasks.HighLevelTaskFactory;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api.user_spec.UserSpec;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.util.common.GeniUrn;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class SliceMembersSshKeysTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(SliceMembersSshKeysTask.class);
    private final Slice slice;
    private final GeniUrn sliceUrn;
    private List<UserSpec> userSpecs = null;
    private final UserAndSliceApiWrapper userAndSliceApiWrapper;
    private final JavaFXLogger logger;
    private final HighLevelTaskFactory highLevelTaskFactory;

    public SliceMembersSshKeysTask(@Nonnull Slice slice, UserAndSliceApiWrapper userAndSliceApiWrapper, JavaFXLogger logger, HighLevelTaskFactory highLevelTaskFactory) {
        super("Get User SSH Keys For users in slice " + slice.getUrn());
        this.slice = slice;
        this.userAndSliceApiWrapper = userAndSliceApiWrapper;
        this.logger = logger;
        this.highLevelTaskFactory = highLevelTaskFactory;
        this.sliceUrn = slice.getUrn();
        assert (this.sliceUrn != null);
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        List<GeniUrn> userUrns = this.userAndSliceApiWrapper.getUsersForSlice((Logger)JavaFXLogger.wrap(this.logger, taskExecution), this.sliceUrn, this.slice.getCredentials());
        if (userUrns == null) {
            userUrns = Collections.emptyList();
        }
        this.userSpecs = new ArrayList<UserSpec>();
        for (GeniUrn userUrn : userUrns) {
            assert (userUrn != null);
            try {
                List userKeys = this.userAndSliceApiWrapper.getSshKeysForUser((Logger)JavaFXLogger.wrap(this.logger, taskExecution), userUrn);
                if (userKeys == null) continue;
                this.userSpecs.add(new UserSpec(userUrn.toString(), (Collection)userKeys));
            }
            catch (JFedException e) {
                LOG.warn("Could not get user key for {}", (Object)userUrn, (Object)e);
            }
        }
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.singletonList(this.highLevelTaskFactory.getSliceCredential(this.slice));
    }

    public List<UserSpec> getUserSpecs() {
        return this.userSpecs;
    }
}

