/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.tasks;

import be.iminds.ilabt.jfed.highlevel.controller.Task;
import be.iminds.ilabt.jfed.highlevel.controller.TaskExecution;
import be.iminds.ilabt.jfed.highlevel.util.JavaFXLogger;
import be.iminds.ilabt.jfed.log.Logger;
import be.iminds.ilabt.jfed.lowlevel.api_wrapper.UserAndSliceApiWrapper;
import be.iminds.ilabt.jfed.lowlevel.connection.JFedException;
import be.iminds.ilabt.jfed.lowlevel.credential.AnyCredential;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import org.slf4j.LoggerFactory;

public class UserCredentialTask
extends Task {
    private static final org.slf4j.Logger LOG = LoggerFactory.getLogger(UserCredentialTask.class);
    private static final long TIME_BETWEEN_RETRIES_IN_MS = 15000L;
    private static final int MAX_RETRIES = 9;
    private final UserAndSliceApiWrapper w;
    private final JavaFXLogger logger;

    public UserCredentialTask(UserAndSliceApiWrapper w, JavaFXLogger logger) {
        super("Get User Credential");
        this.w = w;
        this.logger = logger;
    }

    @Override
    public void doTask(@Nonnull TaskExecution taskExecution) throws JFedException, InterruptedException {
        LOG.debug("Get User Credential started");
        if (!this.tryGetUserCredential(taskExecution, 0)) {
            throw new JFedException("Could not retrieve a valid new user credential");
        }
        LOG.trace("Successfully retrieved a new user credential");
    }

    public boolean tryGetUserCredential(TaskExecution taskExecution, int tryNumber) throws JFedException {
        if (tryNumber >= 9) {
            LOG.error("Maximum number of retries ({}) exceeded to get a valid credential.", (Object)9);
            return false;
        }
        List res = this.w.getLocalUserCredentials((Logger)JavaFXLogger.wrap(this.logger, taskExecution));
        this.logReceivedCredentials(res);
        if (this.w.hasUserCredentials()) {
            assert (res != null);
            assert (!res.isEmpty());
            return true;
        }
        LOG.warn("The received credentials are not valid (long enough). Trying again later");
        try {
            Thread.sleep(15000L);
        }
        catch (InterruptedException ignored) {
            return false;
        }
        return this.tryGetUserCredential(taskExecution, tryNumber + 1);
    }

    private void logReceivedCredentials(List<AnyCredential> res) {
        if (LOG.isDebugEnabled()) {
            try {
                List expireDatesRecv = res.stream().map(AnyCredential::getExpiresDate).collect(Collectors.toList());
                List expireDatesStored = this.w.getCachedUserCredentialsForAM().stream().map(AnyCredential::getExpiresDate).collect(Collectors.toList());
                LOG.debug("Expire dates of received creds: {}. Expire dates of stored credentials: {}", expireDatesRecv, expireDatesStored);
            }
            catch (Throwable e) {
                LOG.warn("Exception while creating log output", e);
            }
        }
    }

    @Override
    public boolean newExecutionNeeded() {
        boolean hasUserCredentials = this.w.hasUserCredentials();
        try {
            List expireDates = this.w.getCachedUserCredentialsForAM() != null ? this.w.getCachedUserCredentialsForAM().stream().map(AnyCredential::getExpiresDate).collect(Collectors.toList()) : null;
            LOG.info("getUserCredential newExecutionNeeded() called -> hasUserCredentials={} now={} expireDates={}", new Object[]{hasUserCredentials, new Date(), expireDates});
        }
        catch (Throwable t) {
            LOG.warn("Exception in logging ignored. hasUserCredentials=" + hasUserCredentials, t);
        }
        return !hasUserCredentials;
    }

    @Override
    @Nonnull
    public List<Task> initDependsOn() {
        return Collections.emptyList();
    }
}

