/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.highlevel.util;

import be.iminds.ilabt.jfed.espec.util.LimitedLiveLog;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import javafx.application.Platform;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.event.Level;

public class InputStreamToLogsThread
extends Thread {
    private static final Logger LOG = LoggerFactory.getLogger(InputStreamToLogsThread.class);
    @Nonnull
    private final InputStream inputStream;
    @Nonnull
    private final String logPrefix;
    @Nullable
    private final LogFunction logFunction;
    @Nullable
    private Logger log;
    @Nullable
    private LimitedLiveLog liveLog;

    public InputStreamToLogsThread(@Nonnull InputStream inputStream, @Nullable Logger log, @Nullable Level logLevel, @Nullable String logPrefix, @Nullable LimitedLiveLog liveLog) {
        this.inputStream = inputStream;
        this.log = log;
        this.liveLog = liveLog;
        String string = this.logPrefix = logPrefix == null ? "" : logPrefix;
        if (logLevel != null && log != null) {
            switch (logLevel) {
                case TRACE: {
                    this.logFunction = arg_0 -> ((Logger)log).trace(arg_0);
                    break;
                }
                case DEBUG: {
                    this.logFunction = arg_0 -> ((Logger)log).debug(arg_0);
                    break;
                }
                case INFO: {
                    this.logFunction = arg_0 -> ((Logger)log).info(arg_0);
                    break;
                }
                case WARN: {
                    this.logFunction = arg_0 -> ((Logger)log).warn(arg_0);
                    break;
                }
                case ERROR: {
                    this.logFunction = arg_0 -> ((Logger)log).error(arg_0);
                    break;
                }
                default: {
                    this.logFunction = null;
                    break;
                }
            }
        } else {
            this.logFunction = null;
        }
    }

    @Override
    public void run() {
        try {
            String s;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(this.inputStream));
            while ((s = stdInput.readLine()) != null) {
                String str = s;
                if (this.logFunction != null) {
                    this.logFunction.log(this.logPrefix + str);
                }
                if (this.log == null) continue;
                Platform.runLater(() -> this.liveLog.appendText(str + "\n"));
            }
            this.inputStream.close();
            this.liveLog.setEndReached();
        }
        catch (IOException ex) {
            LOG.error("Error while reading from InputStream to StringProperty", (Throwable)ex);
        }
    }

    @Nullable
    public LimitedLiveLog getLog() {
        return this.liveLog;
    }

    private static interface LogFunction {
        public void log(String var1);
    }
}

