/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx;

import be.iminds.ilabt.jfed.rspec.parser.RspecParseException;
import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.Pipe;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.SliverTypeShaping;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StaxRspecFxParser {
    private static final Logger LOG = LoggerFactory.getLogger(StaxRspecFxParser.class);
    private static final StaxRspecFxParser INSTANCE = new StaxRspecFxParser();

    public static StaxRspecFxParser getInstance() {
        return INSTANCE;
    }

    private StaxRspecFxParser() {
    }

    public SliverTypeShaping parseSliverTypeShaping(Location location, XMLEventReader eventReader) throws RspecParseException {
        try {
            XMLEvent e = eventReader.nextEvent();
            assert (e.isStartElement());
            StartElement startElement = e.asStartElement();
            assert (startElement.getName().equals(RspecXmlConstants.Q_SLIVER_TYPE_SHAPING));
            SliverTypeShaping res = new SliverTypeShaping();
            while (eventReader.hasNext()) {
                e = eventReader.nextEvent();
                if (e.isStartElement()) {
                    if (!e.asStartElement().getName().equals(RspecXmlConstants.Q_PIPE)) continue;
                    res.getPipe().add(this.parsePipe(e, eventReader));
                    continue;
                }
                if (e.isEndElement()) {
                    if (!e.asEndElement().getName().equals(RspecXmlConstants.Q_SLIVER_TYPE_SHAPING)) continue;
                    return res;
                }
                LOG.warn("Ignoring event {} in SliverTypeShaping", (Object)e);
            }
        }
        catch (XMLStreamException e1) {
            throw new RspecParseException(location, "Could not parse SliverTypeShaping", (Throwable)e1);
        }
        throw new RspecParseException(location, "Did not encounter end element for SliverTypeShaping");
    }

    private Pipe parsePipe(XMLEvent e, XMLEventReader eventReader) throws RspecParseException {
        try {
            Attribute qWeightAtt;
            Attribute lintermAtt;
            Attribute treshAtt;
            Attribute maxtreshAtt;
            Attribute limitAtt;
            Attribute queueInBytesAtt;
            Attribute redAtt;
            Attribute gentleAtt;
            Attribute packetLossAtt;
            Attribute latencyAtt;
            Attribute capacityAtt;
            Attribute destAtt;
            Pipe pipe = new Pipe();
            assert (e.isStartElement());
            StartElement startElement = e.asStartElement();
            assert (startElement.getName().equals(RspecXmlConstants.Q_PIPE));
            Attribute sourceAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_SOURCE);
            if (sourceAtt != null) {
                pipe.setSource(sourceAtt.getValue());
            }
            if ((destAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_DEST)) != null) {
                pipe.setDest(destAtt.getValue());
            }
            if ((capacityAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_CAPACITY)) != null) {
                pipe.setCapacity(Integer.valueOf(Integer.parseInt(capacityAtt.getValue())));
            }
            if ((latencyAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_LATENCY)) != null) {
                pipe.setLatency(Integer.valueOf(Integer.parseInt(latencyAtt.getValue())));
            }
            if ((packetLossAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_PACKET_LOSS)) != null) {
                pipe.setPacketLoss(Float.valueOf(Float.parseFloat(packetLossAtt.getValue())));
            }
            if ((gentleAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_GENTLE)) != null) {
                pipe.setGentle(Boolean.valueOf(Boolean.parseBoolean(gentleAtt.getValue())));
            }
            if ((redAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_RED)) != null) {
                pipe.setRed(Boolean.valueOf(Boolean.parseBoolean(redAtt.getValue())));
            }
            if ((queueInBytesAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_QUEUE_IN_BYTES)) != null) {
                pipe.setQueueInBytes(Boolean.valueOf(Boolean.parseBoolean(queueInBytesAtt.getValue())));
            }
            if ((limitAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_LIMIT)) != null) {
                pipe.setLimit(Integer.valueOf(Integer.parseInt(limitAtt.getValue())));
            }
            if ((maxtreshAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_MAXTRESH)) != null) {
                pipe.setMaxthresh(Integer.valueOf(Integer.parseInt(maxtreshAtt.getValue())));
            }
            if ((treshAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_TRESH)) != null) {
                pipe.setThresh(Integer.valueOf(Integer.parseInt(treshAtt.getValue())));
            }
            if ((lintermAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_LINTERM)) != null) {
                pipe.setLinterm(Integer.valueOf(Integer.parseInt(lintermAtt.getValue())));
            }
            if ((qWeightAtt = startElement.getAttributeByName(RspecXmlConstants.Q_ATT_Q_WEIGHT)) != null) {
                pipe.setQWeight(Float.valueOf(Float.parseFloat(qWeightAtt.getValue())));
            }
            while (eventReader.hasNext()) {
                e = eventReader.nextEvent();
                if (e.isEndElement()) {
                    if (!e.asEndElement().getName().equals(RspecXmlConstants.Q_PIPE)) continue;
                    return pipe;
                }
                LOG.warn("Ignoring event {} in pipe", (Object)e);
            }
        }
        catch (XMLStreamException e1) {
            throw new RspecParseException(e.getLocation(), "Could not parse Pipe", (Throwable)e1);
        }
        throw new RspecParseException(e.getLocation(), "Did not encounter end element for Pipe");
    }
}

