/*
 * Decompiled with CFR 0.152.
 */
package be.iminds.ilabt.jfed.rspec_fx;

import be.iminds.ilabt.jfed.rspec.parser.RspecXmlConstants;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.Pipe;
import be.iminds.ilabt.jfed.rspec.request.ext.delay.SliverTypeShaping;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLStreamException;

public class StaxRspecFxWriter {
    private static final StaxRspecFxWriter INSTANCE = new StaxRspecFxWriter();
    private XMLEventFactory eventFactory = XMLEventFactory.newInstance();

    public static StaxRspecFxWriter getInstance() {
        return INSTANCE;
    }

    private StaxRspecFxWriter() {
    }

    public void writeSliverTypeShaping(XMLEventWriter eventWriter, SliverTypeShaping sliverTypeShaping) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_SLIVER_TYPE_SHAPING, null, null));
        for (Pipe pipe : sliverTypeShaping.getPipe()) {
            this.writePipe(eventWriter, pipe);
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_SLIVER_TYPE_SHAPING, null));
    }

    private void writePipe(XMLEventWriter eventWriter, Pipe pipe) throws XMLStreamException {
        eventWriter.add(this.eventFactory.createStartElement(RspecXmlConstants.Q_PIPE, null, null));
        if (pipe.getSource() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_SOURCE, pipe.getSource()));
        }
        if (pipe.getDest() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_DEST, pipe.getDest()));
        }
        if (pipe.getCapacity() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_CAPACITY, pipe.getCapacity().toString()));
        }
        if (pipe.getLatency() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LATENCY, pipe.getLatency().toString()));
        }
        if (pipe.getPacketLoss() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_PACKET_LOSS, pipe.getPacketLoss().toString()));
        }
        if (pipe.isGentle() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_GENTLE, pipe.isGentle().toString()));
        }
        if (pipe.isRed() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_RED, pipe.isRed().toString()));
        }
        if (pipe.isQueueInBytes() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_QUEUE_IN_BYTES, pipe.isQueueInBytes().toString()));
        }
        if (pipe.getLimit() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LIMIT, pipe.getLimit().toString()));
        }
        if (pipe.getMaxthresh() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_MAXTRESH, pipe.getMaxthresh().toString()));
        }
        if (pipe.getThresh() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_TRESH, pipe.getThresh().toString()));
        }
        if (pipe.getLinterm() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_LINTERM, pipe.getLinterm().toString()));
        }
        if (pipe.getQWeight() != null) {
            eventWriter.add(this.eventFactory.createAttribute(RspecXmlConstants.Q_ATT_Q_WEIGHT, pipe.getQWeight().toString()));
        }
        eventWriter.add(this.eventFactory.createEndElement(RspecXmlConstants.Q_PIPE, null));
    }
}

